%rebase( "_tab_base", tab_info=tab_info)
%from shinkensolutions.api.synchronizer.http_lib_external.v01_00.html.html_distributor import HTML_TYPE
% _colspan=9
% _colspan -= 0 if have_mappers_name_col else 1
% _colspan -= 0 if have_item_class_col else 1

<div class="shinken-list-container">
    <div id="id-shinken-mapping-origin-to-source-messages">
        {{!validation_state}}
    </div>
    %include( "files-configuration")
    <div class="shinken-fix-container">
        <table class="shinken-width-100 shinken-list-table">
            <thead>
                <tr class="shinken-header-line">
                    <th class="shinken-list-header shinken-action-cell"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.counters')}}</div></th>
                    <th class="shinken-list-header shinken-cell-rules-user"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.is_set_by_user')}}</div></th>
                    %if have_mappers_name_col:
                        <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.mapper_name')}}</div></th>
                    %end
                    %if have_item_class_col:
                        <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.item_type')}}</div></th>
                    %end
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.origin_prop_name')}}</div></th>
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.description')}}</div></th>
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.source_prop_name')}}</div></th>
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('mapping_origin_to_source.header.source_prop_desc')}}</div></th>
                    <th class="shinken-list-header shinken-cell-empty"><div class="shinken-list-header-container"></div></th>
                </tr>
                <tr class="shinken-empty-line"><td colspan="{{_colspan}}"></td></tr>
                <tr class="shinken-filter-line">
                    {{!html_distributor.get(HTML_TYPE.FILTER,'counters').get_html()}}
                    {{!html_distributor.get(HTML_TYPE.FILTER,'define_by').get_html()}}
                    %if have_mappers_name_col:
                        {{!html_distributor.get(HTML_TYPE.FILTER,'mapper-name').get_html()}}
                    %end
                    %if have_item_class_col:
                        {{!html_distributor.get(HTML_TYPE.FILTER,'item-type').get_html()}}
                    %end
                    {{!html_distributor.get(HTML_TYPE.FILTER,'source-key').get_html()}}
                    {{!html_distributor.get(HTML_TYPE.FILTER,'description').get_html()}}
                    {{!html_distributor.get(HTML_TYPE.FILTER,'shinken-key').get_html()}}
                    {{!html_distributor.get(HTML_TYPE.FILTER,'shinken-name').get_html()}}
                </tr>
            </thead>
        </table>
    </div>
    <div class="shinken-scrollable-container">
        <table class="shinken-width-100 shinken-list-table">
            <tbody class="shinken-list-tbody">
            %for sort_key, item_type, origin_prop_name, mapping_rule in mapping_rules:
                <tr class="shinken-list-line"
                    data-number-error="{{mapping_rule.error_counter_number}}"
                    data-number-warning="{{mapping_rule.warning_counter_number}}"
                    onmouseenter="MANAGER.EventManager.mouseEnter(event)"
                    onmouseleave="MANAGER.EventManager.mouseLeave(event)"
                    data-is-set-by-user="{{mapping_rule.is_set_by_user}}">
                    <td class="shinken-list-cell shinken-elements-cell shinken-action-cell shinken-text-centred" data-filter="counters" data-filter-value-array="{{mapping_rule.counter_filter}}">
                        <div class="shinken-list-cell-container" >{{!mapping_rule.counter_html}}</div>
                    </td>
                    <td class="shinken-list-cell shinken-elements-cell shinken-cell-rules-user shinken-text-centred" data-filter="define_by" data-filter-value-array="{{mapping_rule.is_set_by_user}}"><div class="shinken-list-cell-container"><div class="shinken-label">{{mapping_rule.is_set_by_user_label}}</div></div></td>
                    %if have_mappers_name_col:
                        <td class="shinken-list-cell shinken-elements-cell" data-filter="mapper-name" data-filter-value-array="{{mapping_rule.mapper_name_filter}}"><div class="shinken-list-cell-container">{{mapping_rule.mapper_name}}</div></td>
                    %end
                    %if have_item_class_col:
                        <td class="shinken-list-cell shinken-elements-cell" data-filter="item-type" data-filter-value-array="{{item_type}}"><div class="shinken-list-cell-container">{{!mapping_rule.item_type_label}}</div></td>
                    %end
                    <td class="shinken-list-cell shinken-elements-cell" data-filter="source-key"><div class="shinken-list-cell-container"><div class="shinken-label">{{!mapping_rule.origin_prop_label}}</div></div></td>
                    <td class="shinken-list-cell shinken-elements-cell" data-filter="description"><div class="shinken-list-cell-container"><div class="shinken-label">{{mapping_rule.description}}</div></div></td>
                    <td class="shinken-list-cell shinken-elements-cell" data-filter="shinken-key"><div class="shinken-list-cell-container"><div class="shinken-label">{{!mapping_rule.source_prop_label}}</div></div></td>
                    <td class="shinken-list-cell shinken-elements-cell" data-filter="shinken-name"><div class="shinken-list-cell-container"><div class="shinken-label">{{!mapping_rule.source_prop_desc}}</div></div></td>
                </tr>
            %end
            </tbody>
        </table>
    </div>
</div>
<div class="shinken-loading-after-refresh">
    <div class="shinken-loading-after-refresh-container">
        <h1>{{!translate('host_template_binding_rules.refresh_rules')}}</h1>
    </div>
</div>
%include( "mapping_origin_to_source_help")