#!/usr/bin/python
import optparse
import socket
import sys
import time

VERSION = '.01'
BUFFER_SIZE = 1024

parser = optparse.OptionParser(
    "%prog [options]", version="%prog " + VERSION)
parser.add_option('-L', '--livestatus-host',
                  dest="livestatus_host", default='127.0.0.1', help='Livestatus host')
parser.add_option('-C', '--cluster',
                  dest="cluster", help='Name of the cluster to query')
parser.add_option('-P', '--port',
                  dest="port", default=50000, help='Livestatus port')



if __name__ == '__main__':
    # Ok first job : parse args
    opts, args = parser.parse_args()
    if args:
        parser.error("Does not accept any argument.")

    livestatus_host = opts.livestatus_host
    cluster = opts.cluster or None
    if not cluster:
        print "Error: cluster parameter (-C) is mandatory"
        sys.exit(2)
    port = int(opts.port)

    start = time.time()
    try:
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.connect((livestatus_host, port))
        query = '''GET hosts
Columns: host_name state
Filter: host_name = %s

''' % cluster
        sock.send(query)
        sock.shutdown(socket.SHUT_WR)    
        data = sock.recv(BUFFER_SIZE).strip()
        sock.close()
    except Exception, exp:
        print 'UNKNOWN: cannot connect to livestatus (%s:%s) : %s' % (livestatus_host, port, exp)
        sys.exit(3)
    end = time.time()

    #print 'QUERY %s' % query
    #print 'result %s' % data
    #print 'time', end - start
    state = 3
    output = ''
    if data == '':
        output = 'UNKNOWN: no such cluster %s on the distant livestatus' % cluster
        state = 3
    else:
        h, state = data.split(';')
        #print h, state
        state = int(state)
        # fake cluster state
        if state == 1:
            state = 2
        state_s = {0: 'OK', 1:'WARNING', 2:'CRITICAL'}.get(state, 'UNKNOWN')
        output = '%s: the cluster %s is %s' % (state_s, cluster, state_s)

    print "%s | query_time=%.4f" % (output, (end - start))
    sys.exit(state)
