%loc = locals()
%if 'li_cls' not in loc:
    %li_cls = ''
%end
%label = app._('element.%s' % name)
%suffix = ''

%if name == 'checks':
    %suffix = '<span id="id-shinken-nb-checks" class="shinken-between-space-bracket"></span>'
%elif name == 'datas':
    %suffix = '<span class="shinken-data-nav-bar-counter shinken-between-bracket"><span class="shinken-user-counter-container shinken-window-user-counter shinken-counter" data-number=""><span class="shinken-counter-label"></span></span><span class="shinken-window-total-counter shinken-counter" data-number="0"><span class="shinken-counter-label">0</span></span></span>'
%elif name == 'direct' or name == 'deprecated':
    %label = '%s<br><span class="contactdeprecatedbloc">(%s)</span>' % (app._('element.direct_configuration'), app._('element.deprecated'))
%end
%error_counter = '<span class="shinken-error-counter shinken-counter" title="%s" data-number=""><span class="shinken-counter-label"></span></span>' % ( app._("element.title_panel_errors") )
%warning_counter = '<span class="shinken-warning-counter shinken-counter" title="%s" data-number=""><span class="shinken-counter-label"></span></span>' % ( app._("element.title_panel_warnings") )

%# protect against name with - and transform them as display space (html it can't have space)
%label = label.replace('-', ' ')

<li class="shinken-nav-tab {{li_cls}}" id="id-shinken-window-{{name}}">
    <span class="shinken-link" data-pane-name="{{name}}" onclick="MANAGER.EventManager.clickOnNavigation('{{name}}')">
        {{!error_counter}}
        {{!warning_counter}}
        {{!label}}
        <span class="shinken-required-field shinken-hidden"></span>
        {{!suffix}}
    </span>
</li>