var __instanceCharts;
var __label_precision_dom;
var __loading_dom;
var __label_precision_container_dom;
var __label_precision_container_dom_approximation;
var __highcharts_tooltip_dom;
var show_trending         = 0;
var show_warning          = false;
var show_critical         = false;
var timerange             = '-1d';
var xAxis_min_range       = 0;
var __min_scale           = 0;
var __max_scale           = 0;
var __has_series          = true;
var __resetExtremes       = true;
var _show_approximation   = false;
var _60SEC                = 60000;
var _360SEC               = 6 * _60SEC;
var _was_colors_validated = false;
var _timezone             = new Date().getTimezoneOffset();
var __has_local_time      = parseInt( __offset_time_zone_backend ) !== _timezone;
var __offset_timezone     = (_timezone - __offset_time_zone_backend) * 60;

function shinken_format_data_tooltip ( value ) {
    value      = value + "";
    var _split = value.split( '.' );
    if ( !_split[ 1 ] ) {
        _split[ 1 ] = '';
    }
    else {
        _split[ 1 ] = '.' + _split[ 1 ];
    }
    var _to_return = '<td class="tooltip_value shinken-text-right">&nbsp;' + _split[ 0 ] + '</td>';
    _to_return += '<td class="tooltip_value shinken-text-left">' + _split[ 1 ] + '</td>';
    return _to_return;
}

function time_format_two_digit ( value ) {
    return value < 10 ? '0' + value : value;
}

function date_format_tooltip ( date_value ) {
    var _hours   = time_format_two_digit( date_value.getHours() );
    var _minutes = time_format_two_digit( date_value.getMinutes() );
    var _seconds = time_format_two_digit( date_value.getSeconds() );
    return date_value.toDateString() + ' ' + _hours + ':' + _minutes + ':' + _seconds;
}

function getServerTimeHtml ( date_value ) {
    var timestamp   = (date_value / 1000 + __offset_timezone) * 1000;
    var date_server = new Date( timestamp );
    return '<small class="width100" >' + date_format_tooltip( date_server ) + '</small>';
}

function getLocalTimeHtml ( date_value ) {
    if ( !__has_local_time ) {
        return '';
    }
    var local_time = new Date( date_value );
    return '<br><small class="width100" > <span class="shinken-local-date">' + date_format_tooltip( local_time ) + '</span></small><br><br>';
}

function shinken_graph_tooltip_header ( date_value ) {
    return getServerTimeHtml( date_value ) + getLocalTimeHtml( date_value );
}

function shinken_graph_tooltip_table_data ( points ) {
    var to_return = '<table class="table-tooltip-graph">';
    var _current;
    for ( var i = 0, _size = points.length; i < _size; i++ ) {
        _current = points[ i ];
        to_return += '<tr><td class="tooltip_text" style="color: ' + _current.color + ';"><span class="shinken-tooltip-text">' + _current.series.options.display_name + '&nbsp;:&nbsp;</span></td>' +
                     shinken_format_data_tooltip( _current.y ) + '</tr>';
    }
    to_return += '</table>';
    return to_return;
}

function setResetExtremes ( to_set ) {
    __resetExtremes = to_set;
}

function endsWith ( string, pattern ) {
    var d = string.length - pattern.length;
    return d >= 0 && string.lastIndexOf( pattern ) === d;
}

function hexToRgb ( hex ) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec( hex );
    return result ? {
        r: parseInt( result[ 1 ], 16 ),
        g: parseInt( result[ 2 ], 16 ),
        b: parseInt( result[ 3 ], 16 )
    } : null;
}

function loadAllDomElement () {
    if ( !__instanceCharts ) {
        __instanceCharts                              = $( '#container' ).highcharts();
        __label_precision_dom                         = document.getElementById( 'label-precision-value' );
        __loading_dom                                 = document.getElementById( 'loading-frame-div' );
        __loading_dom_approximation                   = document.getElementById( 'loading-frame-div-approximation' );
        __label_precision_container_dom               = document.getElementById( 'label-precision' );
        __label_precision_container_dom_approximation = document.getElementById( 'label-precision-approximation' );
    }
    return __instanceCharts;
}

function name_serie_formatter ( hname, sdesc, metric, real_metric, warn, crit, trending ) {
    if ( warn ) {
        return 'warn';
    }
    if ( crit ) {
        return 'crit';
    }
    if ( trending ) {
        return sdesc + '.' + metric + '_trending';
    }
    return sdesc + '.' + metric;
}

function is_serie_in_graphs ( hname, sdesc, metric ) {
    var _serie;
    for ( var i = 0, _size = __instanceCharts.series.length; i < _size; i++ ) {
        _serie = __instanceCharts.series[ i ];
        if ( (_serie.options.hname === hname) && (_serie.options.sdesc === sdesc) && (_serie.options.metric === metric) ) {
            return true;
        }
    }
    return false;
}

function is_last_series () {
    var counter = 0;
    for ( var i = 0; i < __instanceCharts.series.length; i++ ) {
        var serie = __instanceCharts.series[ i ];
        if ( serie.options.real_metric && serie.name !== 'Navigator' ) {
            counter += 1;
        }
    }
    
    return (counter == 1);
}

String.prototype.replaceAll = function ( find, replace ) {
    return this.replace( new RegExp( find, 'g' ), replace );
};

function hash_code ( s ) {
    return s.split( "" ).reduce( function ( a, b ) {
        a = ((a << 5) - a) + b.charCodeAt( 0 );
        return a & a;
    }, 0 );
}

function validate_color () {
    var _regex_color_hexa = /^([A-Fa-f0-9]{6})$/;
    for ( var i = colors.length - 1; i >= 0; i-- ) {
        colors[ i ] = colors[ i ].trim();
        if ( !colors[ i ].match( _regex_color_hexa ) ) {
            console.warn( "color [" + colors[ i ] + "] was removed due to wrong format (cf: format: colors_graphics in documentation)" );
            colors.splice( i, 1 );
        }
    }
    if ( !colors.length ) {
        colors[ 0 ] = "0095DA";
        colors[ 1 ] = "E02C2C";
    }
}

function get_color ( asked_metric ) {
    if ( !_was_colors_validated ) {
        validate_color();
        _was_colors_validated = true;
    }
    var hash = hash_code( asked_metric );
    var idx  = Math.abs( hash % colors.length );
    return {
        'start': [ 0, '#' + colors[ idx ] ],
        'end'  : [ 1, Highcharts.Color( '#' + colors[ idx ] ).setOpacity( 0 ).get( 'rgba' ) ]
    };
}

function clone_object ( object ) {
    var _size      = object.length;
    var _to_return = [];
    for ( var i = 0; i < _size; i++ ) {
        _to_return[ i ]      = [];
        _to_return[ i ][ 0 ] = object[ i ][ 0 ];
        _to_return[ i ][ 1 ] = object[ i ][ 1 ];
    }
    return _to_return;
}

function computeIndexFirst ( range ) {
    var toReturn = 0;
    if ( range > 1 ) {
        toReturn = Math.round( range / 4 );
    }
    return toReturn;
}

function computeIndexLast ( range ) {
    var toReturn = 0;
    if ( range > 1 ) {
        toReturn = Math.round( range / 4 * 3 );
    }
    return toReturn;
}

function completeData ( to_set, diff ) {
    var _size      = to_set.length;
    var _to_return = [];
    if ( !_first_date_parse_data ) {
        _first_date_parse_data = to_set[ 0 ][ 0 ];
    }
    
    if ( to_set[ 0 ][ 0 ] > _first_date_parse_data ) {
        to_set.splice( 0, 0, [ _first_date_parse_data, null ] );
    }
    else if ( to_set[ 0 ][ 0 ] < _first_date_parse_data ) {
        to_set.splice( 0, 1 );
        return completeData( to_set, diff );
    }
    var offset;
    for ( var i = 0; i < _size - 1; i++ ) {
        offset = to_set[ i + 1 ][ 0 ] - to_set[ i ][ 0 ];
        _to_return.push( to_set[ i ] );
        if ( offset !== diff ) {
            // If the interval is different from the graphite interval, null is added for each missing point
            for ( var j = 1, _size_offset = (offset / diff); j <= _size_offset; j++ ) {
                _to_return.push( [ to_set[ i ][ 0 ] + (diff * j), null ] );
            }
        }
    }
    return _to_return;
}

var _first_date_parse_data; //BGL TO HAVE THE DATE BEGGINING AT THE SAME TIME
function parseDataForGraph ( to_set, interval ) {
    interval             = interval * 1000;
    var _size            = to_set.length;
    var _index_to_ignore = 0;
    
    
    var _grouping_range = Math.ceil( _size / 2000 ) * 2;
    switch ( timerange ) {
        case '-1w':
        case '-1month':
            _grouping_range  = 10;
            _index_to_ignore = (to_set[ 0 ][ 0 ] % 300000) / interval;
            break;
    }
    var _index_first = computeIndexFirst( _grouping_range );
    var _index_last  = computeIndexLast( _grouping_range );
    
    var _COUNTER     = 1;
    var _INDEX_FIRST = 0;
    var _INDEX_LAST  = 0;
    if ( __apply_parse_data && _size > 2000 ) {
        switch ( timerange ) {
            case '-1w':
            case '-1month':
                _COUNTER     = _grouping_range;
                _INDEX_FIRST = _index_first;
                _INDEX_LAST  = _index_last;
                to_set       = completeData( to_set, interval );
                _size        = to_set.length;
                break;
        }
    }
    
    var _to_return = [];
    
    var _current_min;
    var _current_max;
    var _current;
    
    
    
    var _time_first;
    var _time_last;
    for ( var i = 0; i < _size; ) {
        if ( _size - i < _COUNTER ) {
            _INDEX_FIRST = 0;
            _INDEX_LAST  = 0;
            _COUNTER     = 1;
        }
        
        _current_min = to_set[ i ];
        
        _current_max = _current_min;
        if ( _INDEX_LAST ) {
            for ( var j = 0; j < _COUNTER; j++ ) {
                _current = to_set[ i + j ];
                if ( _current[ 1 ] === null ) {
                    continue;
                }
                if ( _current[ 1 ] > _current_max[ 1 ] ) {
                    _current_max = _current;
                }
                else if ( _current[ 1 ] < _current_min[ 1 ] ) {
                    _current_min = _current;
                }
                if ( _current_max[ 1 ] === null ) {
                    _current_max = _current;
                }
                if ( _current_min[ 1 ] === null ) {
                    _current_min = _current;
                }
            }
        }
        if ( _current_max[ 0 ] > _current_min[ 0 ] ) {
            _current_min[ 0 ] = to_set[ i + _INDEX_FIRST ][ 0 ];
            _to_return.push( _current_min );
            if ( _INDEX_LAST ) {
                _current_max[ 0 ] = to_set[ i + _INDEX_LAST ][ 0 ];
                _to_return.push( _current_max );
            }
            
            
        }
        else {
            _current_max[ 0 ] = to_set[ i + _INDEX_FIRST ][ 0 ];
            _to_return.push( _current_max );
            if ( _INDEX_LAST ) {
                _current_min[ 0 ] = to_set[ i + _INDEX_LAST ][ 0 ];
                _to_return.push( _current_min );
            }
        }
        
        i = i + _COUNTER;
    }
    if ( DETAIL_GRAPHS_CALL ) {
        var _size_final = _to_return.length;
        setPrecisionLabel( _to_return, _size_final );
    }
    
    return _to_return;
    
}

function setPrecisionLabel ( datas, size ) {
    
    var _precision = Math.round( ((datas[ size - 1 ][ 0 ] - datas[ 0 ][ 0 ]) / size) / 1000 );
    
    _show_approximation = false;
    var _old_value      = __label_precision;
    
    if ( _precision <= 100 ) {
        __label_precision = "1min";
    }
    else if ( _precision <= 330 ) {
        __label_precision   = "5min";
        _show_approximation = true;
    }
    else if ( _precision <= 400 ) {
        __label_precision = "6min";
    }
    else if ( _precision <= 2000 ) {
        __label_precision   = "30min";
        _show_approximation = true;
    }
    else {
        __label_precision = "24h";
    }
    
    __label_precision_dom.innerHTML = __label_precision;
    
    __label_precision_container_dom.style.display = "inline-block";
    if ( _old_value !== __label_precision ) {
        blink( "#label-precision-value", 3, 300 );
    }
    
    
    if ( _show_approximation ) {
        __label_precision_container_dom_approximation.style.display = "inline-block";
        __loading_dom_approximation.style.display                   = "inline-block";
    }
    else {
        __label_precision_container_dom_approximation.style.display = "none";
        __loading_dom_approximation.style.display                   = "none";
    }
}

function blink ( elem, times, speed ) {
    if ( times > 0 || times < 0 ) {
        if ( $( elem ).hasClass( "blink" ) ) {
            $( elem ).removeClass( "blink" );
        }
        else {
            $( elem ).addClass( "blink" );
        }
    }
    
    clearTimeout( function () {
        blink( elem, times, speed );
    } );
    
    if ( times > 0 || times < 0 ) {
        setTimeout( function () {
            blink( elem, times, speed );
        }, speed );
        times -= .5;
    }
}

function showElementByID ( _id ) {
    var _element = document.getElementById( _id );
    if ( _element ) {
        _element.style.display = 'block';
    }
}

function hideElementByID ( _id ) {
    var _element = document.getElementById( _id );
    if ( _element ) {
        _element.style.display = 'none';
    }
}

function b64Encode ( str ) {
    return btoa( encodeURIComponent( str ).replace( /%([0-9A-F]{2})/g, function ( match, p1 ) {
        return String.fromCharCode( parseInt( p1, 16 ) );
    } ) );
}

function b64Decode ( str ) {
    return decodeURIComponent( Array.prototype.map.call( atob( str ), function ( c ) {
        return '%' + ('00' + c.charCodeAt( 0 ).toString( 16 )).slice( -2 );
    } ).join( '' ) );
};
