DETAIL_GRAPH.Host = function () {
    //dom_element
    //name
    //mapping_checks
    this.mapping_checks = {};
    this.init();
};

DETAIL_GRAPH.Host.prototype = {
    init                        : function () {
        this.dom_element   = document.querySelector( '.shinken-list-checks-container-cell' );
        this.uuid          = this.dom_element.dataset.uuid.split( '-' )[ 0 ];
        this.name          = this.dom_element.dataset.hostName;
        var _checks        = this.dom_element.querySelectorAll( '.shinken-check-container' );
        var _complete_uuid = this.dom_element.dataset.uuid;
        var _current;
        for ( var i = 0, _size = _checks.length; i < _size; i++ ) {
            _current                                = new DETAIL_GRAPH.Check( _checks[ i ], this.uuid, this.name );
            this.mapping_checks[ _current.getID() ] = _current;
            _current.computeSelected( _complete_uuid );
        }
        this.computeStartWidth();
        this.changeWidth();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    dragStart                   : function () {
        this.computeStartWidth();
    },
    addCheckDetail              : function ( check_id ) {
        this.getCheck( check_id ).addCheckDetail();
    },
    removeCheckDetail           : function ( check_id ) {
        this.getCheck( check_id ).removeCheckDetail();
        this.computeDisplayGraphContainer();
    },
    removeMetricDetail          : function ( check_id, metric_id ) {
        this.getCheck( check_id ).removeMetricDetail( metric_id );
        this.computeDisplayGraphContainer();
    },
    addMetricDetail             : function ( check_id, metric_id ) {
        this.getCheck( check_id ).addMetricDetail( metric_id );
        this.computeDisplayGraphContainer();
    },
    addThresholdDetail          : function ( check_id, metric_id, threshold_type ) {
        this.getCheck( check_id ).addThresholdDetail( metric_id, threshold_type );
        this.computeDisplayGraphContainer();
    },
    removeThresholdDetail       : function ( check_id, metric_id, threshold_type ) {
        this.getCheck( check_id ).removeThresholdDetail( metric_id, threshold_type );
        this.computeDisplayGraphContainer();
    },
    addSelectedMetric           : function ( selected_metric ) {
        var _check = this.getCheckByUuid( selected_metric.check_uuid );
        if ( _check ) {
            _check.addCheckDetail();
            _check.addSelectedMetric( selected_metric );
            this.computeDisplayGraphContainer();
        }
    },
    reInit                      : function () {
        var _keys = Object.keys( this.mapping_checks );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.mapping_checks[ _keys[ i ] ].reInit();
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getWidth                    : function () {
        return this.dom_element_width;
    },
    getCheck                    : function ( check_id ) {
        return this.mapping_checks[ check_id ];
    },
    setStartWidth               : function ( to_set ) {
        this.start_width = to_set;
    },
    getCheckByUuid              : function ( uuid ) {
        var _keys = Object.keys( this.mapping_checks );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.mapping_checks[ _keys[ i ] ];
            if ( _current.getUuid() === uuid ) {
                return _current;
            }
        }
        return false;
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    computeStartWidth           : function () {
        this.setStartWidth( this.dom_element.getBoundingClientRect().width );
    },
    changeWidth                 : function ( delta ) {
        if ( delta === undefined ) {
            delta = 0;
        }
        var _width = this.start_width + delta;
        if ( _width < 100 ) {
            return;
        }
        this.dom_element_width          = _width;
        this.dom_element.style.width    = this.dom_element_width + "px";
        this.dom_element.style.maxWidth = this.dom_element_width + "px";
    },
    hasActiveMetric             : function () {
        var _keys = Object.keys( this.mapping_checks );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.mapping_checks[ _keys[ i ] ].hasActiveMetric() ) {
                return true;
            }
        }
        return false;
    },
    computeDisplayGraphContainer: function () {
        __instance_detail_graph_container.setHasMetric( this.hasActiveMetric() );
    }
};


var __instance_detail_graph_host = new DETAIL_GRAPH.Host();