

/* We Hide all detail elements */
$(document).ready(function(){
    // By default hide all "hide" chevron of the right part
    $('.chevron-up').hide();
});


$(document).ready(function(){
	$('.applytooltip').tooltip({html:true});
    });

/*
  Look for Shift key up and down
*/
is_shift_pressed = false;
function shift_pressed(){
    is_shift_pressed = true;
}

function shift_released(){
    is_shift_pressed = false;
}

$(document).bind('keydown', 'shift', shift_pressed);
$(document).bind('keyup', 'shift', shift_released);

/*
  Look for ctrl key up and down
*/
is_ctrl_pressed = false;
function ctrl_pressed(){
    is_ctrl_pressed = true;
}

function ctrl_released(){
    is_ctrl_pressed = false;
}

$(document).bind('keydown', 'ctrl', ctrl_pressed);
$(document).bind('keyup', 'ctrl', ctrl_released);


/*
  If we keep the shift pushed and hovering over selections, it
  select the elements. Easier for massive selection :)
*/
function hovering_selection(name){
    if(is_shift_pressed){
	add_element(name);
    }
    if(is_ctrl_pressed){
	remove_element(name);
    }
}



// Update the progress bar is possible, like
function update_progress_bar(current, total){
    var bar = $('#progress-bar');
    // I don't strust javascript float, so I prefer to comapre int for exit
    if (current >= total){
	bar.css('width', '0%');
	// When full, show that we are ok with the commands
	raise_message_ok('All commands are launched');
	return;
    }
    // Ok in the middle
    var pct = parseInt(100*current/total);
    bar.css('width', ''+pct+'%');
    
    
}


/*
  Tool bar related code
*/

function hide_toolbar(){
    $('#toolbar').hide();
    $('#hide_toolbar_btn').hide();
    $('#show_toolbar_btn').show();
    save_toolbar('hide');
}

function show_toolbar(){
    $('#toolbar').show();
    $('#hide_toolbar_btn').show();
    $('#show_toolbar_btn').hide();
    save_toolbar('show');
}

function save_toolbar(toolbar){
    console.log('Need to save toolbar pref '+toolbar);
    $.post("/user/save_pref", { 'key' : 'toolbar', 'value' : toolbar});
}



/* And if the user lick on the good image, we untoggle them. */
function show_detail(name){
    var myFx = $('#'+name).slideToggle();
    $('#show-detail-'+name).toggle();
    $('#hide-detail-'+name).toggle();
}


// The user ask to show the hidden problems that are duplicated
function show_hidden_problems(cls){
    $('.'+cls).show();
    // And hide the vvv button
    $('#btn-'+cls).hide();
}

// At start we hide the unselect all button
$(document).ready(function(){
	//$('#unselect_all_btn').hide();
    $('.btn_show_when_selection').hide();
    /*
    if(toolbar_hide){
        hide_toolbar();
    }else{
        $('#show_toolbar_btn').hide();
    }
    */

    // If actions are not allowed, disable the button 'select all'
    if(!actions_enabled){
	$('#select_all_btn').addClass('disabled');
	// And put in opacity low the 'selectors'
	$('.tick').css({'opacity' : 0.4});
    }
});


// At start we hide the selected images
// and the actions tabs
$(document).ready(function(){
    $('.img_tick').hide();
});



function toggle_select_buttons(){
    /*
      $('#select_all_btn').toggle();
      $('#unselect_all_btn').toggle();
    */
    
    $('.btn_hide_when_selection').toggle();
    $('.btn_show_when_selection').toggle();
}

function show_unselect_all_button(){
    /*
    $('#select_all_btn').hide();
    $('#unselect_all_btn').show();
    */
    $('.btn_hide_when_selection').hide();
    $('.btn_show_when_selection').show();
}

function show_select_all_button(){
    /*$('#unselect_all_btn').hide();
      $('#select_all_btn').show();*/

    $('.btn_hide_when_selection').show();
    $('.btn_show_when_selection').hide();
}

// When we select all, add all in the selected list,
// and hide the select all button, and swap it with
// unselect all one
function select_all_problems(){
    // Maybe the actions are not allwoed. If so, don't act
    if(!actions_enabled){return;}

    toggle_select_buttons();
    /*$('#select_all_btn').hide();
    $('#unselect_all_btn').show();*/

    // we wil lget all elements by looking at .details and get their ids
    $('.element').each(function(){
	add_element($(this).attr('id'));
    });
}

// guess what? unselect is the total oposite...
function unselect_all_problems(){
    toggle_select_buttons();
    /*$('#unselect_all_btn').hide();
    $('#select_all_btn').show();*/
    flush_selected_elements();
}


/* We keep an array of all selected elements */
var selected_elements = [];

function add_remove_elements(name){
    // Maybe the actions are not allwoed. If so, don't act
    if(!actions_enabled){return;}


    //alert(selected_elements.indexOf(name));
    if( selected_elements.indexOf(name) != -1 ){
	remove_element(name);
    }else{
	add_element(name);
    }
}


/* function when we add an element*/
function add_element(name){
    selected_elements.push(name);

    // We put the select all button in unselect mode
    show_unselect_all_button();

    // We show the 'tick' image ofthe selector on the left
    $('#selector-'+name).show();
    
    // mark the line as selected
    $('#'+name).addClass('element-selected');
    
    /* The user will ask something, so it's good to reinit
       the refresh time so he got time to launch its action,
       see reload.js for this function 
    */
    reinit_refresh();
}

/* And or course when we remove it... */
function remove_element(name){
    selected_elements.remove(name);
    if(selected_elements.length == 0){
	show_select_all_button();
    }
    // And hide the tick image
    $('#selector-'+name).hide();

    // mark the line as unselected
    $('#'+name).removeClass('element-selected');

}


/* Flush selected elements, so clean the list
but also untick thems in the UI */
function flush_selected_elements(){
    /* We must copy the list so we can parse it in a clean way
     without fearing some bugs */
    var cpy = $.extend({}, selected_elements);
    $.each(cpy, function(idx, name) {
	remove_element(name);
    });
}

/* Now actions buttons : */
var nb_rechecked = 0;
function recheck_now_all(){
    nb_rechecked = 0;
    var total = selected_elements.length;
    $.each(selected_elements,function(idx, name){
	    console.log('RECHECK?'+idx+''+name);
	    recheck_now(name, function(){
		    nb_rechecked +=1;
		    update_progress_bar(nb_rechecked, total);}
		);
    });
    flush_selected_elements();
}


/* Now actions buttons : */
function submit_check_ok_all(){
    $.each(selected_elements, function(idx, name){
        submit_check(name, '0', 'Forced OK from WebUI');
    });
    flush_selected_elements();
}


/* Now actions buttons : */
function try_to_fix_all(){
    $.each(selected_elements, function(idx, name){
        try_to_fix(name);
    });
    flush_selected_elements();
}


var nb_acknowledged = 0;
function acknowledge_all(user){
    nb_acknowledged = 0;
    var total = selected_elements.length;
    $.each(selected_elements, function(idx, name){
	    do_acknowledge(name, 'Acknowledged by '+user, user, function(){
		    nb_acknowledged +=1;
		    console.log('EXEC'+nb_acknowledged+' '+total);
		    update_progress_bar(nb_acknowledged, total);
		});
	});
    flush_selected_elements();
}


function remove_all(user){
    $.each(selected_elements, function(idx, name){
        do_remove(name, 'Removed from WebUI by '+user, user);
    });
    flush_selected_elements();
}










// OPTIONS
var is_table_options_div_shown = false;
$(function(){
	$('#table_options_div').hide();
    });


function display_table_options(){
    var orig_a = a;
    var a = $('#btn-options');
    var pos = a[0].getBoundingClientRect();
    console.log('GO TO'+pos.left);
    var div = $('#table_options_div');
    div.css('left', pos.left - 100 );
    div.css('top' , pos.top  + 20);
    div.show();
}


function toggle_table_options(){
    if(is_table_options_div_shown){
	close_table_options();
	is_table_options_div_shown = false;
    }else{
	display_table_options();
	is_table_options_div_shown = true;
    }
}

function close_table_options(){
    is_table_options_div_shown = false;
    $('#table_options_div').hide();
}



function apply_form_options(){
    var checkboxes = $("#table_options_div:checkbox");
    console.log(checkboxes.length);
    var realms = [];
    for(var i=0; i<checkboxes.length; i++){
	var box = $(checkboxes[i]);
	var b = (box.attr('checked') == 'checked');
	console.log(b);
	console.log(box.attr('name'));
    }
}






var tabular_cols = [
		    {name:'display-name', id:18, display:_('list.display_name')},
		    {name:'address', id:19, display:_('list.address')},
		    {name:'business-impact', id:8, display:_('list.business_impact')},
		    {name:'realm', id:7, display:_('list.realm')},
		    {name:'tags', id:9, display:_('list.host_templates')},
		    {name:'hostgroups', id:14, display:_('list.hostgroups')},
		    {name:'servicegroups', id:16, display:_('list.servicegroups')},		    
		    {name:'contacts', id:15, display:_('list.contacts')},
		    {name:'parents', id:10, display:_('list.link_to')},		    
		    {name:'summary', id:17, display:_('list.context')},
		    {name:'state', id:1, display:_('list.status')},
		    {name:'state-type', id:4, display:_('list.confirmed')},		    
		    {name:'last-check', id:5, display:_('list.last_check')},
		    {name:'attempts', id:6, display:_('list.attempts')},		    
		    {name:'duration',  'id':2, display:_('list.duration')},
		    {name:'root-problem', id:11, display:_('list.is_root_problem')},
		    {name:'acknowledged', id:12, display:_('list.is_acknowledged')},
		    {name:'downtime', id:13, display:_('list.in_downtime')},
		    {name:'output', id:3, display:_('list.output')},
		    {name:'long_output', id:20, display:_('list.long_output')}
		    ];




$(function(){
	// If cols was never changed, put the default value instead
	if(cols == 0){
	    cols = 164618;
	}
	var f = $('#table_options_form');

	filter_enabled_names = [];
	for(var i=0; i<current_filters.length;i++){
	    filter_enabled_names.push( current_filters[i].type );
	}

	for (var i=0; i<tabular_cols.length; i++){
	    var e = tabular_cols[i];
	    var s = '<label class="checkbox"> <input class="options-checkbox" type="checkbox" name="'+e.name+'" id="col-'+e.name+'"/>'+e.display+'</label>';
	    var o = $(s);
	    f.append(o);
	    var offset = e.id;
	    var mask = 1 << offset; // gets the ith bit
	    var m = cols & mask;
	    var b = (m != 0);

	    // Maybe the filter ask for such field, if so enable it
	    var name = e.name;
	    for (var j=0; j<filter_enabled_names.length;j++){
		if(name == filter_enabled_names[j]){
		    console.log('Forcing filtered filed to display');
		    b = true;
		}
	    }

	    console.log('IS CHECKED?'+e.name+' '+b);
	    $('#col-'+e.name).attr('checked', b);
	}
	apply_cols();
	
	// When the user update the columns, compute the cols by looking at checkbox, update the
	//ta ble visibility and finally update if need the value in the user pref center.
	var checkboxes = $(".options-checkbox").on('click', function(evt){
		apply_cols();
		update_cols_cookie();
	    });

	// Also putting th into white on black mode, to show there is a filter there
	for (var j=0; j<current_filters.length;j++){
	    var obj = current_filters[j];
	    console.log('QUICK FILTERING FILTER ');
	    console.log(obj);
	    var type = obj.type;
	    var th = $('#th-'+type);
	    th.css('color', 'white');
	    th.css('background-color', 'black');
	    th.find('> i').css('opacity', 1);	    
	}


    });



function find_options_entry(name){
    for(var i=0; i<tabular_cols.length; i++){
	if(tabular_cols[i].name == name){
	    return tabular_cols[i];
	}
    }
    return null;
}

function display_options_col(n){
    $('.th-'+n).show();
    $('.td-'+n).show();
    var e = find_options_entry(n);
    var id = e.id;
    console.log('MAKE SURE THE ID'+id+' is added to col');
    //compute_col();
}

function hide_options_col(n){
    $('.th-'+n).hide();
    $('.td-'+n).hide();
    var e = find_options_entry(n);
    var id = e.id;

    console.log('MAKE SURE THE ID'+id+' is removed to col');
    //compute_col();
}

// DEFAULT VALUE FOR COL=206= state+duration+output+realm
function compute_col(){
    // Reset the cols var to 0
    cols = 0;
    var checkboxes = $(".options-checkbox");
    for(var i=0; i<checkboxes.length; i++){
	var c = $(checkboxes[i]);
	var b = (c.attr('checked') == 'checked');
	var n = c.attr('name');
	
	var e = find_options_entry(n);
	var offset = e.id;
	if(b){
	    cols |= 1 << offset;
	}
    }
    console.log('COLS?'+cols);
}

function apply_cols(){
    compute_col();
    for (var i=0; i<tabular_cols.length; i++){
	var e = tabular_cols[i];
	var offset = e.id;
	var mask = 1 << offset; // gets the ith bit
	var m = cols & mask;
	var b = (m != 0);
	if(b){
	    display_options_col(e.name);
	}else{
	    hide_options_col(e.name);
	}
    }
    
}


function update_cols_cookie(){
    $.post("/user/save_pref", { 'key' : 'tab_cols', 'value' : JSON.stringify(cols)});
}




function unset_tab_option(name){
    $('#col-'+name).attr('checked', false);
    apply_cols();
    update_cols_cookie();
}


// *********** Number of element by page

/*********** SPinner **********/
function get_small_spinner(name){
    var opts = {
        lines: 13, // The number of lines to draw
        length: 3, // The length of each line
        width: 2, // The line thickness
        radius: 2, // The radius of the inner circle
        corners: 1, // Corner roundness (0..1)
        rotate: 0, // The rotation offset
        color: '#000', // #rgb or #rrggbb
        speed: 1, // Rounds per second
        trail: 60, // Afterglow percentage
        shadow: false, // Whether to render a shadow
        hwaccel: false, // Whether to use hardware acceleration
        className: 'spinner', // The CSS class to assign to the spinner
        zIndex: 2e9, // The z-index (defaults to 2000000000)
        top: '2px', // Top position relative to parent in px
        left: 'auto' // Left position relative to parent in px
    };
    var target = $('#'+name)[0];
    var spinner = new Spinner(opts).spin(target);
    return spinner;
}


$(function(){
	$('#table_nb_elements_sel').change(function(evt){
		console.log('Change on');
		console.log($(this).val());
		get_small_spinner('table_nb_elements_span');
		var jqxhr = $.post("/user/save_pref", { 'key' : 'tab_nb_elts', 'value' : JSON.stringify($(this).val())});
		jqxhr.done(function() {
			$('#table_nb_elements_span').empty();
			force_refresh();
		    })
	    });

	var opts = $('.table_nb_elements_opt');
	for(var i=0; i<opts.length; i++){
	    var o = $(opts[i]);
	    if( o.val() == tab_nb_elts){
		o.prop('selected', true);
	    }
	}
    });






