#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.


class COUNTER:
    WARNING = u'warning'
    ERROR = u'error'
    USER = u'user-set'
    TOTAL = u'window-total'


class COUNTER_TITLE:
    TITLES = {COUNTER.WARNING: "{{app._('element.title_panel_warnings')}}", COUNTER.ERROR: "{{app._('element.title_panel_errors')}}"}


class HelperObject(object):
    def __init__(self, app):
        self.app = app
    
    
    def build_link_dom_element_depend_if_admin(self, item_type, uuid, label):
        user = self.app.get_user_auth()
        is_admin = user.is_admin()
        
        _to_return = []
        if is_admin and uuid:
            _to_return.append('''<a href="/elements/%s/%s" class ="title shinken-link" draggable="false" target="_blank"><span class="shinken-tag-label">%s</span></a>''' % (item_type, uuid, label))
        else:
            _to_return.append('''<span class="title shinken-space">%s</span>''' % label)
        return " ".join(_to_return)
    
    
    def build_icons_plus(self, is_mass_change=False):
        _to_return = []
        if is_mass_change:
            _to_return.append('''%s''' % self.build_icon_plus("NONE"))
        _to_return.append('''%s''' % self.build_icon_plus("ON"))
        _to_return.append('''%s''' % self.build_icon_plus("OFF"))
        return "".join(_to_return)
    
    
    def build_icon_plus(self, value, label=""):
        _name_img = ''
        if value == 'NONE':
            _name_img = 'property_plus_NONE.png'
        elif value == 'ON':
            _name_img = 'property_plus_on.png'
        elif value == 'OFF':
            _name_img = 'property_plus_off.png'
        
        _to_return = []
        _to_return.append('''<div class='shinken-btn-plus-option' data-value='%s'>''' % value)
        if _name_img:
            _to_return.append('''<img class='shinken-btn-plus-option-img' src='/static/%s/images/shinken/icon-plus/%s'>''' % (self.app.http_start_time, _name_img))
        _to_return.append('''</div>''')
        _to_return.append('''%s''' % label)
        return "".join(_to_return)
    
    
    def get_button_html(self, label="", id_button="", icon_class="", class_to_add='', attribute_to_add="", onclick="MANAGER.EventManager.clickOnButton(event)", datas="", onmouseenter='', onmouseleave=''):
        to_return = []
        if id_button:
            id_button = 'id="%s"' % id_button
        if onclick:
            onclick = 'onclick="%s"' % onclick
        if onmouseenter:
            onmouseenter = 'onmouseenter="%s"' % onmouseenter
        if onmouseleave:
            onmouseleave = 'onmouseleave="%s"' % onmouseleave
        _datas_to_string = " ".join('data-%s="%s"' % (key, val) for (key, val) in datas.items()) if datas else ""
        to_return.append('''<div %s class="shinken-button-container shinken-user-select-none %s" %s %s %s %s %s value="">''' % (id_button, class_to_add, onclick, _datas_to_string, attribute_to_add, onmouseenter, onmouseleave))
        to_return.append('''    <button class="shinken-button">''')
        if icon_class:
            to_return.append('''        <span class="%s"></span>''' % icon_class)
        to_return.append('''        <span class="shinken-button-label">%s</span>''' % label)
        to_return.append('''        <span class="shinken-error-counter shinken-counter" title="%s" data-number=""><span class="shinken-counter-label"></span></span>''' % self.app._('element.title_panel_errors'))
        to_return.append('''        <span class="shinken-warning-counter shinken-counter" title="%s" data-number=""><span class="shinken-counter-label"></span></span>''' % self.app._('element.title_panel_warnings'))
        to_return.append('''        <span class="shinken-user-set-counter shinken-counter" data-number=""><span class="shinken-counter-label"></span></span>''')
        to_return.append('''    </button>''')
        to_return.append('''</div>''')
        return " ".join(to_return)
    
    
    def get_check_box_cell_html(self, user_checkbox_on, default_checkbox_on, name, class_to_add=''):
        _data_name = 'data-name="%s"' % name if name else ''
        if user_checkbox_on == -1:
            return '''<td class="shinken-cell-checkbox-container %s" %s ></td>''' % (class_to_add, _data_name)
            
        _class_user_checkbox = 'shinken-checked' if user_checkbox_on == '1' or user_checkbox_on == 1 else ''
        _class_default_checkbox = 'shinken-checked' if default_checkbox_on == '1' or default_checkbox_on == 1 else ''
        _has_inherited = True
        if default_checkbox_on == -1:
            _has_inherited = False
        
        to_return = []
        to_return.append('''<td class="shinken-cell-checkbox-container %s" %s onclick="MANAGER.EventManager.clickOnCheckboxInput(event)">''' % (class_to_add, _data_name))
        to_return.append('''    <div class="shinken-checkbox-container">''')
        to_return.append('''        <div class="shinken-checkbox shinken-checkbox-user %s"><span class="shinkon-check"></span></div>''' % _class_user_checkbox)
        if _has_inherited:
            to_return.append('''        <div class="shinken-checkbox shinken-checkbox-inherited"><span class="shinkon-check"></span></div>''')
            to_return.append('''        <div class="shinken-checkbox shinken-checkbox-default %s"><span class="shinkon-check"></span></div>''' % _class_default_checkbox)
        to_return.append('''    </div>''')
        to_return.append('''</td>''')
        return " ".join(to_return)
    
    
    def get_check_box_buttons_cell_html(self, name, class_to_add='', label_button_off="", label_button_on=""):
        
        _data_name = 'data-name="%s"' % name if name else ''
        to_return = []
        to_return.append('''<td class="shinken-cell-checkbox-container %s" %s onclick="MANAGER.EventManager.clickOnCheckboxInput(event)">''' % (class_to_add, _data_name))
        to_return.append('''    <div class="shinken-checkbox-container">''')
        to_return.append('''        %s ''' % self.get_button_html(label=label_button_off, class_to_add="shinken-hidden-if-selected"))
        to_return.append('''        %s ''' % self.get_button_html(label=label_button_on, class_to_add="shinken-hidden-if-not-selected"))
        to_return.append('''    </div>''')
        to_return.append('''</td>''')
        return " ".join(to_return)
    
    
    def get_check_collapse_cell_html(self, is_collapse, name, class_to_add='', shinkon_plus='shinicon-angle-down', shinkon_minus='shinicon-angle-up'):
        _class = 'shinken-collapse' if is_collapse else ''
        
        _data_name = 'data-name="%s"' % name if name else ''
        to_return = []
        to_return.append('''<td class="shinken-cell-collapse-container shinken-collapse-listener %s %s" %s onclick="MANAGER.EventManager.clickOnCollapseButton(event)">''' % (class_to_add, _class, _data_name))
        to_return.append('''    <div class="shinken-collapse-container">''')
        to_return.append('''        <span class="collapse-plus %s"></span>''' % shinkon_plus)
        to_return.append('''        <span class="collapse-minus %s"></span>''' % shinkon_minus)
        to_return.append('''    </div>''')
        to_return.append('''</td>''')
        return " ".join(to_return)
    
    
    def get_radio_button_cell_html(self, name, group_name, label="", class_to_add='', attribute_to_add="", datas="", help_label=False):
        _data_name = 'data-name="%s"' % name
        _data_group_name = 'data-group-name="%s"' % group_name
        _attribute_to_string = attribute_to_add
        if help_label:
            _attribute_to_string = '%s onmouseenter="MANAGER.EventManager.mouseEnter(event)" onmouseleave="MANAGER.EventManager.mouseLeave(event)" data-help-label="%s"' % (_attribute_to_string, help_label)
        if datas:
            for key, val in datas.iteritems():
                _attribute_to_string = '%s data-%s="%s"' % (_attribute_to_string, key, val)
        to_return = []
        to_return.append('''<td class="shinken-cell-radio-button %s" %s %s %s onclick="MANAGER.EventManager.clickOnRadioBtn(event)">''' % (class_to_add, _data_name, _data_group_name, _attribute_to_string))
        to_return.append('''    <div class="shinken-radio-button-container">''')
        to_return.append('''    <table class="shinken-width-100"><tr>''')
        to_return.append('''        <td class="shinken-radio-button-icon-cell"><div class="shinken-radio-button"><div class="shinken-checked"></div></div></td>''')
        if label:
            to_return.append('''    <td><div class="shinken-radio-button-label">%s</div></td>''' % label)
        to_return.append('''    </tr></table>''')
        to_return.append('''</td>''')
        return " ".join(to_return)
    
    
    def get_tag_container_parent_html(self, item_prop, entry):
        _to_return = []
        _to_return.append('''<div class="droppable"''')
        _to_return.append(''' data-index="%s"''' % entry.selected_order)
        _to_return.append(''' ondrop="MANAGER.DragNDropManager.dropShinken(event, 'selected-item', '%s', this)"''' % item_prop)
        _to_return.append(''' ondragend="MANAGER.DragNDropManager.dragEndShinken(event, 'selected-item')"''')
        _to_return.append(''' ondragover="MANAGER.DragNDropManager.dragOverShinken(event, 'selected-item', '%s', this)">''' % item_prop)
        _to_return.append('''    %s''' % self.get_tag_container_html(item_prop, entry))
        _to_return.append('''</div>''')
        
        return " ".join(_to_return)
    
    
    def get_counter_html(self, id="", number="", label="", class_to_add="", attribute_label="", extra_attribute=""):
        _id = ("id-shinken-%s-counter" % id) if id else ""
        _to_return = []
        _to_return.append('''<span id="%s" class="shinken-counter %s" data-number="%s" %s''' % (_id, class_to_add, number, extra_attribute))
        _to_return.append('''  onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="">''')
        _to_return.append('''<span class="shinken-counter-label" %s>''' % attribute_label)
        _to_return.append('''<span class="shinken-counter-extra-label">%s</span>''' % label)
        _to_return.append('''%s''' % number)
        _to_return.append('''</span>''')
        _to_return.append('''</span>''')
        return ''.join(_to_return)
    
    
    def get_tag_container_html(self, item_prop, entry, add_close=True, add_dragging=True):
        _to_return = []
        if add_dragging:
            _to_return.append('''    <table class="container-tag draggable %s" draggable="true"''' % entry.extra_class)
        else:
            _to_return.append('''    <table class="container-tag %s"''' % entry.extra_class)
        
        _to_return.append('''     data-key-name="%s"''' % entry.value)
        _to_return.append('''     data-state="%s"''' % entry.state_element)
        _to_return.append('''     data-item-type="%s"''' % entry.item_type)
        _to_return.append('''     data-type="user" ''')
        _to_return.append('''     data-is-disabled="%s"''' % 'true' if entry.is_disable() else 'false')
        _to_return.append('''     data-force-to-null="%s"''' % 'true' if entry.is_forced_to_null() else 'false')
        _to_return.append('''     data-uuid="%s"''' % entry.id)
        if add_dragging:
            _to_return.append('''     ondragstart="MANAGER.DragNDropManager.dragStartShinken(event, 'selected-item', '%s', '%s')" >''' % (item_prop, entry.value))
        _to_return.append('''        <tbody onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="" shi-tip-placement="bottom" >''')
        _to_return.append('''        <tr class="text-break-all-pre-line" >''')
        _to_return.append('''            <td class="content">''')
        _to_return.append('''                %s''' % self.build_link_dom_element_depend_if_admin(entry.item_type, entry.id_link, entry.value))
        if add_close:
            _to_return.append('''                <span class="shinken-close-icon" onclick="MANAGER.EventManager.clickOnDeleteItemSelector('%s', '%s')" >x</span>''' % (item_prop, entry.value))
        _to_return.append('''            </td>''')
        _to_return.append('''            <td class="shinken-tag-cube"></td>''')
        _to_return.append('''        </tr>''')
        _to_return.append('''        </tbody>''')
        _to_return.append('''    </table>''')
        
        return " ".join(_to_return)
    
    
    def get_counters_html(self, wrapper_class="", counters=None, counters_value=None, counters_labels=None):
        if not counters:
            counters = [COUNTER.ERROR, COUNTER.WARNING, COUNTER.USER, COUNTER.TOTAL]
        if not counters_value:
            counters_value = {}
        if not counters_labels:
            counters_labels = {}
        _to_return = []
        
        if wrapper_class:
            _to_return.append('''<span class=%s>''' % wrapper_class)
        for counter in counters:
            _to_return.append(self.get_counter_html(class_to_add="shinken-%s-counter" % counter, number=counters_value.get(counter, ""), label=counters_labels.get(counter, "")))
        if wrapper_class:
            _to_return.append('''</span>''')
        return ''.join(_to_return)
