SHINKEN.TOOLS.TEST_AUTO = (function ( self ) {
    //********************************************  MESSAGES   ******************************************************//
    var _messages                 = {};
    self.hasMessage               = function () {
        return !!Object.keys( _messages ).length;
    };
    self.addError                 = function ( text_message ) {
        console.warn( "GSOU", "[]", text_message );
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new OBJECT.Message( COMPONENT.CONST.STATUS.ERROR, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.addWarning               = function ( text_message ) {
        if ( !_messages[ __shinken_test_type ] ) {
            _messages[ __shinken_test_type ] = [];
        }
        _messages[ __shinken_test_type ].push( new OBJECT.Message( COMPONENT.CONST.STATUS.WARNING, "[" + __shinken_test_type + "] - " + text_message ) );
    };
    self.buildMessage             = function ( timeout ) {
        setTimeout( function () {
            if ( _has_script_error ) {
                self.addError( _has_script_error + ' error(s) javascript detected' );
            }
            var _to_write = new OBJECT.Messages();
            var _keys     = Object.keys( _messages );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _to_write.addMessages( _messages[ _keys[ i ] ] );
            }
            var _dom_element = document.getElementById( 'saving-log-modal-body' );
            
            if ( _to_write.hasMessage() ) {
                if ( _dom_element ) {
                    _dom_element.innerHTML = _to_write.buildMessage();
                    SHINKEN.MODAL.toggle();
                }
                else {
                    var _dom_id           = document.getElementById( "shinken-simple-modal-container" );
                    _dom_id.classList.add('shinken-simple-modal-active');
                    _dom_id.querySelector( '.shinken-simple-modal' ).innerHTML = _to_write.buildMessage();
                }
            }
            else if ( !__is_single ) {
                SHINKEN.TOOLS.TEST_AUTO.doNext();
                console.log( "[TEST_AUTO DONE]", __shinken_test_type, "[OK]", "__do_next = " + __do_next, "phase" + __phase );
            }
        }, timeout );
        
    };
    //********************************************  NEXT    ******************************************************//
    self.doNext                   = function ( timeout, forced_shinken_test_type, forced_phase ) {
        window.onbeforeunload = function () {
        };
        if ( SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ __shinken_test_type ].cancel_next ) {
            return;
        }
        var _timeout         = timeout + 2000;
        var _max_phase       = SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ __shinken_test_type ].phases || 1;
        var _has_other_phase = __phase < _max_phase;
        var _next;
        if ( _has_other_phase ) {
            __phase++;
            _next = __shinken_test_type;
        }
        else {
            __phase = 1;
            _next   = SHINKEN.TOOLS.STRING.prefix_by_zero( parseInt( __shinken_test_type ) + 1, 5 );
        }
        if ( !SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ _next ] || !SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ _next ].address ) {
            console.log( "GREG", "[FIN DES TEST AUTO]", "[]" );
            return;
        }
        if ( __do_next ) {
            setTimeout( function () {
                window.location = self.getNextLink( _next, __phase );
            }, _timeout );
        }
        if ( forced_shinken_test_type && forced_phase ) {
            SHINKEN.HIGHWAY.goTo( self.getNextLink( forced_shinken_test_type, forced_phase ) );
        }
        
    };
    self.refreshPage              = function ( timeout, go_next ) {
        setTimeout( function () {
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                if ( go_next ) {
                    SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO.getNextPhaseLink() );
                }
                SHINKEN.HIGHWAY.refreshCurrentPage();
            }
        }, timeout );
        return 50;
    };
    self.getNextLink              = function ( next, phase ) {
        var _params = SHINKEN.HIGHWAY.getParams();
        if ( SHINKEN.TOOLS.STRING.contains( SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ next ].address, "?" ) ) {
            return location.origin + SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ next ].address + "&shinken_test_auto=" + next + "&phase=" + phase;
        }
        return location.origin + SHINKEN.TOOLS.TEST_AUTO.CONST.STRUCTURE[ next ].address + "?shinken_test_auto=" + next + "&phase=" + phase;
    };
    self.getNextPhaseLink         = function () {
        var _params = SHINKEN.HIGHWAY.getParams();
        if ( isNaN( parseInt( _params.phase ) ) ) {
            _params.phase = 1;
        }
        _params.phase = parseInt( _params.phase ) + 1;
        var _url      = SHINKEN.HIGHWAY.buildParamsToUrl( _params );
        SHINKEN.HIGHWAY.changeUrl( _url );
    };
    //********************************************  TEST    ******************************************************//
    self.___isVariableEqualsTo    = function ( object, key, value_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( object[ key ] !== value_expected ) {
            if ( object.name ) {
                extra_label += " <span class='shinken-data-user'>" + object.name + "</span> ";
            }
            this.addError( extra_label + " la valeur de la clé [<span class='shinken-data-user'>" + key + "</span>] n'est pas égale à [<span class='shinken-data-user'>" + value_expected + "</span>] mais à [<span class='shinken-data-user'>" + object[ key ] + "</span>]" );
        }
    };
    self.___isEqualsTo            = function ( to_test, value_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( to_test !== value_expected ) {
            this.addError( extra_label + " la valeur n'est pas égale à  [<span class='shinken-data-user'>" + value_expected + "</span>]  mais à [<span class='shinken-data-user'>" + to_test + "</span>]" );
        }
    };
    self.___isArrayLengthEqualsTo = function ( array, value_expected, label_array, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( array.length !== value_expected ) {
            this.addError( extra_label + "la longueur du tableau <span class='shinken-data-user'>" + label_array + "</span> n'est pas égale à [<span class='shinken-data-user'>" + value_expected + "</span>] mais à [<span class='shinken-data-user'>" + array.length + "</span>]" );
        }
    };
    self.__isFlatContentEqualTo           = function ( dom_element, string_expected, in_label, extra_label ) {
        string_expected = "" + string_expected;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GREG", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        return self.__isTextEqualTo( SHINKEN.TOOLS.STRING.replaceAll( dom_element.innerText, /\s/g, "" ).trim(), string_expected, in_label, extra_label );
    };
    self.__isInnerTextEqualTo             = function ( dom_element, string_expected, in_label, extra_label ) {
        string_expected = "" + string_expected;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GSOU", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        var _to_test = SHINKEN.TOOLS.STRING.replaceAll( dom_element ? dom_element.innerText : "", /\s/g, " " ).trim();
        if ( dom_element.tagName === "INPUT" || dom_element.tagName === "TEXTAREA" ) {
            _to_test = dom_element.value;
        }
        return self.__isTextEqualTo( _to_test, string_expected, in_label, extra_label );
    };
    self.__isInnerTextContains            = function ( dom_element, value_to_test, in_label, extra_label ) {
        value_to_test = "" + value_to_test;
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            console.warn( "GREG", "[__isInnerTextEqualTo]", "[NOT DONE ON IE]", __shinken_test_type );
            return;
        }
        if ( !in_label ) {
            in_label = dom_element.innerText;
        }
        return self.__containsText( SHINKEN.TOOLS.STRING.replaceAll( dom_element.innerText, /\s/g, " " ).trim(), value_to_test, in_label, extra_label );
    };
    self.__isTextEqualTo                  = function ( text, string_expected, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( text !== string_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> n'est pas égale à [<b>[" + string_expected + "]</b>] ==> [" + text + "]" );
        }
    };
    self.__containsText                   = function ( text, value_to_test, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !SHINKEN.TOOLS.STRING.contains( text, value_to_test ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> ne contient pas <b>" + value_to_test + "</b> ==> [" + text + "]" );
        }
    };
    self.__isNotEmpty                     = function ( to_set, in_label, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( to_set === "" ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "le text dans <b>" + in_label + "</b> est vide" );
        }
    };
    /**
 *
 * @deprecated V02.08.01
 */
    self.__isPropErrorWarningCounter      = function ( prop_name, error_expected, warning_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( prop_name );
        if ( _prop.getCounterError().getValue() !== error_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre d'erreur pour la propriété <b>" + prop_name + "</b> est différent de <b>" + error_expected + "</b> ==> [" + _prop.getCounterError().getValue() + "]" );
        }
        if ( _prop.getCounterWarning().getValue() !== warning_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre de warning pour la propriété <b>" + prop_name + "</b> est différent de <b>" + warning_expected + "</b> ==> [" + _prop.getCounterWarning().getValue() + "]" );
        }
    };
    self.__hasStyle                       = function ( dom_element, key, value_expected, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        var _compute = DOM.Service.getComputedStyle( dom_element );
        if ( !_compute || _compute[ key ] !== value_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le style <b>" + key + "</b> de <b>" + text_desc + "</b> n'est pas égale à <b>" + value_expected + "</b> ==> <b>[" + _compute[ key ] + "]</b>" );
        }
        
    };
    self.__hasClass                       = function ( dom_element, class_name, text_desc, extra_label, inverse ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( inverse ) {
            if ( dom_element.classList.contains( class_name ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La class <b>" + class_name + "</b> existe dans <b>" + text_desc + "</b>" );
            }
        }
        else if ( !dom_element.classList.contains( class_name ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La class <b>" + class_name + "</b> n'existe pas dans <b>" + text_desc + "</b>" );
        }
        
    };
    self.__hasPulsate                     = function ( dom_element, text_desc, timeout ) {
        SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-pulsate', text_desc, "pendant le clignotement" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, 'shinken-pulsate', text_desc, "aprés le clignotement de " + timeout + "ms", true );
        }, timeout );
    };
    self.__isVisible                      = function ( dom_element, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = dom_element.innerText;
        }
        if ( !DOM.Service.isVisible( dom_element, 2 ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> n'est pas visible" );
        }
        
    };
    self.__isVisibleAndHasInnerText       = function ( dom_element, innerText, text_desc, extra_label ) {
        self.__isVisible( dom_element, text_desc, extra_label );
        self.__isInnerTextEqualTo( dom_element, innerText, text_desc, extra_label );
    };
    self.__isNotVisible                   = function ( dom_element, text_desc, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc && dom_element ) {
            text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
        }
        if ( DOM.Service.isVisible( dom_element, 2 ) ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> est visible" );
        }
        
    };
    self.__doesntExist                    = function ( dom_element, text_desc, extra_label ) {
        if ( !dom_element ) {
            return;
        }
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !text_desc ) {
            text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
        }
        if ( dom_element ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le dom élément <b>" + text_desc + "</b> existe" );
        }
        
    };
/**
 *
 * @deprecated V02.08.01
 */
    self.__nbUserElementSelected          = function ( prop_name, number_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        var _prop   = MANAGER.__instance_property_distributor.elements[ prop_name ];
        var _length = 0;
        switch ( _prop.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                var _element_selected = _prop.getSelector().list_element.getSelectedElements();
                _length               = _element_selected.length;
                break;
        }
        if ( _length !== number_expected ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le nombre d'éléments sélectionnés pour la propriété <b>" + prop_name + "</b> est different de " + number_expected + " ==> [" + _length + "]" );
        }
    };
/**
 *
 * @deprecated V02.08.01
 */
    self.__validTimeperiodDaySimple       = function ( prop_name, value, error_expected, warning_expected ) {
        var _timeout = 200;
        var _prop    = MANAGER.__instance_property_distributor.getElement( prop_name );
        _prop.setValueFromUser( value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isPropErrorWarningCounter( prop_name, error_expected, warning_expected );
        }, _timeout );
        return _timeout;
    };
/**
 *
 * @deprecated V02.08.01
 */
    self.__isTagInformation               = function ( name_property, status, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        if ( !status ) {
            status = COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( name_property );
        if ( _prop.tag_information.dom_element.dataset.status !== status ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "Le status du tag information de <b>" + name_property + "</b> n'est pas " + status + " ==> [" + _prop.tag_information.dom_element.dataset.status + "]" );
        }
        switch ( status ) {
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _prop.tag_information.dom_element, "border", "1px solid rgb(236, 87, 87)", "tag d'information de " + _prop.getName(), extra_label );
                //SHINKEN.TOOLS.TEST_AUTO.__isVisible( _prop.tag_information.dom_element, "tag d'information de " + _prop.getName(), extra_label );
                break;
            case COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE :
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _prop.tag_information.dom_element, "display", "none", "tag d'information de " + _prop.getName(), extra_label );
                //SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _prop.tag_information.dom_element, "tag d'information de " + _prop.getName(), extra_label );
                break;
        }
    };
/**
 *
 * @deprecated V02.08.01
 */
    self.__specific                       = function ( extra_label, arg1, arg2, arg3, arg4 ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        switch ( __shinken_test_type ) {
            case "00002":
                SHINKEN.TOOLS.TEST_AUTO.__nbUserElementSelected( arg1, 3, extra_label );
                SHINKEN.TOOLS.TEST_AUTO.__isPropErrorWarningCounter( arg1, arg2, arg3, extra_label );
                SHINKEN.TOOLS.TEST_AUTO.__isTagInformation( arg1, arg4, extra_label );
                break;
        }
    };
    //********************************************  ACTION    ******************************************************//
    self.changeUser                     = function ( login, password ) {
        sessionStorage.removeItem( "user_id" );
        $.post( "/user/auth", { "shinken_login": login, "password": password } ).success(
            function ( data ) {
            }
        ).error(
            function ( res ) {
            }
        );
    };
    self.do_JS_action                     = function ( timeout, function_to_eval, time_to_return ) {
        setTimeout( function () {
            eval( function_to_eval );
        }, timeout );
        return time_to_return;
    };
    //var _interval_do_JS_action_when_ready;
    //self.do_JS_action_when_ready          = function ( timeout, function_to_eval, var_to_test, expected_value ) {
    //    var _to_return = 1000;
    //    _interval_do_JS_action_when_ready = setInterval( function () {
    //        if ( var_to_test === expected_value ){
    //            clearInterval( _interval_do_JS_action_when_ready );
    //        }
    //    }, 10 );
    //    return _to_return;
    //};
    //********************************************  DISPATCH    ******************************************************//
    self.dispatchMouseEvent               = function ( timeout, dom_element, type ) {
        setTimeout( function () {
            self.___dispatchMouseEvent( dom_element, type );
        }, timeout );
        return 100;
    };
    self.dispatchMouseEventWithEval       = function ( timeout, dom_element_to_eval, type ) {
        setTimeout( function () {
            self.___dispatchMouseEvent( eval( dom_element_to_eval ), type );
        }, timeout );
        return 100;
    };
    self.___dispatchMouseEvent            = function ( dom_element, type ) {
        var event = new MouseEvent( type, {
            'view'      : window,
            'bubbles'   : true,
            'cancelable': true
        } );
        dom_element.dispatchEvent( event );
    };
    self.___dispatchEnterKeyEvent              = function ( dom_element, type ) {
        var event = new KeyboardEvent( type, {
            bubbles   : true,
            cancelable: true,
            code      : 'Enter',
            key       : 'Enter',
            charCode  : 13,
            keyCode   : 13,
            view      : window,
            shiftKey  : false
        } );
        dom_element.dispatchEvent( event );
    };
    

    //self.__save_external_object           = function ( code_expected, is_current, extra_label ) {
    //    if ( !extra_label ) {
    //        extra_label = "";
    //    }
    //    var item_dump                                                = {};
    //    item_dump[ 'protect_fields__substrings_matching_fields' ]    = JSON.stringify( SHINKEN.TOOLS.ENCRYPTION.getProtectedKeys() );
    //    item_dump[ 'protect_fields__activate_interface_encryption' ] = SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated();
    //    item_dump[ 'protect_fields__are_viewable_by_admin_si' ]      = SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsAreViewableByAdminSi();
    //    var _data                                                    = self.__save_external_object_data( is_current );
    //    item_dump[ 'item' ]                                          = JSON.stringify( _data );
    //
    //    console.error( "GSOU", "[url]", "DEPRECATED", self.__save_external_object_url(), item_dump );
    //
    //    $.post( self.__save_external_object_url(), item_dump ).success(
    //        function ( data ) {
    //            if ( data.rc !== code_expected ) {
    //                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La sauvegarde de l'élement n'a pas réussi " + JSON.stringify( data ) );
    //            }
    //        }
    //    ).error(
    //        function ( res ) {
    //        }
    //    );
    //
    //};
    //self.__save_external_object_url       = function () {
    //    var _switch_value = __shinken_test_type + "-" + __phase;
    //    switch ( _switch_value ) {
    //        case "00021-1":
    //            return '/element/q/serviceshosts/save/20000000000000000000000000000021?bypass_work_area=1';
    //        case "00023-1":
    //            return '/element/q/hostgroups/save/42000000000000000000000000000000?bypass_work_area=1';
    //        case "00024-1":
    //        case "00024-2":
    //            return '/element/q/hostgroups/save/40000000000000000000000000000024?bypass_work_area=1';
    //        case "00025-1":
    //            return '/element/q/hosts/save_in_work_area/00000000000000000000000000000025?submit_to_stagging=1';
    //        case "00025-2":
    //            return '/element/q/hosttpls/save/10000000000000000000000000000025?bypass_work_area=1';
    //        case "00025-3":
    //            return '/element/q/hosts/apply_work_area/00000000000000000000000000000025?ts=' + Date.now();
    //        case "00026-1":
    //            return '/element/q/hosts/save_in_work_area/00000000000000000000000000000026?submit_to_stagging=1';
    //        case "00026-2":
    //            return '/element/q/hosts/apply_work_area/00000000000000000000000000000026?ts=' + Date.now();
    //        case "00026-3":
    //            return '/element/q/hosts/save/00000000000000000000000000000026?bypass_work_area=1';
    //        case "00028-1":
    //            return '/element/q/resultmodulations/save/40000000000000000000000000000024?bypass_work_area=1';
    //        case "00033-1":
    //        case "00033-2":
    //        case "00033-3":
    //            return '/element/q/contacts/save/35000000000000000000000000000000';
    //        case "00038-1":
    //            return '/element/q/hosts/save/00000000000000000000000000000038?bypass_work_area=1';
    //        case "00040-1":
    //        case "00040-2":
    //        case "00040-3":
    //            return '/element/q/hosttpls/save/10000000000000000000000000000040?bypass_work_area=1';
    //        case "00040-4":
    //        case "00040-5":
    //            return '/element/q/hosttpls/save/11000000000000000000000000000040?bypass_work_area=1';
    //        case "00083-5":
    //            return '/element/q/hosts/save_in_work_area/00000000000000000000000000000001?submit_to_stagging=1';
    //        default:
    //            return '/element/q/hosts/save/00000000000000000000000000000001?bypass_work_area=1';
    //
    //    }
    //};
    //self.__save_external_object_data      = function ( is_current ) {
    //    if ( is_current ) {
    //        return getCurrentObjectFromProperty();
    //    }
    //    var _to_return    = {};
    //    var _switch_value = __shinken_test_type + "-" + __phase;
    //    switch ( _switch_value ) {
    //        case "00023-1":
    //            _to_return[ "members" ]                                = {};
    //            _to_return[ "members" ][ "has_plus" ]                  = false;
    //            _to_return[ "members" ][ "links" ]                     = [];
    //            _to_return[ "members" ][ "links" ][ 0 ]                = {};
    //            _to_return[ "members" ][ "links" ][ 0 ][ "exists" ]    = true;
    //            _to_return[ "members" ][ "links" ][ 0 ][ "item_type" ] = "hosts";
    //            _to_return[ "members" ][ "links" ][ 0 ][ "name" ]      = "00023_test_auto";
    //            _to_return[ "members" ][ "links" ][ 0 ][ "_id" ]       = "00000000000000000000000000000023";
    //            _to_return[ "hostgroup_name" ]                         = "test_auto_valid";
    //            _to_return[ "_id" ]                                    = "42000000000000000000000000000000";
    //            break;
    //        case "00024-1":
    //            _to_return[ "members" ]                                = {};
    //            _to_return[ "members" ][ "has_plus" ]                  = false;
    //            _to_return[ "members" ][ "links" ]                     = [];
    //            _to_return[ "members" ][ "links" ][ 0 ]                = {};
    //            _to_return[ "members" ][ "links" ][ 0 ][ "exists" ]    = true;
    //            _to_return[ "members" ][ "links" ][ 0 ][ "item_type" ] = "hosts";
    //            _to_return[ "members" ][ "links" ][ 0 ][ "name" ]      = "00024_test_auto";
    //            _to_return[ "members" ][ "links" ][ 0 ][ "_id" ]       = "00000000000000000000000000000024";
    //            _to_return[ "hostgroup_name" ]                         = "00024_test_auto";
    //            _to_return[ "_id" ]                                    = "40000000000000000000000000000024";
    //            break;
    //        case "00024-2":
    //            _to_return[ "hostgroup_name" ] = "00024_test_auto";
    //            _to_return[ "_id" ]            = "40000000000000000000000000000024";
    //            break;
    //        case "00025-1":
    //            _to_return[ "host_name" ] = "00025_test_auto";
    //            _to_return[ "_id" ]       = "00000000000000000000000000000025";
    //            break;
    //        case "00026-1":
    //            _to_return[ "host_name" ] = "00026_test_auto_renammed";
    //            _to_return[ "_id" ]       = "00000000000000000000000000000026";
    //            break;
    //        case "00026-3":
    //            _to_return[ "host_name" ]    = "00026_test_auto";
    //            _to_return[ "_id" ]          = "00000000000000000000000000000026";
    //            _to_return[ "display_name" ] = "Non regression SEF-4419";
    //            break;
    //        case "00033-1":
    //        case "00033-2":
    //        case "00033-3":
    //            _to_return[ "_id" ]                                = "35000000000000000000000000000000";
    //            _to_return[ "contact_name" ]                       = "test_auto_user_executor";
    //            _to_return[ "expert" ]                             = "1";
    //            _to_return[ "is_admin" ]                           = "1";
    //            _to_return[ "password" ]                           = "test_auto_user_executor";
    //            _to_return[ "use" ]                                = {};
    //            _to_return[ "use" ][ "has_plus" ]                  = false;
    //            _to_return[ "use" ][ "links" ]                     = [];
    //            _to_return[ "use" ][ "links" ][ 0 ]                = {};
    //            _to_return[ "use" ][ "links" ][ 0 ][ "exists" ]    = true;
    //            _to_return[ "use" ][ "links" ][ 0 ][ "item_type" ] = "contacttpls";
    //            _to_return[ "use" ][ "links" ][ 0 ][ "name" ]      = "test_auto_user_executor_tpl";
    //            _to_return[ "use" ][ "links" ][ 0 ][ "_id" ]       = "36000000000000000000000000000000";
    //            _to_return[ "default_submit_to_staging" ]          = _switch_value === "00033-1" ? "null" : _switch_value === "00033-2" ? "1" : "0";
    //            break;
    //        case "00038-1":
    //            _to_return[ "_id" ]               = "00000000000000000000000000000038";
    //            _to_return[ "display_name" ]      = "service exclude (1)";
    //            _to_return[ "host_name" ]         = "00038_test_auto";
    //            _to_return[ "service_overrides" ] = "00038_test_auto,notes_url shinken_test_unknown";
    //            break;
    //        case "00040-1":
    //            _to_return[ "_id" ]              = "10000000000000000000000000000040";
    //            _to_return[ "name" ]             = "00040_test_auto_1";
    //            _to_return[ "service_excludes" ] = "*_1";
    //            break;
    //        case "00040-2":
    //            _to_return[ "_id" ]                                                   = "10000000000000000000000000000040";
    //            _to_return[ "name" ]                                                  = "00040_test_auto_1";
    //            _to_return[ "service_excludes_by_id" ]                                = {};
    //            _to_return[ "service_excludes_by_id" ][ "has_plus" ]                  = false;
    //            _to_return[ "service_excludes_by_id" ][ "raw_value" ]                 = "";
    //            _to_return[ "service_excludes_by_id" ][ "links" ]                     = [];
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ]                = {};
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "exists" ]    = true;
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "item_type" ] = "serviceshosttpls";
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "name" ]      = "00040_test_auto_1";
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "_id" ]       = "20000000000000000000000000000040";
    //            break;
    //        case "00040-3":
    //            _to_return[ "_id" ]                                                   = "10000000000000000000000000000040";
    //            _to_return[ "name" ]                                                  = "00040_test_auto_1";
    //            _to_return[ "service_excludes_by_id" ]                                = {};
    //            _to_return[ "service_excludes_by_id" ][ "has_plus" ]                  = false;
    //            _to_return[ "service_excludes_by_id" ][ "raw_value" ]                 = "";
    //            _to_return[ "service_excludes_by_id" ][ "links" ]                     = [];
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ]                = {};
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "exists" ]    = true;
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "item_type" ] = "serviceshosttpls";
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "name" ]      = "00040_test_auto_1";
    //            _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "_id" ]       = "20000000000000000000000000000040";
    //            _to_return[ "service_excludes" ]                                      = "*_1";
    //            break;
    //        case "00040-4":
    //            _to_return[ "_id" ]              = "11000000000000000000000000000040";
    //            _to_return[ "name" ]             = "00040_test_auto_2";
    //            _to_return[ "service_excludes" ] = "*";
    //            break;
    //        case "00040-5":
    //            _to_return[ "_id" ]     = "11000000000000000000000000000040";
    //            _to_return[ "name" ]    = "00040_test_auto_2";
    //            _to_return[ "enabled" ] = "0";
    //            break;
    //        case "00083-5":
    //            _to_return[ "_id" ]          = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]    = "00001_test_auto";
    //            _to_return[ "enabled" ]      = "1";
    //            _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
    //            break;
    //        case "00067-2":
    //            _to_return[ "_id" ]          = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]    = "00001_test_auto";
    //            _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
    //            _to_return[ "address" ]      = "localhost";
    //            break;
    //        case "00070-2":
    //        case "00071-2":
    //            _to_return[ "_id" ]          = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]    = "00001_test_auto";
    //            _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
    //            _to_return[ "address" ]      = "localhost";
    //            _to_return[ "use" ]          = "test_auto_disabled";
    //            break;
    //        case "00070-4":
    //        case "00072-2":
    //        case "00073-2":
    //        case "00074-2":
    //        case "00075-2":
    //        case "00076-2":
    //        case "00077-2":
    //        case "00078-2":
    //        case "00079-2":
    //        case "00080-2":
    //            _to_return[ "_id" ]          = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]    = "00001_test_auto";
    //            _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
    //            _to_return[ "address" ]      = "localhost";
    //            _to_return[ "use" ]          = "test_auto_valid";
    //            _to_return[ "hostgroups" ]   = "test_auto_valid";
    //            break;
    //        case "00092-2":
    //        case "00093-2":
    //            _to_return[ "_id" ]             = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]       = "00001_test_auto";
    //            _to_return[ "display_name" ]    = "vérification des propriétés présentes dans un hôte";
    //            _to_return[ "notes_multi_url" ] = "test_auto_1~=http://test_auto_1~=tag~=OPEN_IN_NEW_TAB";
    //            break;
    //        case "00093-3":
    //        case "00093-5":
    //            _to_return[ "_id" ]             = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]       = "00001_test_auto";
    //            _to_return[ "display_name" ]    = "vérification des propriétés présentes dans un hôte";
    //            _to_return[ "notes_multi_url" ] = "test_auto_2~=http://test_auto_1~=tag~=OPEN_IN_NEW_TAB";
    //            break;
    //        case "00093-4":
    //        case "00093-6":
    //        case "00093-7":
    //        case "00093-8":
    //            _to_return[ "_id" ]             = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]       = "00001_test_auto";
    //            _to_return[ "display_name" ]    = "vérification des propriétés présentes dans un hôte";
    //            _to_return[ "notes_multi_url" ] = "test_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TAB";
    //            break;
    //        default:
    //            _to_return[ "_id" ]          = "00000000000000000000000000000001";
    //            _to_return[ "host_name" ]    = "00001_test_auto";
    //            _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
    //            break;
    //    }
    //    return _to_return;
    //};
    
    //OPTIONS MASS ACTIONS
    return self;
})( SHINKEN.TOOLS.TEST_AUTO || {} );

SHINKEN.TOOLS.TEST_AUTO_TOOLTIP = (function ( self ) {
    self.hasText      = function ( timeout, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( document.getElementById( "shi-tip" ), value_expected, "text dans le tooltip" );
        }, timeout );
        return 50;
    };
    self.containsText = function ( timeout, value_to_test ) {
        setTimeout( function () {
            var _dom_element = DOM.Service.createElement( "div", {}, value_to_test );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( document.getElementById( "shi-tip" ), _dom_element.innerText, "text dans le tooltip" );
        }, timeout );
        return 50;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_TOOLTIP || {} );

SHINKEN.TOOLS.TEST_AUTO_DOM = (function ( self ) {
    //********************************************  EVENT   **********************************************************//
    self.dispatchEvent  = function ( timeout, dom_element, event_to_dispatch, times ) {
        setTimeout( function () {
            if ( !times ) {
                times = 1;
            }
            for ( var i = 0; i < times; i++ ) {
                dom_element.dispatchEvent( event_to_dispatch );
            }
        }, timeout );
        return 300;
    };
    self.click          = function ( timeout, dom_element, force_click ) {
        setTimeout( function () {
            var _compute = DOM.Service.getComputedStyle( dom_element );
            if ( !force_click && _compute.pointerEvents === 'none' ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible pointerEvents === 'none'" );
            }
            else if ( !force_click && !DOM.Service.isVisible( dom_element ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "click on  <b>" + dom_element.innerText + "</b> impossible non visible" );
            }
            else {
                dom_element.click();
            }
        }, timeout );
        return 500;
    };
    //********************************************  SETTER GETTER   **************************************************//
    self.setValue       = function ( timeout, dom_element, to_set ) {
        setTimeout( function () {
            dom_element.focus();
            if ( dom_element.classList.contains( "shinken-input" ) || dom_element.classList.contains( "shinken-input-search" ) ) {
                dom_element.value = to_set;
                var evt           = document.createEvent( "HTMLEvents" );
                evt.initEvent( "keyup", false, true );
                dom_element.dispatchEvent( evt );
            }
            else if ( dom_element.hasAttribute( 'contenteditable' ) ) {
                dom_element.innerText = to_set;
                var evt               = document.createEvent( "HTMLEvents" );
                evt.initEvent( "focusout", false, true );
                dom_element.dispatchEvent( evt );
            }
        }, timeout );
        return DOM.CONST.WAITING_TIME_BEFORE_EXEC.INPUT * 3;
    };
    //********************************************  TEST   ***********************************************************//
    self.isVisible      = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.isNotVisible   = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.doesntExist    = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__doesntExist( dom_element, text_desc );
        }, timeout );
        return 10;
    };
    self.hasFocus       = function ( timeout, dom_element, text_desc ) {
        setTimeout( function () {
            if ( !text_desc && dom_element ) {
                text_desc = SHINKEN.TOOLS.STRING.cleanMultipleSpaces( dom_element.innerText );
            }
            if ( !DOM.Service.hasFocus( dom_element ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le dom élément <b>" + text_desc + "</b> n'a pas le focus" );
            }
        }, timeout );
        return 10;
    };
    self.hasStyle       = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.hasData        = function ( timeout, dom_element, key, value_expected, description ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( dom_element.dataset, key, value_expected, description );
        }, timeout );
        return 10;
    };
    self.hasStyleToEval = function ( timeout, dom_element_to_eval, key, value_expected ) {
        setTimeout( function () {
            var dom_element = eval( dom_element_to_eval );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_element, key, value_expected );
        }, timeout );
        return 10;
    };
    self.hasClass       = function ( timeout, dom_element, class_expected, revert, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasClass( dom_element, class_expected, text_desc, '', revert );
        }, timeout );
        return 10;
    };
    self.containsText   = function ( timeout, dom_element, text_expected, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( dom_element, text_expected, text_desc );
        }, timeout );
        return 10;
    };
    self.isText         = function ( timeout, dom_element, text_expected, text_desc ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element, text_expected, text_desc );
        }, timeout );
        return 10;
    };
    self.isTable        = function ( timeout, dom_element, nb_rows, nb_col, inner_text ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( dom_element.tagName, "TABLE" );
            if ( inner_text ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( dom_element, inner_text );
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( SHINKEN.TOOLS.ARRAY.getLength( dom_element.rows ), nb_rows );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( SHINKEN.TOOLS.ARRAY.getLength( dom_element.rows[ 0 ].cells ), nb_col );
        }, timeout );
        return 10;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_DOM || {} );

SHINKEN.TOOLS.TEST_AUTO_IFRAME = (function ( self ) {
    self.getIframeContent      = function ( id ) {
        return document.getElementById( id ).querySelector( 'iframe' ).contentWindow.document;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_IFRAME || {} );


SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT = (function ( self ) {
    self.getEnterEvent = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'Enter',
            key       : 'Enter',
            charCode  : 13,
            keyCode   : 13,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getDownEvent  = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'ArrowDown',
            key       : 'ArrowDown',
            charCode  : 0,
            keyCode   : 40,
            view      : window,
            shiftKey  : false
        } );
    };
    self.getSpaceEvent = function () {
        return new KeyboardEvent( "keydown", {
            bubbles   : true,
            cancelable: true,
            code      : 'Space',
            key       : ' ',
            charCode  : 0,
            keyCode   : 32,
            view      : window,
            shiftKey  : false
        } );
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT || {} );