'use strict';

MANAGER.DistributorMacroManager           = function () {
    this.macros = {};
};
MANAGER.DistributorMacroManager.prototype = {
    construct                 : function ( string ) {
        if ( !this.isMacro( string ) ) {
            return string;
        }
        //var _macro_string = string.substr( 1, string.length - 2 );
        var _macro = this.findMacro( string );
        return _macro;
    },
    recomputeLabelForEachMacro: function () {
        var _keys = Object.keys( this.macros );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.macros[ _keys[ i ] ].init( true );
        }
    },
    isMacro                   : function ( string ) {
        if ( !SHINKEN.TOOLS.STRING.startsWith( string, '$' ) ) {
            return false;
        }
        if ( !SHINKEN.TOOLS.STRING.endsWith( string, '$' ) ) {
            return false;
        }
        return true;
    },
    findMacro                 : function ( name ) {
        var _to_return = this.getMacro( name );
        if ( !_to_return ) {
            _to_return          = new OBJECT.Macro( name );
            this.macros[ name ] = _to_return;
            _to_return.init();
        }
        return _to_return;
    },
    getMacro                  : function ( name ) {
        return this.macros[ name ];
    },
    findMacroByHostKey        : function ( name ) {
        var _name       = '$' + OBJECT.CONST.MACRO.TYPE.HOST_LOCAL + name.substr( 1 ) + '$';
        var _to_return  = this.findMacro( _name );
        _to_return.type = OBJECT.CONST.MACRO.TYPE.HOST_LOCAL; //TODO... A VOIR
        return _to_return;
    },
    changeMacro               : function ( property, value ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro = this.findMacroByHostKey( property.name );
            _macro.setValue( value, property );
            this.recomputeLabelForEachMacro();
        }
    },
    deleteMacroContent        : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro = this.findMacroByHostKey( name );
            _macro.setValue( '' );
            _macro.setU = OBJECT.CONST.MACRO.TYPE.UNKNOWN;
        }
    },
    renamedMacro              : function ( old_name, new_name, value ) {
        if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            var _macro  = this.findMacroByHostKey( old_name );
            _macro.type = OBJECT.CONST.MACRO.TYPE.UNKNOWN;
            _macro      = this.findMacroByHostKey( new_name );
            _macro.setValue( value );
            this.recomputeLabelForEachMacro();
        }
    },
    splitCommand              : function ( colCommand ) {
        var _current;
        var _to_return = [];
        var _splitted  = colCommand.split( REGEXS.parse_arguments );
        var _size      = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.construct( _splitted[ i ] );
            if ( _current ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    },
    hasMacro                  : function ( value ) {
        var _current;
        var _splitted = value.split( REGEXS.parse_arguments );
        var _size     = _splitted.length;
        for ( var i = 0; i < _size; i++ ) {
            _current = this.construct( _splitted[ i ] );
            if ( _current ) {
                if ( typeof _current !== 'string' ) {
                    return true;
                }
            }
        }
        return false;
    },
    buildLabel                : function ( _splitted_data, skip_container, key_dfe ) {
        var _to_return = "";
        var _current;
        for ( var i = 0, _size = _splitted_data.length; i < _size; i++ ) {
            _current = _splitted_data[ i ];
            if ( typeof _current === 'string' ) {
                if ( i ) {
                    _to_return += _current;
                }
                else {
                    var split_command    = _current.split( '!' );
                    var _current_command = MANAGER.__instance_element_distributor.getTypeElementWithName( 'commands', split_command[ 0 ] );
                    if ( _current_command ) {
                        _to_return += SHINKEN.TOOLS.buildLinkShinkenElement( _current_command ).outerHTML;
                        for ( var j = 1, _size_j = split_command.length; j < _size_j; j++ ) {
                            _to_return += '!' + split_command[ j ];
                        }
                    }
                    else {
                        _to_return += _current;
                    }
                }
            }
            else {
                _to_return += _current.getValue();
            }
        }
        if ( !skip_container ) {
            var _class = "shinken-macro-container";
            _class += !_to_return ? ' shinken-hidden' : '';
            _to_return = "<div class='" + _class + "'>" + _to_return + "</div>";
        }
        if ( key_dfe ) {
            _to_return = SHINKEN.TOOLS.STRING.replaceAll( _to_return, OBJECT.CONST.MACRO.TYPE.DFE_KEY, key_dfe );
        }
        else {
            var _text       = SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_macro_not_found' ), '$KEY$' );
            var _to_replace = '<span class="shinken-macro-warning value" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"  onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="' + _text + '">$KEY$</span>';
            _to_return      = SHINKEN.TOOLS.STRING.replaceAll( _to_return, OBJECT.CONST.MACRO.TYPE.DFE_KEY, _to_replace );
        }
        return _to_return;
    }
};
MANAGER.__instance_macro_distributor      = new MANAGER.DistributorMacroManager();