'use strict';
var __shinken_debug_time_start = Date.now();
var __shinken_debug            = SHINKEN.HIGHWAY.getParams( 'shinken_debug' );
document.addEventListener( "DOMContentLoaded", function ( e ) {
    test_user_change();
    if ( __shinken_debug ) {
        MANAGER.__instance_loading.addDebug( 'Dom is ready', MANAGER.__instance_loading.getDebugTimer() );
    }
    if ( MANAGER.WindowModalManager ) {
        MANAGER.__instance_window_modal_manager = new MANAGER.WindowModalManager();
    }
    try {
        if ( typeof current_shinken_user !== 'undefined' ) {
            var _shinken_user = new OBJECT.ShinkenElement();
            _shinken_user.updateData( current_shinken_user );
            MANAGER.__instance_element_distributor.setCurrentUser( _shinken_user );
        }
        if ( document.getElementById( 'shinken-id-navigation-table' ) ) {
            setInterval( ask_menu_update, 30000 );
        }
        doActionWhenDomReady();
    }
    catch ( e ) {
        console.warn( "NO ACTION EXPECTED WHEN DOM READY", e );
    }
} );


MANAGER.LoadingManager           = function () {
    this.is_ready = false;
};
MANAGER.LoadingManager.prototype = {
    isReady      : function () {
        return this.is_ready;
    },
    setIsReady   : function ( to_set ) {
        this.is_ready = to_set;
        if ( __shinken_debug ) {
            MANAGER.__instance_loading.addDebug( 'JS is ready', MANAGER.__instance_loading.getDebugTimer() );
        }
        if ( this.is_ready ) {
            if ( SHINKEN.HIGHWAY.getParams( 'shinken_doc' ) ) {
                doActionWhenReadyDocumentation();
            }
            if ( SHINKEN.HIGHWAY.getParams( 'shinken_test_auto' ) ) {
                setTimeout( function () {
                    doActionWhenReadyTestAuto();
                }, 500 );
            }
        }
        if ( __shinken_debug ) {
            MANAGER.__instance_loading.addDebug( 'Template number', MANAGER.__instance_element_distributor.list_templates.size );
            MANAGER.__instance_loading.addDebug( 'Template number computed', MANAGER.__instance_element_distributor.list_templates.size_computed );
            MANAGER.__instance_loading.addDebug( 'Shinken element', MANAGER.__instance_element_distributor.getNumberShinkenElement() );
        }
    },
    addDebug     : function ( label, value ) {
        if ( !__shinken_debug ) {
            return;
        }
        var _dom_row        = DOM.Service.createElement( 'tr', {} );
        var _dom_label_cell = DOM.Service.createElement( 'td', {}, label );
        var _dom_value_cell = DOM.Service.createElement( 'td', {}, value );
        
        _dom_row.appendChild( _dom_label_cell );
        _dom_row.appendChild( _dom_value_cell );
        
        document.getElementById( 'id-shinken-debug-table' ).appendChild( _dom_row );
    },
    getDebugTimer: function () {
        if ( !__shinken_debug ) {
            return;
        }
        return Date.now() - __shinken_debug_time_start + ' ms';
    },
    showLoading  : function ( progress_state ) {
        var loading_text = document.getElementById( "loading_text" );
        if ( loading_text ) {
            loading_text.innerHTML = progress_state;
        }
        var container_loading_bar = document.getElementById( "container_loading_bar" );
        if ( container_loading_bar ) {
            container_loading_bar.classList.remove( "hide" );
        }
        var loading_page = document.getElementById( "loading_page" );
        if ( loading_page ) {
            loading_page.classList.remove( "hide" );
        }
    },
    removeLoading: function () {
        var container_loading_bar = document.getElementById( "container_loading_bar" );
        if ( container_loading_bar ) {
            container_loading_bar.classList.add( "hide" );
        }
        var loading_page = document.getElementById( "loading_page" );
        if ( loading_page ) {
            loading_page.classList.add( "hide" );
        }
        var loading_text = document.getElementById( "loading_text" );
        if ( loading_text ) {
            loading_text.innerHTML = "";
        }
    }
};

MANAGER.__instance_loading = new MANAGER.LoadingManager();


//TO CLEAN
function test_user_change () {
    if ( !MANAGER.__instance_element_distributor.current_user ) {
        setTimeout( function () {
            test_user_change();
        }, 1000 );
        return;
    }
    var user_log_id_local = MANAGER.__instance_element_distributor.current_user.uuid || '';
    var user_stock        = sessionStorage.getItem( "user_id" );
    if ( user_log_id_local ) {
        if ( !user_stock ) {
            sessionStorage.setItem( "user_id", user_log_id_local );
        }
        else if ( user_log_id_local != user_stock ) {
            setTimeout( function () {
                alert( App.Scope.format( _( 'element.the_user_changed' ), MANAGER.__instance_element_distributor.current_user.contact_name ) );
            }, 1 );
            sessionStorage.setItem( "user_id", user_log_id_local );
        }
    }
}
