//priority 10
//__lib__ lib_external
'use strict';
SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    //type
    //nb
    //elements_mapping
    //dom_element
    //counter_final
    //is_discreet
    this.is_string              = false;
    this.is_label_before        = false;
    this.has_animation          = false;
    this.label                  = "";
    this.show_if_null           = !!show_if_null;
    this.elements_mapping       = {};
    this.counter_final          = 0;
    this.counter_parent         = null;
    this.uuid                   = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html           = null;
    this.toggle_parent_activity = false;
    this.target_dom_element     = null;
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init               : function ( dom_element, update_with_dom ) {
        this.dom_element = dom_element;
        this.setDiscreet( !this.dom_element );
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this.counter_parent = MANAGER.__instance_counter_distributor.findCounter( _name_parent );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label           = _label.outerHTML;
                this.is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this.is_string = true;
            }
            if ( this.dom_element.dataset.showIfNull ) {
                this.show_if_null = true;
            }
            if ( this.dom_element.dataset.isDiscreet ) {
                this.setDiscreet( true );
            }
            if ( update_with_dom ) {
                this.initValueWithDom();
            }
        }
    },
    initValueWithDom   : function () {
        if ( !this.dom_element ) {
            return;
        }
        if ( !this.dom_element.dataset.number ) {
            return;
        }
        this.update( "init_with_dom", parseInt( this.dom_element.dataset.number ) );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue           : function () {
        return this.counter_final;
    },
    has                : function ( name ) {
        return !!this.elements_mapping[ name ];
    },
    setDiscreet        : function ( to_set ) {
        this.is_discreet = to_set;
    },
    reset              : function () {
        this.elements_mapping = {};
        this.counter_final    = 0;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    showForParent      : function ( show ) {
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, show ? this.counter_final : 0 );
        }
    },
    update             : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        //if ( nb_counter ) {
        //    console.warn( "GSOU", "[]", name, nb_counter );
        //}
        if ( !nb_counter ) {
            delete this.elements_mapping[ name ];
        }
        else {
            if ( !is_force && this.elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this.elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltip( tooltip );
        }
        this.counter_final = this.is_string ? "" : 0;
        var _keys          = Object.keys( this.elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counter_final = this.counter_final + this.elements_mapping[ _keys[ i ] ];
        }
        if ( this.target_dom_element ) {
            DOM.Service.setDataSet( this.target_dom_element, 'number', this.counter_final || 0 );
        }
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        return this._askUpdateHTML( retry_update_html );
    },
    setParent          : function ( to_set ) {
        this.counter_parent = to_set;
        if ( this.counter_parent ) {
            this.counter_parent.update( this.uuid, this.counter_final );
        }
        this._updateHTML();
    },
    setTargetDomElement: function ( to_set ) {
        this.target_dom_element = to_set;
        if ( this.target_dom_element ) {
            DOM.Service.setDataSet( this.target_dom_element, 'number', this.counter_final || 0 );
        }
    },
    setLabel           : function ( to_set, is_before ) {
        this.label           = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this.is_label_before = !!is_before;
    },
    isString           : function ( to_set ) {
        this.is_string = to_set;
    },
    _askUpdateHTML     : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            this.timeout_html = null;
        }, 50 );
    },
    _updateHTML        : function ( retry_update_html ) {
        //if ( this.counter_final && this.type === 'warnings' )
        //    console.warn("GSOU", "[Counter - _updateHTML]", retry_update_html, this.uuid, this.counter_final, this.type, this.dom_element );
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        if ( this.counter_final ) {
            this.dom_element_label.innerHTML = this.label ? this.is_label_before ? this.label + " " + this.counter_final : this.counter_final + " " + this.label : this.counter_final;
            DOM.Service.setDataSet( this.dom_element, 'number', this.counter_final );
        }
        else if ( this.show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        
        if ( this.has_animation ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 2000 );
            }
        }
        if ( this.toggle_parent_activity ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-counter-parent', 10 );
            if ( _parent_dom_element ) {
                if ( this.counter_final ) {
                    _parent_dom_element.classList.add( 'shinken-active' );
                }
                else {
                    _parent_dom_element.classList.remove( 'shinken-active' );
                }
            }
        }
        return true;
    },
    setTooltip         : function ( label, type ) {
        if ( !label ) {
            return;
        }
        this.dom_element.setAttribute( 'onmouseenter', 'SHINKEN_TOOLTIP.showTooltip(this)' );
        this.dom_element.setAttribute( 'onmouseleave', 'SHINKEN_TOOLTIP.hideTooltip()' );
        this.dom_element.setAttribute( 'shi-tip-html', label );
        this.dom_element.setAttribute( 'shi-tip-type', type );
    }
};

SHINKEN.OBJECT.CounterInterface           = function () {
};
SHINKEN.OBJECT.CounterInterface.prototype = {
    initCounters            : function ( parent, update_with_dom ) {
        this.errors        = new SHINKEN.OBJECT.Counter();
        this.errors.type   = "errors";
        this.warnings      = new SHINKEN.OBJECT.Counter();
        this.warnings.type = "warnings";
        this.user_set      = new SHINKEN.OBJECT.Counter();
        this.user_set.type = "user_set";
        this.total         = new SHINKEN.OBJECT.Counter();
        this.total.type    = "total";
        this.initCountersDom( update_with_dom );
        if ( parent ) {
            this.setParentCounter( parent );
        }
    },
    initCountersDom         : function ( update_with_dom ) {
        if ( this.dom_element ) {
            this.errors.init( this.dom_element.querySelector( '.shinken-error-counter' ), update_with_dom );
            this.warnings.init( this.dom_element.querySelector( '.shinken-warning-counter' ), update_with_dom );
            this.user_set.init( this.dom_element.querySelector( '.shinken-user-set-counter' ), update_with_dom );
            this.total.init( this.dom_element.querySelector( '.shinken-window-total-counter' ), update_with_dom );
        }
    },
    initCounterValuesWithDom: function () {
        this.errors.initValueWithDom();
        this.warnings.initValueWithDom();
        this.user_set.initValueWithDom();
        this.total.initValueWithDom();
    },
    resetCounters           : function () {
        this.warnings.reset();
        this.errors.reset();
        this.user_set.reset();
        this.total.reset();
    },
    hideCountersForParent   : function () {
        this.warnings.showForParent( false );
        this.errors.showForParent( false );
        this.user_set.showForParent( false );
        this.total.showForParent( false );
    },
    showCountersForParent   : function () {
        this.warnings.showForParent( true );
        this.errors.showForParent( true );
        this.user_set.showForParent( true );
        this.total.showForParent( true );
    },
    hasError                : function () {
        return !!this.errors.counter_final;
    },
    hasWarning              : function () {
        return !!this.warnings.counter_final;
    },
    setError                : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning              : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setUserSet              : function ( data_name, nb ) {
        this.user_set.update( data_name, nb );
    },
    setTotal                : function ( data_name, nb ) {
        this.total.update( data_name, nb );
    },
    getCounterError         : function () {
        return this.errors;
    },
    getCounterWarning       : function () {
        return this.warnings;
    },
    getCounterUserSet       : function () {
        return this.user_set;
    },
    getCounterTotal         : function () {
        return this.total;
    },
    setParentCounter        : function ( to_set ) {
        if ( to_set ) {
            this.getCounterError().setParent( to_set.getCounterError() );
            this.getCounterWarning().setParent( to_set.getCounterWarning() );
            this.getCounterUserSet().setParent( to_set.getCounterUserSet() );
            this.getCounterTotal().setParent( to_set.getCounterTotal() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterface, SHINKEN.OBJECT.ShinkenObject );