'use strict';

PROPERTY.MultiLine           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // rules
    // rules_mapping
    // type
    // component_input
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    // separator_line_html
    // is_set
    this.init( dom_element );
    this.timeout_ask_compute_after_change;
};
PROPERTY.MultiLine.prototype = {
    init                              : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.dom_template              = this.dom_element.querySelector( '.shinken-multi-line-object-template' );
        this.dom_container             = this.dom_element.querySelector( '.shinken-multi-line-object-container' );
        this.dom_output_cfg            = this.dom_element.querySelector( '.shinken-multi-line-object-stringify-result' );
        this.dom_cfg_inherited_label   = this.dom_element.querySelector( '.shinken-cfg-inherited-label-container' );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.getParentName(), dom_element, this.type );
        this.separator_line_saved      = dom_element.dataset.separatorLineSaved;
        this.separator_key_value_saved = dom_element.dataset.separatorKeyValueSaved;
        this.separator_line_html       = dom_element.dataset.separatorLineHtml;
        this.separator_key_value_html  = dom_element.dataset.separatorKeyValueHtml;
        this.line_type                 = dom_element.dataset.lineType;
        this.is_set                    = dom_element.dataset.isSet === "true";
        if ( this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ) {
            this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-prop-cell-action .shinken-input" ), this );
        }
        this.initLines();
    },
    initLines                         : function () {
        this.lines_object          = [];
        this.lines_object_mapping  = {};
        var _existing_line_objects = this.dom_container.querySelectorAll( '.shinken-multi-line-object-row' );
        for ( var i = 0, _size_i = _existing_line_objects.length; i < _size_i; i++ ) {
            var _new_line_object;
            switch ( this.line_type ) {
                case PROPERTY.CONST.NAME.OUTPUT_RULES:
                    _new_line_object = new COMPONENT.OutputRule( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                    _new_line_object = new COMPONENT.UrlLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.PERIOD_ADVANCED_NAME:
                    _new_line_object = new COMPONENT.KeyValueLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
                case PROPERTY.CONST.NAME.PERIOD_DAY_NAME:
                    _new_line_object = new COMPONENT.TimePeriodDayLine( this, _existing_line_objects[ i ], this.separator_key_value_saved, this.separator_key_value_html );
                    break;
            }
            var _index                                         = this.lines_object.push( _new_line_object );
            this.lines_object_mapping[ _new_line_object.uuid ] = _index - 1;
        }
        this.computeValue();
    },
    rebuildMapping                    : function () {
        this.lines_object_mapping = {};
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            this.lines_object_mapping[ this.lines_object[ i ].uuid ] = i;
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnAddLine                    : function () {
        var _to_add = DOM.Service.cloneElement( this.dom_template, { class: "shinken-multi-line-object-row" } );
        this.dom_container.appendChild( _to_add );
        var _new_line;
        switch ( this.line_type ) {
            case PROPERTY.CONST.NAME.OUTPUT_RULES:
                _new_line = new COMPONENT.OutputRule( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                _new_line = new COMPONENT.UrlLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.PERIOD_ADVANCED_NAME:
                _new_line = new COMPONENT.KeyValueLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
            case PROPERTY.CONST.NAME.PERIOD_DAY_NAME:
                _new_line = new COMPONENT.TimePeriodDayLine( this, _to_add, this.separator_key_value_saved, this.separator_key_value_html );
                break;
        }
        var _index                                  = this.lines_object.push( _new_line );
        this.lines_object_mapping[ _new_line.uuid ] = _index - 1;
        this.setStateInheritance( !this.lines_object.length );
        this.computeValue();
        this.askCheckErrorWarning();
        return _new_line;
    },
    ___clickOnItemSelector            : function ( target_component, key_name, element ) {
        target_component.___clickOnItemSelector( key_name, element );
        this.computeValue();
    },
    askComputeAfterChange             : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( dom_element.classList.contains( 'shinken-is-main-input' ) ) {
            this.askComputeAfterChangeMainInput();
        }
        else {
            var _line_object = this.getLineObjectViaChildrenElement( dom_element );
            _line_object.askComputeAfterChange( dom_element, this );
        }
    },
    askComputeAfterChangeMainInput    : function () {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.component_input.setValue();
            self.component_input.validateValueInput();
            self.computeValue();
            MANAGER.ListenerEventManager.askAfterActionProperty( self );
        }, 200 );
    },
    deleteLine                        : function ( dom_element ) {
        var _line_object = this.getLineObjectViaChildrenElement( dom_element );
        if ( !_line_object ) {
            return;
        }
        _line_object.delete();
        var _index = this.lines_object_mapping[ _line_object.uuid ];
        this.lines_object.splice( _index, 1 );
        this.rebuildMapping();
        this.setStateInheritance( !this.lines_object.length );
        this.computeValue();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    deleteAllLines                    : function () {
        for ( var i = this.lines_object.length - 1; i >= 0; i-- ) {
            this.deleteLine( this.lines_object[ i ].dom_element );
        }
    },
    ___onFocusOut                     : function ( dom_element ) {
        this.setValueFromUser( DOM.Service.getInnerText( dom_element ) );
        this.updateCfgDomElement();
        this.computeValue();
        this.setCfgEditable( false );
    },
    ////********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance            : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.value;
        this.setStateInheritance( _is_inheritable );
    },
    _computeState                     : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_mass_change && ! this.value ) {
            switch ( this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue() ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                default:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
            }
        }
        else if ( this.is_override ) {
            _to_set = this.lines_object.length ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.value && !this.lines_object.length ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        
        this.setState( _to_set );
        this.checkErrorWarning();
        this.updateCfgDomElement();
    },
    doActionAfterChange               : function () {
        this.computeValue();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    computeValue                      : function () {
        this.value = "";
        var _current_value;
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            _current_value = this.lines_object[ i ].getValue();
            if ( _current_value === "" ) {
                continue;
            }
            if ( this.value ) {
                this.value += this.separator_line_saved;
            }
            this.value += _current_value;
        }
        
        if ( this.component_input ) {
            this.value = this.value ? this.component_input.getValue() + this.separator_line_saved + this.value : this.component_input.getValue();
        }
        this._computeState();
        this.computeIsSet();
    },
    updateCfgDomElement               : function () {
        if ( !this.dom_output_cfg ) {
            return;
        }
        var _line_separator = this.separator_line_html;
        switch ( this.separator_line_html ) {
            case "BACK_TO_LINE":
                _line_separator = "<br>";
                break;
        }
        
        
        var _to_write = "";
        if ( this.component_input ) {
            _to_write += this.component_input.getValue();
            if ( this.lines_object.length ) {
                _to_write += _line_separator;
            }
        }
        var _to_write_currrent = "";
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            if ( !SHINKEN.TOOLS.STRING.isEmptyHtml( _to_write_currrent ) ) {
                _to_write += _line_separator;
            }
            _to_write_currrent = this.lines_object[ i ].getCfgValue();
            _to_write += _to_write_currrent;
        }
        switch ( this.state ){
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                _to_write = PROPERTY.CONST.CUSTOM_SELECT.NONE;
                break;
        }
        this.dom_output_cfg.innerHTML = _to_write;
    },
    computeIsSet                      : function () {
        this.is_set = !!this.lines_object.length;
        DOM.Service.setDataSet( this.dom_element, 'isSet', this.is_set );
    },
    _updateCfgInheritedLabel          : function ( inherited_value ) {
        var _div_text_to_copy_container = DOM.Service.createElement( 'div', { class: 'shinken-text-to-copy' } );
        var _span_property_name         = DOM.Service.createElement( 'span', { class: 'shinken-multi-line-object-stringify-property' }, this.name );
        var _span_value                 = DOM.Service.createElement( 'span', { class: 'shinken-multi-line-object-inherited-value' }, inherited_value );
        DOM.Service.empty(this.dom_cfg_inherited_label);
        _div_text_to_copy_container.appendChild( _span_property_name );
        _div_text_to_copy_container.appendChild( _span_value );
        this.dom_cfg_inherited_label.appendChild( _div_text_to_copy_container );
    },
    parseValueFromUser                : function ( value, line ) {
        switch ( this.line_type ) {
            case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
                if ( value.startsWith( PROPERTY.CONST.NAME.NOTE_MULTI_URL ) ) {
                    value = value.slice( PROPERTY.CONST.NAME.NOTE_MULTI_URL.length + 1 );
                }
                break;
            case PROPERTY.CONST.NAME.OUTPUT_RULES:
                if ( value.startsWith( PROPERTY.CONST.NAME.OUTPUT_RULES ) ) {
                    value = value.slice( PROPERTY.CONST.NAME.OUTPUT_RULES.length + 1 );
                }
                break;
        }
        return this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ? value : value.split( line.separator_key_value_html );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getSelectViaDomElement            : function ( dom_element ) {
        var _dom_target = DOM.Service.findParentElementWithClass( dom_element, "shinken-select-container", 20 );
        var _to_return  = this.selectors[ _dom_target.dataset.name ];
        if ( !_to_return ) {
            _to_return = this.getLineObjectViaChildrenElement( dom_element );
        }
        return _to_return;
    },
    getLineObjectViaChildrenElement   : function ( dom_element ) {
        var _dom_line_object = DOM.Service.findParentElementWithClass( dom_element, "shinken-multi-line-object-row", 20 );
        if ( !_dom_line_object ) {
            return null;
        }
        var _to_return = this.getLineObjectViaUUID( _dom_line_object.dataset.uuid );
        return _to_return || null;
    },
    getLineObjectViaUUID              : function ( uuid ) {
        var _index = this.lines_object_mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.lines_object[ _index ];
    },
    ___unset                          : function () {
        this.deleteAllLines();
        this._computeState();
    },
    updateWithTemplateSpecific        : function () {
        this._computeState();
    },
    setValueFromUser                  : function ( value ) {
        this.deleteAllLines();
        if ( this.line_type === PROPERTY.CONST.NAME.PERIOD_DAY_NAME ) {
            this.component_input.dom_element.value = "";
            this.askComputeAfterChangeMainInput();
        }
        var _line_separator = this.separator_line_html;
        switch ( this.separator_line_html ) {
            case "BACK_TO_LINE":
                _line_separator = "\n";
                break;
        }
        var _lines = value.split( _line_separator );
        var __new_line;
        var _data_splitted;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            if ( _lines[ i ] ) {
                __new_line     = this.clickOnAddLine();
                _data_splitted = this.parseValueFromUser( _lines[ i ], __new_line );
                __new_line.setValueFromUser( _data_splitted );
            }
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    setCfgEditable                    : function ( to_set ) {
        DOM.Service.setDataSet( this.dom_element, 'cfgEditable', to_set );
        this.setContentEditableCfgTextContainer( to_set );
    },
    setContentEditableCfgTextContainer: function ( to_set ) {
        this.dom_output_cfg.contentEditable = to_set;
        if ( to_set === true ) {
            this.dom_output_cfg.focus();
            var range = document.createRange();
            range.selectNodeContents( this.dom_output_cfg );
            range.collapse( false );
            var sel = window.getSelection();
            sel.removeAllRanges();
            sel.addRange( range );
        }
    },
    //********************************************  VIEW    **********************************************************//
    ___hidePopup                      : function ( _uuid_exception ) {
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            if ( this.lines_object[ i ] !== _uuid_exception ) {
                this.lines_object[ i ].hidePopup();
            }
        }
    },
    //********************************************  VALIDATION   *****************************************************//
    computeErrorsSpecifics    : function () {
        for ( var i = 0, _size_i = this.lines_object.length; i < _size_i; i++ ) {
            this.lines_object[i].computeErrorsSpecifics(this.state)
        }
    },
    ////********************************************  SAVE     *********************************************************//
    getDataToSaveFinal                : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                return this.value || '';
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.MultiLine, PROPERTY.Interface );