#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

### Will be populated by the UI with it's own value
app = None

# We will need external commands here
import time

from shinken.external_command import ExternalCommand, ExternalCommandManager


# Our page
def get_page(cmd=None):
    now = int(time.time())
    print "Ask us an /action page", cmd
    elts = cmd.split('/')
    cmd_name = elts[0]
    cmd_args = elts[1:]
    print "Got command", cmd_name
    print "And args", cmd_args
    
    # Check if the command exist in the external command list
    if cmd_name not in ExternalCommandManager.commands:
        return {'status': 404, 'text': 'Unknown command %s' % cmd_name}
    
    extcmd = '[%d] %s' % (now, ';'.join(elts))
    print "Got the; form", extcmd
    
    # Ok, if good, we can launch the command
    extcmd = extcmd.decode('utf8', 'replace')
    e = ExternalCommand(extcmd)
    print "Creating the command", e.__dict__
    app.push_external_command(e)
    
    return {'status': 200, 'text': 'Command launched'}


pages = {
    get_page: {'routes': ['/action/:cmd#.+#']}
}
