%include( "__shinken-lib", type="SOURCE")
%title="%s %s" % ( app._('source.%s' % source.my_type), source.get_name())
%rebase( "layout_skonf" , page_id="Sources", title=title)

%mod = None
%mod_type = ''
%for m in source.modules:
    %mod = m
    %mod_type = m.properties['type']
%end

%type = 'collector' if source.my_type == 'source' else source.my_type
%sname = source.get_name()
%current_state =  source_json.get('state', 'pending').lower() if source_json['enabled'] else 'disabled'

%if 'hosts_to_analyze' not in locals():
    %hosts_to_analyze=[]
%end

%summary_output = source_json.get('summary_output', '')
%output = source_json.get('output', '')

%tab_active = app.request.GET.get('tab', None)
%if not tab_active:
    %tab_active = 'tab-configuration'
%end

%shi_tip_text_play_button = app._('main.force_import') if source.enabled else app._('main.force_import_not_allowed')

<div id="wrapper"
     class="sk source-index-view shinken-source-state-container"
     data-source-enabled="{{source.enabled}}"
     data-state="{{source.state}}"
     data-source-type="{{source.type}}"
     data-source-name="{{source.source_name}}">
    <div class="shinken-content-header">
        <div class="shinken-source-header">
            <table class="shinken-width-100 shinken-table-header">
                <tr>
                    <td class="shinken-breadcrumb">
                        <a class="shinken-link" href="/main">{{app._('main.sources_maj')}}</a>
                        <a class="shinken-link" href="/main#unsortable-container-source-{{type}}-container">{{app._('source.%s' % type)}}</a>
                        <span class="shinkon shinkon-cogs bullet"></span>
                        <span class="shinken-source-name">{{sname}}</span>
                        <span class="shinken-hidden-if-source-not-active">
                            <span class="state-current-status">
                                <span class="shinken-state-label disabled">{{app._('main.state-disabled')}}</span>
                                <span class="shinken-state-label pending">{{app._('main.state-pending')}}</span>
                                <span class="shinken-state-label ok">{{app._('main.state-ok')}}</span>
                                <span class="shinken-state-label warning">{{app._('main.state-warning')}}</span>
                                <span class="shinken-state-label critical">{{app._('main.state-critical')}}</span>
                                <span class="shinken-state-label difference-computing">{{app._('main.computing_differences')}}</span>
                                <span class="shinken-state-label not-configured">{{app._('main.state-not_configured')}}</span>
                                <span class="shinken-state-label running">{{app._('main.import_progress')}}</span>
                                <span class="shinken-state-label never-import">{{app._('main.never_imported')}}</span>
                                <span class="shinken-state-label ready-for-import">{{app._('main.ready-for-import')}}</span>
                            </span>
                        </span>
                    </td>
                    %if output :
                        <td>
                            <div class="shinken-source-summary-output">
                                <div class="shinken-source-summary-output-container">
                                    {{ !output }}
                                </div>
                                <div class="shinken-source-summary-output-shadow"></div>
                            </div>
                        </td>
                    %elif summary_output :
                        <td>
                            <div class="shinken-alert shinken-alert-ghost-warning shinken-source-summary-output">
                                <div class="shinken-source-summary-output-container">
                                    {{ summary_output }}
                                </div>
                            </div>
                        </td>
                    %else:
                        <td>
                            <div class="shinken-source-summary-output">
                                <div class="shinken-source-summary-output-container">
                                </div>
                                <div class="shinken-source-summary-output-shadow"></div>
                            </div>
                        </td>
                    %end
                    <td class="shinken-cell-action">
                        <div class="shinken-play-import-source"
                             onclick="MANAGER.EventManager.clickOnForceSource('{{source.source_name}}')"
                             onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                             onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                             shi-tip-html="{{shi_tip_text_play_button}}">
                            <span class="icon-play"></span>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div id="shinken-content-analyser-main" class="content-main">
        <!-- Nav tabs -->
        <div class="shinken-source-navigation-container tab-nav">
            <table class="nav nav-tabs shinken-window-group" role="tablist" data-name="tab-group" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'tab-group',true)">
                %_extra_class = 'shinken-active' if tab_active == 'tab-configuration' else ''
                <td id="tab-pane-configuration" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-configuration">
                   <div class="shinken-tab-container">
                       <div class="shinken-tab-border"></div>
                       <div class="shinken-tab-item-link">
                           <span id="id-shinken-window-informations">{{app._('source.configuration')}}</span>
                       </div>
                   </div>
                </td>

                %for tab in source.get_tabs():
                    %_extra_class = "shinken-active" if tab_active == "tab-%s" %(tab['name']) else ''
                    <td id="tab-pane-{{tab['name']}}" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name=tab-{{tab['name']}}>
                        <div class="shinken-tab-container">
                            <div class="shinken-tab-border"></div>
                            <div class="shinken-tab-item-link">
                                <span id="id-shinken-window-{{tab['name']}}">{{!tab['displayed_name']}}
                                    <span id="id-shinken-{{tab['name']}}-warnings-counter" class="shinken-warning-counter shinken-counter" data-number="">
                                        <span class="shinken-counter-label"></span>
                                    </span>
                                    <span id="id-shinken-{{tab['name']}}-errors-counter" class="shinken-error-counter shinken-counter" data-number="">
                                        <span class="shinken-counter-label"></span>
                                    </span>
                                </span>
                            </div>
                        </div>
                    </td>
                %end

                %if source.get_tab_container():
                    %for tab_info in source.get_tab_container():
                        %tab_name = tab_info.name
                        %_extra_class = 'shinken-active' if tab_active == 'tab-%s'%tab_name else ''
                        <td id="tab-pane-{{tab_name}}" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name=tab-{{tab_name}}>
                            <div class="shinken-tab-container">
                                <div class="shinken-tab-border"></div>
                                <div class="shinken-tab-item-link">
                                    <span id="id-shinken-window-{{tab_name}}">{{!tab_info.displayed_name}}
                                        <span id="id-shinken-{{tab_name}}-warnings-counter" class="shinken-warning-counter shinken-counter" data-number="">
                                            <span class="shinken-counter-label"></span>
                                        </span>
                                        <span id="id-shinken-{{tab_name}}-errors-counter" class="shinken-error-counter shinken-counter" data-number="">
                                            <span class="shinken-counter-label"></span>
                                        </span>
                                    </span>
                                </div>
                            </div>
                        </td>
                    %end
                %end

                %if mod_type == 'server_analyzer':
                    %_extra_class = 'shinken-active' if tab_active == 'tab-network-scan' else ''
                    <td id="tab-pane-network-scan" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-network-scan">
                        <div class="shinken-tab-container">
                            <div class="shinken-tab-border"></div>
                            <div class="shinken-tab-item-link">
                                <span id="id-shinken-window-network-scan">{{app._('source.network_scan')}} [<span class="shinken-number-active-conf">{{number_active_conf}}</span>/{{number_total_conf}}]</span>
                            </div>
                        </div>
                    </td>

                    %_extra_class = 'shinken-active' if tab_active == 'tab-analyzer-template-mapping' else ''
                    <td id="tab-pane-analyzer-template-mapping" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-analyzer-template-mapping">
                        <div class="shinken-tab-container">
                            <div class="shinken-tab-border"></div>
                            <div class="shinken-tab-item-link">
                                <span id="id-shinken-window-analyzer-template-mapping">{{app._('source.analyzer_template_mapping')}}</span>
                            </div>
                        </div>
                    </td>

                %elif mod_type == 'discovery-import':
                    %_extra_class = 'shinken-active' if tab_active == 'tab-network-scan' else ''
                    <td id="tab-pane-network-scan" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-network-scan">
                        <div class="shinken-tab-container">
                            <div class="shinken-tab-border"></div>
                            <div class="shinken-tab-item-link">
                                <span id="id-shinken-window-network-scan">{{app._('source.network_scan')}} [<span class="shinken-number-active-conf">{{number_active_conf}}</span>/{{number_total_conf}}]</span>
                            </div>
                        </div>
                    </td>

                %elif mod_type == 'sync-vmware':
                    %_extra_class = 'shinken-active' if tab_active == 'tab-vmwarerules' else ''
                    <td id="tab-pane-vmwarerules" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-vmwarerules">
                        <div class="shinken-tab-container">
                            <div class="shinken-tab-border"></div>
                            <div class="shinken-tab-item-link">
                                <span id="id-shinken-window-vmwarerules">{{app._('source.tagging_rules')}}</span>
                            </div>
                        </div>
                    </td>

                %elif mod_type == 'discovery-import':
                %_extra_class = 'shinken-active' if tab_active == 'tab-discovery-rules' else ''
                <td id="tab-pane-discovery-rules" class="shinken-window-element shinken-active" data-group-name="tab-group" data-name="tab-discovery-rules">
                    <div class="shinken-tab-container">
                        <div class="shinken-tab-border"></div>
                        <div class="shinken-tab-item-link">
                            <a id="id-shinken-window-discovery-rules">{{app._('source.discovery_rules')}}</a>
                        </div>
                    </div>
                </td>
                %end

                %_extra_class = 'shinken-active' if tab_active == 'tab-summary-old-run' else ''
                <td id="tab-pane-summary-old-run" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-summary-old-run">
                    <div class="shinken-tab-container">
                        <div class="shinken-tab-border"></div>
                        <div class="shinken-tab-item-link">
                            %tab_label = app._('source.summary_old_request') if source.type == 'listener' else app._('source.summary_old_run')
                            <span id="id-shinken-window-summary-old-run">{{tab_label}}</span>
                        </div>
                    </div>
                </td>

                %_extra_class = 'shinken-active' if tab_active == 'tab-detail-last-run' or tab_active == 'tab-group' else ''
                <td id="tab-pane-detail-last-run" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-detail-last-run">
                    <div class="shinken-tab-container">
                        <div class="shinken-tab-border"></div>
                        <div class="shinken-tab-item-link">
                            <span id="id-shinken-window-detail-last-run">
                                %tab_label = app._('source.elements_list') if source.type in ('listener', 'analyzer') else app._('source.detail_last_run')
                                %number_text = '[%s]' % total_elements if total_elements != 0 else ''
                                {{tab_label}} {{number_text}}
                            </span>
                        </div>
                    </div>
                </td>

                %if hosts_to_analyze or tab_active == 'tab-analyze-jobs-in-progress':
                %_extra_class = 'shinken-active' if tab_active == 'tab-analyze-jobs-in-progress' else ''
                <td id="tab-pane-analyze-jobs-in-progress" class="shinken-window-element {{_extra_class}}" data-group-name="tab-group" data-name="tab-analyze-jobs-in-progress">
                    <div class="shinken-tab-container">
                        <div class="shinken-tab-border"></div>
                        <div class="shinken-tab-item-link">
                            <span id="id-shinken-window-analyze-jobs-in-progress">{{app._('source.analyze_jobs_in_progress')}}</span>
                        </div>
                    </div>
                </td>
                %end


            </table>
        </div>

        <!-- Tab panes -->
        <div class="tab-content card card-shadow has-tab-attached">

            %_extra_class = 'shinken-hidden' if not tab_active == 'tab-configuration' else ''
            <div id="tab-pane-configuration-target" class="{{_extra_class}}">
                %include( 'tab_source_conf', app=app, source=source, source_conf=source_conf)
            </div>

            %_extra_class = 'shinken-hidden' if not tab_active == 'tab-network-scan' else ''
            <div id="tab-pane-network-scan-target" class="{{_extra_class}}">
                %include( 'tab_source_discovery_network_scan', app=app, source=source)
            </div>

            %if mod_type == 'server_analyzer':
                %_extra_class = 'shinken-hidden' if not tab_active == 'tab-analyzer-template-mapping' else ''
                <div id="tab-pane-analyzer-template-mapping-target" class="{{_extra_class}}">
                    %include( 'tab_template_mapping', app=app, source=source, template_mappping_form=template_mappping_form)
                </div>
            %end

            %for tab in source.get_tabs():
                %_extra_class = 'shinken-hidden' if not tab_active == 'tab-%s' %(tab['name']) else ''
                <div id=tab-pane-{{tab['name']}}-target class="{{_extra_class}} shinken-iframe-tab">
                    <iframe id={{tab['content']}} src={{sname}}/{{tab['name']}}/{{tab['content']}} width="100%" height="100%" frameborder="0"></iframe>
                </div>
            %end

            %if source.get_tab_container():
                %for tab_info in source.get_tab_container():
                    %tab_name = tab_info.name
                    %_extra_class = 'shinken-hidden' if not tab_active == 'tab-%s' %(tab_name) else ''
                    <div id=tab-pane-{{tab_name}}-target class="{{_extra_class}} shinken-iframe-tab">
                        <iframe src={{tab_info.get_route()}} width="100%" height="100%" frameborder="0"></iframe>
                    </div>
                %end
            %end

            %if mod_type == 'sync-vmware':
                %_extra_class = 'shinken-hidden' if not tab_active == 'tab-vmwarerules' else ''
                <div id="tab-pane-vmwarerules-target" class="{{_extra_class}}">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <span>{{app._('source.default_esx_tag')}}&nbsp;:&nbsp;</span>
                                    <span>{{mod.myconf.__dict__.get('esx_templates', app._('element.none'))}}</span>
                                </p>
                                <p>
                                    <span>{{app._('source.default_virtual_server_tag')}}&nbsp;:&nbsp;</span>
                                    <span>{{mod.myconf.__dict__.get('vm_templates', app._('element.none'))}}</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            %end

            %if mod_type == 'discovery-import':
                %_extra_class = 'shinken-hidden' if not tab_active == 'tab-discovery-rules' else ''
                <div id="tab-pane-discovery-rules-target" class="{{_extra_class}} responsive">
                    %include( 'tab_source_discovery', app=app, source=source, last_runs=last_runs)
                </div>
            %end

            %_extra_class = 'shinken-hidden' if not tab_active == 'tab-summary-old-run' else ''
            <div id="tab-pane-summary-old-run-target" class="{{_extra_class}}">
                %include( 'tab_source_old_run', app=app, source=source, last_runs=last_runs)
            </div>

            %_extra_class = 'shinken-hidden' if not tab_active == 'tab-detail-last-run' and not tab_active == 'tab-group' else ''
            <div id="tab-pane-detail-last-run-target" class="{{_extra_class}}">
                %include( 'last_import_detail_list', app=app, source=source, list=list, last_run_number=last_run_number, filters=filters, mod_type=mod_type, display_item_types=display_item_types)
            </div>

            %if hosts_to_analyze or tab_active == 'tab-analyze-jobs-in-progress':
                %_extra_class = 'shinken-hidden' if not tab_active == 'tab-analyze-jobs-in-progress' else ''
                <div id="tab-pane-analyze-jobs-in-progress-target" class="{{_extra_class}}">
                    %include('_analyzer_jobs_launch', app=app, source=source, hosts_to_analyze=hosts_to_analyze)
                </div>
            %end
        </div>
    </div>
    <div class="shinken-loading-after-refresh">
        <div class="shinken-loading-after-refresh-container">
            <h1 class="shinken_1">{{!app._('source.import_in_progress')}}</h1>
            <h1 class="shinken_2">{{!app._('source.import_in_progress_2')}}</h1>
            <h1 class="shinken_3">{{!app._('source.import_in_progress_3')}}</h1>
            <br>
            <br>
            <span class="state-current-status">
                <span class="shinken-state-label difference-computing">{{app._('main.computing_differences')}}</span>
                <span class="shinken-state-label running">{{app._('main.import_progress')}}</span>
            </span>
            <div class="shinken-source-summary-output-container-inport-in-progress"></div>
        </div>
    </div>
</div>
