#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceNotificationWay(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'notificationway_name',
        'uuid',
        'definition_order',
        'host_notifications_enabled',
        'service_notification_options',
        'host_notification_commands',
        'service_notification_period',
        'min_business_impact',
        'host_notification_options',
        'service_notifications_enabled',
        'host_notification_period',
        'service_notification_commands',
        'imported_from'
    ]
    
    
    def __init__(self):
        super(SourceNotificationWay, self).__init__()
        self.item_type = ITEM_TYPE.NOTIFICATIONWAYS
