/* https://unix.stackexchange.com/a/403918/119298
 * capture calls to a routine and replace with your code
 * gcc -Wall -O2 -fpic -shared -ldl -o obfuscate_cmdline.so obfsucate_cmdline.c
 * LD_PRELOAD=/.../obfuscate_cmdline.so theprogram theargs...
 */
#define _GNU_SOURCE /* needed to get RTLD_NEXT defined in dlfcn.h */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <dlfcn.h>

typedef int (*pfi)(int, char **, char **);
static pfi real_main;

/* copy argv to new location */
char **copyargs(int argc, char** argv){
    char **newargv = malloc((argc+1)*sizeof(*argv));
    char *from,*to;
    int i,len;

    for(i = 0; i<argc; i++){
        from = argv[i];
        len = strlen(from)+1;
        to = malloc(len);
        memcpy(to,from,len);
        newargv[i] = to;
        if (i > 0)	{ /* Keep the command name */
            memset(from,'\0',len);    /* zap old argv space */
            argv[i] = 0;
		}
    }

    char *cmd_name = getenv("COMMAND_NAME");
    if (cmd_name != NULL) {
        len = strlen(cmd_name)+1;
        to = malloc(len);
        memcpy(to,cmd_name,len);
        argv[0] = to;
    }



    newargv[argc] = 0;
    return newargv;
}

static int mymain(int argc, char** argv, char** env) {
    return real_main(argc, copyargs(argc,argv), env);
}

int __libc_start_main(pfi main, int argc, char **ubp_av, void (*init) (void), void (*fini)(void), void (*rtld_fini)(void), void (*stack_end)){
    static int (*real___libc_start_main)() = NULL;

    if (!real___libc_start_main) {
        char *error;
        real___libc_start_main = dlsym(RTLD_NEXT, "__libc_start_main");
        if ((error = dlerror()) != NULL) {
            exit(1);
        }
    }
    real_main = main;
    return real___libc_start_main(mymain, argc, ubp_av, init, fini, rtld_fini, stack_end);
}
