#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.


from shinkensolutions.api.synchronizer.source.abstract_module.listener_rest_module import BaseRESTListener

properties = {
    'daemons': ['synchronizer'],
    'type'   : 'listener_rest',
}


# called by the plugin manager to get a broker
def get_instance(plugin):
    instance = RESTListener(plugin)
    return instance


class RESTListener(BaseRESTListener):
    url_base_path = '/shinken/listener-rest'
    
    
    def __init__(self, modconf):
        super(RESTListener, self).__init__(modconf)
        # the base url should contain the name of the listener, with different url and port user can't push objects on the bad listener
        self.url_base_path = '/shinken/%s' % self.module_name
