#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.


# Class for a Regenerator. It will get broks, and "regenerate" real objects
# from them :)
class ArchitectureExportHandler(object):
    
    def __init__(self):
        self.arch_maps = {}
    
    
    def want_brok(self, brok):
        return brok.type == "architecture_export_map"
    
    
    def manage_brok(self, brok):
        """ Look for a manager function for a brok, and call it """
        manage = getattr(self, 'manage_' + brok.type + '_brok', None)
        # If we can and want it, got for it :)
        if manage and self.want_brok(brok):
            return manage(brok)
    
    
    def manage_architecture_export_map_brok(self, b):
        data = b.data
        if data is not None:
            self.arch_maps = data
    
    
    def get_api_architecture_export(self):
        to_return = []
        for key, value in self.arch_maps.iteritems():
            if not hasattr(value, 'iteritems'):
                continue
            _current = {
                'shinken_cartos': []
            }
            for k, v in value.iteritems():
                if k == 'name':
                    _current['name'] = v
                else:
                    _current['shinken_cartos'].append(v)
            
            to_return.append(_current)
        
        return to_return
