%if not 'with_menu' in globals(): with_menu = False

<html lang="en">
<head>
    <style type="text/css">
        body {
            margin : 0px;
        }
        li.tab-label {
            background-image : url(/static/{{app.http_start_time}}/images/tab-label.png);
        }
        .gray-back > li.active {
            background-image : url(/static/{{app.http_start_time}}/images/tab-label-active.png);
        }
        @font-face {
            font-family : 'FontAwesome';
            src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?v=3.0.1');
            src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
            url('/static/{{app.http_start_time}}/font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
            url('/static/{{app.http_start_time}}/font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "Lato-Light";
            src         : url("/static/ui/assets/styles/fonts/lato-light.woff") format("woff"),
            url("/static/ui/assets/styles/fonts/lato-light.ttf") format("truetype");
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "Lato";
            src         : url("/static/ui/assets/styles/fonts/lato-regular.woff") format("woff"),
            url("/static/ui/assets/styles/fonts/lato-regular.ttf") format("truetype");
            font-weight : normal;
            font-style  : normal;
        }
        @font-face {
            font-family : "shinkenicons";
            src         : url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
            url("/static/{{app.http_start_time}}/font/shinkenicons.ttf") format("truetype");
            font-weight : normal;
            font-style  : normal;
        }
    </style>

    <title>{{app._("error.error")}}</title>


    <!-- Le HTML5 shim, for IE6-8 support of HTML elements -->
    <!--[if lt IE 9]>
    <script src="/static/{{app.http_start_time}}/js/html5.js"></script>
    <script src="/static/{{app.http_start_time}}/js/json2.js"></script>
    <![endif]-->

    <!-- Le styles -->
    <link href="/static/{{app.http_start_time}}/css/bootstrap.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/font-awesome.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/shinkon.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/dark.fixes.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/enterprise.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/layout.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/badger.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/elements/jquery.meow.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/elements/header-element.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/deptree.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/custom/buttons.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/elements/jquery.pageslide.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/css/jquery.switchButton.css" rel="stylesheet">

    <!-- css3 effect for pulse is not available on IE, It's not real comment, if so it will not work. -->
    <!--[IF !IE]> -->
    <link href="/static/{{app.http_start_time}}/css/elements/pulse.css" rel="stylesheet">
    <!-- <![ENDIF]-->

    <script src="/static/{{app.http_start_time}}/js/jquery.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery-ui-1.8.17.custom.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/spin.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinkenui.js"></script>
    <script src="/static/{{app.http_start_time}}/js/bootstrap.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.pageslide.js"></script>
    <script src="/static/{{app.http_start_time}}/js/bootstrap-datepicker.js"></script>
    <script src="/static/{{app.http_start_time}}/js/bootstrap-typeahead.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.meow.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery-jsonp-2.2.1.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.hotkeys.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.slimscroll.min.js"></script>
    <script src="/static/{{app.http_start_time}}/js/jquery.switchButton.js"></script>

    <!--Shinken ones-->
    <script src="/static/{{app.http_start_time}}/js/shinken-actions.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-greeting.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-opacity.js"></script>
    <script src="/static/{{app.http_start_time}}/js/shinken-modals.js"></script>
    <script src="/static/{{app.http_start_time}}/js/app.js"></script>

    %from shinken.webui.bottlewebui import DEBUG, HTTP_CODES, request, touni

</head>

<body>

<style type="text/css">
    .menu {
        width   : 100%;
        display : inline-block;
    }
    .content {
        width : 100%;
        %if with_menu:
            margin-top: 60px;
        %end
    }
    .menu-top-bar-error {
        overflow         : visible;
        background-color : #454545;
        z-index          : 9000;
    }
    .autodetection-inner-error {
        background-color : #FFFFFF;
        border           : rgb(204, 204, 204) 1px solid;
        margin           : 10px;
        box-shadow       : 0 5px 15px rgba(0, 0, 0, 0.15);
        border-radius    : 5px 5px 0px 0px;
    }
    .autodetection-inner-error .modules-type-area {
        width            : calc(100% - 20px);
        margin           : 15px 10px 10px 10px;
        background-color : white;
        display          : inline-block;
    }
    .autodetection-inner-error .header {
        margin        : 0;
        padding       : 8px 14px;
        border-bottom : 1px solid #EBEBEB;
        border-radius : 5px 5px 0px 0px;
        background    : #743333 linear-gradient(60deg, #6F746F, #743333);
        font-size     : 26px;
        font-weight   : normal;
        line-height   : 26px;
        color         : #F3F1F1;
    }
    .main-nav-bar .btn-logout button {
        margin-top : 0px !important;
    }
</style>

%if with_menu:
    %include mainmenu globals()
%end

<div class="content">
    <div class="autodetection">
        %status_name = HTTP_CODES.get(e.status, 'Unknown').title()
        <div class="autodetection-inner-error">
            <!-- Header-->
            <div class="header">
                {{app._("error.error")}} {{e.status}}: {{status_name}}
            </div>

            <!-- Modules Area-->
            <div class="modules-type-area">
                <p>{{!(app._("error.sorry") % repr(request.url))}}</p>
                <pre>{{e.output}}</pre>
                %if e.exception:
                    <h2>Exception:</h2>
                    <pre>{{repr(e.exception)}}</pre>
                %end
                %if e.traceback:
                    <h2>Traceback:</h2>
                    <pre>{{e.traceback}}</pre>
                %end
            </div>
        </div>
    </div>
</div>
</body>
</html>
