# -*- coding: utf-8 -*-

# Copyright (C) 2009-2016:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#    Martin Benjamin, b.martin@shinken-solutions.com
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from synchronizer.front_end.object.messages import ValidatorMessages


class BusinessException(Exception):
    code = 400  # type: int
    text = u''  # type: unicode
    
    
    def __init__(self, code=None, text=None, shinken_return_code=None, validator_messages=None):
        # type: (int, unicode, unicode, ValidatorMessages) -> None
        self.code = code or self.code
        self.text = text
        self.shinken_return_code = shinken_return_code
        self.validator_messages = validator_messages
    
    
    def __str__(self):
        return self.text
    
    
    def __unicode__(self):
        return self.text


class ShinkenExceptionValueError(BusinessException):
    pass


class ShinkenExceptionKeyError(BusinessException):
    pass


class ShinkenExceptionNoDataError(BusinessException):
    pass


class ShinkenExceptionNoSuchProcess(BusinessException):
    pass
