#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

class UNIQUE_ADDRESS_BEHAVIOUR(object):
    PARAMETER_NAME = u'host__detect_unique_address__behaviour'
    
    DUPLICATED_ACCEPTED = u'duplicated_accepted'
    WARNING_DISPLAYED = u'warning_displayed'
    ERROR_DISPLAYED = u'error_displayed'
    SAVE_FORBIDDEN = u'save_forbidden'
    
    DEFAULT = DUPLICATED_ACCEPTED

    ALL = (DUPLICATED_ACCEPTED, WARNING_DISPLAYED, ERROR_DISPLAYED, SAVE_FORBIDDEN)
    
    ERRORS = (ERROR_DISPLAYED, SAVE_FORBIDDEN)
    
    
    @staticmethod
    def is_error(to_test):
        return bool(to_test in UNIQUE_ADDRESS_BEHAVIOUR.ERRORS)
