#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.objects.service import Service
from shinken.objects.broker.broker_item import BrokerItem
from shinken.objects.itemsummary import ITEM_TYPE

if TYPE_CHECKING:
    from shinken.misc.type_hint import Tuple


class BrokerService(Service, BrokerItem):
    
    def get_type(self):
        # type: () -> unicode
        return ITEM_TYPE.CHECK
    
    
    def get_context(self):
        context = BrokerItem.get_context(self)
        if context[0] == u'NOTHING' and context[1] == u'NOTHING':
            if self.host.acknowledgement and not self.host.acknowledgement.automatic:
                context = u'INHERITED-ACKNOWLEDGED', u'ACKNOWLEDGED'
        return context
    
    
    def get_names(self):
        # type: () -> Tuple[unicode,unicode]
        if self.host and hasattr(self.host, u'host_name') and hasattr(self, u'service_description'):
            return self.host.host_name, self.service_description
        return u'', u''
