#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.
#
#
# File auto-generated

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Set


# Contains default pickleable objects validated by Shinken
_SAFE_PICKLEABLE_CLASSES_DATABASE = {
    '__builtin__': set(['bool', 'complex', 'dict', 'float', 'frozenset', 'int', 'list', 'long', 'object', 'set', 'slice', 'str', 'tuple', 'unicode', 'xrange']),  # noqa: Auto-generated
    'builtins': set(['bool', 'bytes', 'complex', 'dict', 'float', 'frozenset', 'int', 'list', 'object', 'range', 'set', 'slice', 'str', 'tuple']),  # noqa: Auto-generated
    'collections': set(['Counter', 'OrderedDict', 'defaultdict', 'deque']),  # noqa: Auto-generated
    'copy_reg': set(['_reconstructor']),  # noqa: Auto-generated
    'copyreg': set(['_reconstructor']),  # noqa: Auto-generated
    'ordereddict': set(['OrderedDict']),  # noqa: Auto-generated
    'shinken.toolbox.pickledb': set(['ShinkenUnpickler']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.button.generic_button': set(['GenericButton']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.input': set(['InputStringComp']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.radio_list': set(['RadioListComp', 'RadioListCumulativeComp']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.radio_list_element': set(['RadioListElement']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.component.select': set(['SelectComp']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.shinken_grid': set(['ShinkenGrid']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.shinken_grid_element': set(['ShinkenGridElement']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.shinken_grid_element_template': set(['ShinkenGridElementTemplate']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.grid.square': set(['Point', 'Square']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.counter': set(['Counter']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.empty_object': set(['EmptyObject']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.label': set(['LabelHtml']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.one_line_table_html': set(['OneLineTableHtml']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.tag': set(['TagHtml']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.html.tag_generic': set(['TagGeneric']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.messages': set(['Message', 'Messages', 'ValidatorMessage', 'ValidatorMessages']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_object': set(['ShinkenObject', 'ShinkenObjectContainer']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.abstract_shinken_ui_composite': set(['AbstractShinkenUIComposite']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.shinken_ui_containers': set(['AbstractShinkenUIContainer', 'ShinkenUIList', 'ShinkenUIObject']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.shinken_ui_property': set(['AbstractShinkenUINumberProperty', 'AbstractShinkenUIProperty', 'ShinkenUIAnyProperty', 'ShinkenUIBoolProperty', 'ShinkenUIEnumProperty', 'ShinkenUIFloatProperty', 'ShinkenUIIntegerOrEnumProperty', 'ShinkenUIIntegerProperty', 'ShinkenUIStringProperty']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.object.shinken_ui_composite.shinken_ui_property_bad_value': set(['ShinkenUIPropertyBadInheritedValue', 'ShinkenUIPropertyBadInheritedValueFromConfig', 'ShinkenUIPropertyBadValue']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.table.table_body': set(['TableBody']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.table.table_cell': set(['TableCell', 'TableCellHeader']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.table.table_line': set(['TableLine', 'TableLineHeader', 'TableLineTbody']),  # noqa: Auto-generated
    'shinkensolutions.common_ui.window.window': set(['Window']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub': set(['DataHubConfig']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_backup.data_hub_backup': set(['DataHubBackup', 'DataHubsBackup']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver': set(['AbstractDataHubDriverConfig']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_database': set(['AbstractDataHubDriverConfigDatabase']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.abstract_data_hub_driver_file': set(['AbstractDataHubDriverConfigFile']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_cPickle': set(['DataHubDriverConfigPickle']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_data_hub_config_file': set(['DataHubDriverConfigDataHubConfigFile']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_json': set(['DataHubDriverConfigJson']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_mmap_file': set(['DataHubDriverConfigMmapFile']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_driver.data_hub_driver_mongo': set(['DataHubDriverConfigMongo']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_cache': set(['DataHubMetaDriverConfigCache']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_cleanup_directory': set(['DataHubMetaDriverConfigCleanupDirectory']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_replication': set(['DataHubMetaDriverConfigReplication']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_meta_driver.data_hub_meta_driver_retention': set(['DataHubMetaDriverConfigRetention']),  # noqa: Auto-generated
    'shinkensolutions.data_hub.data_hub_utils.data_hub_unpickler': set(['DataHubUnpickler']),  # noqa: Auto-generated
    'shinkensolutions.validators.validation': set(['ValidationMessages']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.validators.weather_validator_message': set(['WeatherValidatorMessages']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.info_bar.weather_external_link_info_bar': set(['WeatherExternalLinkInfoBar']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.info_bar.weather_external_link_info_bar_refresh': set(['WeatherExternalLinkInfoBarRefresh']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.weather_external_link': set(['WeatherExternalLink']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.weather_external_link_layout': set(['WeatherExternalLinkLayout']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.external_links.weather_external_links': set(['WeatherExternalLinks']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.grids.weather_grid': set(['WeatherGrid']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.grids.weather_grid_layouts_container': set(['WeatherGridLayoutsContainer']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.visual.weather_blink_visual_notification': set(['WeatherBlinkVisualNotification']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_notification_interface': set(['WeatherNotificationInterface']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_notifications': set(['WeatherNotifications']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_sound_notification': set(['WeatherSoundNotification']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.notifications.weather_visual_notifications': set(['WeatherVisualNotifications']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.users.weather_user': set(['WeatherUser']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.users.weather_users': set(['WeatherUsers']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather': set(['Weather', 'WeatherGridsList', 'WeatherIdentity']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather_element_data': set(['WeatherElementData']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather_grid_elements': set(['WeatherGridElements']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.weather_object_interface': set(['WeatherObjectInterface']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.content': set(['SeparatorWidgetContent']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.content_template': set(['SeparatorWidgetContentTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display': set(['SeparatorWidgetContentLayoutInformationToDisplay']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_left_area': set(['SeparatorWidgetContentLayoutInformationToDisplayLeftArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_right_area': set(['SeparatorWidgetContentLayoutInformationToDisplayRightArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_template': set(['SeparatorWidgetContentLayoutInformationToDisplayTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_title_area': set(['SeparatorWidgetContentLayoutInformationToDisplayTitleArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.information_to_display.information_to_display_title_area_template': set(['SeparatorWidgetContentLayoutInformationToDisplayTitleAreaTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.layout': set(['SeparatorWidgetContentLayout']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.content.layout.layout_template': set(['SeparatorWidgetContentLayoutTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.separator_widget': set(['SeparatorWidget']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.separator_widget.separator_widget_template': set(['SeparatorWidgetTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.content': set(['TitleWidgetContent']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.content_template': set(['TitleWidgetContentTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display': set(['TitleWidgetContentLayoutInformationToDisplay']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display_template': set(['TitleWidgetContentLayoutInformationToDisplayTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display_title_area': set(['TitleWidgetContentLayoutInformationToDisplayTitleArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.information_to_display.information_to_display_title_area_template': set(['TitleWidgetContentLayoutInformationToDisplayTitleAreaTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.layout': set(['TitleWidgetContentLayout']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.content.layout.layout_template': set(['TitleWidgetContentLayoutTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.title_widget': set(['TitleWidget']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.title_widget.title_widget_template': set(['TitleWidgetTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.content': set(['WeatherWidgetContent']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.content_template': set(['WeatherWidgetContentTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display': set(['WeatherWidgetContentLayoutInformationToDisplay']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_left_area': set(['WeatherWidgetContentLayoutInformationToDisplayLeftArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_name_area': set(['WeatherWidgetContentLayoutInformationToDisplayNameArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_sla_area': set(['WeatherWidgetContentLayoutInformationToDisplaySlaArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.information_to_display.information_to_display_top_right_area': set(['WeatherWidgetContentLayoutInformationToDisplayTopRightArea']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.layout.layout': set(['WeatherWidgetContentLayout']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.content.weather_widget_item': set(['WeatherWidgetItem']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.weather_widget': set(['WeatherWidget']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.weather_widget.weather_widget_template': set(['WeatherWidgetTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget': set(['Widget']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget_content': set(['WidgetContent']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget_content_template': set(['WidgetContentTemplate']),  # noqa: Auto-generated
    'webui_module_service_weather.objects.weather_objects.widgets.widget_template': set(['WidgetTemplate']),  # noqa: Auto-generated
}  # type: Dict[str, Set[str]]
