#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, NamedTuple


def named_tuple_as_dict(name_tuple):
    # type: (NamedTuple) -> Dict
    # _asdict is not a protected function. It was named with an underscore to prevent confusion with user values.
    # noinspection PyProtectedMember
    return name_tuple._asdict()
