#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.basemodule import SOURCE_STATE
from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.api.synchronizer import get_class_from_type
from shinkensolutions.api.synchronizer.source.abstract_module.source_module import SourceModule
from shinkensolutions.api.synchronizer.source.source_configuration_value import SERVICE_MODE

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, List, Str
    from shinkensolutions.api.synchronizer import ValidationState
    from shinkensolutions.api.synchronizer.source.item.item_container import ItemsContainers


class CollectorModule(SourceModule):
    
    def load_configuration(self, configuration):
        raise NotImplementedError()
    
    
    def import_source_items(self):
        raise NotImplementedError()
    
    
    def prepare_finale_source_result(self, items_containers):
        # type: (ItemsContainers) -> Dict
        
        objects = {}
        output = []
        state = SOURCE_STATE.OK
        errors = []
        warning = []
        
        self.source_configuration.validation_state.warnings = []
        self.source_configuration.proxy_source_info.validation_state.warnings = []
        
        if SERVICE_MODE.is_enable(self._state_of_host_template_binding_rule):
            state = self._check_warning(output, state, self.host_template_binding_rule_manager.validation_state, warning)
        
        if SERVICE_MODE.is_enable(self._state_of_mapping_origin_to_source):
            state = self._check_warning(output, state, self.mapper_origin_to_source.validation_state, warning)
        
        if SERVICE_MODE.is_enable(self._state_of_origin_item_properties_description):
            state = self._check_warning(output, state, self.origin_item_description.validation_state, warning)
        
        if SERVICE_MODE.is_enable(self._state_of_api_item_properties):
            state = self._check_warning(output, state, self.api_item_properties.validation_state, warning)
        
        items_containers.apply_host_template_binding_rules()
        
        for item_type, items in items_containers.get_items().iteritems():
            for source_item in items:
                if item_type not in self.type_to_import and self.type_to_import != [u'']:
                    continue
                item_class = get_class_from_type(item_type)
                conf_item = self._mapper_source_to_conf.map(source_item)
                if item_class not in objects:
                    objects[item_class] = []
                if u'tpl' in item_type:
                    conf_item[u'register'] = u'0'
                objects[item_class].append(conf_item)
        
        result = {
            u'state'  : state,
            u'output' : u'<br>'.join(output) or self.translator.translate(u'source.import_message_when_ok') % self.source_name,
            u'objects': objects,
            u'errors' : errors,
            u'warning': warning
        }
        
        self.logger.info(u'prepare return to synchronizer')
        return result
    
    
    @staticmethod
    def _check_warning(output, state, validation, warning):
        # type: (List[Str], Str, ValidationState, List[Str]) -> unicode
        if validation.has_warning():
            state = SOURCE_STATE.WARNING
            for validation_warning in validation.get_warnings():
                if validation_warning not in output:
                    output.append(validation_warning)
            for validation_warning in validation.get_warnings():
                if validation_warning not in warning:
                    warning.append(validation_warning)
        return state
