#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.log import logger
from shinken.misc.type_hint import TYPE_CHECKING
from shinken.modules.base_module.basemodule import BaseModule

if TYPE_CHECKING:
    from shinken.misc.type_hint import NoReturn, Optional
    from synchronizer.synchronizerdaemon import Synchronizer


class ListenerModule(BaseModule):
    CONFIGURATION_FIELDS = {}
    
    
    def __init__(self, modconf):
        super(ListenerModule, self).__init__(modconf)
        
        # We will need our synchronizer daemon for callback calls
        self.syncdaemon = None  # type: Optional[Synchronizer]
        self._my_source = None
        self._ = lambda x: x
    
    
    def load(self, syncdaemon):
        # type: (Synchronizer) -> NoReturn
        self.syncdaemon = syncdaemon
        self._ = self.syncdaemon._
        
        # NOTE: at this point of time, the synchronizer daemon do not have
        # .sources, so we cannot link our source now
    
    
    def _link_my_source(self):
        for source in self.syncdaemon.sources:
            if source.get_module() is self:
                self._my_source = source
                return
    
    
    def get_my_source(self):
        if self._my_source is None:
            self._link_my_source()
        return self._my_source
    
    
    def get_objects(self):
        return self.get_all_discovery_elements()
    
    
    def get_all_discovery_elements(self):
        raise NotImplementedError()
    
    
    def start_listener(self, reason=None):
        raise NotImplementedError()
    
    
    def stop_listener(self, reason=None):
        raise NotImplementedError()
    
    
    def remove_source_item(self, item_type, source_item):
        raise NotImplementedError()
    
    
    def get_configuration_fields(self):
        raise NotImplementedError()
    
    
    def get_my_configuration(self):
        my_source = self.get_my_source()
        return self.syncdaemon.source_controller.get_source_configuration(my_source)
    
    
    def callback_synchronizer_about_new_elements(self, items_type, data=None):
        my_source = self.get_my_source()
        if my_source is None:
            logger.error(u'[LISTENER] cannot find my own source.')
            return
        my_source.callback_about_new_elements(items_type, data)
    
    
    def callback_synchronizer_about_delete_elements(self, items_type, data=None, import_needed=True):
        my_source = self.get_my_source()
        if my_source is None:
            logger.error(u'[LISTENER] cannot find my own source.')
            return
        my_source.callback_about_delete_elements(items_type, data, import_needed)
    
    
    def callback_synchronizer_about_update_elements(self, items_type, data=None):
        my_source = self.get_my_source()
        if my_source is None:
            logger.error(u'[LISTENER] cannot find my own source.')
            return
        my_source.callback_about_update_elements(items_type, data)
