#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.
from abc import ABCMeta, abstractmethod

from shinken.misc.type_hint import NoReturn, Dict, Optional, List, TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.log import PartLogger
    from shinkensolutions.api.synchronizer import ItemType, SourceConfiguration, SourcePropertyDefinition, SourceTranslatePart


class SourceCallbackOnDelete(object):
    __metaclass__ = ABCMeta
    
    
    def __init__(self):
        self.logger = None  # type: Optional[PartLogger]
        self.source_name = u''  # type: unicode
        self.PROPERTIES_DEFINITIONS = []  # type: List[SourcePropertyDefinition]
        self.translator = None  # type: Optional[SourceTranslatePart]
    
    
    @abstractmethod
    def init_callback(self, conf, logger, source_name, translator):
        # type: (SourceConfiguration, PartLogger, unicode, SourceTranslatePart) -> NoReturn
        self.logger = logger
        self.source_name = source_name
        self.translator = translator
    
    
    @abstractmethod
    def callback_on_delete(self, item, item_type):
        # type: (Dict, ItemType) -> NoReturn
        pass


class SourceCallbackOnNew(object):
    __metaclass__ = ABCMeta
    
    
    def __init__(self):
        self.logger = None  # type: Optional[PartLogger]
        self.source_name = u''  # type: unicode
        self.PROPERTIES_DEFINITIONS = []  # type: List[SourcePropertyDefinition]
        self.translator = None  # type: Optional[SourceTranslatePart]
    
    
    @abstractmethod
    def init_callback(self, conf, logger, source_name, translator):
        # type: (SourceConfiguration, PartLogger, unicode, SourceTranslatePart) -> NoReturn
        self.logger = logger
        self.source_name = source_name
        self.translator = translator
    
    
    @abstractmethod
    def callback_on_new(self, item_id, item_type):
        # type: (str, ItemType) -> NoReturn
        pass


class SourceCallbackOnChange(object):
    __metaclass__ = ABCMeta
    
    
    def __init__(self):
        self.logger = None  # type: Optional[PartLogger]
        self.source_name = u''  # type: unicode
        self.PROPERTIES_DEFINITIONS = []  # type: List[SourcePropertyDefinition]
        self.translator = None  # type: Optional[SourceTranslatePart]
    
    
    @abstractmethod
    def init_callback(self, conf, logger, source_name, translator):
        # type: (SourceConfiguration, PartLogger, unicode, SourceTranslatePart) -> NoReturn
        self.logger = logger
        self.source_name = source_name
        self.translator = translator
    
    
    @abstractmethod
    def callback_on_change(self, item_id, item_type):
        # type: (str, ItemType) -> NoReturn
        pass
