#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import Optional, Type

from shinkensolutions.api.synchronizer.source.display_origin_item.abstract_display_origin_item import AbstractDisplayOriginItem
from shinkensolutions.api.synchronizer.source.display_origin_item.display_origin_item_as_string import DisplayOriginItemAsString
from shinkensolutions.api.synchronizer.source.display_origin_item.display_origin_item_as_tabular import DisplayOriginItemAsTabular

FilePath = str
TypeDisplayOriginItemFormat = str  # Type for DisplayOriginItemFormat.TABULAR / DisplayOriginItemFormat.STRING / DisplayOriginItemFormat.CUSTOM  For type hint.


# see SEF-6035
class DisplayOriginItemFormat(object):
    TABULAR = 'TABULAR'
    STRING = 'STRING'
    CUSTOM = 'CUSTOM'
    
    
    def __init__(self, template_format, title='', display_origin_item_class=None):
        # type: ( TypeDisplayOriginItemFormat, str, Optional[Type[AbstractDisplayOriginItem]]) -> None
        self.template_format = template_format
        self.title = title
        self.display_origin_item_class = display_origin_item_class  # type: Optional[Type[AbstractDisplayOriginItem]]
        
        if self.template_format == DisplayOriginItemFormat.TABULAR:
            self.display_origin_item_class = DisplayOriginItemAsTabular
        elif self.template_format == DisplayOriginItemFormat.STRING:
            self.display_origin_item_class = DisplayOriginItemAsString
    
    
    def load(self, source):
        logger = source.logger
        
        if self.template_format == DisplayOriginItemFormat.TABULAR:
            self.display_origin_item_class = DisplayOriginItemAsTabular
            self.display_origin_item_class.origin_item_properties_description = source.origin_item_description
        
        elif self.template_format == DisplayOriginItemFormat.STRING:
            self.display_origin_item_class = DisplayOriginItemAsString
        
        elif self.template_format == DisplayOriginItemFormat.CUSTOM:
            if not self.display_origin_item_class:
                logger.error('For template_format CUSTOM, display_origin_item can\'t be empty.')
