#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.basemodule import SOURCE_STATE


class SourceException(BaseException):
    
    def __init__(self, message, level=SOURCE_STATE.CRITICAL, error_code=u''):
        self.message = message
        self.level = level
        self.error_code = error_code
    
    
    def __str__(self):
        return u'SourceException(code=[%s] level=[%s] message=[%s])' % (self.error_code, self.level, self.message)
