#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import NoReturn, Type, Optional, List
from shinkensolutions.api.synchronizer import SourcePropertyDefinition
from shinkensolutions.api.synchronizer.source.callback.callback_interface import SourceCallbackOnDelete
from shinkensolutions.api.synchronizer.source.display_origin_item.display_origin_item_format import DisplayOriginItemFormat
from shinkensolutions.api.synchronizer.source.mapping.origin_to_source.mapper import AbstractMapperOriginToSource
from shinkensolutions.api.synchronizer.source.source_configuration_value import SERVICE_MODE, ServiceMode
from shinkensolutions.api.synchronizer.source.source_exception import SourceException
from shinkensolutions.api.synchronizer import ITEM_TYPE


class SourceSetup(object):
    private_properties_definitions = None  # type: List[SourcePropertyDefinition]
    
    
    def __init__(self):
        self.private_state_of_mapping_origin_to_source = SERVICE_MODE.ON
        self.private_origin_to_source_type_mapper = None  # type: Optional[Type[AbstractMapperOriginToSource]]
        self.private_origin_to_source_mappers_name = []  # type: List[unicode]
        
        self.private_state_of_host_template_binding_rule = SERVICE_MODE.ON
        
        self.private_state_of_display_origin_item = SERVICE_MODE.ON
        self.private_display_origin_item_format = None  # type: Optional[DisplayOriginItemFormat]
        
        self.private_state_of_api_item_properties = SERVICE_MODE.OFF
        
        self.private_type_to_import = list(ITEM_TYPE.ALL_TYPES)  # type: Optional[List[unicode]]
        self.private_not_editable_properties = None
        
        self.private_state_of_origin_item_properties_description = SERVICE_MODE.ON
        self.private_on_delete_callbacks = []  # type: List[SourceCallbackOnDelete]
        self.private_origin_item_description_class = None
        self.private_api_item_properties_class = None
        self.private_properties_definitions = []  # type: List[SourcePropertyDefinition]
    
    
    def set_mapping_origin_to_source(self, state, mapper=None, mappers_name=None):
        # type: (ServiceMode, Type[AbstractMapperOriginToSource], Optional[List[unicode]]) -> NoReturn
        self._check_value(state, u'mapping_origin_to_source')
        self.private_state_of_mapping_origin_to_source = state
        self.private_origin_to_source_type_mapper = mapper
        self.private_origin_to_source_mappers_name = mappers_name or []
    
    
    def set_host_template_binding_rule(self, value):
        # type: (ServiceMode) -> NoReturn
        self._check_value(value, u'service_host_template_binding_rule')
        self.private_state_of_host_template_binding_rule = value
    
    
    def set_display_origin_item(self, value, display_origin_item_format):
        # type: (ServiceMode, DisplayOriginItemFormat ) -> NoReturn
        self._check_value(value, u'service_display_origin_item')
        
        self.private_state_of_display_origin_item = value
        self.private_display_origin_item_format = display_origin_item_format
    
    
    def set_api_item_properties(self, value):
        # type: (ServiceMode ) -> NoReturn
        self._check_value(value, u'set_api_item_properties')
        self.private_state_of_api_item_properties = value
    
    
    def set_origin_item_properties_description(self, value):
        # type: (ServiceMode ) -> NoReturn
        self._check_value(value, u'origin_item_properties_description')
        self.private_state_of_origin_item_properties_description = value
    
    
    def set_origin_type_to_import(self, value):
        # type: (list ) -> NoReturn
        self.private_type_to_import = value
    
    
    def set_not_editable_properties(self, to_set):
        # type: (list[str]) -> NoReturn
        self.private_not_editable_properties = to_set
    
    
    @staticmethod
    def _check_value(value, service_name):
        if value not in SERVICE_MODE.SERVICE_MODE_VALUES:
            raise SourceException(u'Possible value for %s are %s, you set : %s' % (service_name, u','.join(SERVICE_MODE.SERVICE_MODE_VALUES), value))
    
    
    def add_on_delete_callback(self, on_delete_callback):
        # type: (SourceCallbackOnDelete) -> NoReturn
        self.private_on_delete_callbacks.append(on_delete_callback)
        self.private_properties_definitions.extend(on_delete_callback.PROPERTIES_DEFINITIONS)
    
    
    def set_origin_item_description_class(self, origin_item_description_class):
        # type: (Type) -> None
        self.private_origin_item_description_class = origin_item_description_class
    
    
    def set_api_item_properties_class(self, api_item_properties_class):
        # type: (Type) -> None
        self.private_api_item_properties_class = api_item_properties_class
    
    
    def set_configuration_properties_definition(self, properties_definitions):
        # type: (List[SourcePropertyDefinition]) -> None
        for index, current in enumerate(properties_definitions):
            current.order = index
        self.private_properties_definitions.extend(properties_definitions)
