%tab_name = translate('host_template_binding_rules.tab_display_name')
<div class="shinken-help-container">
    <div class="shinken-help-content" data-order="1" data-tab="host-template-binding-rules-tab" data-tab-order="1" data-tab-name="{{tab_name}}"  data-level="1">
        <div class="shinken-title">
            {{!translate('common.help.interface_description.title_1')}}
        </div>
    </div>
    <div class="shinken-help-content" data-order="2" data-tab="host-template-binding-rules-tab" data-tab-order="1" data-tab-name="{{tab_name}}" data-level="2">
        <div class="shinken-title">
            {{!translate('common.help.interface_description.subtitle_1')}}
        </div>
        <table class="shinken-help-content-table">
            %for i in range(1,7):
                <tr>
                    <td class="shinken-help-key-cell">
                        <div class="shinken-help-key">
                            {{!translate('host_template_binding_rules.help.column_description.key_%s' % i)}}
                        </div>
                    </td>
                    <td>
                        <div class="shinken-help-text">
                            {{!translate('host_template_binding_rules.help.column_description.text_%s' % i)}}
                        </div>
                    </td>
                </tr>
            %end
        </table>
        <div class="shinken-title">
            {{!translate('common.help.interface_description.subtitle_2')}}
        </div>
        <table class="shinken-help-content-table">
            <tr>
                <td class="shinken-help-key-cell">
                    <div>
                        {{!html_distributor.get(HTML_TYPE.BUTTON,'reload_rules').get_html_as_label()}}
                    </div>
                </td>
                <td>
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.interface_description.text_2')}}
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <div class="shinken-help-content" data-order="3" data-tab="host-template-binding-rules-tab" data-tab-order="1" data-tab-name="{{tab_name}}" data-level="1">
        <div class="shinken-title">
            {{!translate('host_template_binding_rules.help.binding_rule_definition.title_1')}}
        </div>
    </div>
    <div class="shinken-help-content" data-order="4" data-tab="host-template-binding-rules-tab" data-tab-order="1" data-tab-name="{{tab_name}}" data-level="1">
        <table class="shinken-help-content-table">
            <tr>
                <td colspan="2">
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.binding_rule_definition.text_5')}}
                    </div>
                </td>
            </tr>
            <tr>
                <td class="shinken-help-key-cell">
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.interface_description.text_1')}}
                    </div>
                </td>
                <td>
                    <div class="shinken-help-text">
                        <div class="shinken-files-url-container shinken-user-select-text">
                            %for _current in files_configuration:
                                <div class="shinken-file-url shinken-user-select-text" data-status="{{_current['status']}}">{{_current['path']}}</div>
                            %end
                        </div>
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <div class="shinken-help-content" data-order="5" data-tab="host-template-binding-rules-tab" data-tab-order="1" data-tab-name="{{tab_name}}" data-level="2">
        <div class="shinken-title">
            {{!translate('host_template_binding_rules.help.binding_rule_definition.subtitle_1')}}
        </div>

        <table class="shinken-help-content-table shinken-table-layout-fixed">
            <tr>
                <td>
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.binding_rule_definition.text_1')}}
                    </div>
                </td>
                <td class="shinken-example">
                        <div class="shinken-title">
                            {{!translate('host_template_binding_rules.help.binding_rule_definition.title_2')}}
                        </div>
<div class="shinken-code shinken-user-select-text">[
  {
    "name" : "rule 32 bit generation",
    "template" : "x86,32-bit",
    "condition1" : "config.product.osType=86"
  },
  {
    "name" : "Linux 64bits",
    "template" : "linux,64-bit,x64",
    "condition1" : "config.product.osType=64 AND config.guestFullName=ubuntu",
#   "condition2" : "config.product.osType=64 AND config.guestFullName=^Centos$",
    "condition3" : "config.product.osType=64 AND config.guestFullName=fedora",
    "disable" : "true"
  }
]</div>
                </td>
            </tr>
        </table>
        <table class="shinken-help-content-table shinken-help-rules-condition-table">
            %for i in range(1,6):
                <tr>
                    <td class="shinken-help-key-cell">
                        <div class="shinken-help-key">
                            {{!translate('host_template_binding_rules.help.rule_syntax.key_%s' % i)}}
                        </div>
                    </td>
                    <td>
                        <div class="shinken-help-text">
                            {{!translate('host_template_binding_rules.help.rule_syntax.text_%s' % i)}}
                        </div>
                    </td>
                </tr>
            %end
        </table>
         <table class="shinken-help-content-table">
            <tr>
                <td>
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.binding_rule_definition.subtext_1')}}
                    </div>
                </td>

            </tr>
        </table>
    </div>
    <div class="shinken-help-content" data-order="6" data-tab="host-template-binding-rules-tab" data-tab-order="1" data-tab-name="{{tab_name}}" data-level="2">
        <div class="shinken-title">
            {{!translate('host_template_binding_rules.help.binding_rule_definition.subtitle_3')}}
        </div>
        <table class="shinken-help-content-table">
            <tr>
                <td>
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.binding_rule_definition.text_3')}}
                    </div>
                </td>
            </tr>
        </table>

        <div class="shinken-title">
            {{!translate('host_template_binding_rules.help.binding_rule_definition.subtitle_4')}}
        </div>
         <table class="shinken-help-content-table">
            <tr>
                <td>
                    <div class="shinken-help-text">
                        {{!translate('host_template_binding_rules.help.binding_rule_definition.text_4')}}
                    </div>
                </td>
            </tr>
        </table>

    </div>
</div>
