CONTROLLER.HostTemplateBindingRules = (function ( self ) {
    "use strict";
    self.controller_name     = 'HostTemplateBindingRules';
    self.list_property       = "";
    //********************************************  EVENT LISTENER  **************************************************//
    self.mouseEnter          = function ( event ) {
        if ( event.target.classList.contains( 'shinken-list-line' ) ) {
            if ( parseInt( event.target.dataset[ 'numberError' ] ) ) {
                SHINKEN_TOOLTIP.showTooltip( event.target.querySelector( '.shinken-list-cell[data-filter="counters"] .shinken-error-counter' ) );
            }
            else if ( parseInt( event.target.dataset[ 'numberWarning' ] ) ) {
                SHINKEN_TOOLTIP.showTooltip( event.target.querySelector( '.shinken-list-cell[data-filter="counters"] .shinken-warning-counter' ) );
            }
        }
    };
    self.mouseLeave          = function () {
        SHINKEN_TOOLTIP.hideTooltip();
    };
    self.clickOnSelector     = function ( event ) {
        self.onClick();
        self.getListProperty().clickOnSelector( event );
    };
    self.clickOnItemSelector = function ( event, parent_name, element ) {
        self.getListProperty().clickOnItemSelector( event, parent_name, element );
    };
    self.onChangeOnInput     = function ( event ) {
        self.getListProperty().askComputeAfterChange( event.target );
    };
    self.clickOnInput        = function ( event ) {
    };
    self.onClick             = function ( event ) {
        self.getListProperty().onClick();
    };
    self.clickOnButton       = function ( event, event_name ) {
        self.onClick();
        switch ( event_name ) {
            case "reload_rules":
                self.clickOnReloadRules();
                break;
        }
    };
    self.askInitReload       = function () {
        DOM.BodyService.askAddClass( "shinken-import-in-progress" );
    };
    self.askReload           = function () {
        setTimeout( function () {
            self.updateCounter();
            location.reload();
        }, 1000 );
    };
    self.clickOnReloadRules  = function () {
        parent.window.MANAGER.__instance_source_distributor.findSource( parent.document.getElementById( "wrapper" ).dataset.sourceName ).askUpdateBeforeAnyAction();
        self.askInitReload();
        $.ajax( {
            url    : "/sources/" + SHINKEN.TOOLS.STRING.urlEncodeForEscapeNavigator(__current_source_name) + "/template_binding_rules/reload",
            success: function ( data ) {
                switch ( data ) {
                    case SOURCE.CONST.STATE.RUNNING :
                        DOM.BodyService.removeClass( "shinken-import-in-progress" );
                        window.parent.MANAGER.__instance_source_distributor.current_element.askForRefresh();
                        break;
                    default:
                        self.askReload();
                        break;
                }
            },
            error  : function ( data, txt ) {
                self.askReload();
                console.log( 'Got bad result for ' + data );
            }
        } );
        $.ajax();
    };
    self.keydown             = function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                CONTROLLER.Help.toggleHelp( event );
                break;
            case SHINKEN.CONST.KEY_CODE.ESCAPE:
                CONTROLLER.Help.closeHelp();
                break;
        }
    };
    //********************************************  GETTER SETTER    ******************************************************//
    self.getListProperty     = function () {
        if ( !self.list_property ) {
            self.list_property = new SHINKEN_LIST.SetFromHtml( document.querySelector( ".shinken-list-container" ) );
        }
        return self.list_property;
    };
    //********************************************  COUNTER    ******************************************************//
    self.updateCounter       = function () {
        try {
            var _warnings = document.getElementById( "id-shinken-host-template-binding-rules-messages" ).querySelector( ".shinken-warnings-message" );
            _warnings     = _warnings ? parseInt( _warnings.dataset.number ) + parseInt( _warnings.dataset.extraNumber ) : 0;
            window.parent.MANAGER.__instance_counter_distributor.findCounter( 'host_template_binding_rules-warnings' ).update( 'id-shinken-host-template-binding-rules-messages', _warnings );
            
            var _errors = document.getElementById( "id-shinken-host-template-binding-rules-messages" ).querySelector( ".shinken-errors-message" );
            _errors     = _errors ? parseInt( _errors.dataset.number ) + parseInt( _errors.dataset.extraNumber ) : 0;
            window.parent.MANAGER.__instance_counter_distributor.findCounter( 'host_template_binding_rules-errors' ).update( 'id-shinken-host-template-binding-rules-messages', _errors );
            self.computeSizes();
        }
        catch ( e ) {
            console.warn( "[self - updateCounter]", e );
        }
    };
    //********************************************  NAVIGATOR SIZE MANAGER    ******************************************************//
    self.computeSizes        = function () {
        var _size_container  = DOM.Service.getHeight( document.querySelector( ".shinken-list-container" ) );
        var _size_message    = DOM.Service.getHeight( document.getElementById( "id-shinken-host-template-binding-rules-messages" ) );
        var _size_file       = DOM.Service.getHeight( document.querySelector( ".shinken-files-configuration" ) );
        var _size_header     = DOM.Service.getHeight( document.querySelector( ".shinken-fix-container" ) );
        var _variable_dom    = document.querySelector( ".shinken-scrollable-container" );
        var _size_scrollable = _size_container - _size_message - _size_file - _size_header - 5;
        DOM.Service.setStyles( _variable_dom, { height: _size_scrollable } );
    };
    return self;
})( CONTROLLER.HostTemplateBindingRules || {} );

$( window ).resize( CONTROLLER.HostTemplateBindingRules.computeSizes );

MANAGER.DistributorControllerManager.getController = function () {
    return CONTROLLER.HostTemplateBindingRules;
};

document.addEventListener( "DOMContentLoaded", function ( e ) {
    CONTROLLER.HostTemplateBindingRules.updateCounter();
    MANAGER.HelpGenerator.init( [ 'source' ] );
} );
document.addEventListener( "click", function ( event ) {
    MANAGER.EventManager.onClick( event );
} );