#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved

from shinken.misc.type_hint import Dict, NoReturn
from shinkensolutions.api.synchronizer.source.route.route_container import RouteContainer
from shinkensolutions.api.synchronizer.source.tab.tab import AbstractTab


class TabContainer(object):
    
    def __init__(self, route_container):
        # type: (RouteContainer) -> None
        self._tabs = {}  # type: Dict[unicode, AbstractTab]
        self._route_container = route_container
    
    
    def __iter__(self):
        return self._tabs.itervalues()
    
    
    def add(self, tab_name, tab):
        # type: (unicode, AbstractTab) -> NoReturn
        self._tabs[tab_name] = tab
        self._route_container.add(tab_name, tab)
    
    
    def get(self, tab_name):
        return self._tabs[tab_name]
