#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ...object.html.label import LabelHtml
from ...object.html.tag import TagHtml
from ...object.shinken_object import ShinkenObject

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, NoReturn, Optional, Callable
    from shinkensolutions.component.abstract_translate_component import TranslateKey


class GenericButton(ShinkenObject):
    def __init__(self, translate=None, name=u'', tag=None, label=u'', label_object=None):
        # type: (Callable[[TranslateKey, Any],unicode], unicode, TagHtml, unicode, LabelHtml) -> None
        super(GenericButton, self).__init__(translate)
        self._name = name
        self._tag = tag
        self._label = None  # type: Optional[LabelHtml]
        self.set_label(label_object or label)
        self._onclick = u'MANAGER.EventManager.clickOnButton(event)'
        self.add_class(u'shinken-button')
        self._attribute = ''
    
    
    def set_onclick(self, to_set):
        # type: (unicode) -> NoReturn
        self._onclick = to_set
    
    
    def set_name(self, to_set):
        # type: (unicode) -> NoReturn
        self._name = to_set
    
    
    def set_label(self, to_set):
        # type: (Any) -> NoReturn
        if isinstance(to_set, basestring):
            self._label = LabelHtml(self.translate, to_set)
        else:
            self._label = to_set
    
    
    def set_tag(self, to_set):
        # type: (TagHtml)-> NoReturn
        self._tag = to_set
    
    
    def get_tag(self):
        # type: ()-> TagHtml
        return self._tag
    
    
    def get_label(self):
        # type: (Any) -> LabelHtml
        return self._label
    
    
    def get_label_html(self):
        return self._label.get_html()
    
    
    def get_html(self):
        # type: () -> unicode
        _to_return = [
            u'''%s''' % (self._tag.get_opening_tag_html() if self._tag else u''),
            u''' <div class="%s" onclick="%s" data-name="%s" %s %s>''' % (self._class, self._onclick, self._name, self._attribute, self.tooltip.get_html()),
            self.wrap_in_middle_vertical_align_container(self._label.get_html()),
            u''' </div>''',
            u'''%s''' % (self._tag.get_closing_tag_html() if self._tag else u'')
        ]
        return u''.join(_to_return)
    
    
    def get_html_as_label(self):
        # type: () -> unicode
        _to_return = [
            u'''%s''' % (self._tag.get_opening_tag_html() if self._tag else u''),
            u''' <div class="%s" data-name="%s" %s>''' % (self._class, self._name, self._attribute),
            self.wrap_in_middle_vertical_align_container(self._label.get_html()),
            u''' </div>''',
            u'''%s''' % (self._tag.get_closing_tag_html() if self._tag else u'')
        ]
        return ''.join(_to_return)
