#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import TYPE_CHECKING
from ..object.shinken_object import ShinkenObject
from ..component.option_select import OptionSelectAbstractComp

if TYPE_CHECKING:
    from shinkensolutions.api.synchronizer import TranslatePart
    from shinken.misc.type_hint import NoReturn, List
    from ..component.option_select_property import OptionSelectPropertyComp


class SelectComp(ShinkenObject):
    def __init__(self, translator, options=None, _id=u''):
        # type: (TranslatePart, List[OptionSelectAbstractComp], unicode) -> None
        super(SelectComp, self).__init__(translator)
        self.options = options if options else []
        self.label = u''
        self._id = _id
        self.mapping_options = {}
        self.compute_options_mapping()
        self.select_search_input = None
        self.select_search_input_info = None
        self.label_info = None
        self.has_header = False
        self.has_list_pop_info = False
    
    
    def get_id(self):
        return self._id
    
    
    def add_option(self, to_add):
        if to_add.get_id() not in self.mapping_options:
            self.mapping_options[to_add.get_id()] = to_add
            self.options.append(to_add)
    
    
    def compute_options_mapping(self):
        for option in self.options:
            self.mapping_options[option.get_id()] = option
    
    
    def set_label(self, to_set):
        # type: (unicode) -> NoReturn
        self.label = to_set
    
    
    def get_option(self, prop_name, option_name):
        # type: (unicode, unicode)-> OptionSelectPropertyComp
        return self.mapping_options.get(OptionSelectAbstractComp.build_id(prop_name, option_name), None)
    
    
    def set_label_info(self, to_set):
        # type: (unicode)-> NoReturn
        self.label_info = to_set
    
    
    def set_has_list_pop_info(self, to_set):
        # type: (bool)-> NoReturn
        self.has_list_pop_info = to_set
    
    
    def get_html(self, value_selected=None, parent_name=u''):
        # type: (List, unicode)-> unicode
        
        if value_selected is None:
            value_selected = []
        options_list = []
        
        for option in self.options:
            if value_selected and option.get_value() in value_selected:
                option.set_is_selected(True)
                self.set_label(option.get_label())
            options_list.append(option.get_html())
        
        _caret = u'''<span class="caret"></span>'''
        selector_html = [
            u'''<div class="shinken-select-selector shinken-select-selector-status shinken-user-select-none" onclick="MANAGER.EventManager.clickOnSelector(event, '%s')">''' % parent_name,
            u'''<div class="shinken-selector-label shinken-space">%s</div>''' % self.label,
            _caret,
            u'''</div>'''
        ]
        
        pop_up_information = [
            u'''<td class="shinken-list-select-info-cell">''',
            u'''<div class="shinken-list-select-info-container">''',
            u'''%s''' % self.select_search_input_info.get_html() if self.select_search_input_info else u'',
            u'''<div class="shinken-list-select-info-label">%s</div>''' % self.label_info if self.label_info else u'',
            u'''<div class="shinken-list-select-info-elements-container"></div>''',
            u'''</div>''',
            u'''</td>'''
        ]
        
        options_list_html = ['''<div class="shinken-list-select %s">''' % ('shinken-has-select-header' if self.has_header else ''),
                             '''<table class="shinken-table-list-select">''',
                             '''<tr>''',
                             '''<td class="shinken-list-select-cell">''',
                             '''<div class="shinken-list-select-container">''',
                             '''<div class="list-select-header">''',
                             '''%s''' % self.select_search_input.get_html() if self.select_search_input else '',
                             '''</div>''',
                             '''<div class="list-select-content shinken-user-select-none" >''',
                             '''%s''' % ''.join(options_list),
                             '''</div>''',
                             '''</div>''',
                             '''</td>'''
                             '''%s''' % ''.join(pop_up_information) if self.has_list_pop_info else '',
                             '''</tr>'''
                             '''</table>'''
                             '''</div>'''
                             ]
        _to_return = [''.join(selector_html),
                      ''.join(options_list_html)]
        
        _to_return = ''.join(_to_return)
        return _to_return
