#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn, Any


class AbstractDistributor(object):
    def __init__(self):
        # type: ()-> None
        self.contents = {}
    
    
    def reset(self):
        # type: ()-> NoReturn
        self.contents = None
        self.contents = {}
    
    
    def add_element(self, _id_, to_add):
        # type: (str,Any)-> NoReturn
        self.contents[_id_] = to_add
    
    
    def get_element(self, _id_):
        # type: (str)-> Any
        return self.contents[_id_]
    
    
    def find_element(self, _id_):
        # type: (str)-> Any
        raise NotImplementedError()
