#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.common_ui.component.button.generic_button import GenericButton
from shinkensolutions.common_ui.object.messages import MESSAGE, Message
from shinkensolutions.component.abstract_component import AbstractComponent

if TYPE_CHECKING:
    from shinken.misc.type_hint import Callable, Any, Optional
    from shinkensolutions.component.abstract_translate_component import AbstractTranslateComponent, TranslateKey
    from shinkensolutions.common_ui.object.html.label import LabelHtml
    from shinkensolutions.common_ui.object.html.tag import TagHtml


class UiFactoryComponent(AbstractComponent):
    
    def __init__(self, translate_component):
        # type: (AbstractTranslateComponent) -> None
        self.translate_component = translate_component
        self.translate = None  # type:Optional[Callable[[TranslateKey, Any],unicode]]
    
    
    def init(self):
        self.translate = self.translate_component.translate
    
    
    def build_generic_button(self, name=u'', tag=None, label=u'', label_object=None):
        # type: (unicode, TagHtml, unicode, LabelHtml) -> GenericButton
        return GenericButton(translate=self.translate, name=name, tag=tag, label=label, label_object=label_object)
    
    
    def build_message(self, type_message, text, weight=MESSAGE.WEIGHT_LOW):
        # type: (unicode, unicode, Optional[int]) -> Message
        return Message(type_message, text, translate=self.translate, weight=weight)
