#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from .constant import SHINKEN_GRID_ELEMENTS_CONSTS
from ..object.shinken_ui_composite.shinken_ui_containers import ShinkenUIObject
from ..object.shinken_ui_composite.shinken_ui_property import ShinkenUIIntegerProperty, ShinkenUIIntegerOrEnumProperty

if TYPE_CHECKING:
    from shinken.misc.type_hint import Type
    from ..object.messages import ValidatorMessages


class ShinkenGridElementTemplate(ShinkenUIObject):
    KEYS_VALIDATION_MSG = u'validation_messages'
    KEYS_WIDTH = u'width'
    KEYS_HEIGHT = u'height'
    KEYS_POS_X = u'position_x'
    KEYS_POX_Y = u'position_y'
    KEYS_TYPE = u'type'
    
    KEYS_PURE_POSITIVE_INTEGERS = (KEYS_POS_X, KEYS_POX_Y)
    KEYS_PURE_INTEGERS = [KEYS_HEIGHT]
    
    
    def __init__(self, associated_key, index, validator_message_type=None, mandatory=False):
        # type:(unicode, int, Type[ValidatorMessages], bool) -> None
        super(ShinkenGridElementTemplate, self).__init__(associated_key, validator_message_type=validator_message_type, mandatory=mandatory)
        self.index = index
        self.width = ShinkenUIIntegerOrEnumProperty(SHINKEN_GRID_ELEMENTS_CONSTS.KEY_WIDTH, validator_message_type=validator_message_type, enum=(u'all',), allow_default=True, must_be_strict_positive=True)
        self.height = ShinkenUIIntegerProperty(SHINKEN_GRID_ELEMENTS_CONSTS.KEY_HEIGHT, validator_message_type=validator_message_type, allow_default=True, must_be_strict_positive=True)
