#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2021
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinken.toolbox.pickledb import ShinkenPickleableMeta

if TYPE_CHECKING:
    from shinken.misc.type_hint import Optional


class Point(object):
    __metaclass__ = ShinkenPickleableMeta
    __slots__ = [u'x', u'y']
    
    
    def __init__(self, x, y):
        # type: (Optional[int], Optional[int]) -> None
        self.x = x
        self.y = y if y != u'unlimited' else -1
    
    
    def __repr__(self):
        return u'x:%s,y:%s' % (self.x, self.y)


class Square(object):
    __slots__ = [u'border_bottom_left_point', u'border_top_right_point']
    __metaclass__ = ShinkenPickleableMeta
    
    
    def __init__(self, border_bottom_left_point, border_top_right_point):
        # type: (Point, Point) -> None
        self.border_bottom_left_point = border_bottom_left_point
        self.border_top_right_point = border_top_right_point
    
    
    def __repr__(self):
        return u'bottom_left [%s], top_right [%s]' % (self.border_bottom_left_point, self.border_top_right_point)
