'use strict';
var SHINKEN_VALIDATION = {};
SHINKEN_VALIDATION.CONST = {
    BOOLEAN: {
        _KEY : "boolean",
    },
    COLOR: {
        CSS: {
            _KEY : "color_css_valid",
            REGEX : /[";']/
        }
    },
    LIST: {
        INCLUDE_IN: "list_include_in"
    },
    NUMBER: {
        FLOAT_POSITIVE: "float_positive",
        INTEGER_POSITIVE: "integer_positive",
        INTEGER_BETWEEN: "integer_between"
    },
    STRING: {
        NOT_EMPTY: "string_not_empty",
        DONT_HAVE_FORBIDDEN: "dont_have_forbidden",
        IS_STRING: "is_string"
    },
    OTHERS: {
        DEFINE_STRING_OR_INTEGER_POSITIVE: "define_string_or_integer_positive"
    }
};
var SHINKEN = SHINKEN || {};
SHINKEN.DOM = SHINKEN.DOM ||{};
SHINKEN.MODAL     = SHINKEN.MODAL || {};
SHINKEN.NAVIGATOR = SHINKEN.NAVIGATOR || {};
SHINKEN.PAGE      = SHINKEN.PAGE || {};
SHINKEN.TOOLS            = SHINKEN.TOOLS || {};
SHINKEN.TOOLS.ARRAY      = SHINKEN.TOOLS.ARRAY || {};
SHINKEN.TOOLS.ENCRYPTION = SHINKEN.TOOLS.ENCRYPTION || {};
SHINKEN.OBJECT           = SHINKEN.OBJECT || {};
SHINKEN.OBJECT.CONST     = SHINKEN.OBJECT.CONST || {};
SHINKEN.ELEMENT          = SHINKEN.ELEMENT || {};
var DOM   = DOM || {};
DOM.CONST = DOM.CONST || {};
SHINKEN.CONST               = {
    KEY_CODE: {
        TAB      : 9,
        ENTER    : 13,
        SHIFT    : 16,
        CTRL     : 17,
        ALT      : 18,
        PAUSE    : 19,
        CAPS_LOCK: 20,
        ESCAPE   : 27,
        SPACE    : 32,
        PAGE_UP  : 33,
        PAGE_DOWN: 34,
        END      : 35,
        HOME     : 36,
        LEFT     : 37,
        UP       : 38,
        RIGHT    : 39,
        DOWN     : 40,
        F        : 60,
        W        : 87,
        F1       : 112
    }
};
SHINKEN.CONST.CONFIGURATION = {
    ELEMENT_UNIQUE_ADDRESS_BEHAVIOUR: {
        DUPLICATED_ACCEPTED: "duplicated_accepted",
        WARNING_DISPLAYED  : "warning_displayed",
        ERROR_DISPLAYED    : "error_displayed",
        SAVE_FORBIDDEN     : "save_forbidden"
    }
};
SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, '<span class="shinken-tag-label">' + label + '</span>' );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
var COMMUNICATION                        = {};
COMMUNICATION.MESSAGE                    = {};
COMMUNICATION.QUERY                      = {};
COMMUNICATION.MESSAGE.SUCCESS            = 'success';
COMMUNICATION.MESSAGE.ERROR              = 'error';
COMMUNICATION.MESSAGE.WARNING            = 'warning';
COMMUNICATION.CODE                       = {};
COMMUNICATION.CODE.SUCCESS               = 200;
COMMUNICATION.CODE.WARNING               = 202;
COMMUNICATION.CODE.RESET_CONTENT         = 205;
COMMUNICATION.CODE.ERROR                 = 400;
COMMUNICATION.CODE.UNAUTHORIZED          = 401;
COMMUNICATION.CODE.FORBIDDEN             = 403;
COMMUNICATION.CODE.NOT_FOUND             = 404;
COMMUNICATION.CODE.INTERNAL_SERVER_ERROR = 500;
COMMUNICATION.RETURN_CODE                = {
    ELEMENT_UNKNOWN: "element-unknown"
};
COMMUNICATION.QUERY.GET = {
    SEPARATOR      : {
        GET_BEGINNER: '?',
        GET_ADD     : '&',
        PARAM_SETTER: '=',
        SLASH       : '/'
    },
    SOURCE         : {
        LIST                 : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ORDER            : {
            URL    : "/api/sources/setorder",
            OPTIONS: {
                TIMESTAMP: "?ts=",
                ORDER    : "&order="
            }
        },
        REFRESH              : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ENABLED          : {
            URL    : "/api/sources/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        SET_DISCOVERY_ENABLED: {
            URL    : "/api/sources/conf/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                CONF_ID    : "&conf_id=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        FORCE_IMPORT         : {
            URL    : "/api/sources/forceimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        CLEAN_IMPORT         : {
            URL    : "/api/sources/cleanimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        REFRESH_UNIQUE       : {
            URL    : "/api/sources/unique_source/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        ANALYZER             : {
            LAUNCH_BATCH      : "/api/analyzers/launch_analyze_batch",
            STOP_ANALYSE_BATCH: "/api/analyzers/stop_analyze_batch",
            GET_RESULTS       : "/api/analyzers/get_analyze_jobs_result"
        },
        REDIRECT_DETAIL      : {
            URL    : "/sources/",
            OPTIONS: {
                TAB_DETAIL         : "tab=tab-detail-last-run",
                TAB_SUMMARY_OLD_RUN: "tab=tab-summary-old-run",
                FILTER_STATUS      : "filter=status:"
            }
        }
    },
    OVERRIDE       : {
        BASE: '/elements/service_overrides/'
    },
    MASS_CHANGE    : {
        BASE        : "/elements/massive_change/",
        PROGRESS_BAR: "/elements/massive_change_progress/"
    },
    USER_MANAGER   : {
        USER_PREFERENCES: "/user_preferences/"
    },
    USER           : {
        GET_USER_PREFERENCES: "/user/prefs"
    },
    SERVICE_WEATHER: {
        WEATHER_SPACE       : 'service-weather',
        GET_WEATHER         : '/api/V1/get/',
        GET_EDITABLE_WEATHER: '/api/V1/get-editable/',
        PREVIEW_WEATHER     : '/api/V1/preview/',
        SAVE_WEATHER        : '/api/V1/save/',
        SAVE_MANY_WEATHER   : '/api/V1/update-many'
    },
    NOTIFICATION_OF_CHANGE: {
        GET_INFORMATION_FOR_WEATHER_EXTERNAL_LINKS: "/get_information_for_weather_external_links"
    }
};
COMMUNICATION.PAGE_TYPE = {
    LIST_ALL_ELEMENT : "list-all-element",
    LIST_WORKING_AREA: "list-working-area"
};
SHINKEN.TOOLS.STRING             = (function ( self ) {
    "use strict";
    self.CONST = {
        REGEX                   : {
            HTML_TAG        : /<(?:.|\n)*?>/gm,
            ESCAPE_CHARACTER: /\x1b/g
        },
        WHITE_SPACE             : ' ',
        NON_BREAK_SPACE         : '\u00a0',
        INVISIBLE_CHAR          : '\u200b',
        COMMA                   : ',',
        CHAR_CODE_BACK_TO_LINE  : 10,
        CHAR_CODE_INVISIBLE_CHAR: 8203
    };
    
    self.capitalize                              = function ( str ) {
        if ( !str ) {
            return "";
        }
        return str.charAt( 0 ).toUpperCase() + str.substring( 1 ).toLowerCase();
    };
    self.toUpperCase                             = function ( str ) {
        return str.toUpperCase();
    };
    self.isUpperCase                             = function ( str ) {
        if ( !str ) {
            return false;
        }
        return str === self.toUpperCase( str );
    };
    self.extractBetween                          = function ( string, start_tag, end_tag ) {
        if ( !string ) {
            return string;
        }
        var _start = string.indexOf( start_tag );
        if ( _start === -1 ) {
            return string;
        }
        _start   = _start + start_tag.length;
        var _end = string.indexOf( end_tag, _start );
        if ( _end === -1 ) {
            return string;
        }
        return string.substring( _start, _end );
    };
    self.replaceAll                              = function ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    };
    self.replaceWithRegex                        = function ( text_to_change, regex, change_with ) {
        return text_to_change.replace( regex, change_with );
    };
    self.extractStringIfBeginningBy              = function ( str, search ) {
        var _to_return = false;
        if ( str.startsWith( search ) ) {
            _to_return = str.substr( search.length, str.length );
        }
        return _to_return;
    };
    self.splitMultiselectValueWithNoPlus         = function ( str ) {
        var _to_return = SHINKEN.TOOLS.STRING.replaceAll( str, PROPERTY.CONST.STATE_VALUE_PLUS.ON + ",", "" );
        _to_return     = SHINKEN.TOOLS.STRING.replaceAll( _to_return, PROPERTY.CONST.STATE_VALUE_PLUS.ON, "" );
        return _to_return ? _to_return.split( ',' ) : [];
    };
    self.contains                                = function ( string, to_find ) {
        if ( !string || !to_find ) {
            return false;
        }
        return string.indexOf( to_find ) !== -1;
    };
    self.containsAny                             = function ( string, to_find_any_of ) {
        for ( var _i = 0; _i < to_find_any_of.length; _i++ ) {
            if ( to_find_any_of[ _i ] && self.contains( string, to_find_any_of[ _i ] ) ) {
                return true;
            }
        }
        return false;
    };
    self.containsCharCode                        = function ( string, char_code ) {
        if ( !string ) {
            return false;
        }
        var _codes = this.getCharCodes( string );
        return SHINKEN.TOOLS.ARRAY.contains( _codes, char_code );
    };
    self.containsIgnoreCase                      = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        
        var _string_to_lower_case  = string.toLowerCase();
        var _to_find_to_lower_case = to_find.toLowerCase();
        return self.contains( _string_to_lower_case, _to_find_to_lower_case );
    };
    self.cleanMultipleSpaces                     = function ( string ) {
        string = self.trim( string );
        return self.replaceWithRegex( string, /\s\s+/g, self.CONST.WHITE_SPACE );
    };
    self.removeXss                               = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        string = string || "";
        string = string.replace( /&/g, "" );
        string = string.replace( /</g, "" );
        string = string.replace( />/g, "" );
        string = string.replace( /"/g, "" );
        string = string.replace( /'/g, "" );
        string = string.replace( /\//g, "" );
        return string;
    };
    self.cleanXss                                = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        string = string || "";
        string = string.replace( /&/g, "&amp;" );
        string = string.replace( /</g, "&lt;" );
        string = string.replace( />/g, "&gt;" );
        string = string.replace( /"/g, "&quot;" );
        string = string.replace( /'/g, "&#x27;" );
        string = string.replace( /\//g, "&#x2F;" );
        return string;
    };
    self.cleanXssForTooltip                      = function ( string ) {
        var to_return = this.cleanXss( "" + string );
        to_return     = to_return.replace( /&/g, "___" );
        return to_return;
    };
    self.cleanXssForTooltipWithUserData          = function ( string ) {
        var to_return  = DOM.Service.createElement( "div", {}, this.unescape_xss( string ) );
        var user_datas = to_return.querySelectorAll( ".shinken-data-user,.shinken-bad-data-user" );
        for ( var i = 0, _size_i = user_datas.length; i < _size_i; i++ ) {
            self.cleanXssForTooltipWithUserData_internal( user_datas[ i ] );
        }
        return self.replaceAll( to_return.innerHTML, '"', "'" );
    };
    self.cleanXssForTooltipWithUserData_internal = function ( dom_element ) {
        var _spans = dom_element.querySelector( "span.shinken-data-user" );
        if ( _spans ) {
            for ( var i = 0, _size_i = _spans.length; i < _size_i; i++ ) {
                self.cleanXssForTooltipWithUserData_internal( _spans[ i ] );
            }
        }
        else {
            dom_element.innerHTML = self.cleanXssForTooltip( dom_element.innerHTML );
        }
    };
    self.cleanJavaScript             = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        var index_open  = string.indexOf( "<script>" );
        var index_close = string.indexOf( "</script>" );
        if ( index_open === -1 || index_close === -1 || index_close < index_open ) {
            return string;
        }
        index_close = index_close + "</script>".length;
        return self.cleanJavaScript( string.substring( 0, index_open ) + string.substring( index_close, string.length ) );
    };
    self.uncleanBeforecleanXss       = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        var _string = self.unescape_xss( string + "" );
        return self.cleanXss( _string );
    };
    self.unescape_xss                = function ( string ) {
        if ( typeof string !== 'string' ) {
            return string;
        }
        string = string || "";
        string = string.replace( /&amp;/g, '&' );
        string = string.replace( /&lt;/g, '<' );
        string = string.replace( /&gt;/g, '>' );
        string = string.replace( /&quot;/g, '"' );
        string = string.replace( /&#x27;/g, "'" );
        string = string.replace( /&#39;/g, "'" );
        string = string.replace( /&#x2F;/g, "/" );
        return string;
    };
    self.escapeBackslash             = function ( string ) {
        return SHINKEN.TOOLS.STRING.replaceAll( string, "\\", "___SHINKEN_BACKSLASH___" );
    };
    self.getRandomInt                = function ( max ) {
        return Math.floor( Math.random() * Math.floor( max ) );
    };
    self.trim                        = function ( string ) {
        return string.trim();
    };
    self.trimExtented                = function ( string ) {
        var _to_return = string.trim();
        if ( _to_return === string ) {
            return string;
        }
        return self.trimExtented( _to_return );
    };
    self.format                      = function () {
        var s = arguments[ 0 ];
        for ( var i = 0; i < arguments.length - 1; i++ ) {
            var reg = new RegExp( "\\{" + i + "\\}", "gm" );
            s       = s.replace( reg, arguments[ i + 1 ] );
        }
        return s;
    };
    self.getNumberOccurence          = function ( string, to_find ) {
        if ( to_find.length <= 0 ) {
            return (string.length + 1);
        }
        
        var n    = 0;
        var pos  = 0;
        var step = to_find.length;
        
        while ( true ) {
            pos = string.indexOf( to_find, pos );
            if ( pos >= 0 ) {
                ++n;
                pos += step;
            }
            else {
                break;
            }
        }
        return n;
    };
    self.startsWith                  = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        return string.substr( 0, to_find.length ) === to_find;
    };
    self.endsWith                    = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        var _start_index = string.length - to_find.length;
        return string.substr( _start_index ) === to_find;
    };
    self.hashCode                    = function ( string ) {
        return string.split( "" ).reduce( function ( a, b ) {
            a = ((a << 5) - a) + b.charCodeAt( 0 );
            return a & a;
        }, 0 );
    };
    self.buildS4                     = function () {
        return Math.floor( (1 + Math.random()) * 0x10000 )
                   .toString( 16 )
                   .substring( 1 );
    };
    self.buildUUID                   = function () {
        return self.buildS4() + self.buildS4() + '-' + self.buildS4() + '-' + self.buildS4() + '-' +
               self.buildS4() + '-' + self.buildS4() + self.buildS4() + self.buildS4();
    };
    self.getCharCodes                = function ( string ) {
        var _size      = string.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = string.charCodeAt( i );
        }
        return _to_return;
    };
    self.b64Encode                   = function ( str ) {
        return btoa( encodeURIComponent( str ).replace( /%([0-9A-F]{2})/g, function ( match, p1 ) {
            return String.fromCharCode( parseInt( p1, 16 ) );
        } ) );
    };
    self.b64Decode                   = function ( str ) {
        return decodeURIComponent( Array.prototype.map.call( atob( str ), function ( c ) {
            return '%' + ('00' + c.charCodeAt( 0 ).toString( 16 )).slice( -2 );
        } ).join( '' ) );
    };
    self.urlEncode                   = function ( str ) {
        return encodeURIComponent( str );
    };
    self.urlEncodeForEscapeNavigator = function ( str ) {
        var to_return = encodeURIComponent( str );
        to_return     = self.replaceAll( to_return, '%', '__' );
        to_return     = self.replaceAll( to_return, '!', '__21' );
        to_return     = self.replaceAll( to_return, '(', '__28' );
        to_return     = self.replaceAll( to_return, ')', '__29' );
        to_return     = self.replaceAll( to_return, '*', '__2A' );
        to_return     = self.replaceAll( to_return, '~', '__7E' );
        return to_return;
    };
    self.urlDecode                   = function ( str ) {
        return decodeURIComponent( str );
    };
    self.isEmpty                     = function ( string ) {
        if ( !string ) {
            return true;
        }
        var s = string.replace( /\s/g, '' );
        return s.length === 0;
    };
    self.isEmptyHtml                 = function ( string ) {
        if ( !string ) {
            return true;
        }
        var dom = DOM.Service.createElement( 'div', '', string );
        return self.isEmpty( dom.innerText );
    };
    self.indexesOf                   = function ( string, to_find ) {
        var _to_return = [];
        
        var _length         = string.length;
        var _length_to_find = to_find.length;
        
        var _current;
        for ( var i = 0; i <= _length - _length_to_find; i++ ) {
            _current = string.substring( i, i + _length_to_find );
            if ( _current === to_find ) {
                _to_return.push( i );
            }
        }
        return _to_return;
    };
    self.indexesOfNotBetween         = function ( string, to_find, to_ignore ) {
        var _to_return = self.indexesOf( string, to_find );
        return self.splicesindexesOfNotBetween( _to_return, to_ignore );
    };
    self.splicesindexesOfNotBetween  = function ( indexes, to_ignore ) {
        var _to_return = indexes;
        var _current_index;
        for ( var i = _to_return.length - 1; i >= 0; i-- ) {
            _current_index = _to_return[ i ];
            for ( var j = 0, _size_j = to_ignore.length; j < _size_j; j = j + 2 ) {
                if ( _current_index > to_ignore[ j ] && _current_index < to_ignore[ j + 1 ] ) {
                    _to_return.splice( i, 1 );
                    break;
                }
            }
        }
        return _to_return;
    };
    self.extraTextNotBetween         = function ( text, indexes_to_ignore ) {
        var _to_return = [];
        if ( !Array.isArray( indexes_to_ignore ) || !indexes_to_ignore.length ) {
            return _to_return;
        }
        var _split = self.splitWithIndexes( text, indexes_to_ignore, 1 );
        var _keep  = true;
        for ( var i = 0, _size_i = _split.length; i < _size_i; i++ ) {
            if ( _keep ) {
                _to_return.push( _split[ i ] );
            }
            _keep = !_keep;
        }
        return _to_return;
    };
    self.isInteger                   = function ( string ) {
        var pattern = /^\d+$/;
        return pattern.test( string );
    };
    self.splitWithIndexes            = function ( string, indexes, size_split_label ) {
        var _to_return = [];
        if ( !size_split_label ) {
            size_split_label = 1;
        }
        var _size_index = indexes.length;
        if ( !_size_index ) {
            _to_return[ 0 ] = string;
            return _to_return;
        }
        
        for ( var i = 0; i <= _size_index; i++ ) {
            if ( i === 0 ) {
                _to_return[ i ] = string.substring( 0, indexes[ i ] );
            }
            else if ( i === _size_index ) {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label );
            }
            else {
                _to_return[ i ] = string.substring( indexes[ i - 1 ] + size_split_label, indexes[ i ] );
            }
        }
        
        return _to_return;
        
    };
    self.prefix_by_zero              = function ( str, max ) {
        str = str.toString();
        return str.length < max ? self.prefix_by_zero( "0" + str, max ) : str;
    };
    self.getSubStringUntil           = function ( string, start, end ) {
        var _size = string.length;
        return string.substr( start, _size - end );
    };
    self.getAllIndexOf               = function ( string, to_find, to_return, start_index ) {
        if ( !to_return ) {
            to_return   = [];
            start_index = 0;
        }
        var _index = string.substr( start_index ).indexOf( to_find );
        if ( _index !== -1 ) {
            to_return.push( _index + start_index );
            return self.getAllIndexOf( string, to_find, to_return, _index + to_find.length + start_index );
        }
        return to_return;
    };
    self.escapeRegExp                = function ( string ) {
        return string.replace( /[.*+?^${}()|[\]\\]/g, '\\$&' );
    };
    self.isMatchingStarRegexTab      = function ( to_test, tab_to_test ) {
        for ( var i = 0, _size_i = tab_to_test.length; i < _size_i; i++ ) {
            if ( self.isMatchingStarRegex( to_test, tab_to_test[ i ].trim() ) ) {
                return true;
            }
        }
        return false;
    };
    self.isMatchingStarRegex         = function ( to_test, regex_star ) {
        var _contains_star = self.getAllIndexOf( regex_star, "*" );
        if ( !_contains_star.length ) {
            return to_test.trim() === regex_star.trim();
        }
        var _replaced = SHINKEN.TOOLS.STRING.replaceAll( regex_star, "**", "*" );
        if ( regex_star !== _replaced ) {
            return self.isMatchingStarRegex( to_test, _replaced );
        }
        regex_star         = self.escapeRegExp( regex_star );
        var _current       = new RegExp( SHINKEN.TOOLS.STRING.replaceAll( SHINKEN.TOOLS.STRING.trim( regex_star ), "\\*", ".*" ) );
        var _current_match = to_test.match( _current );
        if ( _current_match && _current_match[ 0 ] === to_test ) {
            return true;
        }
        return false;
    };
    self.toBool                      = function ( value ) {
        if ( value !== "false" && value !== "true" ) {
            return null;
        }
        return value === "true";
    };
    self.splitShinken                = function ( string, separator ) {
        var _to_return = string.split( separator );
        for ( var i = 0, _size_i = _to_return.length; i < _size_i; i++ ) {
            _to_return[ i ] = _to_return[ i ].trim();
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.STRING || {} );
SHINKEN.TOOLS.STRING.PARENTHESIS = (function ( self ) {
    "use strict";
    self.isValid          = function ( indexes_opening, indexes_closing ) {
        var _size_open  = indexes_opening.length;
        var _size_close = indexes_closing.length;
        if ( _size_open !== _size_close ) {
            return _( "validator.parenthesis.not_same_number" );
        }
        for ( var i = 0; i < _size_open; i++ ) {
            if ( indexes_opening[ i ] > indexes_closing[ i ] ) {
                return _( "validator.parenthesis.not_good_order" );
            }
        }
    };
    self.getActiveIndexes = function ( indexes_opening, indexes_closing ) {
        var _to_return = [];
        var _size      = indexes_opening.length;
        var _concat    = [];
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_opening[ i ], is_open: true } );
        }
        for ( var i = 0; i < _size; i++ ) {
            _concat.push( { index: indexes_closing[ i ], is_open: false } );
        }
        _concat = SHINKEN.TOOLS.ARRAY.sortArray( _concat, "index" );
        if ( !_concat.length ) {
            return _to_return;
        }
        _to_return.push( _concat[ 0 ].index );
        var _current;
        var _search_close = 1;
        for ( var i = 1, _size_i = _concat.length; i < _size_i; i++ ) {
            _current = _concat[ i ];
            if ( _search_close ) {
                if ( _current.is_open ) {
                    _search_close++;
                }
                else {
                    _search_close--;
                    if ( !_search_close ) {
                        _to_return.push( _current.index );
                    }
                }
            }
            else {
                _to_return.push( _current.index );
                _search_close++;
            }
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.STRING.PARENTHESIS || {} );
SHINKEN.TOOLS.STRING.JSON        = (function ( self ) {
    "use strict";
    self.isFormatJsonInvalid    = function ( json_to_test ) {
        try {
            JSON.parse( json_to_test );
        }
        catch ( json_error ) {
            return json_error;
        }
        return false;
    };
    self.getFormattedLineNumber = function ( dict ) {
        return SHINKEN.TOOLS.STRING.getNumberOccurence( JSON.stringify( dict, null, 2 ), "\n" );
    };
    self.hasJsonCharacters      = function ( text ) {
        return SHINKEN.TOOLS.STRING.containsAny( text, ['{', '}', ',', ':', '[', ']', '"'] );
    };
    return self;
})( SHINKEN.TOOLS.STRING.JSON || {} );
SHINKEN.TOOLS.STRING_FILTER      = (function ( self ) {
    self.containsIgnoreCase = function ( string, to_find ) {
        if ( !string ) {
            return false;
        }
        var _split = to_find.split( "|" );
        for ( var i = 0, _size_i = _split.length; i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( string, _split[ i ] ) ) {
                return true;
            }
        }
        return false;
    };
    return self;
})( SHINKEN.TOOLS.STRING_FILTER || {} );
SHINKEN.TOOLS.MD5 = (function ( self ) {
    "use strict";
    self.MD5 = function ( d ) {
        var result = M( V( Y( X( d ), 8 * d.length ) ) );
        return result.toLowerCase();
    };
    
    function M ( d ) {
        for ( var _, m = "0123456789ABCDEF", f = "", r = 0; r < d.length; r++ ) {
            _ = d.charCodeAt( r ), f += m.charAt( _ >>> 4 & 15 ) + m.charAt( 15 & _ );
        }
        return f;
    }
    
    function X ( d ) {
        for ( var _ = Array( d.length >> 2 ), m = 0; m < _.length; m++ ) {
            _[ m ] = 0;
        }
        for ( m = 0; m < 8 * d.length; m += 8 ) {
            _[ m >> 5 ] |= (255 & d.charCodeAt( m / 8 )) << m % 32;
        }
        return _;
    }
    
    function V ( d ) {
        for ( var _ = "", m = 0; m < 32 * d.length; m += 8 ) {
            _ += String.fromCharCode( d[ m >> 5 ] >>> m % 32 & 255 );
        }
        return _;
    }
    
    function Y ( d, _ ) {
        d[ _ >> 5 ] |= 128 << _ % 32, d[ 14 + (_ + 64 >>> 9 << 4) ] = _;
        for ( var m = 1732584193, f = -271733879, r = -1732584194, i = 271733878, n = 0; n < d.length; n += 16 ) {
            var h = m,
                t = f,
                g = r,
                e = i;
            f = md5_ii( f = md5_ii( f = md5_ii( f = md5_ii( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_hh( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_gg( f = md5_ff( f = md5_ff( f = md5_ff( f = md5_ff( f, r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 0 ], 7, -680876936 ), f, r, d[ n + 1 ], 12, -389564586 ), m, f, d[ n + 2 ], 17, 606105819 ), i, m, d[ n + 3 ], 22, -1044525330 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 4 ], 7, -176418897 ), f, r, d[ n + 5 ], 12, 1200080426 ), m, f, d[ n + 6 ], 17, -1473231341 ), i, m, d[ n + 7 ], 22, -45705983 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 8 ], 7, 1770035416 ), f, r, d[ n + 9 ], 12, -1958414417 ), m, f, d[ n + 10 ], 17, -42063 ), i, m, d[ n + 11 ], 22, -1990404162 ), r = md5_ff( r, i = md5_ff( i, m = md5_ff( m, f, r, i, d[ n + 12 ], 7, 1804603682 ), f, r, d[ n + 13 ], 12, -40341101 ), m, f, d[ n + 14 ], 17, -1502002290 ), i, m, d[ n + 15 ], 22, 1236535329 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 1 ], 5, -165796510 ), f, r, d[ n + 6 ], 9, -1069501632 ), m, f, d[ n + 11 ], 14, 643717713 ), i, m, d[ n + 0 ], 20, -373897302 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 5 ], 5, -701558691 ), f, r, d[ n + 10 ], 9, 38016083 ), m, f, d[ n + 15 ], 14, -660478335 ), i, m, d[ n + 4 ], 20, -405537848 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 9 ], 5, 568446438 ), f, r, d[ n + 14 ], 9, -1019803690 ), m, f, d[ n + 3 ], 14, -187363961 ), i, m, d[ n + 8 ], 20, 1163531501 ), r = md5_gg( r, i = md5_gg( i, m = md5_gg( m, f, r, i, d[ n + 13 ], 5, -1444681467 ), f, r, d[ n + 2 ], 9, -51403784 ), m, f, d[ n + 7 ], 14, 1735328473 ), i, m, d[ n + 12 ], 20, -1926607734 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 5 ], 4, -378558 ), f, r, d[ n + 8 ], 11, -2022574463 ), m, f, d[ n + 11 ], 16, 1839030562 ), i, m, d[ n + 14 ], 23, -35309556 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 1 ], 4, -1530992060 ), f, r, d[ n + 4 ], 11, 1272893353 ), m, f, d[ n + 7 ], 16, -155497632 ), i, m, d[ n + 10 ], 23, -1094730640 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 13 ], 4, 681279174 ), f, r, d[ n + 0 ], 11, -358537222 ), m, f, d[ n + 3 ], 16, -722521979 ), i, m, d[ n + 6 ], 23, 76029189 ), r = md5_hh( r, i = md5_hh( i, m = md5_hh( m, f, r, i, d[ n + 9 ], 4, -640364487 ), f, r, d[ n + 12 ], 11, -421815835 ), m, f, d[ n + 15 ], 16, 530742520 ), i, m, d[ n + 2 ], 23, -995338651 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 0 ], 6, -198630844 ), f, r, d[ n + 7 ], 10, 1126891415 ), m, f, d[ n + 14 ], 15, -1416354905 ), i, m, d[ n + 5 ], 21, -57434055 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 12 ], 6, 1700485571 ), f, r, d[ n + 3 ], 10, -1894986606 ), m, f, d[ n + 10 ], 15, -1051523 ), i, m, d[ n + 1 ], 21, -2054922799 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 8 ], 6, 1873313359 ), f, r, d[ n + 15 ], 10, -30611744 ), m, f, d[ n + 6 ], 15, -1560198380 ), i, m, d[ n + 13 ], 21, 1309151649 ), r = md5_ii( r, i = md5_ii( i, m = md5_ii( m, f, r, i, d[ n + 4 ], 6, -145523070 ), f, r, d[ n + 11 ], 10, -1120210379 ), m, f, d[ n + 2 ], 15, 718787259 ), i, m, d[ n + 9 ], 21, -343485551 ), m = safe_add( m, h ), f = safe_add( f, t ), r = safe_add( r, g ), i = safe_add( i, e );
        }
        return Array( m, f, r, i );
    }
    
    function md5_cmn ( d, _, m, f, r, i ) {
        return safe_add( bit_rol( safe_add( safe_add( _, d ), safe_add( f, i ) ), r ), m );
    }
    
    function md5_ff ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & m | ~_ & f, d, _, r, i, n );
    }
    
    function md5_gg ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ & f | m & ~f, d, _, r, i, n );
    }
    
    function md5_hh ( d, _, m, f, r, i, n ) {
        return md5_cmn( _ ^ m ^ f, d, _, r, i, n );
    }
    
    function md5_ii ( d, _, m, f, r, i, n ) {
        return md5_cmn( m ^ (_ | ~f), d, _, r, i, n );
    }
    
    function safe_add ( d, _ ) {
        var m = (65535 & d) + (65535 & _);
        return (d >> 16) + (_ >> 16) + (m >> 16) << 16 | 65535 & m;
    }
    
    function bit_rol ( d, _ ) {
        return d << _ | d >>> 32 - _;
    }
    
    return self;
})( SHINKEN.TOOLS.MD5 || {} );
String.prototype.startsWith = String.prototype.startsWith || function ( pattern ) {
    return this.indexOf( pattern ) === 0;
};
String.prototype.endsWith   = String.prototype.endsWith || function ( pattern ) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf( pattern ) === d;
};
SHINKEN.TOOLS.CLASS = (function ( self ) {
    "use strict";
    self.CONST        = {
        COMPONENT: {
            SELECT: "component-select"
        }
    };
    self.addPrototype = function ( object_to_add_in, object_to_add_from ) {
        var _current;
        var _keys = Object.keys( object_to_add_from.prototype );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = _keys[ i ];
            if ( !object_to_add_in.prototype[ _current ] ) {
                object_to_add_in.prototype[ _current ] = object_to_add_from.prototype[ _current ];
            }
        }
    };
    return self;
})( SHINKEN.TOOLS.CLASS || {} );
SHINKEN.TOOLS.Link = (function ( self ) {
    "use strict";
    self.parse_to_link = function ( item_type, item_name, item_uuid ) {
        return "<a href='/elements/" + item_type + "/" + item_uuid + "' class='shinken-link'>" + item_name + "</a>";
    };
    return self;
})( SHINKEN.TOOLS.Link || {} );
var COMPONENT = COMPONENT || {};
COMPONENT.CONST = {
    NOT_FOUND               : -1,
    BTN_STATE               : {
        DISABLED           : -1,
        OFF                : 0,
        ON                 : 1,
        DISCREET           : 2,
        INIT               : 3,
        ENABLED_WITH_ERRORS: 4
    },
    BTN_STATUS              : {
        NONE   : 0,
        WARNING: 1,
        ERROR  : 2
    },
    AUTO_SELECT_ACTION_TYPE : {
        MOVE_DOWN: 'move_down',
        MOVE_UP  : 'move_up',
        MOUSE    : 'mouse',
        KEY_INPUT: 'key_input'
    },
    BTN_NAME                : {
        SAVE: 'save',
        DEFAULT: 'default'
    },
    SELECT                  : {
        SELECTOR                  : 'shinken-select-selector',
        SELECTOR_TEXT             : 'shinken-selector-label',
        SELECTOR_LIST             : 'shinken-list-select',
        SELECTOR_LIST_OPTION      : 'shinken-option',
        OPTION_ACTIVE_STAGING     : 'shinken-active-option-staging',
        OPTION_ACTIVE_WORKING_AREA: 'shinken-active-option-working-area',
        DATA_STATE_SELECTOR       : 'stateSelector',
        TIMER_DELAY_BUILD_HTML    : 100
    },
    BTN_INHERITANCE         : {
        TIMER_DELAY_BUILD_HTML: 100
    },
    INHERITANCE_ARBORESCENCE: {},
    TAG                     : {
        STATE: {
            WORKING         : 'working_area',
            NEW             : 'new',
            STAGGING        : 'stagging',
            DISABLED        : 'disabled',
            UNKNOWN         : 'unknown',
            HIDDEN          : 'hidden',
            INHERITED       : 'inherited',
            FORCE_TO_NULL   : 'force-to-null',
            OVERRIDE_NEW    : 'override-new',
            OVERRIDE_UNKNOWN: 'override-unknown',
            IT_SELF         : 'shinken-itself'
        }
    },
    FILTER                  : {
        TYPES_VALIDATION: {
            HAS_FOCUS: "has_focus",
            NOT_FOCUS: "not_focus"
        }
    },
    INPUT                   : {
        TYPES: {
            SINGLE_SELECT: 'single-select'
        }
    },
    LIST_SELECT             : {
        CLASS: {
            NO_RESULT   : 'shinken-no-result',
            FILTERING_ON: 'shinken-filtering-on'
        }
    },
    LIST_SELECT_ELEMENT     : {
        CLASS: {
            HIDDEN: 'shinken-hidden'
        }
    },
    STATUS                  : {
        NONE   : 'shinken-no-status',
        INFO   : 'shinken-info',
        ERROR  : 'shinken-error-status',
        WARNING: 'shinken-warning-status',
        BEWARE : 'shinken-beware-status',
        VALID  : 'shinken-valid-status'
    },
    TYPE                    : {
        HIDDEN                    : "hidden",
        SINGLE_SELECT             : "select-single",
        STRING_INPUT              : "input_string",
        INPUT_STRING_ARRAY        : "input_string_array",
        STRING_INPUT_WITH_DROPDOWN: "input-string-with-dropdown",
        MULTI_SELECT              : "select-multi",
        LABEL                     : "label",
        SINGLE_SELECT_WITH_INPUT  : "select-single-with-input",
        MULTI_SELECT_BASIC        : "select-multi-basic"
    },
    TAG_INFORMATION         : {
        STATUS: {
            NONE                 : 'none',
            ALL_DISABLED         : 'all-disabled',
            ALL_DISABLED_OVERRIDE: 'all-disabled-override',
            NOT_VALID_FOR_ARBITER: 'not-arbiter-valid',
            USER_GROUP_COHERENCY : 'user-group-coherency',
            IN_SHELL             : 'in_shell',
            CHECK_DUPLICATE      : 'check_duplicate',
            LOCKED               : 'locked'
        }
    },
    PAGINATION_NAVIGATION       : {
        FIRST                      : 'first',
        LAST                       : 'last',
        PREVIOUS                   : 'previous',
        NEXT                       : 'next',
    }
};
var SHINKEN_LIST = SHINKEN_LIST || {};
SHINKEN_LIST.CONST = SHINKEN_LIST.CONST || {
    MASS_ACTION     : {
        NAME          : 'mass-action',
        WORK_AREA_NAME: 'mass-action-work-area'
    },
    STRUCTURE_FORMAT: {
        GENERIC        : "GENERIC",
        WITH_HEADER_FIX: "WITH_HEADER_FIX"
    },
    TYPE            : {
        CHECK_IN_HOST       : "CHECK_IN_HOST",
        MASS_CHANGE_SUM_FULL: "MASS_CHANGE_SUM_FULL",
        DATA_PROP           : "DATA_PROP"
    },
    FILTER          : {
        HAS_CHILDREN: "**SHINKEN_HAS_CHILDREN**",
        ALL         : "___ALL___",
        EMPTY       : "___EMPTY___",
        NOT_EMPTY   : "___NOT_EMPTY___",
        VISUAL      : "VISUAL",
        AUDIO       : "AUDIO",
        STATUS      : {
            DISABLED    : -1,
            OFF         : 0,
            ON          : 1,
            HAS_CHILDREN: 2
        },
        TYPE        : {
            HIDDEN                    : "hidden",
            SINGLE_SELECT             : "select-single",
            STRING_INPUT              : "input_string",
            INPUT_STRING_ARRAY        : "input_string_array",
            STRING_INPUT_WITH_DROPDOWN: "input-string-with-dropdown"
        }
    },
    SELECTION       : {
        STATUS: {
            DISABLED: -1,
            OFF     : 0,
            ON      : 1
        }
    },
    ACTION          : {
        REMOVE      : "remove",
        CHANGE_OWNER: "change_owner"
    }
};
"use strict";
var MANAGER = MANAGER || {};
MANAGER.CONST = MANAGER.CONST || {
    STATE          : {
        WORK_FLOW: {
            STAGING     : "save-direct-in-staging",
            WORKING_AREA: "save-in-working-area"
        }
    },
    DRAG_N_DROP    : {
        CLASS: {
            HOVER    : "hover",
            DRAGGABLE: "draggable",
            DRAGGING : "shinken-dragging-on"
        }
    },
    HELP           : {
        STATUS: {
            INACTIVE: 1,
            ACTIVE  : 2,
            FORCED  : 3
        }
    },
    AFTER_ACTION   : {
        CLICK_ON_SERVICE_OVERRIDE       : 0,
        UPDATE_VIEW_ON_WINDOW_PROPERTIES: 1
    },
    CONTROLLER     : {
        SHINKEN_ELEMENT        : "shinken-element",
        LIST_ALL               : "list-all",
        MASS_CHANGE            : "mass-change",
        SOURCES                : "sources",
        MAIN                   : "main",
        WEATHER                : "weather",
        COMMON_UI              : "common_ui",
        UI_VISUALISATION       : "ui_visualisation",
        UI_NAV_BAR             : "nav_bar",
        SHINKEN_VIEW           : "shinken_view",
        UI_LOGIN               : "ui_login",
        UI_VIEW_WEATHER_MANAGER: "ui_view_weather_manager",
        UI_PANELS              : "ui_panels",
        APPLY                  : "apply",
        UI_PANELS_VIEW         : "ui_panels_view"
    },
    USER_PREFS_KEYS: {
        SHOW_SOURCE_CONFIGURATION_TAB_OLD_RUN: "show_source_configuration_tab_old_run"
    },
    RESIZE         : {
        TYPE: {
            NONE        : "NONE",
            LEFT        : "LEFT",
            RIGHT       : "RIGHT",
            BOTTOM      : "BOTTOM",
            TOP         : "TOP",
            BOTTOM_RIGHT: "BOTTOM_RIGHT",
            BOTTOM_LEFT : "BOTTOM_LEFT",
            TOP_RIGHT   : "TOP_RIGHT",
            TOP_LEFT    : "TOP_LEFT"
        }
    }
};
SHINKEN.CARTO = {};
SHINKEN.CARTO.CONST = {
    NAME    : "name",
    URL     : "url",
    IS_VALID: "is_valid"
};
SHINKEN.OBJECT.ShinkenObject           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObject';
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    setShinkenDebug : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            if ( _components[ i ] ) {
                _components[ i ].setShinkenDebug( to_set );
            }
        }
    },
    isShinkenDebugOn: function () {
        return this.is_shinken_debug;
    },
    getChildrenObject       : function () {
        return [];
    },
    getChildrenObjectDict   : function () {
        return {};
    },
    initMessages            : function ( to_set ) {
        this.messages = new OBJECT.Messages();
    },
    setMessages             : function ( to_set ) {
        this.initMessages();
        if ( !to_set ) {
            return;
        }
        var _keys = Object.keys( to_set );
        
        var _current_key;
        var _current_status;
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current_key    = _keys[ i ];
            _current_status = OBJECT.MessageService.parseBackendStatus( _current_key );
            for ( var j = 0, _size_j = to_set[ _current_key ].length; j < _size_j; j++ ) {
                this.messages.addMessage( _current_status, to_set[ _current_key ][ j ] );
            }
        }
        this.doActionAfterAddMessages();
    },
    addMessages             : function ( shinken_messages ) {
        this.messages.addMessages( shinken_messages.getAllMessages() );
    },
    addMessage              : function ( status, text ) {
        if ( !this.messages ) {
            this.messages = new OBJECT.Messages();
        }
        this.messages.addMessage( status, text );
    },
    doActionAfterAddMessages: function () {
    },
    getMessages             : function () {
        return this.messages;
    },
    getAllObjectWithMessages: function () {
        var to_return = [];
        if ( this.messages && this.messages.hasStatus() ) {
            to_return.push( this );
        }
        var _components = this.getChildrenObject();
        for ( var j = 0, _size_j = _components.length; j < _size_j; j++ ) {
            if ( _components[ j ] ) {
                to_return = SHINKEN.TOOLS.ARRAY.concat( to_return, _components[ j ].getAllObjectWithMessages() );
            }
        }
        return to_return;
    },
    setNeedValidation: function ( to_set ) {
        this.need_validation = to_set;
        var _components      = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
    getObjectClassName: function () {
        return this.__class_name__;
    },
    isObjectClassName : function ( to_test ) {
        return to_test === this.__class_name__;
    }
};
SHINKEN.OBJECT.ShinkenObjectHtml           = function () {
};
SHINKEN.OBJECT.ShinkenObjectHtml.prototype = {
    setDomElement             : function ( to_set ) {
        this.dom_element = to_set;
        this.doActionAfterSetDomElement();
    },
    doActionAfterSetDomElement: function () {
    },
    getDomElement             : function () {
        return this.dom_element;
    },
    addDomElement             : function ( to_add ) {
        DOM.Service.addElementTo( to_add, this.getDomElement() );
    },
    changeContentDomElement   : function ( new_content ) {
        DOM.Service.empty( this.getDomElement() );
        this.addDomElement( new_content );
    },
    askUpdateHtml             : function () {
        var self = this;
        if ( self.timeout_ask_compute_html ) {
            clearTimeout( self.timeout_ask_compute_html );
        }
        self.timeout_ask_compute_html = setTimeout( function () {
            self.updateHtml();
            self.timeout_ask_compute_html = null;
        }, 200 );
    },
    updateHtml                : function () {
    },
    computeHtml               : function () {
        this.computeHtmlExtra();
    },
    computeHtmlExtra          : function () {
    },
    getObjectType             : function () {
        return "";
    },
    onClick     : function ( event ) {
    },
    hidePopup   : function ( event ) {
    },
    askHidePopup: function ( dom_element ) {
        if ( dom_element === this.getDomElement() ) {
            return false;
        }
        this.hidePopup( dom_element );
        return true;
    },
    askAddClass : function ( to_add, time_out ) {
        if ( !time_out ) {
            return;
        }
        if ( !this.getDomElement() ) {
            var self = this;
            setTimeout( function () {
                self.askAddClass( to_add, time_out - 100 );
            }, 100 );
            return;
        }
        
        DOM.Service.askAddClass( this.getDomElement(), to_add, time_out );
    },
    setTooltipHtml            : function ( html ) {
        var _dom = this.getDomElement();
        if ( !_dom ){
            return;
        }
        _dom.setAttribute( 'shi-tip-html', html );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectHtml, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.ShinkenObjectContainer           = function () {
};
SHINKEN.OBJECT.ShinkenObjectContainer.prototype = {
    initContents: function () {
        this.contents = [];
        this.mapping  = {};
    },
    getSize         : function () {
        return this.contents.length;
    },
    getContents     : function () {
        return this.contents;
    },
    getContent      : function ( index ) {
        return this.contents[ index ];
    },
    getContentByUUID: function ( uuid ) {
        var _index = this.mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.contents[ _index ];
    },
    getMappingIndex: function ( uuid ) {
        return this.mapping[ uuid ];
    },
    add             : function ( to_add ) {
        if ( this.mapping[ to_add.getUUID() ] !== undefined ) {
            this.contents[ this.mapping[ to_add.getUUID() ] ] = to_add;
        }
        else {
            this.mapping[ to_add.getUUID() ] = this.contents.push( to_add ) - 1;
        }
    },
    removeContent   : function ( uuid_to_remove ) {
        var _to_remove = this.getContentByUUID( uuid_to_remove );
        _to_remove.remove();
        SHINKEN.TOOLS.ARRAY.removeElementByIndex( this.contents, this.mapping[ uuid_to_remove ] );
        this.computeMapping();
    },
    computeMapping  : function () {
        this.mapping = {};
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.mapping[ this.contents[ i ].getUUID() ] = i;
        }
    },
    getObjectsType  : function () {
        return "";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainer, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.ShinkenObjectContainerHtml           = function () {
};
SHINKEN.OBJECT.ShinkenObjectContainerHtml.prototype = {
    onClick     : function ( event ) {
        this.askHidePopup( this.getDomByEvent( event ) );
    },
    askHidePopup: function ( dom_element ) {
        if ( dom_element === this.getDomElement() ) {
            return false;
        }
        this.hidePopup();
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].askHidePopup( dom_element );
        }
        return true;
    },
    getContentByEvent: function ( event ) {
        if ( !event ) {
            return null;
        }
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
        if ( !_parent_dom_element ) {
            return null;
        }
        var _type = _parent_dom_element.dataset.objectType;
        if ( _type === this.getObjectsType() ) {
            return this.getContentByUUID( _parent_dom_element.dataset.name );
        }
    },
    getDomByEvent    : function ( event ) {
        if ( !event ) {
            return null;
        }
        return DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainerHtml, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainerHtml, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.InterfaceHtml           = function () {
};
SHINKEN.OBJECT.InterfaceHtml.prototype = {
    addClass: function ( toAdd ) {
        if ( !this.class ) {
            this.class = toAdd;
        }
        else {
            this.class = this.class + " " + toAdd;
        }
    }
};
SHINKEN.SERVER = {};
SHINKEN.SERVER.CONST = {
    NAME              : "name",
    LIST_SHINKEN_CARTO: "shinken_cartos"
};
"use strict";
SHINKEN.ELEMENT.USER = {
    PARAM : {
        ACL: {
            KEY             : "acl",
            MAKE_DOWNTIME   : "make_downtime",
            MAKE_ACKNOWLEDGE: "make_acknowledge",
            FORCE_RESULT    : "force_result_check",
            RECHECK_NOW     : "force_retry_check",
            SLA_VIEW        : "sla_view",
            HISTORIC        : {
                SHOW             : "in_tab_history",
                SHOW_BOTH        : "history_sla",
                SHOW_HISTORY_ONLY: "history",
                SHOW_SLA_ONLY    : "sla",
                HISTORIC_RANGE   : "show_history_range",
                SLA_RANGE        : "show_sla_range"
            },
            SHARE           : {
                4: "read",
                3: "create",
                2: "organize",
                1: "update",
                0: "delete"
            },
            SHARE_PRIVATE   : "share_private",
            SHARE_GROUP     : "share_group",
            SHARE_EVERYBODY : "share_everybody"
        },
        GROUPS                                                       : "groups",
        PREFS                                                        : {
            NAME                   : "prefs",
            DEFAULT_SCREEN         : {
                NAME: "defaultScreen",
                TYPE: "type",
                UUID: "uuid"
            },
            DEFAULT_LIST           : {
                NAME         : "defaultLists",
                ROOT_PROBLEMS: "rootProblems",
                ALL          : "all"
            },
            PANELS                 : {
                NAME: "panels"
            },
            DETAIL_GRAPH_HOST_WIDTH: "detail_graph_host_width",
            DEFAULT_EVENTS_TUB     : {
                NAME: "defaultEventsTub",
                ALL : "all_events"
            },
            HISTORIC_TAB           : {
                NAME               : "historicTab",
                SHOW_OUTPUTS       : "show_historic_outputs",
                COLLAPSE_ALL_OUTPUT: "collapse_all_historic_outputs",
                SIZE_SLA_COLUMNN   : "size_sla_column"
            },
            WEATHER_SERVICE        : {
                NAME                  : "weather_service",
                FORM_POSITION         : "form_position",
                ACTION_BUTTON_POSITION: "action_button_position"
            },
            NOTIFICATION_OF_CHANGE : {
                NAME: "notifications_of_change"
            },
            OTHERS                 : {
                NAME: "others"
            }
        },
        SETTINGS                                                     : {
            FIELD            : "settings",
            DEFAULT_URL      : "default_url",
            NAME_DEFAULT_VIEW: "name_default_view"
        },
        STATUS                                                       : "status",
        UI                                                           : "ui",
        USER_NAME                                                    : "userName",
        UUID                                                         : "uuid",
        EXISTS                                                       : "user_exists",
        VERSION                                                      : "version",
        VERSION_FULL                                                 : "version_full",
        SHINKEN_VERSION                                              : "shinken_version",
        SHINKEN_VERSION_TOOLTIP                                      : "shinken_version_tooltip",
        SHINKEN_VERSION_SHORT                                        : "shinken_short_version",
        CSS_CHECK_VERSION                                            : "check_plugin_styles_css_hash",
        TIME_ZONE_BACKEND                                            : "time_zone_backend",
        EVENT_CONTAINER_DAY_KEEP_DATA                                : "event_container_day_keep_data",
        EVENTS_EXPORT_MAX_RETRY                                      : "events_export_max_retry",
        EVENTS_CSV_EXPORT_LIMIT                                      : "events_csv_export_limit",
        DEFAULT_NOTIFICATIONS_SETTINGS                               : "default_notifications_settings",
        DEFAULT_NOTIFICATIONS_SETTINGS__USERS__SOUND__VOLUME_PERCENT : "default_notifications_settings__users__sound__volume_percent",
        DEFAULT_NOTIFICATIONS_SETTINGS__USERS__VISUAL__BLINK__ENABLED: "default_notifications_settings__users__visual__blink__enabled",
        TILES_FORMAT                                                 : {
            KEY        : "tiles_format",
            KEY_BACKEND: "tiles_background",
            TYPE       : {
                DEFAULT   : 0,
                CONTEXT_UP: 1,
                STATUS_UP : 2
            },
            BACKEND_KEY: {
                DEFAULT   : "context_and_status",
                CONTEXT_UP: "context",
                STATUS_UP : "status"
            }
            
        },
        ARCHITECTURE                                                 : "architecture_map",
        IS_ADMIN                                                     : "is_admin",
        CAN_EDIT_WEATHER_SERVICE                                     : "can_edit_weather_service",
        HAS_EVENT_TUB_MODULE                                         : "has_event_tub_module",
        HAS_WEATHER_SERVICE_MODULE                                   : "has_weather_service_module",
        HAS_ARCHITECTURE_MODULE                                      : "has_architecture_module",
        KNOWN_MODULES                                                : "known_modules"
    },
    SAVING: {
        TIMER_DELAY: 2000
    },
    STATUS: {
        OFF: 0,
        ON : 1
    }
};
SHINKEN.SCREEN       = {
    TYPE      : {
        HIVE             : "hive",
        LIST             : "list",
        LIST_ROOT_PROBLEM: "list-root-problem",
        EVENT            : "event",
        SERVICE_WEATHER  : "service_weather",
        VIEW360          : "360",
        IMPACTS          : "impacts",
        REPORTING        : "reporting",
        REPORTING_WEB    : "reporting-web",
        DASHBOARD        : "dashboard",
        IFRAME           : "iframe"
    },
    FOUND_ITEM: {
        INIT         : 0,
        FOUND        : 1,
        NOT_FOUND    : 2,
        FOUND_RECHECK: 3,
        DELETED      : 4
    }
};
SHINKEN.OBJECT.VIEW = {
    PARAM: {
        NAME          : "name",
        NB_ERRORS     : "nb_errors",
        NB_WARNINGS   : "nb_warnings",
        UUID          : "uuid",
        TYPE          : "type",
        NOTIFICATIONS : "notifications",
        USERS         : {
            _KEY          : "users",
            OWNER         : "owner_user",
            PREVIOUS_OWNER: "previous_owner_user",
            CREATOR       : "creator_user"
        },
        EXTERNAL_LINKS: "external_links"
    },
    USER : {
        NAME: "user_name",
        UUID: "user_uuid"
    }
};
var OBJECT = OBJECT || {};
OBJECT.CONST = OBJECT.CONST || {
    TEMPLATE             : {
        FIELD : {
            UUID             : 'uuid',
            _ID              : '_id',
            _SYNC_KEYS       : '_SYNC_KEYS',
            NAME             : 'name',
            IS_TEMPLATE      : 'is_template',
            IS_TOP_LEVEL     : 'is_top_level',
            ITEM_TYPE        : 'item_type',
            LAST_MODIFICATION: 'last_modification',
            REGISTER         : 'register',
            SOURCES          : 'sources',
            USE              : 'use',
            ENABLED          : 'enabled',
            UNCONFIGURED     : 'unconfigured',
            STATUS           : 'template-status',
            IS_NEW           : 'is_new',
            LOOP             : 'loop',
            WORK_AREA_INFO   : 'work_area_info',
            METADATA         : '@metadata'
        },
        STATUS: {
            USEFUL  : 'useful-template',
            USELESS : 'useless-template',
            BADLOOP : 'badloop-template',
            NEW     : 'new-template',
            UNKNOWN : 'unknown-template',
            DISABLED: 'disabled-template'
        }
    },
    ELEMENT_LIST         : {
        TYPE: {
            USER       : 'user',
            INHERITANCE: 'inheritance',
            SEARCHING  : 'searching'
        },
        FILTER_OPTION: {
            IGNORED  : 'ignored_during_filter'
        }
    },
    MACRO                : {
        TYPE: {
            HOST_LOCAL        : '_HOST',
            SERVICE_LOCAL     : '_SERVICE',
            HOST_PROPERTY     : 'macros_host_properties',
            SERVICE_PROPERTY  : 'macros_service_properties',
            GLOBAL            : 'macros_global',
            GLOBAL_INTERPRETED: 'macros_global_interpreted',
            UNKNOWN           : 'unknown',
            VALUE_DFE         : 'VALUE_DFE',
            DFE_KEY           : '$KEY$'
        }
    },
    CHECK_IN_HOST        : {
        STATUS: {
            NONE                           : "",
            DFE_STRUCTURE                  : 'dfe-structure',
            ALREADY_EXISTING_NAME          : "already_existing_name",
            ALREADY_EXISTING_NAME_IN_SAME  : "already_existing_name_in_same_host",
            ALREADY_EXISTING_NAME_DUPLICATE: "already_existing_name_duplicate"
        }
    },
    ELEMENT              : {
        PHASE           : {
            INIT         : 0,
            VIEWING      : 1,
            EDITING      : 2,
            ON_SAVING    : 3,
            SAVING_FAILED: 4,
            RELOADING    : 5
        },
        FIELD           : {
            ID                    : '_id',
            UUID                  : 'uuid',
            SOURCES               : 'sources',
            IMPORT_DATE           : 'import_date',
            SERVICE_OVERRIDES     : 'service_overrides',
            SERVICE_EXCLUDES_BY_ID: 'service_excludes_by_id',
            WORK_AREA_INFO        : 'work_area_info',
            SYNC_KEYS             : '_SYNC_KEYS ',
            LAST_MODIFICATION     : 'last_modification',
            ENABLED               : 'enabled',
            STATUS                : 'status',
            ITEM_TYPE             : 'item_type'
        },
        FIELD_UI        : {
            UUID                                        : 'uuid',
            ITEM_NAME                                   : 'item_name',
            ITEM_UUID                                   : 'item_uuid',
            STATUS                                      : 'status',
            CONTEXT                                     : 'context',
            CONTEXT_OR_STATUS                           : 'context_or_status',
            SLA                                         : {
                __KEY__           : "sla",
                VALUE             : 'value',
                QUALITY           : 'quality',
                TENDENCY          : 'tendency',
                WARNING_THRESHOLD : 'warning_threshold',
                CRITICAL_THRESHOLD: 'critical_threshold'
            },
            ITEM_TYPE                                   : 'item_type',
            IS_EXISTING                                 : 'exists',
            IS_NOT_AUTHORIZED_FOR_USER                  : 'is_not_authorized_for_user',
            ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW: 'element_visibility_on_not_authenticated_view',
            NAME                                        : 'name',
            VISUALISATION_NAME                          : 'visualisation_name'
        },
        MODULATION      : {
            TYPE: {
                NONE_FORCED: -1,
                NONE       : 0,
                PLUS       : 1,
                EXISTING   : 2,
                ERROR      : 3
            }
        },
        TYPE            : {
            CLUSTERS                  : 'clusters',
            CLUSTER_TPLS              : 'clustertpls',
            DISCOVERY                 : 'discovery',
            HOSTS                     : 'hosts',
            HOST_GROUPS               : 'hostgroups',
            HOST_TPLS                 : 'hosttpls',
            CHECK_ON_HOST             : 'serviceshosts',
            CHECK_ON_TPL_HOST         : 'serviceshosttpls',
            CHECK_ON_CLUSTER          : 'servicesclusters',
            CHECK_ON_TPL_CLUSTER      : 'servicesclustertpls',
            CHECK_TPLS                : 'servicetpls',
            COMMANDS                  : 'commands',
            CONTACT_GROUPS            : 'contactgroups',
            CONTACT_TPLS              : 'contacttpls',
            CONTACTS                  : 'contacts',
            ESCALATIONS               : 'escalations',
            MODULATION_BUSINESS_IMPACT: 'businessimpactmodulations',
            MODULATION_DATA           : 'macromodulations',
            MODULATION_RESULT         : 'resultmodulations',
            NOTIFICATION_WAYS         : 'notificationways',
            TIME_PERIODS              : 'timeperiods',
            SYNCHRONIZER_LINKER       : 'sync'
        },
        WORK_AREA_STATUS: {
            PROPOSED : 'PROPOSED',
            WORKING  : 'WORKING',
            REJECTED : 'REJECTED',
            VALIDATED: 'VALIDATED'
            
        },
        STATUS          : {
            NEW: 'new'
        },
        SLA             : {
            TENDENCY: {
                STAGNANT  : 'stagnant',
                DECRASING : 'decreasing',
                INCREASING: 'increasing'
            },
            STATUS  : {
                OK      : 0,
                WARNING : 1,
                CRITICAL: 2,
                UNKNOWN : 3
            }
        },
        SAVE            : {
            TYPE: {
                LINK: "LINK"
            }
        }
    },
    OVERRIDE_STATUS      : {
        OFF     : "0",
        ON      : "1",
        DISABLED: "2"
    },
    MODE_OVERRIDE_EXCLUDE: {
        NORMAL  : "0",
        OVERRIDE: "1",
        EXCLUDE : "2"
    },
    EXCLUDE_STATUS       : {
        OFF    : "0",
        BY_ID  : "1",
        BY_NAME: "2"
    }
};
var SHINKEN                     = SHINKEN || {};
SHINKEN.OBJECT                  = SHINKEN.OBJECT || {};
SHINKEN.OBJECT.CONST            = SHINKEN.OBJECT.CONST || {};
SHINKEN.OBJECT.CONST.VALIDATION = SHINKEN.OBJECT.CONST.VALIDATION || {
    FIELD: {
        MESSAGES                : 'validation_messages',
        ERRORS                  : 'errors',
        CRITICAL                : 'critical',
        WARNINGS                : 'warnings',
        _KEY_MESSAGE            : 'message',
        PATH_VALIDATION_FOR_JSON: 'path_validation_for_json'
    }
};
"use strict";
var PROPERTY = PROPERTY || {} ;
PROPERTY.CONST = PROPERTY.CONST || {} ;
PROPERTY.CONST.COMMON = {
    TYPES                   : {
        BOOLEAN                   : "boolean",
        DATA                      : "data",
        MULTI_SELECT              : "select-multi",
        MULTI_SELECT_BASIC        : "select-multi-basic",
        RANGE                     : "range",
        RANGE_BUSINESS_IMPACT     : "range_business_impact",
        RANGE_WITH_INPUT          : "range_with_input",
        SINGLE_SELECT             : "select-single",
        SINGLE_SELECT_WITH_INPUT  : "select-single-with-input",
        STRING_INPUT              : "input_string",
        STRING_INPUT_WITH_DROPDOWN: "input-string-with-dropdown",
        CHECKBOX_SINGLE           : "checkbox-single",
        CHECKBOX_MULTI            : "checkbox-multi",
        RADIO_LIST                : "radio-list",
        RADIO_LIST_CUMULATIVE     : "radio-list-cumulative",
        MULTI_LINE_OBJECT         : "multi-line-object",
        PROPERTY_INFORMATION      : "property-information"
    },
    VALUE : {
        DEFAULT : "default"
    }
};
SHINKEN.TOOLS.DICT = (function ( self ) {
    "use strict";
    self.CONST   = {};
    self.assign  = function ( dest, src ) {
        var _keys = Object.keys( src );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key         = _keys[ i ];
            dest[ _current_key ] = src[ _current_key ];
        }
        return dest;
    };
    self.assigns = function ( dest, srcs ) {
        return srcs.reduce( self.assign, dest );
    };
    self.clone  = function (to_clone) {
        var json = JSON.stringify(to_clone);
        var to_return = JSON.parse(json);
        
        return to_return;
    }
    return self;
})( SHINKEN.TOOLS.DICT || {} );
var WINDOW = {};
WINDOW.CONST = {
    ELEMENT   : {
        GENERIC      : "generic",
        DATAS        : "datas",
        CHECKS       : "checks",
        MONITORING   : "monitoring",
        NOTIFICATIONS: "notifications",
        ADVANCED     : "advanced",
        USER_RIGHTS  : "user-rights",
        AUTHORIZATION: "authorization",
        PROPOSED     : "proposed",
        CHANGES      : "changes"
    },
    CLASS     : {
        WINDOW_GROUP: "shinken-window-group",
        WINDOW_TAB  : "shinken-window-element"
    },
    ID        : {
        WINDOW_TAB: "id-shinken-window-",
        TAB_PANE  : "tab-pane-"
    },
    GROUP     : {
        MASS_CHANGE: "mass-change"
    }
};
var CONTROLLER = CONTROLLER || {};
CONTROLLER.CONST = CONTROLLER.CONST || {
    MASS_CHANGE: {
        NAME      : "mass-change",
        TYPE      : {
            PROPERTIES     : 'properties',
            DATAS          : 'datas',
            LOCAL_DATAS    : 'local_datas',
            DFE_DATAS      : 'dfe_datas',
            CHECKS         : 'checks',
            CHECKS_OVERRIDE: 'overrides',
            CHECKS_EXCLUDE : 'excludes'
        },
        GROUP_DATA: {
            ALL  : "___ALL___",
            LOCAL: "___LocalData___"
        }
    },
    PHASE      : {
        ACTIVE: 1
    }
};
var SHINKEN_TOOLTIP = (function ( self ) {
    "use strict";
    
    self.PLACEMENT                       = {};
    self.PLACEMENT.LEFT                  = 'left';
    self.PLACEMENT.RIGHT                 = 'right';
    self.PLACEMENT.TOP                   = 'top';
    self.PLACEMENT.TOP_LEFT              = 'top-left';
    self.PLACEMENT.TOP_RIGHT             = 'top-right';
    self.PLACEMENT.BOTTOM                = 'bottom';
    self.PLACEMENT.BOTTOM_LEFT           = 'bottom-left';
    self.PLACEMENT.BOTTOM_RIGHT          = 'bottom-right';
    self.PLACEMENT.LEFT_BOTTOM           = 'left-bottom';
    self.TYPE                            = {};
    self.TYPE.ERROR_MESSAGE_WEATHER      = 'shinken-error-message-weather';
    self.TYPE.WARNING_MESSAGE_WEATHER    = 'shinken-warning-message-weather';
    self.TYPE.ERROR                      = 'shinken-error';
    self.TYPE.ERROR_BORDER               = 'shinken-error-border';
    self.TYPE.WARNING                    = 'shinken-warning';
    self.TYPE.WARNING_BORDER             = 'shinken-warning-border';
    self.TYPE.BEWARE_BORDER              = 'shinken-beware-border';
    self.TYPE.NORMAL_DISCREET            = 'shinken-normal-discreet';
    self.TYPE.NORMAL_ON_BLACK            = 'shinken-normal-on-black';
    self.TYPE.NORMAL_ON_BLACK_ALIGN_LEFT = 'shinken-normal-on-black-align-left';
    self.TYPE.OFF_WHITE_ON_BLACK         = 'shinken-off-white-on-black';
    self.TYPE.DISPLAY_TEXT               = 'shinken-normal-text';
    self.CONDITION                       = {};
    self.CONDITION.SHIFT                 = 'shinken-shift';
    self.CONDITION.CTRL_SHIFT            = 'shinken-ctrl-shift';
    self.CONDITION.ELLIPSIS              = 'shinken-ellipsis';
    self.STYLE                           = {};
    self.STYLE.PADDING_HORIZONTAL        = 8;
    self.STYLE.PADDING_VERTICAL          = 4;
    self.STYLE.MIN_WIDTH_TEXT            = 60;
    self.STYLE.HEIGHT_TEXT_LINE          = 20;
    self.STYLE.ARROW_SIZE                = 5;
    self.DEFAULT                         = {};
    self.DEFAULT.TIMER_POP               = 100;
    self.MAX_TRY_IN_SCREEN               = 10;
    
    self.CONDITION_TYPE = {
        HAS_CLASS    : "has_class",
        HAS_NOT_CLASS: "has_not_class"
    };
    
    var __container;
    var __text_container;
    var __type;
    var __condition;
    var __arrow;
    var __placement;
    var __placement_origin;
    var __is_forced_placement;
    var __try;
    var __try_container;
    var __innerText;
    var __innerHtml;
    var __width;
    var __height;
    var __timer_pop;
    var __parent_container;
    var __classes_added;
    var __timeout_pop;
    var __interval_update_value;
    var __interval_update_object;
    var __interval_pop_out;
    var __interval_auto_scroll;
    var __timeout_auto_scroll;
    var __pos_top;
    var __pos_left;
    
    self.showTooltipIf = function ( element, condition_type, condition_value ) {
        if ( !condition_value || !condition_type ) {
            return;
        }
        switch ( condition_type ) {
            case self.CONDITION_TYPE.HAS_CLASS:
                if ( !element.classList.contains( condition_value ) ) {
                    return false;
                }
                break;
            case  self.CONDITION_TYPE.HAS_NOT_CLASS :
                var _splitted = condition_value.split( ',' );
                for ( var i = 0, _size = _splitted.length; i < _size; i++ ) {
                    if ( element.classList.contains( _splitted[ i ] ) ) {
                        return false;
                    }
                }
                break;
            default:
                console.log( "Type not manage" );
                return false;
        }
        _showTooltip( element );
    };
    
    self.showTooltipChildren = function ( element, css_selector ) {
        self.showTooltip( element.querySelector( css_selector ) );
    };
    self.showTooltip         = function ( element ) {
        if ( !element ) {
            return;
        }
        if ( !__container ) {
            initDomElement();
        }
        if ( !__container ) {
            return;
        }
        var _condition_type = element.getAttribute( "shi-tip-condition-type" );
        if ( _condition_type ) {
            return self.showTooltipIf( element, _condition_type, element.getAttribute( "shi-tip-condition-value" ) );
        }
        _showTooltip( element );
    };
    
    self.hideTooltip   = function () {
        if ( __container ) {
            setActive( false );
            clean();
        }
    };
    self.updateTooltip = function ( element ) {
        if ( !DOM.Service.isVisible( __container ) ) {
            self.showTooltip( element );
            return;
        }
        _showTooltip( element, true );
    };
    
    function _showTooltip ( element, skip_clean ) {
        __try           = 0;
        __try_container = 0;
        if ( !skip_clean ) {
            clean();
        }
        setTimerPop( element );
        updateTooltipValue( element );
        setType( element );
        setIntervalUpdate( element );
        setCondition( element );
        setParentContainer( element );
        if ( __innerText || __innerHtml ) {
            setClass( element );
            getSize();
            setPlacement( element );
            setPosition( element, skip_clean );
            setArrow();
            launchIntervalPopOut( element );
            launchIntervalAutoScroll( element );
        }
        if ( __interval_update_value ) {
            __interval_update_object = setInterval( function () {
                updateTooltipValue( element );
            }, __interval_update_value );
        }
    }
    
    function updateTooltipValue ( element ) {
        setText( element );
        setHTML( element );
    }
    
    function setPlacement ( element ) {
        cleanArrow();
        __is_forced_placement = element.getAttribute( 'shi-tip-is-forced-position' );
        __placement           = __is_forced_placement || element.getAttribute( 'shi-tip-placement' ) || self.PLACEMENT.TOP;
        __placement_origin    = __placement;
    }
    
    function setActive ( _bool ) {
        if ( _bool ) {
            __container.classList.add( 'shinken-tooltip-active' );
        }
        else {
            __container.classList.remove( 'shinken-tooltip-active' );
        }
    }
    
    function setArrow () {
        __container.classList.add( __placement );
    }
    
    function cleanIntervalPopOut () {
        if ( __interval_pop_out ) {
            clearInterval( __interval_pop_out );
            __interval_pop_out = null;
        }
    }
    
    function cleanIntervalAutoScroll () {
        __text_container.scrollTop = -400;
        if ( __timeout_auto_scroll ) {
            clearTimeout( __timeout_auto_scroll );
            __timeout_auto_scroll = null;
        }
        if ( __interval_auto_scroll ) {
            clearInterval( __interval_auto_scroll );
            __interval_auto_scroll = null;
        }
    }
    
    function launchIntervalPopOut ( element ) {
        cleanIntervalPopOut();
        var _data_timer                = new Date().getTime();
        var _selector                  = "[data-shinken-tooltip='" + _data_timer + "']";
        element.dataset.shinkenTooltip = _data_timer;
        __interval_pop_out             = setInterval( function () {
            var _elements = document.querySelector( _selector );
            if ( !_elements ) {
                setActive( false );
                cleanIntervalPopOut();
            }
        }, 1000 );
    }
    
    function launchIntervalAutoScroll ( element ) {
        cleanIntervalAutoScroll();
        if ( __text_container.clientHeight < __text_container.scrollHeight ) {
            __timeout_auto_scroll = setTimeout( function () {
                __interval_auto_scroll = setInterval( function () {
                    __text_container.scrollTop = __text_container.scrollTop + 1;
                    if ( __text_container.scrollTop >= __text_container.scrollHeight - __text_container.clientHeight ) {
                        __timeout_auto_scroll = setTimeout( function () {
                            launchIntervalAutoScroll();
                        }, 2000 );
                    }
                }, 100 );
            }, 2000 );
            
        }
        
    }
    
    function cleanArrow () {
        __container.classList.remove( __placement );
    }
    
    function cleanRectWidth ( _rect ) {
        var _to_return = Math.min( _rect.width, 600 );
        if ( __classes_added ) {
            if ( __classes_added.indexOf( '300' ) !== -1 ) { //BGL  A REFAIRE PROPRE
                _to_return = Math.min( _to_return, 300 );
            }
        }
        return _to_return;
    }
    
    function setPosition ( element_to_bind, skip_clean ) {
        if ( !skip_clean ) {
            clean();
        }
        var _rect       = element_to_bind.getBoundingClientRect();
        var _width_rect = cleanRectWidth( _rect );
        if ( !_width_rect ) {
            return; //ELEMENT NOT DISPLAYED
        }
        computePosition( _rect, _width_rect );
        
        if ( isInScreen() ) {
            if ( __try > self.MAX_TRY_IN_SCREEN ) {
                computePosition( _rect, _width_rect );
            }
            __timeout_pop = setTimeout( function () {
                __container.style.top  = __pos_top + 'px';
                __container.style.left = __pos_left + 'px';
            }, __timer_pop );
        }
        else {
            setPosition( element_to_bind, skip_clean );
        }
    }
    
    function computePosition ( _rect, _width_rect ) {
        switch ( __placement ) {
            case self.PLACEMENT.TOP:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.TOP_LEFT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect + 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.TOP_RIGHT:
                __pos_top  = (_rect.top - __height + self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.LEFT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left - __width);
                break;
            case self.PLACEMENT.RIGHT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left + _width_rect);
                break;
            case self.PLACEMENT.BOTTOM:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.BOTTOM_LEFT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - __width + _width_rect + 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.BOTTOM_RIGHT:
                __pos_top  = (_rect.bottom - self.STYLE.ARROW_SIZE);
                __pos_left = _rect.left - 2 * self.STYLE.ARROW_SIZE;
                break;
            case self.PLACEMENT.LEFT_BOTTOM:
                __pos_top  = _rect.top;
                __pos_left = (_rect.left - __width);
                break;
            default:
                console.warn( "[shi-type]", __placement, "NOT MANAGED" );
        }
    }
    
    function isInScreen () {
        var _to_return       = true;
        var _bounding_parent = __parent_container ? __parent_container.getBoundingClientRect() : false;
        var _left_parent     = _bounding_parent ? _bounding_parent.left : -10;
        var _right_parent    = _bounding_parent ? _bounding_parent.right : window.innerWidth - 10;
        var _top_parent      = _bounding_parent ? _bounding_parent.top : -10;
        var _bottom_parent   = _bounding_parent ? _bounding_parent.bottom : window.innerHeight - 10;
        
        if ( __pos_left < _left_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.LEFT_BOTTOM:
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (__pos_left + __width) > _right_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                case self.PLACEMENT.RIGHT:
                case self.PLACEMENT.LEFT_BOTTOM:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( __pos_top < _top_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.LEFT_BOTTOM:
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (__pos_top + __height) > _bottom_parent ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.LEFT_BOTTOM:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        __try++;
        if ( __is_forced_placement || __try > self.MAX_TRY_IN_SCREEN ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            __placement = __placement_origin;
            _to_return  = true;
        }
        return _to_return;
    }
    
    function createDomElement () {
        var _html             = '<table><tr><td></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-left"></div></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-middle"></div></td><td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-right"></div></td><td></td></tr><tr><td><div class="shi-tip-arrow tooltip-arrow-left" id="tooltip-arrow-left-middle"></div></td><td colspan="3"><div class="shi-tip-text"></div></td><td><div class="shi-tip-arrow tooltip-arrow-right" id="tooltip-arrow-right-middle"></div></td></tr><tr><td></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-left"></div></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-middle"></div></td><td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-right"></div></td><td></td></tr></table>';
        __container           = document.createElement( 'div' );
        __container.id        = 'shi-tip';
        __container.innerHTML = _html;
        document.body.appendChild( __container );
    }
    
    function initDomElement () {
        __container = document.getElementById( 'shi-tip' );
        if ( !__container ) {
            createDomElement();
        }
        
        if ( __container ) {
            __text_container = __container.querySelector( '.shi-tip-text' );
            __arrow          = __container.querySelector( '.shi-tip-arrow' );
        }
    }
    
    function setText ( element ) {
        __innerText = element.getAttribute( 'shi-tip-text' );
        if ( __innerText ) {
            __text_container.innerHTML = __innerText;
        }
    }
    
    function setHTML ( element ) {
        __innerHtml = element.getAttribute( 'shi-tip-html' );
        if ( __innerHtml ) {
            __text_container.innerHTML = replaceAll( __innerHtml, '___', '&' );
        }
    }
    
    function setType ( element ) {
        __type                   = element.getAttribute( 'shi-tip-type' ) || false;
        __container.dataset.type = __type;
    }
    
    function setIntervalUpdate ( element ) {
        __interval_update_value = parseInt( element.getAttribute( 'shi-tip-update-interval' ) ) || false;
    }
    
    function setCondition ( element ) {
        __condition = element.getAttribute( 'shi-tip-condition' ) || false;
        
        __container.dataset.condition = __condition;
    }
    
    function setTimerPop ( element ) {
        __timer_pop = element.getAttribute( 'shi-tip-timer-pop' ) || self.DEFAULT.TIMER_POP;
    }
    
    function setParentContainer ( element ) {
        var _selector_parent_container = element.getAttribute( 'shi-tip-parent-container' );
        if ( _selector_parent_container ) {
            __parent_container = findParentElementWithClass( element, _selector_parent_container, 50 );
        }
        else {
            __parent_container = false;
        }
    }
    
    function setClass ( element ) {
        __classes_added = element.getAttribute( 'shi-tip-class' );
        
        __container.className = __classes_added;
    }
    
    function getSize () {
        setActive( true );
        var _sizes = __container.getBoundingClientRect();
        __width    = _sizes.width;
        __height   = _sizes.height;
    }
    
    function clean () {
        __container.style.top  = '-5000px';
        __container.style.left = '-5000px';
        clearTimeout( __timeout_pop );
        cleanIntervalPopOut();
        cleanIntervalAutoScroll();
        if ( __interval_update_object ) {
            clearInterval( __interval_update_object );
            __interval_update_object = null;
        }
    }
    
    function replaceAll ( string, target, replacement ) {
        return string.split( target ).join( replacement || '' );
    }
    
    function findParentElementWithClass ( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( !element ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    }
    
    return self;
    
})( {} );
var common_ui_en = {
 "common" : {
 "error" : "Error",
 "false" : "False",
 "load_in_progress" : "Loading...",
 "not_valid_format_value" : "Bad format key : <span class='shinken-data-user'>{0}</span>",
 "true" : "True",
 "unknown_key" : "Unknown key : <span class='shinken-data-user'>{0}</span>",
 "unknown_user" : "Unknown user : <span class='shinken-highlight-data-user'>{0}</span>",
 "unknown_value" : "Unknown value : <span class='shinken-highlight-data-user'>{0}</span>",
 "warning" : "Warning"
 },
 "confirmation_popup" : {
 "cancel_button" : "Cancel",
 "validate_button" : "Confirm"
 },
 "date_time" : {
 "None" : "each month",
 "agoMoment" : "ago",
 "april" : "April",
 "august" : "August",
 "day" : "day",
 "days" : "days",
 "december" : "December",
 "enabled" : "Enabled",
 "february" : "February",
 "friday" : "Friday",
 "hour" : "hour",
 "hours" : "hours",
 "inMoment" : "In",
 "january" : "January",
 "july" : "July",
 "june" : "June",
 "label_week_-1" : "last",
 "label_week_-2" : "before last",
 "label_week_-3" : "before before last",
 "label_week_-4" : "before before before last",
 "label_week_-5" : "before before before before last",
 "label_week_1" : "first",
 "label_week_2" : "second",
 "label_week_3" : "third",
 "label_week_4" : "forth",
 "label_week_5" : "fifth",
 "march" : "March",
 "may" : "May",
 "minute" : "minute",
 "minutes" : "minutes",
 "monday" : "Monday",
 "month" : "month",
 "months" : "months",
 "november" : "November",
 "now" : "Now",
 "october" : "October",
 "saturday" : "Saturday",
 "second" : "second",
 "seconds" : "seconds",
 "september" : "September",
 "short_day" : "j",
 "short_days" : "j",
 "short_hour" : "h",
 "short_hours" : "h",
 "short_minute" : "m",
 "short_minutes" : "m",
 "short_month" : "m",
 "short_months" : "m",
 "short_second" : "s",
 "short_seconds" : "s",
 "short_week" : "w",
 "short_weeks" : "w",
 "short_year" : "y",
 "short_years" : "y",
 "sunday" : "Sunday",
 "thursday" : "Thursday",
 "tuesday" : "Tuesday",
 "wednesday" : "Wednesday",
 "week" : "week",
 "weeks" : "weeks",
 "year" : "year",
 "years" : "years"
 },
 "filter" : {
 "error_level" : {
 "CRITICAL" : "CRITICAL",
 "ERROR" : "ERROR",
 "WARNING" : "WARNING",
 "___ALL___" : "--All--"
 },
 "message_placeholder" : "Enter a name"
 },
 "gap_time" : {
 "backendOutSynch" : "Backend local time has gap of more than 30 seconds",
 "backendOutSynchShort" : "Time gap"
 },
 "json_editor" : {
 "invalid_json" : "The JSON structure is invalid, We can only detect the first error <span class='shinken-data-user'>(encountered line {0})</span>",
 "invalid_json_ie" : "The JSON structure is invalid. The nature of the error is not provided by the Internet Explorer browser. <br> You can use another browser (Edge, Firefox or Google Chrome) or an editing tool capable of editing JSON to know the nature of the error.",
 "not_valid_format_value" : "The content of the key <span class='shinken-data-user'>{0}</span> is not in the correct format",
 "unknown_value" : "Unknown key : <span class='shinken-data-user'>{0}</span>"
 },
 "license" : {
 "aTrialVersion" : "a trial version",
 "contactMailSubject" : "About my licence",
 "contactUs" : "Contact us",
 "day" : "day",
 "errors" : {
 "cannotUpdateLicense" : "Impossible to update the license."
 },
 "exceedBy" : "exceed by {0}",
 "expired" : "expired",
 "invalidFormat" : "invalid format",
 "left" : "left",
 "license" : "License",
 "licenseEndingDate" : "License ending the {0}",
 "licenseInvalid" : "INVALID LICENSE",
 "licensePeriod" : "License period",
 "licenseTypePro" : "PRO LICENSE",
 "licenseTypeTrial" : "TRIAL LICENSE",
 "noLicenseKey" : "No license key",
 "nodesAndLimit" : "Hosts: {0} / {1}",
 "onServer" : "on the server",
 "unexpectedError" : "Unexpected Error",
 "youAreUsingSecondTime" : "You are using for the second time",
 "yourLicenseHas" : "Your license has an"
 },
 "loading_frame" : {
 "load_in_progress" : "Loading..."
 },
 "logout" : {
 "errors" : {
 "cannot_logout" : "Impossible to log out."
 }
 },
 "messages" : {
 "invalid_syntax" : "Invalid syntax :",
 "no_message_to_display" : "No problems found in this tab",
 "tag_error" : "Errors",
 "tag_warning" : "Warnings"
 },
 "notification" : {
 "blink_user_warning" : "<span class='shinken-warning'>Note : </span>visual notifications are disabled in your user profile",
 "no_change" : "<span class='shinken-warning'>Note : </span>there have been no changes since the last refresh",
 "sound_navigator_warning" : "<span class='shinken-warning'>Remarque : </span>sound cannot be played until the user interacts with the document first<br>Changing your browser settings to solve this problem",
 "sound_user_warning" : "<span class='shinken-warning'>Note : </span>audio notifications are disabled in your user profile"
 },
 "progress_bar" : {
 "previewing_error_detail_401" : "The preview was not successful because you do not have the minimum rights to modify this page (401 error). Please contact your administrator.",
 "previewing_failed" : "Failed preview",
 "previewing_in_progress" : "Preview in progress...",
 "previewing_succeed" : "Successfully preview",
 "previewing_succeed_with_error" : "Preview finished with errors",
 "previewing_succeed_with_warning" : "Preview finished with warnings",
 "saving_error_detail_401" : "The backup was not successful because you do not have the minimum rights to modify this page (401 error). Please contact your administrator.",
 "saving_error_detail_404" : "The resource was not found (404 error). Please contact your administrator.",
 "saving_failed" : "Failed saved",
 "saving_in_progress" : "Save in progress...",
 "saving_succeed" : "<table class='shinken-table-container-save-back-message'><tr><td><span>Successfully saved</span></td></tr></table>",
 "saving_succeed_with_warning" : "<table class='shinken-table-container-save-back-message'><tr><td><span>Successfully saved with warnings</span></td></tr></table>",
 "toggle_display_message_label" : "<span class='shinken-show-if-hidden'>See</span><span class='shinken-show-if-not-hidden'>Hide</span> details"
 },
 "service_weather" : {
 "add_new_weather_button" : {
 "errors" : {
 "cannot_create_new_service_weather" : "It is not possible to create a new service weather for the moment"
 }
 },
 "generate_at" : {
 "generation_in_progress" : "<span class='shinken-note shinken-between-space-parenthensis'>in progress...</span>"
 },
 "weathers" : {
 "errors" : {
 "cannot_get_weathers" : "Impossible to get the service weathers."
 }
 }
 },
 "shinken_list" : {
 "sort" : {
 "decrease" : "Descending sort",
 "increase" : "Ascending sort",
 "remove" : "Remove sorting"
 }
 },
 "ui_visualisation" : {
 "add_to_favorite_form" : {
 "copy" : " (copy)"
 },
 "default_view_button" : {
 "tooltipDefaultViewBtn" : "Define current view as default view",
 "tooltipIsAlreadyDefaultView" : "This view is already the default view",
 "tooltipIsEditOnDefaultView" : "A view in edit mode cannot be set as default view"
 }
 },
 "users" : {
 "errors" : {
 "cannot_get_user_from_backend" : "Impossible to get the user.",
 "user_doesnt_exist" : "Attention, the user no longer exists"
 }
 },
 "window_group_save" : {
 "action_button" : {
 "apply" : "Apply",
 "cancel" : "Cancel"
 }
 }
};
var common_ui_fr = {
 "common" : {
 "error" : "Erreur",
 "false" : "Faux",
 "load_in_progress" : "Chargement...",
 "not_valid_format_value" : "Clé avec un mauvais format : <span class='shinken-data-user'>{0}</span>",
 "true" : "Vrai",
 "unknown_key" : "Clé inconnue : <span class='shinken-data-user'>{0}</span>",
 "unknown_user" : "Utilisateur inconnu : <span class='shinken-highlight-data-user'>{0}</span>",
 "unknown_value" : "Valeur inconnue : <span class='shinken-highlight-data-user'>{0}</span>",
 "warning" : "Avertissement"
 },
 "confirmation_popup" : {
 "cancel_button" : "Annuler",
 "validate_button" : "Valider"
 },
 "date_time" : {
 "None" : "chaque mois",
 "agoMoment" : "Il y a",
 "april" : "Avril",
 "august" : "Août",
 "day" : "jour",
 "days" : "jours",
 "december" : "Décembre",
 "enabled" : "Activé",
 "february" : "Février",
 "friday" : "Vendredi",
 "hour" : "heure",
 "hours" : "heures",
 "inMoment" : "Dans",
 "january" : "Janvier",
 "july" : "Juillet",
 "june" : "Juin",
 "label_week_-1" : "dernier",
 "label_week_-2" : "avant dernier",
 "label_week_-3" : "avant avant dernier",
 "label_week_-4" : "avant avant avant dernier",
 "label_week_-5" : "avant avant avant avant dernier",
 "label_week_1" : "premier",
 "label_week_2" : "deuxième",
 "label_week_3" : "troisième",
 "label_week_4" : "quatrième",
 "label_week_5" : "cinquième",
 "march" : "Mars",
 "may" : "Mai",
 "minute" : "minute",
 "minutes" : "minutes",
 "monday" : "Lundi",
 "month" : "mois",
 "months" : "mois",
 "november" : "Novembre",
 "now" : "Maintenant",
 "october" : "Octobre",
 "saturday" : "Samedi",
 "second" : "seconde",
 "seconds" : "secondes",
 "september" : "Septembre",
 "short_day" : "j",
 "short_days" : "j",
 "short_hour" : "h",
 "short_hours" : "h",
 "short_minute" : "min",
 "short_minutes" : "min",
 "short_month" : "mois",
 "short_months" : "mois",
 "short_second" : "sec",
 "short_seconds" : "sec",
 "short_week" : "sem",
 "short_weeks" : "sem",
 "short_year" : "an",
 "short_years" : "ans",
 "sunday" : "Dimanche",
 "thursday" : "Jeudi",
 "tuesday" : "Mardi",
 "wednesday" : "Mercredi",
 "week" : "semaine",
 "weeks" : "semaines",
 "year" : "an",
 "years" : "ans"
 },
 "filter" : {
 "error_level" : {
 "CRITICAL" : "CRITIQUE",
 "ERROR" : "ERREUR",
 "WARNING" : "AVERTISSEMENT",
 "___ALL___" : "--Tous--"
 },
 "message_placeholder" : "Saisir un nom"
 },
 "gap_time" : {
 "backendOutSynch" : "L'heure du backend diffère de plus de 30 sec par rapport à votre ordinateur",
 "backendOutSynchShort" : "Ecart de temps"
 },
 "json_editor" : {
 "invalid_json" : "La structure JSON est invalide, nous ne pouvons détecter que la première erreur <span class='shinken-data-user'>(rencontrée ligne {0})</span>",
 "invalid_json_ie" : "La structure JSON est invalide. La nature de l'erreur n'est pas fourni par le navigateur Internet Explorer.<br> Vous pouvez utiliser un autre navigateur (Edge, Firefox ou Google Chrome) ou un outil d'édition capable d'éditer le JSON pour connaitre la nature de l'erreur.",
 "not_valid_format_value" : "Le contenu de la clé <span class='shinken-data-user'>{0}</span> n'est pas au bon format",
 "unknown_value" : "Clé inconnue : <span class='shinken-data-user'>{0}</span>"
 },
 "license" : {
 "aTrialVersion" : "une licence d'essai",
 "contactMailSubject" : "A propos de ma licence",
 "contactUs" : "Contactez-nous",
 "day" : "jour",
 "errors" : {
 "cannotUpdateLicense" : "Impossible de mettre à jour la licence."
 },
 "exceedBy" : "dépassé de {0}",
 "expired" : "expirée",
 "invalidFormat" : "format invalide",
 "left" : "restant(s)",
 "license" : "Licence",
 "licenseEndingDate" : "La licence se termine le {0}",
 "licenseInvalid" : "LICENCE INVALIDE",
 "licensePeriod" : "Durée de la licence",
 "licenseTypePro" : "LICENCE PRO",
 "licenseTypeTrial" : "LICENCE D'ESSAI",
 "noLicenseKey" : "Aucune licence",
 "nodesAndLimit" : "Hôtes: {0} / {1}",
 "onServer" : "sur le serveur",
 "unexpectedError" : "Erreur inattendue",
 "youAreUsingSecondTime" : "Vous utilisez pour la deuxième fois ",
 "yourLicenseHas" : "La licence a un"
 },
 "loading_frame" : {
 "load_in_progress" : "Chargement en cours..."
 },
 "logout" : {
 "errors" : {
 "cannot_logout" : "Impossible de se déconnecter."
 }
 },
 "messages" : {
 "invalid_syntax" : "Syntaxe invalide :",
 "no_message_to_display" : "Aucun problème trouvé dans cet onglet",
 "tag_error" : "Erreurs",
 "tag_warning" : "Avertissements"
 },
 "notification" : {
 "blink_user_warning" : "<span class='shinken-warning'>Remarque : </span>les notifications visuelles sont désactivées dans votre profil utilisateur",
 "no_change" : "<span class='shinken-warning'>Remarque : </span>il n'y a pas eu de changements depuis le dernier rafraichissement",
 "sound_navigator_warning" : "<span class='shinken-warning'>Remarque : </span>le son ne peut pas être joué tant que l’utilisateur n’a pas interagi avec la fenètre<br>Changer les réglages de votre navigateur pour résoudre ce problème",
 "sound_user_warning" : "<span class='shinken-warning'>Remarque : </span>les notifications sonores sont désactivées dans votre profil utilisateur"
 },
 "progress_bar" : {
 "previewing_error_detail_401" : "La prévisualisation n'a pas aboutie, car vous n'avez pas les droits minimums pour modifier cette page (erreur 401). Veuillez contacter votre administrateur.",
 "previewing_failed" : "Prévisualisation échouée",
 "previewing_in_progress" : "Prévisualisation en cours...",
 "previewing_succeed" : "Prévisualisation réussie",
 "previewing_succeed_with_error" : "Prévisualisation finie avec des erreurs",
 "previewing_succeed_with_warning" : "Prévisualisation finie avec des avertissements",
 "saving_error_detail_401" : "La sauvegarde n'a pas abouti, car vous n'avez pas les droits minimums pour modifier cette page (erreur 401). Veuillez contacter votre administrateur.",
 "saving_error_detail_404" : "La ressource n'a pas été trouvée (erreur 404). Veuillez contacter votre administrateur.",
 "saving_failed" : "Enregistrement échoué",
 "saving_in_progress" : "Sauvegarde en cours...",
 "saving_succeed" : "<table class='shinken-table-container-save-back-message'><tr><td><span>Enregistrement réussi</span></td></tr></table>",
 "saving_succeed_with_warning" : "<table class='shinken-table-container-save-back-message'><tr><td><span>Enregistrement réussi avec des avertissements</span></td></tr></table>",
 "toggle_display_message_label" : "<span class='shinken-show-if-hidden'>Voir</span><span class='shinken-show-if-not-hidden'>Cacher</span> le détail"
 },
 "service_weather" : {
 "add_new_weather_button" : {
 "errors" : {
 "cannot_create_new_service_weather" : "Il n'est pas possible de créer une nouvelle météo des services pour le moment"
 }
 },
 "generate_at" : {
 "generation_in_progress" : "<span class='shinken-note shinken-between-space-parenthensis'>en cours...</span>"
 },
 "weathers" : {
 "errors" : {
 "cannot_get_weathers" : "Impossible d'obtenir les météos des services."
 }
 }
 },
 "shinken_list" : {
 "sort" : {
 "decrease" : "Tri décroissant",
 "increase" : "Tri croissant",
 "remove" : "Supprimer le tri"
 }
 },
 "ui_visualisation" : {
 "add_to_favorite_form" : {
 "copy" : " (copie)"
 },
 "default_view_button" : {
 "tooltipDefaultViewBtn" : "Définir la vue courante comme vue par défaut",
 "tooltipIsAlreadyDefaultView" : "Cette vue est déjà la vue par défaut",
 "tooltipIsEditOnDefaultView" : "Une vue en mode édition ne peut pas être définie comme vue par défaut"
 }
 },
 "users" : {
 "errors" : {
 "cannot_get_user_from_backend" : "Impossible d'obtenir l'utilisateur.",
 "user_doesnt_exist" : "Attention, l'utilisateur n'existe plus"
 }
 },
 "window_group_save" : {
 "action_button" : {
 "apply" : "Appliquer",
 "cancel" : "Annuler"
 }
 }
};
SHINKEN.OBJECT.CounterV2_CONST = {
    TYPE: {
        ERRORS   : "errors",
        WARNINGS : "warnings",
        TOTAL    : "total",
        FILTERING: "filtering"
    }
};
SHINKEN.OBJECT.CounterV2           = function ( type ) {
    this.__class_name__ = 'SHINKEN.OBJECT.CounterV2';
    this.init( type );
};
SHINKEN.OBJECT.CounterV2.prototype = {
    init: function ( type ) {
        this._counter_final       = 0;
        this.label                = "";
        this._is_label_before     = false;
        this._show_if_null        = false;
        this._is_string           = false;
        this.type                 = type;
        this._show_to_parent      = true;
        this._data_target_name    = "number";
        this._counter_parent_list = [];
        this._elements_mapping    = {};
        this.uuid                 = SHINKEN.TOOLS.STRING.buildUUID();
        this._targets_dom_element = [];
    },
    getValue                  : function () {
        return this._counter_final;
    },
    hasCounter                : function () {
        return !!this._counter_final;
    },
    setShowIfNull             : function ( to_set ) {
        this._show_if_null = !!to_set;
    },
    reset                     : function () {
        this._elements_mapping = {};
        this._counter_final    = 0;
        this.showForParent( true );
        this.updateTargetsDomElement();
        this._updateHTML();
    },
    showForParent             : function ( show ) {
        this._show_to_parent = !!show;
        this.updateParents();
    },
    updateParents             : function () {
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].update( this.uuid, this._show_to_parent ? this._counter_final : 0 );
        }
    },
    update                    : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this._elements_mapping[ name ];
        }
        else {
            if ( !is_force && this._elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this._elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltipHtml( tooltip );
        }
        
        this._counter_final = this._is_string ? "" : 0;
        this.askFinalUpdate( retry_update_html );
    },
    askFinalUpdate            : function ( retry_update_html ) {
        if ( this.timeout_final_update ) {
            clearTimeout( this.timeout_final_update );
        }
        var self                  = this;
        self.timeout_final_update = setTimeout( function () {
            self.finalUpdate( retry_update_html );
            self.timeout_final_update = null;
        }, 10 );
    },
    finalUpdate               : function ( retry_update_html ) {
        var _keys = Object.keys( this._elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this._counter_final = this._counter_final + this._elements_mapping[ _keys[ i ] ];
        }
        this.updateTargetsDomElement();
        this.updateParents();
        return this._askUpdateHTML( retry_update_html );
    },
    setParent                 : function ( to_add ) {
        if ( !to_add ) {
            return;
        }
        this._counter_parent_list.push( to_add );
        this.updateParents();
    },
    setDataTargetName         : function ( to_set ) {
        this._data_target_name = to_set;
    },
    doActionAfterSetDomElement: function () {
        if ( !this.dom_element_label ) {
            this.dom_element_label = this.getDomElement().querySelector( ".shinken-counter-label" );
        }
    },
    setDomElementLabel        : function ( to_set ) {
        this.dom_element_label = to_set;
        this._updateHTML();
    },
    addTargetsDomElement      : function ( to_set ) {
        this._targets_dom_element.push( to_set );
        this.updateTargetsDomElement();
    },
    updateTargetsDomElement   : function () {
        for ( var i = 0, _size_i = this._targets_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.setDataSet( this._targets_dom_element[ i ], this._data_target_name, this._counter_final || '' );
        }
    },
    setLabel                  : function ( to_set, is_before ) {
        this.label            = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this._is_label_before = !!is_before;
    },
    isString                  : function ( to_set ) {
        this._is_string = to_set;
    },
    _askUpdateHTML            : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            self.timeout_html = null;
        }, 50 );
    },
    _updateHTML               : function ( retry_update_html ) {
        if ( !this.dom_element_label && !this.dom_element ) {
            return;
        }
        var _html       = "";
        var _data_value = "";
        if ( this._counter_final ) {
            _html       = (this.label ? this._is_label_before ? this.label + this._counter_final : this._counter_final + this.label : this._counter_final);
            _data_value = this._counter_final;
        }
        else if ( this._show_if_null ) {
            _html       = "0";
            _data_value = "0";
        }
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = _html;
        }
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'number', _data_value );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterV2, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.CounterInterfaceV2           = function () {
};
SHINKEN.OBJECT.CounterInterfaceV2.prototype = {
    initCounter          : function ( type ) {
        if ( !this.counters ) {
            this.counters = {};
        }
        this.counters[ type ] = new SHINKEN.OBJECT.CounterV2( type );
    },
    resetCounters        : function () {
        var _keys = Object.keys( this.counters );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counters[ _keys[ i ] ].reset();
        }
    },
    countersShowForParent: function ( to_set ) {
        var _keys = Object.keys( this.counters );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counters[ _keys[ i ] ].showForParent( to_set );
        }
    },
    hasCounter           : function ( type ) {
        return this.counters[ type ].hasCounter();
    },
    setCounterValue      : function ( type, data_name, nb ) {
        this.counters[ type ].update( data_name, nb );
    },
    getCounter           : function ( type ) {
        return this.counters[ type ];
    },
    setCountersParent     : function ( parent ) {
        var _keys = Object.keys( this.counters );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.setCounterParent(parent, _keys[ i ]);
        }
    },
    setCounterParent     : function ( parent, type ) {
        this.counters[ type ].setParent( parent.getCounter( type ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceV2, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    this.__class_name__ = 'SHINKEN.OBJECT.Counter';
    this._counter_final         = 0;
    this.label                  = "";
    this._is_label_before       = false;
    this._has_animation         = false;
    this._show_if_null          = !!show_if_null;
    this._is_string             = false;
    this._counter_parent_list   = [];
    this._elements_mapping      = {};
    this.uuid                   = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html           = null;
    this.type                   = '';
    this.dom_class_selector     = '';
    this._targets_dom_element   = [];
    this._show_to_parent        = true;
    this.toggle_parent_activity = false;
    this._data_target_name      = "number";
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init            : function ( dom_element, update_with_dom ) {
        this.dom_element = dom_element;
        this.setDiscreet( !this.dom_element );
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this._counter_parent_list.push( MANAGER.__instance_counter_distributor.findCounter( _name_parent ) );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label            = _label.outerHTML;
                this._is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this._is_string = true;
            }
            if ( this.dom_element.dataset.showIfNull ) {
                this._show_if_null = true;
            }
            if ( this.dom_element.dataset.isDiscreet ) {
                this.setDiscreet( true );
            }
            if ( update_with_dom ) {
                this.initValueWithDom();
            }
        }
    },
    initFromParent  : function ( parent, update_with_dom ) {
        this.init( DOM.Service.askFindChildElementWithClass( parent.dom_element, this.getDomSelector(), 'shinken-counter-candidate', 30 ), update_with_dom );
    },
    initValueWithDom: function () {
        if ( !this.dom_element ) {
            return;
        }
        if ( !this.dom_element.dataset.number ) {
            return;
        }
        this.update( "init_with_dom" + this.uuid, parseInt( this.dom_element.dataset.number ) );
    },
    getValue                    : function () {
        return this._counter_final;
    },
    has                         : function ( name ) {
        return !!this._elements_mapping[ name ];
    },
    setDiscreet                 : function ( to_set ) {
        this.is_discreet = !!to_set;
    },
    hasCounter                  : function () {
        return !!this._counter_final;
    },
    setShowIfNull               : function ( to_set ) {
        this._show_if_null = !!to_set;
    },
    setAnimation                : function ( to_set ) {
        this._has_animation = !!to_set;
    },
    reset                       : function () {
        this._elements_mapping = {};
        this._counter_final    = 0;
        this.showForParent( true );
        this.updateTargetDomElement();
        this._updateHTML();
    },
    showForParent               : function ( show ) {
        this._show_to_parent = !!show;
        this.updateParents();
    },
    updateParents               : function () {
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].update( this.uuid, this._show_to_parent ? this._counter_final : 0 );
        }
    },
    update                      : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this._elements_mapping[ name ];
        }
        else {
            if ( !is_force && this._elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this._elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltip( tooltip );
        }
        
        this._counter_final = this._is_string ? "" : 0;
        var _keys           = Object.keys( this._elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this._counter_final = this._counter_final + this._elements_mapping[ _keys[ i ] ];
        }
        
        
        this.updateTargetDomElement();
        this.updateParents();
        return this._askUpdateHTML( retry_update_html );
    },
    setParent                   : function ( to_add ) {
        if ( !to_add ) {
            return;
        }
        
        this._counter_parent_list.push( to_add );
        this.updateParents();
        this._updateHTML();
    },
    setDataTargetName           : function ( to_set ) {
        this._data_target_name = to_set;
    },
    setDomElementLabel          : function ( to_set ) {
        this.dom_element_label = to_set;
        this.is_discreet       = false;
        this._updateHTML();
    },
    addTargetsDomElement        : function ( to_set ) {
        this._targets_dom_element.push( to_set );
        this.updateTargetDomElement();
    },
    updateTargetDomElement      : function () {
        for ( var i = 0, _size_i = this._targets_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.setDataSet( this._targets_dom_element[ i ], this._data_target_name, this._counter_final || '' );
        }
    },
    setLabel                    : function ( to_set, is_before ) {
        this.label            = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this._is_label_before = !!is_before;
    },
    isString                    : function ( to_set ) {
        this._is_string = to_set;
    },
    _askUpdateHTML              : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            self.timeout_html = null;
        }, 50 );
    },
    _updateHTML                 : function ( retry_update_html ) {
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        
        if ( this._counter_final ) {
            this.dom_element_label.innerHTML = (this.label ? this._is_label_before ? this.label + this._counter_final : this._counter_final + this.label : this._counter_final);
            DOM.Service.setDataSet( this.dom_element, 'number', this._counter_final );
        }
        else if ( this._show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        var _parent_dom_element;
        if ( this.has_animation ) {
            _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 1600 );
            }
        }
        if ( this.toggle_parent_activity ) {
            _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-counter-parent', 10 );
            if ( _parent_dom_element ) {
                if ( this._counter_final ) {
                    _parent_dom_element.classList.add( 'shinken-active' );
                }
                else {
                    _parent_dom_element.classList.remove( 'shinken-active' );
                }
            }
        }
        return true;
    },
    setTooltip                  : function ( label, type ) {
        if ( !label ) {
            return;
        }
        this.dom_element.setAttribute( 'onmouseenter', 'SHINKEN_TOOLTIP.showTooltip(this)' );
        this.dom_element.setAttribute( 'onmouseleave', 'SHINKEN_TOOLTIP.hideTooltip()' );
        this.dom_element.setAttribute( 'shi-tip-html', label );
        this.dom_element.setAttribute( 'shi-tip-type', type );
    },
    getDomSelector              : function () {
        switch ( this.type ) {
            case "error":
                return ".shinken-error-counter";
            case "warning":
                return ".shinken-warning-counter";
            case "user_set":
                return ".shinken-user-set-counter";
            case "total":
                return ".shinken-window-total-counter";
            default:
                return this.dom_class_selector;
        }
    },
    getObjectParentWithClassName        : function ( class_name ) {
        if ( !this.object_parent ){
            return null;
        }
        if ( this.object_parent.getObjectClassName() === class_name ){
            return this.object_parent;
        }
        if ( !this._counter_parent_list.length ){
            return null;
        }
        var _current;
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            _current =  this._counter_parent_list[i].getObjectParentWithClassName(class_name);
            if ( _current ){
                return _current;
            }
        }
        return null;
    },
    computeHtml: function () {
        var _value = this._counter_final;
        if ( !_value ) {
            if ( this._show_if_null ) {
                _value = 0;
            }
            else {
                _value = "";
            }
        }
        this.setDomElement( DOM.Service.createElement( "span", {
            class        : "shinken-counter shinken-" + this.type + "-counter",
            "data-number": _value
        } ) );
        this.dom_element_label = DOM.Service.createElement( "span", { class: "shinken-counter-label" }, _value );
        DOM.Service.addElementTo( this.dom_element_label, this.dom_element );
    },
    pulsate: function () {
        if ( !this.hasCounter() ) {
            return;
        }
        if ( this.object_parent && this.object_parent.dom_element ) {
            DOM.Service.askAddClass( this.object_parent.dom_element, 'shinken-pulsate', 1600 );
        }
        else {
            DOM.Service.askAddClass( this.dom_element, 'shinken-pulsate', 1600 );
        }
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].pulsate();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Counter, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.CounterInterface           = function () {
};
SHINKEN.OBJECT.CounterInterface.prototype = {
    addExtraCounter               : function ( to_add, type, dom_class_selector, data_target_name ) {
        to_add.type                 = type;
        to_add.container_class_name = this.getObjectClassName();
        if ( dom_class_selector ) {
            to_add.dom_class_selector = "." + dom_class_selector;
        }
        if ( data_target_name ) {
            to_add.setDataTargetName( data_target_name );
        }
        this.getExtraCounters()[ type ] = to_add;
    },
    initCounters                  : function ( parent, update_with_dom ) {
        this.errors                      = new SHINKEN.OBJECT.Counter();
        this.errors.type                 = "error";
        this.errors.container_class_name = this.getObjectClassName();
        this.errors.object_parent        = this;
        
        
        this.warnings                      = new SHINKEN.OBJECT.Counter();
        this.warnings.type                 = "warning";
        this.warnings.container_class_name = this.getObjectClassName();
        
        this.user_set                      = new SHINKEN.OBJECT.Counter();
        this.user_set.type                 = "user_set";
        this.user_set.container_class_name = this.getObjectClassName();
        
        this.total                      = new SHINKEN.OBJECT.Counter();
        this.total.type                 = "total";
        this.total.container_class_name = this.getObjectClassName();
        this.initCountersDom( update_with_dom );
        if ( parent ) {
            this.setParentCounter( parent );
        }
    },
    initCountersDom               : function ( update_with_dom ) {
        if ( this.dom_element ) {
            this.errors.initFromParent( this, update_with_dom );
            this.warnings.initFromParent( this, update_with_dom );
            this.user_set.initFromParent( this, update_with_dom );
            this.total.initFromParent( this, update_with_dom );
            var _keys = Object.keys( this.getExtraCounters() );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                this.getExtraCounterByName( _keys[ i ] ).initFromParent( this, update_with_dom );
            }
        }
    },
    resetCounters                 : function () {
        this.warnings.reset();
        this.errors.reset();
        this.user_set.reset();
        this.total.reset();
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).reset();
        }
    },
    hideCountersForParent         : function () {
        this.warnings.showForParent( false );
        this.errors.showForParent( false );
        this.user_set.showForParent( false );
        this.total.showForParent( false );
        
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).showForParent( false );
        }
    },
    showCountersForParent         : function () {
        this.warnings.showForParent( true );
        this.errors.showForParent( true );
        this.user_set.showForParent( true );
        this.total.showForParent( true );
        
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).showForParent( true );
        }
    },
    setVisibilityCountersForParent: function ( to_set ) {
        to_set ? this.showCountersForParent() : this.hideCountersForParent();
    },
    hasError                      : function () {
        return this.errors.hasCounter();
    },
    hasWarning                    : function () {
        return this.warnings.hasCounter();
    },
    setError                      : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning                    : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setUserSet                    : function ( data_name, nb ) {
        this.user_set.update( data_name, nb );
    },
    setTotal                      : function ( data_name, nb ) {
        this.total.update( data_name, nb );
    },
    getCounterError               : function () {
        return this.errors;
    },
    getCounterWarning             : function () {
        return this.warnings;
    },
    getCounterUserSet             : function () {
        return this.user_set;
    },
    getCounterTotal               : function () {
        return this.total;
    },
    getExtraCounters              : function () {
        if ( !this.extraCounters ) {
            this.extraCounters = {};
        }
        return this.extraCounters;
    },
    getExtraCounterByName         : function ( name ) {
        return this.getExtraCounters()[ name ];
    },
    findExtraCounter              : function ( name ) {
        var _counter = this.getExtraCounterByName( name );
        if ( _counter ) {
            return _counter;
        }
        this.addExtraCounter( new SHINKEN.OBJECT.Counter(), name );
        return this.getExtraCounterByName( name );
    },
    setParentCounter              : function ( to_set ) {
        var _parent = to_set || this.parent_container;
        if ( _parent ) {
            this.getCounterError().setParent( _parent.getCounterError() );
            this.getCounterWarning().setParent( _parent.getCounterWarning() );
            this.getCounterUserSet().setParent( _parent.getCounterUserSet() );
            this.getCounterTotal().setParent( _parent.getCounterTotal() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
        this.setParentExtraCounter( _parent );
    },
    setParentExtraCounter         : function ( _parent ) {
        var _keys = Object.keys( this.getExtraCounters() );
        var _current;
        var _current_key;
        var _parent_counter;
        var _parent_dom_counter;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current     = this.getExtraCounterByName( _current_key );
            if ( _parent ) {
                _parent_counter                    = _parent.findExtraCounter( _current_key );
                _parent_counter.dom_class_selector = _current.dom_class_selector;
                _parent_dom_counter                = DOM.Service.askFindChildElementWithClass( _parent.dom_element, _parent_counter.getDomSelector(), 'shinken-counter-candidate', 20 );
                if ( _parent_dom_counter ) {
                    _parent_counter.init( _parent_dom_counter, false );
                }
                else {
                    _parent_counter.setDataTargetName( _current._data_target_name );
                    _parent_counter.addTargetsDomElement( _parent.dom_element );
                }
                _current.setParent( _parent_counter );
                _parent.setParentCounter();
            }
            else {
                _current.setParent();
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.CounterInterfaceValidation           = function () {
};
SHINKEN.OBJECT.CounterInterfaceValidation.prototype = {
    initCounters             : function () {
        this.errors                      = new SHINKEN.OBJECT.Counter();
        this.errors.type                 = "error";
        this.errors.container_class_name = this.getObjectClassName();
        this.errors.object_parent        = this;
        
        this.warnings                      = new SHINKEN.OBJECT.Counter();
        this.warnings.type                 = "warning";
        this.warnings.container_class_name = this.getObjectClassName();
        this.warnings.object_parent        = this;
    },
    setParentCounter              : function ( to_set ) {
        var _parent = to_set || this.parent_container;
        if ( _parent ) {
            this.getCounterError().setParent( _parent.getCounterError() );
            this.getCounterWarning().setParent( _parent.getCounterWarning() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
        }
    },
    doActionAfterAddMessages: function () {
        this.setWarning( this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setError( this.getObjectClassName(), this.messages.getNumberErrors() );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceValidation, SHINKEN.OBJECT.CounterInterface );
SHINKEN.OBJECT.Sorting           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.Sorting';
    this._status        = SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE;
    this._pop_up_status = SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE;
    this._counter       = new SHINKEN.OBJECT.Counter();
};
SHINKEN.OBJECT.Sorting.prototype = {
    init: function () {
    },
    changeToNextStatus: function () {
        switch ( this._status ) {
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE:
                return;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE:
                this.setStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING );
                break;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING:
                this.setStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING );
                break;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING:
                this.setStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE );
                break;
        }
    },
    clickOnButton     : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-header-popup":
                this.changePopUpStatus();
                break;
            case "click-on-option-header-popup":
                this.setStatus( param.status );
                this.setIndex( param.index );
                this.changePopUpStatus( SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE );
                break;
            case "click-on-header":
                this.changeToNextStatus();
                this.setIndex( param );
                break;
        }
    },
    changePopUpStatus : function ( to_set ) {
        if ( !to_set ) {
            to_set = this._pop_up_status === SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE ? SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.OPEN : SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE;
        }
        this._pop_up_status = to_set;
        this.updateDomParent();
    },
    hidePopup         : function () {
        this.changePopUpStatus( SHINKEN.OBJECT.Sorting.CONST.POPUP_STATUS.CLOSE );
    },
    getStatus                 : function () {
        return this._status;
    },
    getIndex                  : function () {
        return this._counter.getValue();
    },
    setDomParent              : function ( to_set ) {
        this._dom_parent = to_set;
        this.updateDomParent();
    },
    updateDomParent           : function () {
        DOM.Service.setDataSet( this._dom_parent, 'sortingStatus', this._status );
        DOM.Service.setDataSet( this._dom_parent, 'sortingPopUpStatus', this._pop_up_status );
    },
    setIndex                  : function ( to_set ) {
        if ( this._status === SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE ) {
            to_set = SHINKEN.OBJECT.Sorting.CONST.NO_INDEX;
        }
        this._counter.update( "index_sorting", to_set );
    },
    setStatus                 : function ( to_set ) {
        this._status = to_set;
        switch ( this._status ) {
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE:
                break;
            case SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE:
                this.setIndex( SHINKEN.OBJECT.Sorting.CONST.NO_INDEX );
                break;
            default:
                break;
        }
        this.updateDomParent();
    },
    computeHtml               : function ( name_parent ) {
        if ( this._status === SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE || this.getDomElement() ) {
            return;
        }
        this.sort_popup_button         = DOM.Service.createElement( "div",
            {
                class  : "shinken-sort-popup-button shinken-2023-arrow-down",
                onclick: "MANAGER.EventManager.clickOnButton(event, 'click-on-header-popup', '" + name_parent + "')"
            } );
        this.sort_priority_dom_element = DOM.Service.createElement( "div", { class: "shinken-list-header-sort-priority" } );
        this.popup_sort_container      = DOM.Service.createElement( "div", { class: "shinken-list-header-sort-popup" } );
        this.computeHtmlSortPriority();
        this.computeHtmlSortPopup( name_parent );
    },
    computeHtmlSortPopup      : function ( name_parent ) {
        DOM.Service.empty( this.popup_sort_container );
        var _increase_option    = this.computeHtmlSortPopupOption( SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING, "shinicon shinicon-sort-increase", _( "shinken_list.sort.increase", [DICTIONARY_COMMON_UI] ), name_parent );
        var _decrease_option    = this.computeHtmlSortPopupOption( SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING, "shinicon shinicon-sort-decrease", _( "shinken_list.sort.decrease", [DICTIONARY_COMMON_UI] ), name_parent );
        var _delete_sort_option = this.computeHtmlSortPopupOption( SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE, "shinkon shinkon-times-bold", _( "shinken_list.sort.remove", [DICTIONARY_COMMON_UI] ), name_parent );
        DOM.Service.addElementTo( _increase_option, this.popup_sort_container );
        DOM.Service.addElementTo( _decrease_option, this.popup_sort_container );
        DOM.Service.addElementTo( _delete_sort_option, this.popup_sort_container );
        DOM.Service.addElementTo( this.popup_sort_container, this.cell_content );
    },
    computeHtmlSortPopupOption: function ( status, icon, label, name_parent ) {
        var to_return   = DOM.Service.createElement( "div",
            {
                class        : "shinken-list-header-sort-popup-option",
                "data-status": status,
                "data-name"  : status,
                onclick      : "MANAGER.EventManager.clickOnButton(event, 'click-on-option-header-popup', '" + name_parent + "')"
            }
        );
        var table       = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-header-sort-popup-option-table" } );
        var tr          = DOM.Service.createElement( "tr", {} );
        var _icon_cell  = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-popup-option-icon-cell" } );
        var _label_cell = DOM.Service.createElement( "td", {}, label );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: icon } ), _icon_cell );
        DOM.Service.addElementTo( _icon_cell, tr );
        DOM.Service.addElementTo( _label_cell, tr );
        DOM.Service.addElementTo( tr, table );
        DOM.Service.addElementTo( table, to_return );
        return to_return;
    },
    computeHtmlSortPriority   : function () {
        var _table                      = DOM.Service.createElement( "table", { class: "shinken-list-header-sort-priority-table shinken-width-100 shinken-user-select-none" } );
        var _tr                         = DOM.Service.createElement( "tr", {} );
        this._counter.dom_element_label = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-number" } );
        var _icon                       = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-icon-cell" } );
        var _icon_decrease              = DOM.Service.createElement( "span", { class: "shinicon shinicon-sort-decrease" } );
        var _icon_increase              = DOM.Service.createElement( "span", { class: "shinicon shinicon-sort-increase" } );
        
        DOM.Service.addElementTo( _icon_decrease, _icon );
        DOM.Service.addElementTo( _icon_increase, _icon );
        DOM.Service.addElementTo( this._counter.dom_element_label, _tr );
        DOM.Service.addElementTo( _icon, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, this.sort_priority_dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Sorting, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.SortingInterface           = function () {
};
SHINKEN.OBJECT.SortingInterface.prototype = {
    initSorting            : function () {
        this.sorting_object = new SHINKEN.OBJECT.Sorting();
        this.sorting_object.init();
    },
    initSortingAvailability: function () {
    },
    makeSortingUnavailable : function () {
        this.sorting_object._status = SHINKEN.OBJECT.Sorting.CONST.STATUS.UNAVAILABLE;
    },
    computeHtmlSorting     : function () {
        this.sorting_object.computeHtml( this.name );
    },
    setDomParentForSorting : function ( to_set ) {
        this.sorting_object.setDomParent( to_set );
    },
    hidePopupSorting    : function () {
        this.sorting_object.hidePopup();
    },
    clickOnButtonSorting: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-header-popup":
            case "click-on-option-header-popup":
            case "click-on-header":
                this.sorting_object.clickOnButton( event, event_name, param );
                break;
        }
    },
    getSortingIndex     : function () {
        return this.sorting_object.getIndex();
    },
    getSortingStatus    : function () {
        return this.sorting_object.getStatus();
    },
    setSortingIndex     : function ( to_set ) {
        return this.sorting_object.setIndex( to_set );
    },
    setSortingStatus    : function ( to_set ) {
        return this.sorting_object.setStatus( to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SortingInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.Sorting.CONST = {
    NO_INDEX    : 0,
    STATUS      : {
        UNAVAILABLE: "UNAVAILABLE",
        NONE       : "NONE",
        INCREASING : "INCREASING",
        DECREASING : "DECREASING"
    },
    POPUP_STATUS: {
        CLOSE: "CLOSE",
        OPEN : "OPEN"
    }
};
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.cleanEmpty                 = function ( array ) {
        var toReturn = [];
        for ( var i = 0, _size_i = array.length; i < _size_i; i++ ) {
            if ( array[ i ] === null || array[ i ] === undefined ) {
                continue;
            }
            toReturn.push( array[ i ] );
        }
        return toReturn;
    };
    self.concat                     = function ( array_1, array_2 ) {
        var toReturn = array_1.concat( array_2 );
        return toReturn;
    };
    self.concatUnique               = function ( array_1, array_2, key_for_unique ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.concatUniqueIfNotPresentIn = function ( array_1, array_2, array_3 ) {
        var toReturn = [];
        var _size    = array_1.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_1[ i ] ) ) {
                toReturn[ i ] = array_1[ i ];
            }
        }
        _size = array_2.length;
        for ( i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_2[ i ] ) ) {
                self.addElement( toReturn, array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.sortNumber                 = function ( array ) {
        if ( !array ) {
            return array;
        }
        return array.sort( function ( a, b ) {
            return a - b;
        } );
    };
    self.sortArray                  = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayMultiple          = function ( array, comparator_values ) {
        if ( !array ) {
            return array;
        }
        if ( !comparator_values ) {
            return array;
        }
        var size      = array.length;
        var fix_array = [];
        var to_sort   = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return fix_array.concat( to_sort );
    };
    self.getMapValues               = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator                = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith                 = function ( array, key, value ) {
        if ( !array ) {
            return [];
        }
        if ( !key || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return [];
        }
        var toReturn = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply           = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _to_return = [];
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply            = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        var _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        var _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith       = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.findFirstIndexWith         = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        var size = array.length;
        if ( !size ) {
            return null;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return i;
            }
        }
        return -1;
    };
    self.getLengthWith              = function ( array, key, value ) {
        var _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey                 = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.extractKeys                = function ( array, keys ) {
        var _keys_size = keys.length;
        if ( !array || !_keys_size ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current ) {
                toReturn[ i ] = self.initEmptyArray( _keys_size );
            }
            else {
                toReturn[ i ] = [];
                for ( var j = 0; j < _keys_size; j++ ) {
                    toReturn[ i ].push( _current[ keys[ j ] ] );
                }
            }
        }
        return toReturn;
    };
    self.removeDuplicate            = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( toReturn.indexOf( _current ) !== -1 ) {
                continue;
            }
            toReturn.push( _current );
        }
        return toReturn;
    };
    self.removeDuplicateArray       = function ( array ) {
        if ( !array ) {
            return null;
        }
        var toReturn = [];
        var size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        var _current;
        var _to_add;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ];
            _to_add  = true;
            for ( var j = 0, _size_j = toReturn.length; j < _size_j; j++ ) {
                if ( self.areEquals( toReturn[ j ], _current ) ) {
                    _to_add = false;
                }
            }
            if ( _to_add ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent          = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        var _extract1 = self.extractKey( array1, key );
        var _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        var _size1 = _extract1.length;
        var _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( var i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo           = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement                 = function ( array, key, value_to_find ) {
        var _size = self.getLength( array );
        var _current_element;
        for ( var i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone          = function ( array ) {
        var toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initEmptyArray             = function ( length ) {
        var toReturn = [];
        for ( var i = 0; i <= length; i++ ) {
            toReturn.push( null );
        }
        return toReturn;
    };
    self.initConstantArray          = function ( to_add, length ) {
        var toReturn = [];
        for ( var i = 0; i < length; i++ ) {
            toReturn.push( to_add );
        }
        return toReturn;
    };
    self.initIntegerArray           = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString   = function ( indexBegin, indexEnd ) {
        var toReturn = [];
        for ( var i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.indexOf                    = function ( array, key, value ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.indexOfCollection          = function ( array, to_find ) {
        var size = array.length;
        var _current;
        for ( var i = 0; i < size; i++ ) {
            if ( array[ i ] === to_find ) {
                return i;
            }
        }
        return -1;
    };
    self.search                     = function ( array, key, value ) {
        var index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                       = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                  = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                      = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                       = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        var b            = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                   = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.containsAtLeastOne         = function ( array1, array2 ) {
        if ( !array1 || !array2 ) {
            return false;
        }
        for ( var i = 0, _size_i = array2.length; i < _size_i; i++ ) {
            if ( self.contains( array1, array2[ i ] ) ) {
                return true;
            }
        }
        return false;
    };
    self.addElement                 = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement              = function ( array, toRemove ) {
        var index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        self.removeElementByIndex( array, index );
        return true;
    };
    self.removeElementByIndex       = function ( array, index ) {
        array.splice( index, 1 );
    };
    self.parseToArray               = function ( obj, extra_value ) {
        if ( !obj ) {
            return null;
        }
        
        var _keys      = Object.keys( obj );
        var _size      = _keys.length;
        var _to_return = [];
        for ( var i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        if ( extra_value ) {
            _to_return.push( extra_value );
        }
        return _to_return;
    };
    self.containsElementWith        = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        var _size = array.length;
        for ( var i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEquals                  = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    self.getMedianIndex             = function ( array, round_up ) {
        if ( !array ) {
            return SHINKEN.TOOLS.ARRAY.NOT_FOUND;
        }
        return round_up ? Math.ceil( array.length / 2 ) : Math.floor( array.length / 2 );
    };
    self.getFirstPartOf             = function ( array ) {
        return array.slice( 0, self.getMedianIndex( array ) + 1 );
    };
    self.getLastPartOf              = function ( array ) {
        return array.slice( self.getMedianIndex( array ), array.length );
    };
    self.minNumber                  = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.min( a, b );
        }, array[ 0 ] );
    };
    self.maxNumber                  = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.max( a, b );
        }, array[ 0 ] );
    };
    self.medianNumber               = function ( array ) {
        if ( !array ) {
            return null;
        }
        var sorted = array.slice().sort();
        var half   = Math.floor( array.length / 2 );
        
        if ( array.length % 2 ) {
            return sorted[ half ];
        }
        
        return (sorted[ half - 1 ] + sorted[ half ]) / 2.0;
    };
    self.take                       = function ( arr, n ) {
        return arr.filter( function ( _, i ) {
            return i < n;
        } );
    };
    self.takeLast                   = function ( arr, n ) {
        var _len = arr.length;
        return arr.filter( function ( _, i ) {
            return _len - i <= n;
        } );
    };
    self.searchIndexByDichotomy     = function ( comp_by_index, i_up, i_down ) {
        /*
        * return the index of the bigger element that is smaller or equal to the search element.
        *
        * [i_down, i_up] are search interval
        * comp_by_index, comparing function:
        *       return value > 0 if the value at index i is bigger than the search value
        *       return value < 0 if the value at index i is smaller than the search value
        *       return 0 if the value at index i is equal than the search value
        *  */
        if ( !i_down ) {
            i_down = 0;
        }
        var _i_up   = i_up;
        var _i_down = i_down;
        var _i_cur;
        while ( _i_up > _i_down ) {
            _i_cur = Math.floor( (_i_up + _i_down + 1) / 2 );
            if ( comp_by_index( _i_cur ) > 0 ) {
                if ( _i_up === _i_cur ) {
                    break;
                }
                _i_up = _i_cur;
            }
            else {
                if ( _i_down === _i_cur ) {
                    break;
                }
                _i_down = _i_cur;
            }
        }
        return _i_down;
    };
    return self;
})( SHINKEN.TOOLS.ARRAY || {} );
SHINKEN.TOOLS.ARRAY.NOT_FOUND = -1;
SHINKEN.TOOLS.BOOLEAN = (function ( self ) {
    "use strict";
    self.isBoolean               = function ( value ) {
        return value === false || value === true || value === "false" || value === "true";
    };
    self.parseToBoolean = function ( value ) {
        if ( value === "false" ) {
            return false;
        }
        if ( value === "true" ) {
            return true;
        }
        return !!value;
    };
    return self;
})( SHINKEN.TOOLS.BOOLEAN || {} );
var DATE_TIME = {};
var __traduction;
DATE_TIME.FORMAT = {
    TIME           : {
        DEFAULT: "HH:MM:SS",
        HH_MM  : "HH:MM"
    },
    DATE           : {
        DEFAULT   : "YYYY-MM-DD",
        WITH_SLASH: "YYYY/MM/DD",
        NO_YEAR   : "MM-DD"
    },
    TIME_PERIOD    : {
        YEAR   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30 * 355,
            KEY      : 'year',
            SHORT_KEY: 'short_year'
        },
        MONTH  : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30,
            KEY      : 'month',
            SHORT_KEY: 'short_month'
        },
        WEEK   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 7,
            KEY      : 'week',
            SHORT_KEY: 'short_week'
        },
        DAY    : {
            NB_MS    : 1000 * 60 * 60 * 24,
            KEY      : 'day',
            SHORT_KEY: 'short_day'
        },
        HOUR   : {
            NB_MS    : 1000 * 60 * 60,
            KEY      : 'hour',
            SHORT_KEY: 'short_hour'
        },
        MINUTE : {
            NB_MS    : 1000 * 60,
            KEY      : 'minute',
            SHORT_KEY: 'short_minute'
        },
        SECONDE: {
            NB_MS    : 1000,
            KEY      : 'second',
            SHORT_KEY: 'short_second'
        }
    },
    NOW            : 'now',
    TYPE_VALIDATION: {
        HOUR: "hour",
        MIN : "min"
    }
};
DATE_TIME.now = function() {
    return new Date();
};
DATE_TIME.buildDate = function(day_delta) {
    var _to_return = new Date();
    _to_return.setDate(_to_return.getDate()+day_delta);
    return _to_return;
};
DATE_TIME.getTimestampNow = function() {
    return Date.now();
};
DATE_TIME.FORMAT.getTime = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.TIME.DEFAULT;
    }
    format = format.toUpperCase();
    switch ( format ) {
        case DATE_TIME.FORMAT.TIME.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
        case DATE_TIME.FORMAT.TIME.HH_MM:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 );
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.DATE.DEFAULT;
    }
    
    switch ( format ) {
        case DATE_TIME.FORMAT.DATE.DEFAULT:
            return date.getFullYear() +  '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        case DATE_TIME.FORMAT.DATE.NO_YEAR:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        case DATE_TIME.FORMAT.DATE.WITH_SLASH:
            return date.getFullYear() + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        default:
            return  date.getFullYear() + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date_from_timestamp = function( timestamp, format ) {
    return DATE_TIME.FORMAT.get_date(new Date(timestamp*1000), format);
};
DATE_TIME.FORMAT.get_time_from_timestamp = function( timestamp, format ) {
    return DATE_TIME.FORMAT.getTime(new Date(timestamp*1000), format);
};
DATE_TIME.initTraduction = function() {
    __traduction = [];
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _short_label;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        _short_label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        __traduction[ _label ] = [_( 'date_time.' + _label, [DICTIONARY_COMMON_UI] ), _( 'date_time.' + _label + 's', [DICTIONARY_COMMON_UI] )];
        __traduction[ _short_label ] = [_( 'date_time.' + _short_label, [DICTIONARY_COMMON_UI] ), _( 'date_time.' + _short_label + 's', [DICTIONARY_COMMON_UI] )];
    }
    __traduction[ DATE_TIME.NOW ] = [_( 'date_time.now', [DICTIONARY_COMMON_UI] ), ''];
};
DATE_TIME.getTraduction = function( key, is_plural ) {
    if ( !__traduction ) {
        this.initTraduction();
    }
    return __traduction[ key ][ is_plural ? 1 : 0 ];
};
DATE_TIME.durationToString = function( timestamp, is_short_name, limit, escape_extra_text ) {
    if ( !timestamp ) {
        return DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    
    var in_the_past = false;
    if ( timestamp < 0 ) {
        in_the_past = true;
        timestamp = -timestamp;
    }
    
    if ( !limit ) {
        limit = 9999;
    }
    var toReturn = '';
    var _nb;
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _nb_sec;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        if ( is_short_name ) {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        }
        else {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        }
        
        _nb_sec = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'NB_MS' ];
        
        if ( timestamp >= _nb_sec ) {
            _nb = parseInt( timestamp / _nb_sec );
            if ( toReturn ) {
                toReturn += " ";
            }
            toReturn += _nb + " " + DATE_TIME.getTraduction( _label, _nb > 1 );
            timestamp = timestamp - _nb * _nb_sec;
            limit--;
        }
        if ( limit <= 0 ) {
            break;
        }
    }
    if  ( escape_extra_text ){
        return toReturn;
    }
    if ( !toReturn ) {
        toReturn = DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    else if ( in_the_past ) {
        toReturn = _( 'date_time.agoMoment', [DICTIONARY_COMMON_UI]  ) + ' ' + toReturn;
    }
    else {
        toReturn = _( 'date_time.inMoment', [DICTIONARY_COMMON_UI]  ) + ' ' + toReturn;
    }
    return toReturn;
};
DATE_TIME.relativeTime = function( elapsed ) {
    if ( elapsed < 0 ) {
        return relativeTime( -elapsed ) + ' ago';
    }
    var msPerSecond = DATE_TIME.FORMAT.TIME_PERIOD[ 'SECONDE' ][ 'NB_MS' ];
    var msPerMinute = DATE_TIME.FORMAT.TIME_PERIOD[ 'MINUTE' ][ 'NB_MS' ];
    var msPerHour = DATE_TIME.FORMAT.TIME_PERIOD[ 'HOUR' ][ 'NB_MS' ];
    var msPerDay = DATE_TIME.FORMAT.TIME_PERIOD[ 'DAY' ][ 'NB_MS' ];
    var msPerMonth = DATE_TIME.FORMAT.TIME_PERIOD[ 'MONTH' ][ 'NB_MS' ];
    var msPerYear = DATE_TIME.FORMAT.TIME_PERIOD[ 'YEAR' ][ 'NB_MS' ];
    
    if ( elapsed < msPerMinute ) {
        return Math.round( elapsed / msPerSecond );
    }
    else if ( elapsed < msPerHour ) {
        return Math.round( elapsed / msPerMinute );
    }
    else if ( elapsed < msPerDay ) {
        return Math.round( elapsed / msPerHour );
    }
    else if ( elapsed < msPerMonth ) {
        return Math.round( elapsed / msPerDay );
    }
    else if ( elapsed < msPerYear ) {
        return Math.round( elapsed / msPerMonth );
    }
    else {
        return Math.round( elapsed / msPerYear );
    }
};
DATE_TIME.isValid = function( type, string_value ) {
    if ( isNaN( string_value ) ) {
        return false;
    }
    var _value_splitted = string_value.split( '' );
    var _size = _value_splitted.length;
    var value;
    switch ( type ) {
        case DATE_TIME.FORMAT.TYPE_VALIDATION.HOUR:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 23 ) {
                return false;
            }
            break;
        case DATE_TIME.FORMAT.TYPE_VALIDATION.MIN:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 59 ) {
                return false;
            }
            break;
        default:
            console.warn( "DATE_TIME.isValid : unknown format =>", type );
    }
    return true;
};
DATE_TIME.isValidRangeTimeperiod = function( time1, time2 ) {
    return (DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time1 ) <= DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time2 ));
};
DATE_TIME.splitTimeperiodDay = function( value ) {
    var _to_return = [];
    var _timeperiod_ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES );
    for ( var i = 0, _size = _timeperiod_ranges.length; i < _size; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodRanges( _timeperiod_ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodRanges = function( value ) {
    var ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS );
    var _size_ranges = ranges.length;
    var _to_return = [];
    for ( var i = 0; i < _size_ranges; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodTime( ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodTime = function( value ) {
    var _to_return = {};
    var _time_splitted = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN );
    if ( _time_splitted.length !== 2 ) {
        _to_return.invalid = true;
        return _to_return;
    }
    _to_return.hour = _time_splitted[ 0 ].trim();
    _to_return.min = _time_splitted[ 1 ].trim();
    
    return _to_return;
};
DATE_TIME.getTimeperiodLabel = function( type, value ) {
    switch ( type ) {
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR:
            return value.hour + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN + value.min;
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE:
            return DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 0 ] ) + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS + DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 1 ] );
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.FULL:
            var _current_range;
            var _to_return = "";
            var _size = value.length;
            for ( var i = 0; i < _size; i++ ) {
                _current_range = value[ i ];
                _to_return += DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE, value[ i ] );
                if ( (value + 1) !== _size ) {
                    _to_return += PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES;
                }
            }
            return _to_return;
    }
};
DATE_TIME.initHistoricArrayTimeStamp             = function ( length ) {
        var toReturn = [];
        for ( var i = length - 1; i>=0; i-- ) {
            toReturn.push( DATE_TIME.buildDate(- i).getTime()/1000 );
        }
        return toReturn;
    };
DOM.BodyService = (function ( self ) {
    "use strict";
    
    var __body_element;
    var __list_to_remove = {};
    var __time_out_add;
    var __bouding_rect;
    
    self.load            = function () {
        if ( !__body_element ) {
            __body_element = document.querySelector( 'body' );
        }
    };
    self.hasChildWithID  = function ( id ) {
        var _child = self.getDomElement().querySelector( "#" + id );
        return _child;
    };
    self.askAddClass     = function ( to_add, time_out ) {
        self.getDomElement().classList.add( to_add );
        if ( time_out ) {
            __list_to_remove[ to_add ] = true;
            clearTimeout( __time_out_add );
            __time_out_add = setTimeout( function () {
                var _keys = Object.keys( __list_to_remove );
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    self.getDomElement().classList.remove( _keys[ i ] );
                }
                __list_to_remove = {};
            }, time_out );
        }
    };
    self.removeClass     = function ( to_remove ) {
        self.getDomElement().classList.remove( to_remove );
        __list_to_remove[ to_remove ] = false;
    };
    self.addChild        = function ( dom_element ) {
        DOM.Service.addElementTo( dom_element, self.getDomElement() );
    };
    self.getDomElement   = function () {
        if ( !__body_element ) {
            self.load();
        }
        return __body_element;
    };
    self.cleanDomElement = function () {
        __body_element = null;
    };
    self.getWidth = function () {
        if ( !__bouding_rect ){
            __bouding_rect = DOM.Service.getBoundingClientRect(this.getDomElement());
        }
        return __bouding_rect[DOM.CONST.STYLE.WIDTH] ;
    };
    self.reset = function () {
        __bouding_rect = undefined;
    };
    return self;
})( DOM.BodyService || {} );
window.addEventListener( "resize", function () {
    DOM.BodyService.reset()
} );
DOM.ScrollService = (function ( self ) {
    "use strict";
    
    self.getMiddleScrollPosition       = function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        return ((_bottom - _top) / 2) + _top;
    };
    self.getFirstVisibleDom            = function ( dom_element_container, css_selector_children, move_down ) {
        var _position = DOM.Service.getBoundingClientRect( dom_element_container, move_down ? DOM.CONST.STYLE.TOP : DOM.CONST.STYLE.BOTTOM );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _position, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFromMiddle = function ( dom_element_container, css_selector_children, move_down ) {
        var _middle_pos = DOM.ScrollService.getMiddleScrollPosition( dom_element_container );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _middle_pos, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFrom       = function ( list, position, move_down, dom_element_container ) {
        var _size  = list.length;
        var _index = move_down ? _size - 1 : 0;
        var _delta = move_down ? -1 : 1;
        
        var _closer_index     = _index;
        var _last_closer_diff = 9999;
        var _current;
        for ( ; _index < _size && _index >= 0; _index = _index + _delta ) {
            _current = list[ _index ];
            if ( !DOM.Service.isVisible( _current ) ) {
                continue;
            }
            if ( DOM.Service.getMissingScrollPositionToBeVisible( _current, dom_element_container ) ) {
                continue;
            }
            var _median = DOM.Service.getBoundingClientRect( _current, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
            if ( Math.abs( _median - position ) < _last_closer_diff ) {
                _last_closer_diff = Math.abs( _median - position );
                _closer_index     = _index;
                continue;
            }
            else {
                break;
            }
        }
        return list[ _closer_index ];
    };
    self.isVisible                     = function ( dom_element_container, dom_element_to_test, marge, action_type ) {
        if ( !dom_element_to_test ) {
            return false;
        }
        marge               = marge || 0;
        var _rect_to_test   = dom_element_to_test.getBoundingClientRect();
        var _rect_container = dom_element_container.getBoundingClientRect();
        
        if ( action_type ) {
            if ( _rect_to_test.bottom - _rect_container.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
            }
            if ( _rect_container.bottom - _rect_to_test.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_TOP;
            }
            return true;
        }
        else {
            return _rect_to_test.bottom - _rect_container.top >= marge && _rect_container.bottom - _rect_to_test.top >= marge;
        }
    };
    self.bindWith                      = function ( dom_element, dom_element_to_bind_with, previous_position_vertical, action_type ) {
        switch ( action_type ) {
            case DOM.CONST.ATTRIBUTE.SCROLL_TOP:
            case DOM.CONST.ATTRIBUTE.SCROLL_DOWN:
                if ( self.isVisible( dom_element, dom_element_to_bind_with, 3 * DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT ), action_type ) ) {
                    return;
                }
                else {
                    var _delta = DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT );
                    if ( previous_position_vertical ) {
                        _delta = previous_position_vertical - DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                    }
                    self.changeVerticaly( dom_element, _delta, action_type );
                }
                break;
        }
    };
    self.changeVerticaly               = function ( dom_element, delta, action_type ) {
        dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] = Math.ceil( dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] - delta );
    };
    
    return self;
})( DOM.ScrollService || {} );
DOM.ServiceEllipsis = (function ( self ) {
    "use strict";
    var __canvas  = document.createElement( "canvas" );
    var __context = __canvas.getContext( "2d" );
    
    var __size_distributor = {};
    
    self.getSizeDistributor   = function () {
        return __size_distributor;
    };
    self.ellipsis             = function ( dom_element, text, font, nb_line ) {
        DOM.Service.empty( dom_element );
        var _to_return = {
            width      : DOM.Service.getBoundingClientRect( dom_element, DOM.CONST.STYLE.WIDTH ),
            height       : DOM.Service.getBoundingClientRect( dom_element.parentElement, DOM.CONST.STYLE.HEIGHT ),
            text        : "",
            has_ellipsis: false,
            line_number: 1
        };
        if ( !_to_return.width || !_to_return.height ) {
            return _to_return;
        }
        var _text_to_split     = self.splitByWidth_toArray( text, _to_return.width, font );
        _to_return.line_number = _text_to_split.length;
        for ( var i = 0; i < nb_line; i++ ) {
            if ( _to_return.line_number <= i ) {
                break;
            }
            _to_return.text += _text_to_split[ i ];
        }
        if ( _to_return.line_number > nb_line ) {
            _to_return.text         = _to_return.text.substring( 0, _to_return.text.length - 3 );
            _to_return.text += "...";
            _to_return.has_ellipsis = true;
            _to_return.line_number = nb_line;
        }
        dom_element.innerText = _to_return.text;
        if ( _to_return.height < DOM.Service.getBoundingClientRect( dom_element, DOM.CONST.STYLE.HEIGHT ) && nb_line > 1 ) {
            return self.ellipsis( dom_element, text, font, nb_line - 1 );
        }
        return _to_return;
    };
    self.splitByWidth_toArray = function ( text, width, font ) {
        var _to_return = [];
        var _temp_text = text;
        while ( _temp_text ) {
            var _split = self.splitByWidth_toLine( _temp_text, width, font );
            if ( !_split ) {
                return _to_return;
            }
            _to_return.push( _split );
            if ( _split === _temp_text ) {
                _temp_text = "";
            }
            else {
                _temp_text = _temp_text.substring( _split.length );
            }
        }
        return _to_return;
    };
    self.splitByWidth_toLine  = function ( text, width, font ) {
        var _to_return     = "";
        var _current_width = 0;
        var _split_text    = text.split( "" );
        for ( var i = 0, _size_i = _split_text.length; i < _size_i; i++ ) {
            _current_width += self.getCharMeasure( _split_text[ i ], font );
            if ( _current_width > width ) {
                return _to_return;
            }
            else {
                _to_return = _to_return + _split_text[ i ];
            }
        }
        return _to_return;
    };
    self.getCharMeasure       = function ( char, font ) {
        if ( !__size_distributor[ font ] ) {
            __size_distributor[ font ] = {};
        }
        if ( !__size_distributor[ font ][ char ] ) {
            __size_distributor[ font ][ char ] = self._measureChar( char, font );
        }
        return __size_distributor[ font ][ char ];
    };
    self._measureChar         = function ( letter, font ) {
        __context.font = font;
        return __context.measureText( letter ).width;
    };
    return self;
})( DOM.ServiceEllipsis || {} );
DOM.Service = (function ( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.findParentElementWithDataSet              = function ( element, key, deepLimit ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( self.hasKeyInDataSet( element, key ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass                = function ( element, class_tag, deepLimit ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) && (element.tagName === "path" || element.tagName === "svg") ) {
            deepLimit--;
            return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.findParentElementWithID                   = function ( element, id, deepLimit ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) && (element.tagName === "path" || element.tagName === "svg") ) {
            deepLimit--;
            return this.findParentElementWithID( element.parentElement, id, deepLimit );
        }
        if ( element.id === id ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithID( element.parentElement, id, deepLimit );
    };
    self.findParentElementByClassWithClassExcluded = function ( element, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_exclude ) ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementByClassWithClassExcluded( element.parentElement, class_tag, class_exclude, deepLimit );
    };
    self.askFindChildElementWithClass              = function ( element, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !element || !class_tag ) {
            return null;
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( class_tag, "." ) ) {
            class_tag = class_tag.substring( 1 );
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( class_exclude, "." ) ) {
            class_exclude = class_exclude.substring( 1 );
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        return this.findChildElementWithClass( element.children, class_tag, class_exclude, deepLimit );
    };
    self.findChildElementWithClass                 = function ( elements, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !elements.length ) {
            return null;
        }
        var children = [];
        for ( var i = 0, _size = elements.length; i < _size; i++ ) {
            try {
                if ( elements[ i ].classList.contains( class_tag ) ) {
                    return elements[ i ];
                }
                if ( !elements[ i ].classList.contains( class_exclude ) || !elements[ i ].childElementCount ) {
                    children = SHINKEN.TOOLS.ARRAY.concat( children, SHINKEN.TOOLS.ARRAY.parseToArray( elements[ i ].children ) );
                }
            }
            catch ( e ) {
            
            }
        }
        deepLimit--;
        return this.findChildElementWithClass( children, class_tag, class_exclude, deepLimit );
        
    };
    self.querySelectorAllWithOutChild              = function ( dom_element, class_tag, class_exclude ) {
        var _to_return = [];
        var _current;
        if ( dom_element ) {
            for ( var i = 0, _size_i = dom_element.children.length; i < _size_i; i++ ) {
                _current = dom_element.children[ i ];
                if ( _current.classList.contains( class_exclude ) ) {
                    continue;
                }
                if ( _current.classList.contains( class_tag ) ) {
                    _to_return.push( _current );
                    continue;
                }
                _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, self.querySelectorAllWithOutChild( _current, class_tag, class_exclude ) );
            }
        }
        return _to_return;
    };
    self.isExisting                                = function ( dom_element ) {
        var elements = document.querySelectorAll( self.getSelector( dom_element ) );
        for ( var i = 0, _size_i = elements.length; i < _size_i; i++ ) {
            if ( elements[ i ] === dom_element ) {
                return true;
            }
        }
        return false;
    };
    self.isInDom                                   = function ( dom_element ) {
        var isElementInDom = dom_element.getRootNode
                             ? dom_element.getRootNode( { composed: true } ) === document
                             : document.body.contains( dom_element );
    };
    self.getSelector                               = function ( dom_element ) {
        var _class_selector = SHINKEN.TOOLS.ARRAY.join( dom_element.classList, "." );
        if ( _class_selector ) {
            _class_selector = "." + _class_selector;
        }
        return dom_element.tagName + _class_selector;
    };
    self.setPageTitle                              = function ( to_set ) {
        document.title = to_set;
    };
    
    self.hasKeyInDataSet                 = function ( element, key ) {
        return typeof element.dataset[ key ] !== "undefined";
    };
    self.hasKeyInDataSetAndKeyNotEmpty   = function ( element, key ) {
        return self.hasKeyInDataSet( element, key ) && element.dataset[ key ];
    };
    self.createTable                     = function ( cells_dom ) {
        var toReturn = document.createElement( "table", { class: "shinken-table" } );
        var _current_row;
        var _current_cell;
        for ( var i = 0, _size_i = cells_dom.length; i < _size_i; i++ ) {
            _current_row = document.createElement( "tr" );
            for ( var j = 0, _size_j = cells_dom[ i ].length; j < _size_j; j++ ) {
                _current_cell = document.createElement( "td" );
                _current_cell.appendChild( cells_dom[ i ][ j ] );
                _current_row.appendChild( _current_cell );
            }
            toReturn.appendChild( _current_row );
        }
        return toReturn;
    };
    self.createElement                   = function ( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML !== undefined && innerHTML !== null ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.cloneElement                    = function ( dom_element_to_clone, attributes ) {
        var _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                      = function ( element, attributes, on_mouse_enter ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( "onmouseenter", on_mouse_enter || "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        var _keys = Object.keys( attributes );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.removeTooltip                   = function ( element ) {
        element.setAttribute( "onmouseenter", "" );
        element.setAttribute( "onmouseleave", "" );
    };
    self.removeElement                   = function ( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        
        try {
            var _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.getInnerText                    = function ( element ) {
        if ( !element ) {
            return;
        }
        return element.innerText.trim();
    };
    self.toggleClass                     = function ( element, to_toggle ) {
        if ( element.classList.contains( to_toggle ) ) {
            element.classList.remove( to_toggle );
        }
        else {
            element.classList.add( to_toggle );
        }
    };
    self.removeElementIfHasClass         = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementWithIndex             = function ( element, parent, index ) {
        if ( !index ) {
            index = 0;
        }
        if ( index >= parent.children.length ) {
            parent.appendChild( element );
        }
        else {
            parent.insertBefore( element, parent.children[ index ] );
        }
    };
    self.addElementAtIndex               = function ( element, parent, index ) {
        if ( !parent || !element ) {
            return;
        }
        if ( !index ) {
            index = 0;
        }
        if ( parent.childElementCount <= index ) {
            self.addElementTo( element, parent );
        }
        else {
            self.insertElementBefore( parent.children[ index ], element );
        }
    };
    self.addAllChildrenTo                = function ( element_with_children, parent ) {
        if ( parent && element_with_children ) {
            var _children = element_with_children.children;
            for ( var i = 0, _size_i = _children.length; i < _size_i; i++ ) {
                self.addElementTo( _children[ i ], parent );
            }
            parent.appendChild( element_with_children );
        }
        
    };
    self.addElementTo                    = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.addElementToAfterEmpty          = function ( element, parent ) {
        self.empty( parent );
        self.addElementTo( element, parent );
    };
    self.addElementAfterTo               = function ( element, target ) {
        var _next = target.nextSibling.nextSibling;
        if ( _next ) {
            target.parentNode.insertBefore( element, _next );
        }
        else {
            self.addElementTo( element, target.parentNode );
        }
    };
    self.switchElementParent             = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.switchElement                   = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        var _index_1 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_1.children, element_1 );
        var _index_2 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_2.children, element_2 );
        self.insertElementBefore( element_2, element_1 );
        self.addElementAtIndex( element_1, parent_2, _index_2 );
    };
    self.insertElementBefore             = function ( element_existing, element_to_insert ) {
        if ( !element_existing || !element_to_insert ) {
            return;
        }
        var _parent = element_existing.parentNode;
        _parent.insertBefore( element_to_insert, element_existing );
    };
    self.addLoadingFrame                 = function ( dom_parent, text, parent_scrollable ) {
        if ( !dom_parent ) {
            return;
        }
        if ( DOM.Service.getComputedStyle( dom_parent, DOM.CONST.STYLE.POSITION ) === "absolute" ) {
            console.error( "NOT SUPPORTED addLoadingFrame" );
            return;
        }
        self.setStyle( dom_parent, DOM.CONST.STYLE.POSITION, "relative" );
        var _to_add = self.createElement( "div", { class: "shinken-loading-frame" }, "" );
        if ( text ) {
            var _dom_text = self.createElement( "div", { class: "shinken-loading-frame-text" }, text );
            self.addElementTo( _dom_text, _to_add );
            
            var _interval = setInterval( function () {
                if ( self.isExisting( _to_add ) ) {
                    if ( !parent_scrollable ) {
                        var _new_top = (self.getBoundingClientRect( _to_add )[ "height" ] - self.getBoundingClientRect( _dom_text )[ "height" ]) / 2;
                        self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, _new_top );
                    }
                    else {
                        var _scrolling_needed = self.getMissingScrollPositionToBeVisible( _dom_text, parent_scrollable );
                        if ( _scrolling_needed ) {
                            self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, Math.max( 0, self.getComputedStyle( _dom_text, DOM.CONST.STYLE.TOP ) + _scrolling_needed ) );
                        }
                    }
                }
                else {
                    clearInterval( _interval );
                }
            }, 200 );
        }
        self.addElementTo( _to_add, dom_parent );
    };
    self.getPositionToPercentFull        = function ( dom_element, forbid_negative_value ) {
        var _rect = self.getBoundingClientRect( dom_element );
        DOM.Service.removeStyles( dom_element, [DOM.CONST.STYLE.HEIGHT, DOM.CONST.STYLE.WIDTH] );
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.TOP ]    = self.getPercentCompareToWindowHeight( _rect[ DOM.CONST.STYLE.TOP ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.BOTTOM ] = self.getPercentCompareToWindowHeight( window.innerHeight - _rect[ DOM.CONST.STYLE.TOP ] - _rect[ DOM.CONST.STYLE.HEIGHT ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = self.getPercentCompareToWindowWidth( _rect[ DOM.CONST.STYLE.LEFT ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.RIGHT ]  = self.getPercentCompareToWindowWidth( window.innerWidth - _rect[ DOM.CONST.STYLE.LEFT ] - _rect[ DOM.CONST.STYLE.WIDTH ], forbid_negative_value );
        return _to_return;
    };
    self.parsePositionToPercent          = function ( dom_element, forbid_negative_value ) {
        var _rect                         = self.getBoundingClientRect( dom_element );
        var _styles                       = {};
        _styles[ DOM.CONST.STYLE.TOP ]    = "auto";
        _styles[ DOM.CONST.STYLE.BOTTOM ] = "auto";
        _styles[ DOM.CONST.STYLE.LEFT ]   = "auto";
        _styles[ DOM.CONST.STYLE.RIGHT ]  = "auto";
        
        _rect.left < window.innerWidth / 2 ?
        _styles[ DOM.CONST.STYLE.LEFT ] = self.getPercentCompareToWindowWidth( _rect[ DOM.CONST.STYLE.LEFT ], forbid_negative_value ) :
        _styles[ DOM.CONST.STYLE.RIGHT ] = self.getPercentCompareToWindowWidth( window.innerWidth - _rect[ DOM.CONST.STYLE.LEFT ] - _rect[ DOM.CONST.STYLE.WIDTH ], forbid_negative_value );
        
        _rect.top < window.innerHeight / 2 ?
        _styles[ DOM.CONST.STYLE.TOP ] = self.getPercentCompareToWindowHeight( _rect[ DOM.CONST.STYLE.TOP ], forbid_negative_value ) :
        _styles[ DOM.CONST.STYLE.BOTTOM ] = self.getPercentCompareToWindowHeight( window.innerHeight - _rect[ DOM.CONST.STYLE.TOP ] - _rect[ DOM.CONST.STYLE.HEIGHT ], forbid_negative_value );
        
        DOM.Service.setStyles( dom_element, _styles );
    };
    self.getPercentCompareToWindowHeight = function ( value, forbid_negative_value ) {
        var _to_return = (value * 100) / window.innerHeight;
        if ( forbid_negative_value && _to_return < 0 ) {
            _to_return = 0;
        }
        return _to_return + "%";
    };
    self.getPercentCompareToWindowWidth  = function ( value, forbid_negative_value ) {
        var _to_return = (value * 100) / window.innerWidth;
        if ( forbid_negative_value && _to_return < 0 ) {
            _to_return = 0;
        }
        return _to_return + "%";
    };
    self.parsePositionForDragStart       = function ( dom_element, ignore_size ) {
        var _rect = DOM.Service.getBoundingClientRect( dom_element );
        DOM.Service.removeStyles( dom_element, [DOM.CONST.STYLE.BOTTOM, DOM.CONST.STYLE.RIGHT] );
        var _new_styles                     = {};
        _new_styles[ DOM.CONST.STYLE.TOP ]  = _rect[ DOM.CONST.STYLE.TOP ];
        _new_styles[ DOM.CONST.STYLE.LEFT ] = _rect[ DOM.CONST.STYLE.LEFT ];
        if ( !ignore_size ) {
            _new_styles[ DOM.CONST.STYLE.WIDTH ]  = _rect[ DOM.CONST.STYLE.WIDTH ];
            _new_styles[ DOM.CONST.STYLE.HEIGHT ] = _rect[ DOM.CONST.STYLE.HEIGHT ];
        }
        DOM.Service.setStyles( dom_element, _new_styles );
    };
    self.getPositionsForSaveInPercent    = function ( dom_element, keys ) {
        var _to_return = {};
        var _current_key;
        for ( var i = 0, _size = keys.length; i < _size; i++ ) {
            _current_key                = keys[ i ];
            _to_return [ _current_key ] = self.getPositionForSaveInPercent( dom_element, _current_key );
        }
        return _to_return;
    };
    self.getPositionForSaveInPercent     = function ( dom_element, key ) {
        var _value = self.getBoundingClientRect( dom_element, key );
        switch ( key ) {
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.BOTTOM:
            case DOM.CONST.STYLE.HEIGHT:
                return self.getPercentCompareToWindowHeight( _value );
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.RIGHT:
            case DOM.CONST.STYLE.WIDTH:
                return self.getPercentCompareToWindowWidth( _value );
        }
    };
    
    self.setDataSet                      = function ( element, attr, value ) {
        if ( !element ) {
            return;
        }
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.querySelectorAllWithData        = function ( css_selector, attr, dom_element ) {
        dom_element = dom_element || document;
        var _all_doms = dom_element.querySelectorAll(css_selector);
        var _to_return = [];
        for ( var i = 0, _size_i = _all_doms.length; i < _size_i; i++ ) {
            if ( _all_doms[i].dataset[attr] ){
                _to_return.push(_all_doms[i]);
            }
        }
        return _to_return;
    };
    self.updateWithComputedWidthClass         = function ( dom_element ) {
        var _with         = self.getBoundingClientRect( dom_element, DOM.CONST.STYLE.WIDTH );
        var _class_to_add = self.computedWidthClass( _with );
        var _classes      = dom_element.classList;
        for ( var i = 0, _size_i = _classes.length; i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.STRING.startsWith( _classes[ i ], "shinken-width-for-responsive-" ) ) {
                dom_element.classList.remove( _classes[ i ] );
            }
        }
        dom_element.classList.add( _class_to_add );
    };
    self.updateWithComputedWidthClassWithList         = function ( dom_element, list_size ) {
        var _with         = self.getBoundingClientRect( dom_element, DOM.CONST.STYLE.WIDTH );
        var _class_to_add = list_size[list_size.length - 1];
        for ( var i = list_size.length - 1 ; i >= 0; i-- ) {
            if ( _with  > list_size[i] ){
                break;
            }
            else {
                _class_to_add = list_size[i];
            }
        }
        _class_to_add = "shinken-width-for-responsive-" + _class_to_add;
        var _classes      = dom_element.classList;
        for ( var j = 0, _size_j = _classes.length; j < _size_j; j++ ) {
            if ( SHINKEN.TOOLS.STRING.startsWith( _classes[ j ], "shinken-width-for-responsive-" ) ) {
                dom_element.classList.remove( _classes[ j ] );
            }
        }
        dom_element.classList.add( _class_to_add );
    };
    self.computedWidthClass                   = function ( width ) {
        var _width_compute = Math.floor( width / 50 );
        return "shinken-width-for-responsive-" + _width_compute * 50;
    };
    self.askAddClass                          = function ( element, to_add, time_out ) {
        if ( !element ) {
            return;
        }
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.addClasses                           = function ( dom_element, class_to_add ) {
        if ( !dom_element ) {
            return;
        }
        if ( typeof class_to_add === "string" ) {
            class_to_add = class_to_add.split( " " );
        }
        for ( var i = 0, _size_i = class_to_add.length; i < _size_i; i++ ) {
            dom_element.classList.add( class_to_add[ i ] );
        }
    };
    self.removeClasses                        = function ( dom_element, class_to_remove ) {
        if ( !dom_element ) {
            return;
        }
        if ( typeof class_to_remove === "string" ) {
            class_to_remove = class_to_remove.split( " " );
        }
        for ( var i = 0, _size_i = class_to_remove.length; i < _size_i; i++ ) {
            dom_element.classList.remove( class_to_remove[ i ] );
        }
    };
    self.addOrRemoveClasses                   = function ( dom_element, boolean, _class ) {
        boolean ? self.addClasses( dom_element, _class ) : self.removeClasses( dom_element, _class );
    };
    self.applySiblingSettings                 = function ( dom_element, dom_element_ref ) {
        dom_element.className = dom_element_ref.className;
    };
    self.getComputedStyle                     = function ( dom_element, key ) {
        if ( !dom_element ) {
            return {};
        }
        var _to_return = dom_element.currentStyle || getComputedStyle( dom_element );
        if ( key ) {
            _to_return = _to_return[ key ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_return, "px" ) ) {
                _to_return = parseInt( _to_return );
            }
        }
        return _to_return;
    };
    self.getComputedStyles                    = function ( dom_element, keys ) {
        if ( !keys || !dom_element ) {
            return self.getComputedStyle( dom_element );
        }
        var _computed  = self.getComputedStyle( dom_element );
        var _to_return = {};
        var _to_add;
        for ( var i = 0, _size_i = keys.length; i < _size_i; i++ ) {
            _to_add = _computed[ keys[ i ] ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_add, "px" ) ) {
                _to_add = parseInt( _to_add );
            }
            _to_return[ keys[ i ] ] = _to_add;
        }
        return _to_return;
    };
    self.cleanAllStyles                       = function ( dom_element ) {
        dom_element.removeAttribute( "style" );
    };
    self.attributeStyleToDict                 = function ( dom_element ) {
        var attribute_style = dom_element.getAttribute( "style" );
        var _to_return      = {};
        var split_1         = attribute_style.split( ";" );
        for ( var i = 0, _size_i = split_1.length; i < _size_i; i++ ) {
            if ( !split_1[ i ] ) {
                continue;
            }
            var split_2                = split_1[ i ].split( ":" );
            _to_return[ split_2[ 0 ] ] = split_2[ 1 ];
        }
        return _to_return;
    };
    self.cleanAllStyles                       = function ( dom_element ) {
        dom_element.removeAttribute( "style" );
    };
    self.setStyle                             = function ( dom_element, key, value ) {
        if ( !dom_element || !key ) {
            return;
        }
        dom_element.style[ key ] = self._parseStyle( key, value );
    };
    self._parseStyle                          = function ( key, value ) {
        switch ( key ) {
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.HEIGHT:
            case DOM.CONST.STYLE.WIDTH:
            case DOM.CONST.STYLE.LINE_HEIGHT:
            case DOM.CONST.STYLE.MAX_HEIGHT:
            case DOM.CONST.STYLE.MAX_WIDTH:
            case DOM.CONST.STYLE.BORDER_RADIUS:
                if ( !isNaN( value ) ) {
                    value = value + "px";
                }
                break;
            default:
                break;
        }
        return value;
    };
    self.setStyles                            = function ( dom_element, styles ) {
        var keys = Object.keys( styles );
        for ( var i = 0, size = keys.length; i < size; i++ ) {
            self.setStyle( dom_element, keys[ i ], styles[ keys[ i ] ] );
        }
    };
    self.removeStyles                         = function ( dom_element, styles ) {
        for ( var i = 0, size = styles.length; i < size; i++ ) {
            self.removeStyle( dom_element, styles[ i ] );
        }
    };
    self.removeStyle                          = function ( dom_element, style ) {
        if ( !dom_element ) {
            return;
        }
        dom_element.style.removeProperty( style );
    };
    self.styleToHtml                          = function ( styles ) {
        var _keys      = Object.keys( styles );
        var _current_key;
        var _to_return = "";
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _to_return += _current_key + ":" + self._parseStyle( _current_key, styles[ _current_key ] ) + ";";
        }
        return _to_return;
    };
    self.setStyleInHard                       = function ( dom_element, style ) {
        self.removeStyle(dom_element, style);
        var _hard_value = self.getBoundingClientRect(dom_element, style);
        self.setStyle(dom_element, style, _hard_value);
    };
    self.getBoundingClientRect                = function ( dom_element, key ) {
        if ( !dom_element ) {
            return;
        }
        var _rect = dom_element.getBoundingClientRect();
        if ( !key ) {
            return _rect;
        }
        if ( key === DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM ) {
            return parseInt( (_rect[ DOM.CONST.STYLE.TOP ] + _rect[ DOM.CONST.STYLE.BOTTOM ]) / 2 );
        }
        return parseInt( _rect[ key ] );
    };
    self.hasScrollHeight                      = function ( dom_element ) {
        return dom_element.clientHeight < dom_element.scrollHeight;
    };
    self.hasScrollWidth                       = function ( dom_element ) {
        return dom_element.clientWidth < dom_element.scrollWidth;
    };
    self.setHtmlOrHide                        = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( "shinken-hidden" );
        }
        else {
            dom_element.classList.add( "shinken-hidden" );
        }
    };
    self.replaceChild                         = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                                = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.addAttribute                         = function ( dom_element, attribute_name, to_set ) {
        dom_element.setAttribute( attribute_name, to_set );
    };
    self.removeAttribute                      = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    self.getHeight                            = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight;
    };
    self.getHeightWithMargin                  = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight + self.getComputedStyle( dom_element, "marginTop" ) + self.getComputedStyle( dom_element, "marginBottom" );
    };
    self.isVisible                            = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        try {
            var styles = self.getComputedStyle( elem );
        }
        catch ( ex ) {
            throw Error( "DOM.Service: elem is not an element." );
        }
        
        if ( styles.display === "none" ) {
            return false;
        }
        if ( styles.visibility !== "visible" && styles.visibility !== "inherit" ) {
            return false;
        }
        if ( styles.opacity < 0.1 ) {
            return false;
        }
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, deepness-- );
        }
        return true;
    };
    self.getMissingScrollPositionToBeVisible  = function ( dom_element, dom_parent ) {
        var _parent_rect  = self.getBoundingClientRect( dom_parent );
        var _element_rect = self.getBoundingClientRect( dom_element );
        if ( _element_rect[ DOM.CONST.STYLE.TOP ] < _parent_rect[ DOM.CONST.STYLE.TOP ] ) {
            return _parent_rect[ DOM.CONST.STYLE.TOP ] - _element_rect[ DOM.CONST.STYLE.TOP ];
        }
        if ( _element_rect[ DOM.CONST.STYLE.BOTTOM ] > _parent_rect[ DOM.CONST.STYLE.BOTTOM ] ) {
            return _parent_rect[ DOM.CONST.STYLE.BOTTOM ] - _element_rect[ DOM.CONST.STYLE.BOTTOM ];
        }
        return 0;
    };
    self.setInputValue                        = function ( dom_element, to_set ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) ) {
            dom_element.setAttribute( "value", to_set );
            dom_element.classList.toggle( "IE-PATCH" );
            dom_element.value = to_set;
            return;
        }
        dom_element.value = to_set;
    };
    self.hasFocus                             = function ( dom_element ) {
        return dom_element === document.activeElement;
    };
    self.generateDomElementFromString         = function ( string ) {
        var _to_return = self.createElement( "div", "", string );
        return _to_return.children;
    };
    self.isMatchingMedianDomElementTopWith    = function ( list, y ) {
        var _median_index = SHINKEN.TOOLS.ARRAY.getMedianIndex( list, true );
        if ( _median_index === SHINKEN.TOOLS.ARRAY.NOT_FOUND ) {
            return DOM.CONST.VALUE.NONE;
        }
        var _median  = list[ _median_index ];
        var _compare = self.compareCoordinates( _median, null, y );
        if ( _compare === 0 ) {
            return _median;
        }
        return _compare;
    };
    self.compareCoordinates                   = function ( dom_element, x, y ) {
        var _rect = self.getBoundingClientRect( dom_element );
        if ( x ) {
            if ( _rect.left < x ) {
                return -1;
            }
            if ( _rect.left + _rect.width > x ) {
                return 1;
            }
        }
        if ( y ) {
            if ( _rect.top > y ) {
                return -1;
            }
            if ( _rect.top + _rect.height < y ) {
                return 1;
            }
        }
        return 0;
    };
    self.show                                 = function ( dom_element ) {
        dom_element.classList.remove( "shinken-hidden" );
    };
    self.hide                                 = function ( dom_element ) {
        dom_element.classList.add( "shinken-hidden" );
    };
    self.setEditable                          = function ( edit_content, dom_container, dom_to_edit ) {
        dom_to_edit.contentEditable = edit_content;
        if ( edit_content === true ) {
            self.focusAtTheEnd( dom_to_edit );
        }
        self.setDataSet( dom_container, "statusEdit", edit_content ? "1" : "0" );
    };
    self.focusAtTheEnd                        = function ( dom_element ) {
        dom_element.focus();
        var range = document.createRange();
        range.selectNodeContents( dom_element );
        range.collapse( false );
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange( range );
    };
    self.scrollbarIsVisible                   = function ( dom_element, axe ) {
        switch ( axe ) {
            case "height":
                return dom_element.scrollHeight > dom_element.clientHeight;
            case "width":
                return dom_element.scrollWidth > dom_element.clientWidth;
        }
    };
    self.getNavigatorZoom                     = function () {
        return Math.round( window.devicePixelRatio * 100 );
    };
    self.getFontZoomed                        = function ( font_size, zoom_percent ) {
        if ( !zoom_percent || zoom_percent === 100 ) {
            return font_size;
        }
        return parseInt( font_size * zoom_percent / 100 );
    };
    self.saveCursorPosition                   = function ( dom_element ) {
        return dom_element.selectionStart;
    };
    self.focusAndSetCursorPosition            = function ( dom_element, cursor_position ) {
        dom_element.selectionStart = cursor_position;
        dom_element.selectionEnd   = cursor_position;
        dom_element.blur();
        dom_element.focus();
    };
    self.isMouseOnScrollBar = function (event, dom_element ) {
         return event.clientX >= dom_element.clientWidth || event.clientY >= dom_element.clientHeight;
    }
    self.SimulateAction                       = {
        _doDispatch: function ( event_name, dom_element ) {
            if ( !dom_element ) {
                return;
            }
            var evt = document.createEvent( "HTMLEvents" );
            evt.initEvent( event_name, false, true );
            dom_element.dispatchEvent( evt );
        },
        mouseDown  : function ( dom_element ) {
            self.SimulateAction._doDispatch( "mousedown", dom_element );
        },
        mouseUp    : function ( dom_element ) {
            self.SimulateAction._doDispatch( "mouseup", dom_element );
        },
        keyUp      : function ( dom_element ) {
            self.SimulateAction._doDispatch( "keyup", dom_element );
        },
        click      : function ( dom_element ) {
            self.SimulateAction._doDispatch( "click", dom_element );
        }
    };
    self.computeHasScrollVertical             = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        self.addOrRemoveClasses( dom_element, self.hasScrollHeight( dom_element ), "shinken-scroll-vertical-active" );
    };
    self.computeHasScrollVerticals            = function ( selector, dom_element ) {
        if ( !selector ) {
            return;
        }
        if ( !dom_element ) {
            dom_element = document;
        }
        var _dom_s = dom_element.querySelectorAll( selector );
        for ( var i = 0, _size_i = _dom_s.length; i < _size_i; i++ ) {
            self.computeHasScrollVertical( _dom_s[ i ] );
        }
    };
    self.focusOnAnchor                        = function ( selector_css, parent_dom, animation, extra_size_for_top ) {
        return selector_css.focusOnAnchor_withDom( document.querySelector( selector_css ), parent_dom, new DOM.Service.Animation( animation, 2000 ), extra_size_for_top );
    };
    self.focusOnAnchor_withDom                = function ( dom_element, parent_dom, animation_object, extra_size_for_top ) {
        if ( !dom_element ) {
            return;
        }
        if ( parent_dom ) {
            parent_dom.classList.add( "shinken-scroll-behavior-smooth" );
            extra_size_for_top   = extra_size_for_top || 5; //-5 USED TO NOT BE STUCK ON THE TOP
            parent_dom.scrollTop = dom_element.offsetTop - extra_size_for_top;
        }
        else {
            dom_element.scrollIntoView();
        }
        switch ( animation_object.type ) {
            case 'shinken-pulsate':
                DOM.Service.askAddClass( dom_element, 'shinken-pulsate', animation_object.timer );
        }
    };
    self.focus                                = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        dom_element.focus();
    };
    self.isVisibleIntoScrollingVerticalParent = function ( dom_element, parent_scrolling_dom_element ) {
        var rect   = dom_element.getBoundingClientRect();
        var rect_2 = parent_scrolling_dom_element.getBoundingClientRect();
        return (rect.top >= rect_2.top) && (rect.bottom <= rect_2.bottom);
    };
    self.isVisibleIntoScrollingVerticalParent_Box = function ( box_dom, box_parent ) {
        return (box_dom.top >= box_parent.top) && (box_dom.bottom <= box_parent.bottom);
    };
    
    return self;
})( DOM.Service || {} );
DOM.Service.Toggle = (function ( self ) {
    "use strict";
    self.toggle              = function ( element ) {
        var dom_parent = DOM.Service.findParentElementWithClass(element, "shinken-toggle-container", 10);
        DOM.Service.toggleClass(dom_parent, "shinken-close");
    };
    return self;
})( DOM.Service.Toggle || {} );
DOM.CONST = {
    STYLE                   : {
        LEFT            : "left",
        RIGHT           : "right",
        TOP             : "top",
        BOTTOM          : "bottom",
        HEIGHT          : "height",
        MAX_HEIGHT      : "max-height",
        MAX_WIDTH       : "max-width",
        LINE_HEIGHT     : "line-height",
        WIDTH           : "width",
        Z_INDEX         : "z-index",
        DISPLAY         : "display",
        POSITION        : "position",
        BACKGROUND_COLOR: "background-color",
        PADDING         : "padding",
        MARGIN          : "margin",
        BORDER_RADIUS   : "border-radius",
        FONT_SIZE       : "font-size"
    },
    ATTRIBUTE               : {
        SCROLL_DOWN: "scrollDown",
        SCROLL_TOP : "scrollTop",
        SCROLL_LEFT: "scrollLeft"
    },
    VALUE                   : {
        NONE: "none"
    },
    SPECIAL                 : {
        MEDIAN_TOP_BOTTOM: "MEDIAN_TOP_BOTTOM"
    },
    WAITING_TIME_BEFORE_EXEC: {
        INPUT: 200
    }
};
DOM.Service.Animation = function ( type, timer ) {
    this.type  = type;
    this.timer = timer;
};
SHINKEN.TOOLS.FORM             = (function ( self ) {
    "use strict";
    self.buildGetUrl                = function ( form ) {
        var _to_return = "";
        for ( var i = 0, _size_i = form.elements.length; i < _size_i; i++ ) {
            if ( i ){
                _to_return += "&";
            }
            _to_return += form.elements[i].name + "=" + form.elements[i].value;
        }
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.FORM || {} );
SHINKEN.TOOLS.LOADING_FRAME             = (function ( self ) {
    "use strict";
    self.getHtml                = function ( id ) {
        return '<div id="'+ id +'" class="shinken-loading-frame"><div class="shinken-loading-frame-container"><h1><div class="shinken-pulsate">'+ _( 'loading_frame.load_in_progress', [DICTIONARY_COMMON_UI] )+ '</div></h1></div></div>';
    };
    return self;
})( SHINKEN.TOOLS.LOADING_FRAME || {} );
SHINKEN.NAVIGATOR = (function ( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function () {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden () {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function ( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function () {
        return navigator.isHidden;
    };
    self.init                 = function ( nb_try ) {
        var _navigator_class = '';
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
            _navigator_class    = 'shinken-navigator-is-firefox';
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
            _navigator_class   = 'shinken-navigator-is-chrome';
        }
        else if ( window.navigator.userAgent.indexOf( 'Trident' ) !== -1 ) {
            navigator.isIE   = true;
            _navigator_class = 'shinken-navigator-is-IE';
        }
        if ( document.body ) {
            document.body.classList.add( _navigator_class );
        }
        else if ( nb_try ) {
            setTimeout( function () {
                nb_try = nb_try - 1;
                SHINKEN.NAVIGATOR.init( nb_try );
            }, 1000 );
        }
    };
    self.shinken_beforeunload = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );
SHINKEN.NAVIGATOR.init( 50 );
SHINKEN.TOOLS.NUMBER = (function ( self ) {
    "use strict";
    self.roundTo                 = function ( number, precision ) {
        if ( !precision ) {
            precision = 0;
        }
        var _number = Number( number );
        return _number.toFixed( precision );
    };
    self.parseFloat              = function ( number ) {
        if ( typeof number === "string" ) {
            number = number.replace( ',', '.' );
        }
        return parseFloat( number );
    };
    self.percent                 = function ( number ) {
        return self.roundTo( number * 100, 2 );
    };
    self.getRandom               = function ( min, max ) {
        return Math.floor( Math.random() * (max - min + 1) + min );
    };
    self.percent_no_extem        = function ( number ) {
        var toReturn = self.percent( number );
        if ( toReturn === '100.00' ) {
            toReturn = 100;
            if ( number !== 1 ) //IN ORDER TO NOT BE AT 100% WHEN THE PERCENT IS ROUNDED
            {
                toReturn = 99.99;
            }
        }
        else if ( toReturn === '-100.00' ) {
            toReturn = -100;
        }
        else if ( toReturn === '0.00' ) {
            toReturn = 0;
        }
        return toReturn;
    };
    self.getPathIconSla          = function ( sla_percent, critical_threshold, warning_threshold ) {
        sla_percent        = parseFloat( sla_percent );
        critical_threshold = parseFloat( critical_threshold );
        warning_threshold  = parseFloat( warning_threshold );
        var _path          = "";
        if ( sla_percent < critical_threshold ) {
            _path = "assets/images/widget/sla/storm.svg";
        }
        else if ( sla_percent >= critical_threshold && sla_percent < warning_threshold ) {
            _path = "assets/images/widget/sla/cloud.svg";
        }
        else {
            _path = 'assets/images/widget/sla/sun.svg';
        }
        return _path;
    };
    self.getDateToFormatedNumber = function ( number_date ) {
        if ( number_date > 9 ) {
            return number_date;
        }
        return "0" + number_date;
    };
    self.getValueInInterval      = function ( value, min, max ) {
        return Math.max( Math.min( value, max ), min );
    };
    self.isNumber                = function ( value ) {
        return !isNaN( value );
    };
    self.isInteger               = function ( value ) {
        if ( isNaN( value ))  {
            return false;
        }
        return parseFloat( value ) === parseInt( value, 10 );
    };
    return self;
})( SHINKEN.TOOLS.NUMBER || {} );
var CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = null;
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    self.type             = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent       = function ( dom_event, value, displayResultCallBack ) {
        var _dom_button = DOM.Service.findParentElementWithClass( dom_event, 'shinken-button', 10 );
        setValueTextArea( value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResultCallBack ? displayResultCallBack( status, _dom_button ) : displayResult( status, _dom_button );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    self.buildHtmlButtons = function ( hasCopyButton, hasEditButton, event_name ) {
        var table_buttons = DOM.Service.createElement( "table", { class: "shinken-copy-buttons-container" } );
        var line_buttons  = DOM.Service.createElement( "tr", {} );
        if ( hasCopyButton ) {
            var button_copy_cell = DOM.Service.createElement( "td", { class: "shinken-btn-copy-cell" } );
            var button_copy      = DOM.Service.createElement( "td", {
                class             : "shinken-button shinken-btn-copy shinken-btn-copy-text",
                onclick           : 'MANAGER.EventManager.clickOnButton(event)',
                'data-status-copy': '0',
                'data-name'       : event_name ? event_name : '',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_text_copy' )
            } );
            var icon_button_copy = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinicon shinicon-copy" } );
            
            button_copy.appendChild( icon_button_copy );
            button_copy_cell.appendChild( button_copy );
            line_buttons.appendChild( button_copy_cell );
        }
        if ( hasEditButton ) {
            var button_edit_cell = DOM.Service.createElement( "td", { class: "shinken-btn-edit-cell" } );
            var button_edit      = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy",
                onclick           : 'MANAGER.EventManager.clickOnPaste(event)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_edition' )
            } );
            var icon_button_edit = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinken-icons-url shinken-icons-url-write" } );
            
            button_edit.appendChild( icon_button_edit );
            button_edit_cell.appendChild( button_edit );
            line_buttons.appendChild( button_edit_cell );
        }
        table_buttons.appendChild( line_buttons );
        return table_buttons;
    };
    
    self.doPaste = function ( event ){
        event.preventDefault();
        var clipboardData = event.clipboardData || window.clipboardData;
        var to_return  = window.clipboardData ? clipboardData.getData( 'Text' ) : clipboardData.getData( "text/plain" );
        to_return      = to_return.trim();
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            pasteHtmlForIE( SHINKEN.TOOLS.STRING.cleanXss( to_return ) );
        }
        else {
            document.execCommand( "insertHTML", false, SHINKEN.TOOLS.STRING.cleanXss( to_return ) );
        }
        return to_return;
    }
    
    init();
    
    function init () {
        setTimeout( function () {
            createDomTextArea();
        }, 1000 );
    }
    
    function createDomTextArea () {
        self.dom_textarea               = document.createElement( 'textarea' );
        self.dom_textarea.id            = 'id-shinken-copy-clipboard-container';
        self.dom_textarea.style.opacity = '0';
        var _body                       = document.querySelector( 'body' );
        _body.appendChild( self.dom_textarea );
    }
    
    
    function setValueTextArea ( to_set ) {
        self.dom_textarea.value = to_set;
    }
    
    
    function displayResult ( status, dom_button ) {
        var _text     = status ? _( 'copy_service.copySuccess' ) : _( 'copy_service.copyFail' );
        var _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        var _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    }
    
    function pasteHtmlForIE ( text_to_paste ) {
        var sel,
            range;
        
        if ( window.getSelection ) {
            sel = window.getSelection();
            if ( sel.getRangeAt && sel.rangeCount ) {
                range = sel.getRangeAt( 0 );
                range.deleteContents();
                
                var _div       = DOM.Service.createElement( "div", {}, text_to_paste );
                
                var frag = document.createDocumentFragment(),
                    node,
                    lastNode;
                
                while ( (node = _div.firstChild) ) {
                    lastNode = frag.appendChild( node );
                }
                range.insertNode( frag );
                
                if ( lastNode ) {
                    range = range.cloneRange();
                    range.setStartAfter( lastNode );
                    range.collapse( true );
                    sel.removeAllRanges();
                    sel.addRange( range );
                }
            }
        }
    }
    
    return self;
    
})( {} );
var __lang_obj        = {};
var DICTIONARY_COMMON = "common";
var DICTIONARY_COMMON_UI = "common_ui";
var __dictionary_active_name__ = __dictionary_active_name__ || "lang_";
function __gup ( name, url ) {
    if ( !url ) {
        url = location.href;
    }
    name        = name.replace( /[\[]/, "\\\[" ).replace( /[\]]/, "\\\]" );
    var regexS  = "[\\?&]" + name + "=([^&#]*)";
    var regex   = new RegExp( regexS );
    var results = regex.exec( url );
    return results == null ? null : results[ 1 ];
}
function _load_lang_obj_array ( dictionary_origin_array ) {
    for ( var i = 0, _size_i = dictionary_origin_array.length; i < _size_i; i++ ) {
        _load_lang_obj( dictionary_origin_array[ i ] );
    }
}
function _load_lang_obj ( dictionary_origin ) {
    if ( __lang_obj[ dictionary_origin ] ) {
        return;
    }
    var lang                        = __gup( 'lang' );
    lang                            = !lang ? __shinken_lang__ : lang;
    var _to_return                  = dictionary_origin !== DICTIONARY_COMMON ? __dictionary_active_name__ + dictionary_origin + '_' : __dictionary_active_name__;
    if ( dictionary_origin === DICTIONARY_COMMON_UI ){
        _to_return = DICTIONARY_COMMON_UI + "_";
    }
    _to_return += lang === 'fr' ? lang : 'en';
    __lang_obj[ dictionary_origin ] = eval( _to_return );
}
function _load_extra_lang_obj ( dictionary_origin ) {
    if ( __lang_obj[ dictionary_origin ] ) {
        return;
    }
    var lang                        = __gup( 'lang' );
    lang                            = !lang ? __shinken_lang__ : lang;
    var _to_return                  = dictionary_origin + "_";
    _to_return += lang === 'fr' ? lang : 'en';
    __lang_obj[ dictionary_origin ] = eval( _to_return );
}
function _ ( to_trad, dictionary_origin ) {
    var elts                    = to_trad.split( '.' );
    var dictionary_origin_array = !dictionary_origin ? [ DICTIONARY_COMMON ] : dictionary_origin;
    _load_lang_obj_array( dictionary_origin_array );
    
    for ( var j = 0, _size_j = dictionary_origin_array.length; j < _size_j; j++ ) {
        var _to_return = __lang_obj[ dictionary_origin_array[ j ] ][ elts[ 0 ] ];
        var _found     = true;
        for ( var i = 0, _size = elts.length; i < _size; i++ ) {
            _to_return = i !== 0 ? _to_return[ elts[ i ] ] : _to_return;
            if ( typeof _to_return === 'undefined' ) {
                _found = false;
                break;
            }
        }
        if ( _found ) {
            return _to_return;
        }
    }
    return 'TO_TRAD(' + to_trad + ')';
}
SHINKEN.TOOLS.InterfaceRefreshComponent           = function () {
};
SHINKEN.TOOLS.InterfaceRefreshComponent.prototype = {
    update      : function () {
    },
    phaseUpdated: function ( phase, parent_object ) {
        switch ( phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.READY :
                this.eventIsReady( parent_object );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STARTING :
                this.eventIsStarting( parent_object );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING :
                this.eventIsRunning( parent_object );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING :
                this.eventIsRefreshing( parent_object );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING :
                this.eventIsStopping( parent_object );
                break;
        }
    },
    setLastComputeDate: function ( to_set ) {
    },
    eventIsReady     : function ( parent_object ) {
    },
    eventIsStarting  : function ( parent_object ) {
    },
    eventIsRunning   : function ( parent_object ) {
    },
    eventIsRefreshing: function ( parent_object ) {
    },
    eventIsStopping  : function ( parent_object ) {
    },
    updateCountdown  : function ( parent_object ) {
    }
};
SHINKEN.OBJECT.JsonEditor           = function ( dom_element, json, default_tag ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonEditor';
    this.dom_element    = dom_element;
    this.json           = json;
    this.content     = null;
    this.default_tag = default_tag;
    this.init();
};
SHINKEN.OBJECT.JsonEditor.prototype = {
    init: function () {
        this.content = DOM.Service.createElement( "span", {}, this.parseToHtml( this.json ) );
        this.computeErrorContent();
    },
    
    getCurrentContent: function () {
        return this.dom_element.innerText;
    },
    computeErrorContent: function () {
        this.data_with_error = {};
        var _error_contents  = this.content.querySelectorAll( "." + SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR );
        for ( var i = 0, _size_i = _error_contents.length; i < _size_i; i++ ) {
            if ( _error_contents[ i ].dataset.jsonUuidPart ) {
                this.data_with_error[ _error_contents[ i ].dataset.jsonUuidPart ] = _error_contents[ i ].innerText;
            }
        }
    },
    parseToHtml                         : function ( to_parse ) {
        var _to_return = '';
        if ( to_parse.__class_name__  === "SHINKEN.OBJECT.Param" ) {
            var _value = to_parse.getUserValue() === undefined ? "" : to_parse.getUserValue();
            if ( typeof _value === 'string' ) {
                return this.parseStringToHtml( _value, to_parse );
            }
            else if ( typeof _value === 'number' ) {
                return this.parseNumberToHtml( _value, to_parse );
            }
            else if ( typeof _value === 'boolean' ) {
                return this.parseBooleanToHtml( _value, to_parse );
            }
            else if ( _value instanceof Array ) {
                return this.parseArrayToHtml( _value, to_parse );
            }
            return this.parseObjectToHtml( _value, to_parse );
        }
        else if ( to_parse instanceof Array ) {
            _to_return += this.parseArrayToHtml( to_parse );
        }
        else if ( typeof to_parse === 'object' ) {
            _to_return += this.parseObjectToHtml( to_parse );
        }
        else if ( typeof to_parse === 'string' ) {
            return this.parseStringToHtml( to_parse );
        }
        else if ( typeof to_parse === 'number' ) {
            return this.parseNumberToHtml( to_parse );
        }
        else if ( typeof to_parse === 'boolean' ) {
            return this.parseBooleanToHtml( to_parse );
        }
        else {
            _to_return += '{}';
        }
        return _to_return;
    },
    parseObjectToHtml                   : function ( to_parse, object_with_json_information ) {
        if ( to_parse.json_list_content ) {
            return this.parseArrayToHtml( to_parse.json_list_content, to_parse );
        }
        var _to_return = '<span class="' + this.parseJsonTagToClassCss( object_with_json_information ) + '" ' + this.parseJsonTagToAttribute( object_with_json_information ) + '>{';
        _to_return += this.buildAnchorsEntry( to_parse );
        var _keys      = Object.keys( to_parse );
        if ( _keys.length ) {
            _to_return += this.buildUlEntry( to_parse );
            var _current_key;
            _keys = Object.keys( to_parse ); //TO KEEP THERE BECAUSE THE KEYS CAN CHANGE
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _to_return += this.buildLiEntry( to_parse );
                _to_return += this.buildKeyEntry( _current_key );
                _to_return += this.parseToHtml( to_parse[ _keys[ i ] ] );
                if ( i < _keys.length - 1 ) {
                    _to_return += ",";
                }
                _to_return += "</div></li>";
            }
            _to_return += "</ul>";
        }
        _to_return += "}</span>";
        return _to_return;
    },
    parseArrayToHtmlWithListKeys        : function ( to_parse, object_with_json_information ) {
        var _to_return = "";
        var _current_list_keys;
        for ( var i = 0, _size_i = object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length; i < _size_i; i++ ) {
            _to_return += "<div>";
            _to_return += this.buildDivEntry( object_with_json_information, i );
            _current_list_keys = object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key[ i ] ].list_keys;
            if ( !_current_list_keys ) {
                continue;
            }
            for ( var j = 0, _size_j = _current_list_keys.length; j < _size_j; j++ ) {
                _to_return += this.parseArrayToHtmlWithListKeys_forKey( to_parse, _current_list_keys[ j ] );
            }
            _to_return += "</div></div>";
        }
        return _to_return;
    },
    parseArrayToHtmlWithListKeys_forKey : function ( to_parse, key ) {
        if ( to_parse[ key ][ SHINKEN.OBJECT.JsonEditor.CONST.JSON_INDEX_ALREADY_WRITE ] ) {
            return "";
        }
        var _to_return = this.buildLiEntry();
        _to_return += this.parseToHtml( to_parse[ key ] );
        if ( typeof to_parse[ key ] === "object" ) {
            to_parse[ key ][ SHINKEN.OBJECT.JsonEditor.CONST.JSON_INDEX_ALREADY_WRITE ] = true;
        }
        if ( !this.isLastIndexArrayDisplayed( to_parse ) ) {
            _to_return += ",";
        }
        _to_return += "</div></li>";
        return _to_return;
    },
    isLastIndexArrayDisplayed           : function ( array ) {
        for ( var i = 0, _size_i = array.length; i < _size_i; i++ ) {
            if ( !array[ i ][ SHINKEN.OBJECT.JsonEditor.CONST.JSON_INDEX_ALREADY_WRITE ] ) {
                return false;
            }
        }
        return true;
    },
    parseObjectToHtmlWithListKeys       : function ( to_parse ) {
        var _to_return = "";
        var _current_list_keys;
        for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length; i < _size_i; i++ ) {
            _to_return += "<div>";
            _to_return += this.buildDivEntry( to_parse, i );
            _current_list_keys = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key[ i ] ].list_keys;
            if ( !_current_list_keys ) {
                continue;
            }
            for ( var j = 0, _size_j = _current_list_keys.length; j < _size_j; j++ ) {
                _to_return += this.parseObjectToHtmlWithListKeys_forKey( to_parse, _current_list_keys[ j ] );
            }
            _to_return += "</div></div>";
        }
        return _to_return;
    },
    parseObjectToHtmlWithListKeys_forKey: function ( to_parse, key ) {
        if ( to_parse[ key ] === undefined ) {
            return ""; //PATCH if a key was already used, it is not anymore available (deleted)
        }
        var _to_return = this.buildLiEntry();
        _to_return += '<span class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
        _to_return += this.parseToHtml( to_parse[ key ] );
        delete to_parse[ key ];
        if ( Object.keys( to_parse ).length > 1 ) { // AT THIS MOMENT THERE IS AT LEAST THE PROPERTY JSON_FORMAT_INFORMATION
            _to_return += ",";
        }
        _to_return += "</div></li>";
        return _to_return;
    },
    parseArrayToHtml                    : function ( to_parse, object_with_json_information ) {
        var _to_return = '<span class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>[';
        if ( object_with_json_information && object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            _to_return = '<span class="' + this.parseJsonTagToClassCss( object_with_json_information ) + '" ' + this.parseJsonTagToAttribute( object_with_json_information ) + '>[';
        }
        if ( to_parse.length ) {
            _to_return += "<ol class='A'>";
            if ( object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] && object_with_json_information[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length ) {
                _to_return += this.parseArrayToHtmlWithListKeys( to_parse, object_with_json_information );
            }
            for ( var i = 0, _size_i = to_parse.length; i < _size_i; i++ ) {
                _to_return += this.parseArrayToHtmlWithListKeys_forKey( to_parse, i );
            }
            _to_return += "</ol>";
        }
        _to_return += ']</span>';
        return _to_return;
    },
    parseStringToHtml                   : function ( string, to_parse ) {
        if ( string === this.default_tag && !(to_parse && to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ]) ) {
            return '"<span class="X" data-default-value="' + this.default_tag + '">' + this.default_tag + '</span>"';
        }
        var string_escape = SHINKEN.TOOLS.STRING.cleanXss( string );
        return '<span class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>"' + string_escape + '"</span>';
    },
    parseBooleanToHtml                  : function ( boolean, to_parse ) {
        return this.parseNumberToHtml( boolean, to_parse );
    },
    parseNumberToHtml                   : function ( number, to_parse ) {
        return '<span class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>' + number + '</span>';
    },
    parseJsonTagToClassCss              : function ( to_parse, index ) {
        var _to_return = "";
        if ( to_parse && to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents.length; i < _size_i; i++ ) {
                if ( index !== undefined && index !== i ) {
                    continue;
                }
                _to_return += " " + (to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ i ].class || "");
            }
        }
        return _to_return;
    },
    parseJsonTagToAttribute             : function ( to_parse, index ) {
        var _to_return = "";
        if ( to_parse && to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            var _tootip = "";
            for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents.length; i < _size_i; i++ ) {
                if ( index !== undefined && index !== i ) {
                    continue;
                }
                _to_return += ' data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ i ].uuid + '"';
                _tootip += to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].contents[ i ].tooltip;
            }
            if ( _tootip ) {
                _to_return += ' onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-type="shinken-warning" shi-tip-html="' + SHINKEN.TOOLS.STRING.cleanXssForTooltipWithUserData( _tootip ) + '"';
            }
        }
        return _to_return;
    },
    buildAnchorsEntry: function ( to_parse ) {
        var _to_return = "";
        if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ] ) {
            for ( var i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ].length; i < _size_i; i++ ) {
                _to_return += '<span data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ][ i ] + '"></span>';
            }
            delete to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ];
        }
        return _to_return;
    },
    buildUlEntry     : function ( to_parse ) {
        var _to_return = "";
        if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] ) {
            if ( to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ].with_list_key.length ) {
                _to_return += '<ul class="D">';
                _to_return += this.parseObjectToHtmlWithListKeys( to_parse );
            }
            else {
                _to_return += '<ul class="D ' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>';
            }
            delete to_parse[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ];
        }
        else {
            _to_return += '<ul class="D">';
        }
        return _to_return;
    },
    buildKeyEntry    : function ( key ) {
        return '<span class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
    },
    buildLiEntry     : function ( to_parse ) {
        return '<li><div class="' + this.parseJsonTagToClassCss( to_parse ) + '" ' + this.parseJsonTagToAttribute( to_parse ) + '>';
    },
    buildDivEntry    : function ( to_parse, index ) {
        return '<div class="z' + this.parseJsonTagToClassCss( to_parse, index ) + '" ' + this.parseJsonTagToAttribute( to_parse, index ) + '>';
    },
    updateHtml            : function () {
        DOM.Service.addElementToAfterEmpty( this.content, this.dom_element );
        this.dom_element.classList.add( "shinken-json-editor-container" );
        this.dom_element.setAttribute( "contenteditable", "true" );
    },
    cleanHtmlAfterEdition : function () {
        this.updateDefaultValueHtml();
        this.removeErrorAfterUpdate();
    },
    updateDefaultValueHtml: function () {
        var _default_value_doms = this.dom_element.querySelectorAll( ".X" );
        for ( var i = 0, _size_i = _default_value_doms.length; i < _size_i; i++ ) {
            if ( _default_value_doms[ i ].innerText !== _default_value_doms[ i ].dataset.defaultValue ) {
                _default_value_doms[ i ].classList.remove( "X" );
            }
        }
    },
    removeErrorAfterUpdate: function () {
        var _keys = Object.keys( this.data_with_error );
        var _current_key;
        var _current_dom;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current_dom = this.dom_element.querySelector( '.' + SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR + '[data-json-uuid-part="' + _current_key + '"]' );
            if ( _current_dom && !this._is_same_text( _current_dom.innerText, this.data_with_error[ _current_key ] ) ) {
                _current_dom.classList.remove( SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR );
                DOM.Service.removeTooltip( _current_dom );
                delete this.data_with_error[ _current_key ];
            }
        }
        
    },
    _is_same_text         : function ( text_1, text_2 ) {
        return SHINKEN.TOOLS.STRING.replaceAll( text_1, "\n", "" ) === SHINKEN.TOOLS.STRING.replaceAll( text_2, "\n", "" );
    }
};
SHINKEN.OBJECT.JsonEditor.CONST = {
    SHINKEN_JSON_UUID_ANCHOR         : "__SHINKEN_JSON_UUID_ANCHOR_ANCHOR__",
    JSON_UNKNOWN_PROPERTY            : "__JSON_UNKNOWN_PROPERTY__",
    JSON_BAD_FORMAT_IS_NOT_AN_OBJECT : "__JSON_BAD_FORMAT_IS_NOT_AN_OBJECT__",
    JSON_INVALID_VALUE               : "__JSON_INVALID_VALUE__",
    JSON_MODIFIED_VALUE_TO_FIT_FORMAT: "__JSON_MODIFIED_VALUE_TO_FIT_FORMAT__",
    JSON_DEFAULT_VALUE_IS_OK         : "__JSON_DEFAULT_VALUE_IS_OK__",
    JSON_FORMAT_INFORMATION          : "__JSON_FORMAT_INFORMATION__",
    JSON_INDEX_ALREADY_WRITE         : "__JSON_INDEX_ALREADY_WRITE__",
    CLASS_ERROR                      : "shinken-json-error"
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.JsonEditor, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.JsonEditorService = (function ( self ) {
    "use strict";
    var __LINE_TAG__       = "__SHINKEN_LINE_TAG__";
    self.computeValidation = function ( dom_element ) {
        var _text_parsed = _parseJsonDomElementToText( dom_element );
        _text_parsed     = SHINKEN.TOOLS.STRING.replaceAll( _text_parsed, __LINE_TAG__, "\n" );
        return [_text_parsed, SHINKEN.TOOLS.STRING.JSON.isFormatJsonInvalid( _text_parsed )];
    };
    self.computeLineNumber = function ( dom_element, error_line ) {
        var _computed_style = DOM.Service.getComputedStyles( dom_element, ["padding-bottom", "padding-top", "line-height", "height"] );
        var number_line     = (dom_element.scrollHeight - _computed_style[ "padding-bottom" ] - _computed_style[ "padding-top" ]) / _computed_style[ "line-height" ];
        var _html           = '';
        for ( var i = 1, _size = number_line; i <= _size; i++ ) {
            if ( i === error_line ) {
                _html += '<div class="shinken-line-number shinken-weather-json-form-line-error" data-number="' + i + '">' + i + '</div>';
            }
            else {
                _html += '<div class="shinken-line-number" data-number="' + i + '">' + i + '</div>';
            }
        }
        var _container       = document.querySelector( '.shinken-textarea-line-nums' );
        _container.innerHTML = _html;
        if ( error_line ) {
            self.scrollToError( dom_element, error_line );
        }
        _container.style.transform = "translateY(-" + dom_element.scrollTop + "px)";
    };
    self.scrollToError     = function ( dom_element, error_line ) {
        var _computed_style = DOM.Service.getComputedStyles( dom_element, ["padding-bottom", "padding-top", "line-height", "height"] );
        dom_element.scrollTo( 0, (error_line) * _computed_style[ "line-height" ] - _computed_style[ "height" ] / 2 );
    };
    
    var _parseJsonDomElementToText = function ( dom_element ) {
        var clone    = DOM.Service.cloneElement( dom_element );
        var _text    = clone.innerHTML;
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "<li", __LINE_TAG__ + "<li" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ol>", __LINE_TAG__ + "</ol>" );
        _text        = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ul>", __LINE_TAG__ + "</ul>" );
        var _new_dom = DOM.Service.createElement( "div", {}, _text );
        var _text_2  = _new_dom.innerText;
        return SHINKEN.TOOLS.STRING.replaceAll( _text_2, __LINE_TAG__, "\n" );
    };
    
    return self;
})( SHINKEN.OBJECT.JsonEditorService || {} );
SHINKEN.OBJECT.JsonForm           = function ( dom_element ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonForm';
    this.init( dom_element );
};
SHINKEN.OBJECT.JsonForm.prototype = {
    init         : function ( dom_element ) {
        this.dom_element                     = dom_element;
        this.message_invalid                 = "";
        this.timeout_computeEditorLineNumber = null;
        this.line_invalid                    = 0;
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-anchor-json":
                var _to_return = this.dom_element.querySelector( "[data-json-uuid-part='" + param + "']" );
                DOM.Service.focusOnAnchor_withDom( _to_return, this.dom_element, new DOM.Service.Animation( "shinken-pulsate", 1600 ), 5 );
                return _to_return;
        }
    },
    
    isValid: function () {
        return !this.error_syntax;
    },
    
    getMessageInValid: function () {
        return this.message_invalid;
    },
    getText          : function () {
        return this.text;
    },
    askComputeLineNumber: function ( timeout ) {
        timeout  = timeout || 0;
        var self = this;
        if ( self.timeout_computeEditorLineNumber ) {
            clearTimeout( self.timeout_computeEditorLineNumber );
        }
        self.timeout_computeEditorLineNumber = setTimeout( function () {
            var _interval_done = setInterval( function () {
                if ( self.dom_element.scrollHeight ) {
                    SHINKEN.OBJECT.JsonEditorService.computeLineNumber( self.dom_element, self.line_invalid );
                    clearInterval( _interval_done );
                }
            }, 100 );
        }, timeout );
    },
    scrollToError       : function () {
        SHINKEN.OBJECT.JsonEditorService.scrollToError( this.dom_element, this.line_invalid );
    },
    _computeWhenInvalid : function () {
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            this.message_invalid = _( "json_editor.invalid_json_ie", [DICTIONARY_COMMON_UI] );
            return;
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isFireFox' ) ) {
            this.line_invalid = parseInt( SHINKEN.TOOLS.STRING.extractBetween( this.error_syntax.toString(), 'at line ', ' column' ) );
        }
        else {
            var _error_position = parseInt( this.error_syntax.message.replace( /[^\d.]/g, '' ) );
            var _json_error     = this.text.substring( 0, _error_position );
            this.line_invalid   = _json_error.split( "\n" ).length;
        }
        this.message_invalid = SHINKEN.TOOLS.STRING.format( _( "json_editor.invalid_json", [DICTIONARY_COMMON_UI] ), this.line_invalid );
    },
    computeIsValid      : function () {
        this.line_invalid = 0;
        var _analyze      = SHINKEN.OBJECT.JsonEditorService.computeValidation( this.dom_element );
        this.text         = _analyze[ 0 ];
        this.error_syntax = _analyze[ 1 ];
        if ( !this.isValid() ) {
            this._computeWhenInvalid();
        }
    }
};
SHINKEN.OBJECT.ShinkenObjectJson           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObjectJson';
};
SHINKEN.OBJECT.ShinkenObjectJson.prototype = {
    parseToJson       : function () {
        var _to_return = this.getObjectToJson();
        
        var _components = this.getChildrenObjectDict();
        
        
        if ( Array.isArray( _components ) ) {
            _to_return.json_list_content = [];
            for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
                _to_return.json_list_content.push( _components[ i ].parseToJson() );
            }
        }
        else {
            var _keys = Object.keys( _components );
            var _current_key;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                if ( Array.isArray( _components[ _current_key ] ) ) {
                    _to_return[ _current_key ] = [];
                    for ( var j = 0, _size_j = _components[ _current_key ].length; j < _size_j; j++ ) {
                        _to_return[ _current_key ].push( _components[ _current_key ][ j ].parseToJson() );
                    }
                }
                else if ( _components[ _current_key ].__class_name__  === "SHINKEN.OBJECT.Param" ) {
                    _to_return[ _current_key ] = _components[ _current_key ].user_value;
                }
                else if ( _components[ _current_key ] ) {
                    _to_return[ _current_key ] = _components[ _current_key ].parseToJson();
                }
            }
        }
        return _to_return;
    },
    getObjectToJson   : function () {
        var _to_return = this._getObjectToJson() || {};
        var _keys;
        var i;
        var _size;
        if ( this.unknown_property ) {
            _keys = Object.keys( this.unknown_property );
            for ( i = 0, _size = _keys.length; i < _size; i++ ) {
                _to_return[ _keys[ i ] ] = this[ _keys[ i ] ].getObjectToJson();
            }
        }
        if ( this.__class_name__  !== "SHINKEN.OBJECT.Param" ) {
            var _valid_own_property = this.getValidOwnProperty().getContent();
            for ( i = 0, _size = _valid_own_property.length; i < _size; i++ ) {
                if ( _valid_own_property[ i ].is_mandatory && typeof this[ _valid_own_property[ i ].key ] === 'undefined' ) {
                    _to_return[ _valid_own_property[ i ].key ] = "";
                }
            }
        }
        
        if ( this._json_anchor ) {
            _to_return[ SHINKEN.OBJECT.JsonEditor.CONST.SHINKEN_JSON_UUID_ANCHOR ] = this._json_anchor;
        }
        var _information = this.addJSONInformation();
        if ( _information ) {
            _to_return[ SHINKEN.OBJECT.JsonEditor.CONST.JSON_FORMAT_INFORMATION ] = _information;
        }
        return _to_return;
    },
    addJSONInformation: function () {
        var _to_return = null;
        if ( this.messages && this.messages.hasStatus() ) {
            _to_return = this.messages._getObjectToJson();
        }
        return _to_return;
    },
    _getObjectToJson  : function () {
        return {};
    },
    addJsonAnchor: function ( uuid_anchor ) {
        this._json_anchor = this._json_anchor || [];
        this._json_anchor.push( uuid_anchor );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectJson, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.NOTIFICATION       = {};
SHINKEN.OBJECT.NOTIFICATION.CONST = {
    CONTAINER: {
        ID: 'shinken-notification-popup-container'
    },
    STATUS   : {
        ERROR       : 'error',
        WARNING     : 'warning',
        INFO        : 'info',
        SUCCESS     : 'success',
        COPY_SUCCESS: 'copy_success',
        COPY_FAILED : 'copy_failed'
    },
    PLACEMENT: {
        TOP                       : 0,
        RIGHT                     : 1,
        BOTTOM                    : 2,
        LEFT                      : 3,
        SPECIFIC_TITLE_HIVE       : 4,
        SPECIFIC_TITLE_LIST       : 5,
        COPY_NOTIFICATION_SUCCESS : 6,
        COPY_NOTIFICATION_FAILED  : 7,
        SPECIFIC_COPY_WEATHER_JSON: 8
    },
    OF_CHANGE: {
        FIELD: {
            SOUND                  : "sound",
            VISUAL                 : "visual",
            BLINK                  : "blink",
            ENABLED                : "enabled",
            VOLUME                 : "volume"
        },
        VALUE: {
            DEFAULT: "default",
            ON     : "ON",
            OFF    : "OFF"
        }
    }
};
COMPONENT.Interface = function() {
};
COMPONENT.Interface.prototype = {
    initInterface: function() {
        this.url_param_key = this.dom_element.dataset.urlParamKey;
    },
    doExtraAction: function() {
        if ( this.url_param_key ) {
            this.updateUrlWithValue();
        }
    },
    updateUrlWithValue: function() {
    },
    setTooltip       : function ( to_set, type ) {
        if ( to_set ) {
            this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            this.dom_element.setAttribute( 'shi-tip-html', to_set );
            if ( type ) {
                this.dom_element.setAttribute( 'shi-tip-type', type );
            }
        }
        else {
            this.dom_element.setAttribute( 'shi-tip-html', '' );
        }
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Interface, SHINKEN.OBJECT.CounterInterface );
PROPERTY.InterfaceCommon = function () {
};
PROPERTY.InterfaceCommon.prototype = {
    initDomElement               : function ( element ) {
        this.name          = element.dataset.name;
        this.type          = element.dataset.type;
        this.dom_element   = element;
        this.default_value = element.dataset.defaultValue;
        this.parent_container  = null;
        this.is_disabled     = element.classList.contains( 'shinken-disabled' );
        this.initCounters( null, true );
        this.setIsRequired( element.dataset.isRequired );
    },
    onFocus                      : function () {
    },
    onFocusOut                   : function ( dom_element ) {
        this.___onFocusOut( dom_element );
    },
    clickOnSelector              : function ( event ) {
        event.stopPropagation();
        if ( this.is_disabled ) {
            return false;
        }
        var _target_component = this.getSelector();
        _target_component.clickOnSelector( event.target );
        this.hidePopup( _target_component );
    },
    clickOnItemSelector          : function ( key_name, dom_element, target_component ) {
        if ( this.is_disabled ) {
            return false;
        }
        if ( !target_component ) {
            target_component = this.getSelector();
        }
        this.clickOnItemSelector_end( target_component, key_name, dom_element );
    },
    clickOnItemSelector_end      : function ( target_component, key_name, dom_element ) {
        this.___clickOnItemSelector( target_component, key_name, dom_element );
    },
    clickOnInput                 : function () {
        this.hidePopup();
    },
    clickOnCheckboxInput         : function ( name ) {
        this.___clickOnCheckboxInput( name );
    },
    clickOnRadioBtn              : function ( dom_element, value ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( typeof value === "undefined" ) {
            value = dom_element.value;
        }
        this.___clickOnRadioBtn( value );
    },
    keydown                      : function ( event, key_code ) {
    },
    getName                      : function () {
        return this.name;
    },
    getLabelViaDom               : function () {
        return this.dom_element.querySelector( '.shinken-property-label .shinken-label' ).innerText;
    },
    getNameOrUUID                : function () {
        return this.getName();
    },
    getParentName                : function () {
        return this.name;
    },
    getState                     : function () {
        return this.state;
    },
    setState                     : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
    },
    setLastItemSelected          : function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    getValue                     : function () {
        return this.value
    },
    setValue                     : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet                        : function () {
        var _to_return = this.getValue();
        return !!_to_return;
    },
    setIsDisable                 : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    setIsRequired                : function ( to_set ) {
        this.is_required = to_set;
    },
    unset                        : function () {
        this.___unset();
    },
    setValueFromUser             : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    isDifferentValue             : function ( value1, value2 ) {
        return value1 !== value2 && SHINKEN.TOOLS.STRING.unescape_xss( value1 ) !== SHINKEN.TOOLS.STRING.unescape_xss( value2 );
    },
    _computeState                : function () {
    },
    hidePopup                    : function ( exception ) {
        this.___hidePopup( exception );
    },
    updateView                   : function () {
        this.___updateView();
    },
    getFlatValueLabel            : function () {
    },
    getDataToSave                : function () {
        return this.getDataToSaveFinal();
    },
    onClick                      : function () {
    },
};
PROPERTY.AbstractCommon = function () {
};
PROPERTY.AbstractCommon.prototype = {
    ___updateView          : function () {
    },
    ___unset               : function () {
    },
    getSelector            : function () {
    },
    getValue               : function () {
        console.error( "[Abstract - getValue]", "[NOT IMPLEMENTED]", this.type );
    },
    getFlatValue           : function () {
        console.error( "[Abstract - getFlatValue]", "[NOT IMPLEMENTED]", this.type );
    },
    ___clickOnItemSelector : function ( _target_component, key_name ) {
    },
    ___clickOnCheckboxInput: function ( name ) {
    },
    ___clickOnRadioBtn     : function ( value ) {
    },
    ___onFocusOut          : function ( dom_element ) {
    },
    ___hidePopup           : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, PROPERTY.AbstractCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, SHINKEN.OBJECT.CounterInterface );
SHINKEN.OBJECT.CONST.PHASE                  = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : "READY",
    WAITING_FOR_READY       : 10,
    STOPPING                : "STOPPING",
    STARTING                : 12,
    STUCK                   : 13,
    HIDDEN                  : 14,
    ASKING_ENTER_PREVIEWING : 15,
    PREVIEWING              : 16,
    ASKING_ENTER_EDITING    : 17,
    ASKING_SHOW_FORM        : 171,
    ASK_FOR_REFRESH         : 18,
    RUNNING_OK              : 19,
    RUNNING_OK_WITH_WARNING : 191,
    RUNNING_NOK             : 20,
    SAVING_AFTER_PREVIEWING : 21,
    TO_BE_DELETED           : 22,
    ASK_FOR_SAVING          : 23,
    ASK_FOR_CANCEL          : 24,
    CANCEL                  : 25,
    SAVE_DONE               : 26,
    RUNNING_WITH_WARNING    : 27,
    ASK_FOR_CLOSE           : 28,
    DISCREET_USER           : "DISCREET_USER",
    DISCREET_VIEW           : "DISCREET_VIEW",
    DISCREET_NAVIGATOR      : "DISCREET_NAVIGATOR"
};
SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT = 0;
SHINKEN.OBJECT.Phase           = function ( parent_object ) {
    this.previous_phase             = null;
    this.current_phase              = SHINKEN.OBJECT.CONST.PHASE.INIT;
    this.next_phase                 = null;
    this.parent_object              = parent_object;
    this.timeout_set_phase_callback = null;
    this.timeout_phase              = null;
    this.synchrnonized_phase_object = [];
};
SHINKEN.OBJECT.Phase.prototype = {
    setPhase            : function ( to_set ) {
        if ( this.timeout_phase ) {
            clearTimeout( this.timeout_phase );
        }
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        if ( this.dom_element ) {
            if ( this.dom_element_data_name ) {
                DOM.Service.setDataSet( this.dom_element, this.dom_element_data_name + 'CurrentPhase', this.current_phase );
                DOM.Service.setDataSet( this.dom_element, this.dom_element_data_name + 'PreviousPhase', this.previous_phase );
            }
            else {
                DOM.Service.setDataSet( this.dom_element, 'currentPhase', this.current_phase );
                DOM.Service.setDataSet( this.dom_element, 'previousPhase', this.previous_phase );
            }
        }
        this.next_phase = null;
        if ( this.parent_object ) {
            
            var _self = this;
            if ( _self.timeout_set_phase_callback ) {
                clearTimeout( _self.timeout_set_phase_callback );
            }
            _self.timeout_set_phase_callback = setTimeout( function () {
                _self.parent_object.callbackForPhase();
                _self.timeout_set_phase_callback = null;
            }, SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT );
        }
        if ( this.synchrnonized_phase_object.length ) {
            for ( var i = 0, _size_i = this.synchrnonized_phase_object.length; i < _size_i; i++ ) {
                this.synchrnonized_phase_object[ i ].setPhase( to_set );
            }
        }
    },
    setPhaseIfNotPhase  : function ( to_set, if_not ) {
        if ( this.isPhase( if_not ) ) {
            return;
        }
        this.setPhase( to_set );
    },
    setPhaseIfPhase  : function ( to_set, if_is ) {
        if ( !this.isPhase( if_is ) ) {
            return;
        }
        this.setPhase( to_set );
    },
    setPhaseWithTimeOut : function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self           = this;
        this.timeout_phase = setTimeout( function () {
            self.setPhase( to_set );
        }, timeout );
    },
    isPhase             : function ( to_test ) {
        return this.current_phase === to_test;
    },
    togglePhase         : function ( phase_1, phase_2 ) {
        if ( this.isPhase( phase_1 ) ) {
            this.setPhase( phase_2 );
        }
        else {
            this.setPhase( phase_1 );
        }
    },
    isPreviousPhase     : function ( to_test ) {
        if ( !this.previous_phase ) {
            return false;
        }
        return this.previous_phase === to_test;
    },
    setParent           : function ( parent_object ) {
        this.parent_object = parent_object;
    },
    addSynchronizedPhase: function ( to_add ) {
        this.synchrnonized_phase_object.push( to_add );
    },
    setDomElement       : function ( to_set, data_name ) {
        this.dom_element           = to_set;
        this.dom_element_data_name = data_name;
    }
};
SHINKEN.OBJECT.PhaseInterface           = function () {
};
SHINKEN.OBJECT.PhaseInterface.prototype = {
    initPhase           : function ( dom_element ) {
        this.phase = new SHINKEN.OBJECT.Phase( this );
        if ( dom_element ) {
            this.phase.setDomElement( dom_element );
        }
    },
    addSynchronizedPhase: function ( to_add ) {
        this.phase.addSynchronizedPhase( to_add );
    },
    isPhase             : function ( to_test ) {
        return this.phase.isPhase( to_test );
    },
    isInPhase           : function ( array_to_test ) {
        for ( var i = 0, _size_i = array_to_test.length; i < _size_i; i++ ) {
            if ( this.phase.isPhase( array_to_test[ i ] ) ) {
                return true;
            }
        }
        return false;
    },
    setPhase            : function ( to_set ) {
        this.phase.setPhase( to_set );
    },
    togglePhase         : function ( phase_1, phase_2 ) {
        this.phase.togglePhase( phase_1, phase_2 );
    },
    setPhaseParent      : function ( to_set ) {
        this.phase.setParent( to_set );
    },
    setPhaseDomElement  : function ( to_set, data_name ) {
        this.phase.setDomElement( to_set, data_name );
    },
    setPhaseIfNotPhase  : function ( to_set, if_not ) {
        this.phase.setPhaseIfNotPhase( to_set, if_not );
    },
    setPhaseIfPhase  : function ( to_set, if_is ) {
        this.phase.setPhaseIfPhase( to_set, if_is );
    },
    setPhaseWithTimeOut : function ( to_set, timeout ) {
        this.phase.setPhaseWithTimeOut( to_set, timeout );
    },
    getCurrentPhase     : function () {
        return this.phase.current_phase;
    },
    getPreviousPhase    : function () {
        return this.phase.previous_phase;
    },
    setPreviousPhaseForced    : function ( to_set ) {
        this.phase.previous_phase = to_set;
    },
    isPreviousPhase     : function ( to_test ) {
        return this.phase.isPreviousPhase( to_test );
    },
    callbackForPhase    : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.SLIDE_PANEL = {
    TYPE    : {
        HORIZONTAL_RIGHT: "HORIZONTAL_RIGHT",
        HORIZONTAL_LEFT : "HORIZONTAL_LEFT",
        VERTICAL_TOP    : "VERTICAL_TOP",
        VERTICAL_BOTTOM : "VERTICAL_BOTTOM"
    },
    POSITION: {
        RIGHT : "RIGHT",
        LEFT  : "LEFT",
        TOP   : "TOP",
        BOTTOM: "BOTTOM"
    },
    ACTION  : {
        PIN_TO_RIGHT : "pin-to-right",
        PIN_TO_LEFT  : "pin-to-left",
        PIN_TO_TOP   : "pin-to-top",
        PIN_TO_BOTTOM: "pin-to-bottom"
    }
};
SHINKEN.OBJECT.InterfaceSlidePanel           = function () {
};
SHINKEN.OBJECT.InterfaceSlidePanel.prototype = {
    init      : function () {
    },
    initCommon: function () {
        this.initPhase();
    },
    initSize  : function () {
    },
    openIfHasContent: function ( init_with_ratio, loading_message ) {
        if ( this.content_html ) {
            this.open( init_with_ratio, loading_message );
        }
    },
    open            : function ( init_with_ratio, loading_message ) {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
                this.computeHtml();
                this.initSize( init_with_ratio );
                if ( loading_message ) {
                    this.setLoading( loading_message );
                }
                break;
            default:
                this.askOpen();
                break;
        }
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    close           : function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
                break;
            default:
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                this.askClose();
                break;
        }
    },
    clickOnButton   : function ( event, event_name, param ) {
        switch ( event_name ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_RIGHT:
                this.pinToRight();
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_LEFT:
                this.pinToLeft();
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_TOP:
                this.pinToTop();
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_BOTTOM:
                this.pinToBottom();
                break;
        }
    },
    setLoading           : function ( to_set ) {
        if ( !this.dom_element_loading ){
            this.dom_element_loading = DOM.Service.createElement( "div", { class: "shinken-panel-loading-container" } );
            var _content = DOM.Service.createElement( "div", { class: "shinken-panel-loading-content" } );
            this.dom_element_loading_message = DOM.Service.createElement( "div", { class: "shinken-panel-loading-message" } );
            var _icon    = DOM.Service.createElement( "div", { class: "shinken-panel-loading-icon" }, '<span class="shinkon shinkon-reload"></span>' );
            DOM.Service.addElementTo( this.dom_element_loading_message, _content );
            DOM.Service.addElementTo( _icon, _content );
            DOM.Service.addElementTo( _content, this.dom_element_loading );
        }
        this.dom_element_loading_message.innerHTML =  to_set;
        this.setContent( this.dom_element_loading );
    },
    setContent           : function ( to_set ) {
        this.content_html = to_set;
        DOM.Service.addElementToAfterEmpty( this.content_html, this.getDomElement() );
        this.computeSizes();
    },
    setName              : function ( to_set ) {
        this.name = to_set;
    },
    getName              : function () {
        return this.name;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setMainPartDomElement: function ( to_set ) {
        this.dom_element_parent    = to_set.parentElement;
        this.dom_element_main_part = to_set;
    },
    computeAfterResize: function ( width, height ) {
    },
    computeSizes      : function () {
    },
    getCurrentRatio   : function () {
    },
    
    onDragStart: function ( origin_x, origin_y ) {
        this.origin_x = origin_x;
        this.origin_y = origin_y;
    },
    onDragMove : function ( delta_x, delta_y ) {
        switch ( this.type ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT:
                this.computeAfterDragMove( -delta_x );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT:
                this.computeAfterDragMove( delta_x );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP:
                this.computeAfterDragMove( delta_y );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM:
                this.computeAfterDragMove( -delta_y );
                break;
        }
        
    },
    onDragStop : function () {
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceSlidePanel, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceSlidePanel, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.COMUNICATION = (function ( self ) {
    "use strict";
    self.requestGet      = function ( url, success, error, not_found_callback, unauthorized_callback ) {
        var request = new XMLHttpRequest();
        
        request.open( 'GET', url, true );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send();
    };
    self.requestPost     = function ( url, data, success, error, not_found_callback, unauthorized_callback ) {
        var request            = new XMLHttpRequest();
        self._success_callback = success;
        
        request.open( 'POST', url, true );
        request.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8' );
        request.onload  = self.onRequestSuccess( success, not_found_callback, unauthorized_callback );
        request.onerror = error || self.onRequestError;
        request.send( data );
    };
    self.requestPostJSON = function ( url, data ) {
        var request = new XMLHttpRequest();
        request.open( 'POST', url, true );
        request.setRequestHeader( 'Content-Type', "application/json;charset=UTF-8" );
        request.send( data );
    };
    self.onRequestError  = function () {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( "error", SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    };
    
    self.onRequestSuccess = function ( success, not_found_callback, unauthorized_callback ) {
        return function () {
            var _data = JSON.parse( this.response );
            switch ( this.status ) {
                case COMMUNICATION.CODE.UNAUTHORIZED:
                    _do_action_401( unauthorized_callback, _data );
                    return;
                case COMMUNICATION.CODE.INTERNAL_SERVER_ERROR:
                    _do_action_500( _data );
                    return;
                default:
                    switch ( _data.rc ) {
                        case COMMUNICATION.CODE.UNAUTHORIZED:
                            _do_action_401( unauthorized_callback, _data );
                            return;
                        case COMMUNICATION.CODE.NOT_FOUND:
                            if ( not_found_callback ) {
                                not_found_callback( this.status, _data );
                                return;
                            }
                            break;
                    }
                    break;
            }
            success( this.status, _data );
        };
    };
    var _do_action_401    = function ( unauthorized_callback, data ) {
        if ( unauthorized_callback ) {
            unauthorized_callback( COMMUNICATION.CODE.UNAUTHORIZED, data );
            
        }
    };
    var _do_action_500    = function ( data ) {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( data, SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    };
    return self;
})( SHINKEN.COMUNICATION || {} );
SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT = (function ( self ) {
    "use strict";
    self.informParentIframeUrlChange = function ( controller_name ) {
        try {
            window.parent.CONTROLLER.UiVisualisation.iframeChangeUrl( window.location.href, controller_name );
        }
        catch ( e ) {
        }
    };
    self.redirectIfNeeded            = function () {
        var need_redirect = false;
        try {
            if ( window.parent.CONTROLLER.UiVisualisation === undefined ) {
                need_redirect = true;
            }
        }
        catch ( e ) {
            need_redirect = true;
        }
        if ( need_redirect ) {
            SHINKEN.HIGHWAY.goTo( window.location.href.replace( window.location.origin, window.location.origin + "/static/ui/index.html#" ) );
        }
    };
    self.clickDone                   = function (event) {
        try {
            window.parent.CONTROLLER.UiVisualisation.clickDoneOnIframe(event);
        }
        catch ( e ) {
        }
    };
    self.doActionAfter               = function ( event_name, param ) {
        try {
            window.parent.CONTROLLER.UiVisualisation.doActionAfter( event_name, param );
        }
        catch ( e ) {
            try {
                window.parent.window.parent.CONTROLLER.UiVisualisation.doActionAfter( event_name, param ); //FOR THE WEATHER...
            }
            catch ( e ) {
            }
        }
    };
    
    return self;
})( SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT || {} );
SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD = (function ( self ) {
    "use strict";
    self.doActionAfter = function ( id_iframe, event_name, callback_to_eval ) {
        try {
            var _iframe          = DOM.BodyService.getDomElement().querySelector( "#" + id_iframe );
            var _controller_name = _iframe.contentWindow.document.querySelector( ".shinken-parent-event-listener" ).dataset.controller;
            var _controller      = _iframe.contentWindow.MANAGER.DistributorControllerManager.getController( _controller_name );
            _controller.doActionAfter( event_name, callback_to_eval );
        }
        catch ( e ) {
            console.error( e );
        }
    };
    
    return self;
})( SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD || {} );
SHINKEN.COMUNICATION.CONST = {
    QUERY: {
        SEPARATOR: {
            GET_BEGINNER: '?',
            GET_ADD     : '&',
            PARAM_SETTER: '=',
            SLASH       : '/'
        },
        PARAMETER: {
            SHINKEN_TIMESTAMP: "shinken-timestamp",
            WIDTH            : "width",
            HEIGHT           : "height"
        },
        GET      : {
            LICENCE           : "/api/key",
            DASHBOARD         : "/screen/dashboard",
            LIST_CONFIG       : "/screen/list",
            LIST_ALL_DATAS    : "/api/list-elements-all",
            LIST_EVENTS       : "/event-container",
            HIVE              : "/screen/hive",
            HIVE_ALL_ELEMENT  : "/api/state/elements",
            HOST              : "/api/host/",
            SERVICE           : "/api/service/",
            ELEMENTS_RECHECKED: "/api/elements_rechecked",
            SHARE             : "/share",
            LIST_HOSTS        : {
                KEY             : "/lookup/",
                FILTER_CHECK    : "with_checks_only",
                FILTER_CHECK_OFF: 0,
                FILTER_CHECK_ON : 1
            },
            LIST_CHECK        : {
                KEY            : "/lookup-service/",
                KEY_WITH_METRIC: "api/widget/graphs/checks-with-metrics/"
            },
            USER              : {
                KEY: "/user"
            },
            USERS             : {
                KEY: "/users"
            },
            IS_SERVER_READY   : "/api/is_backend_available",
            DETAIL_HISTORIC   : {
                KEY                  : "/inner/history/",
                RANGES               : "ranges/",
                BEGIN                : "start",
                END                  : "end",
                DATE                 : "date",
                DISPLAY_FULL_RANGES  : "display_full_ranges",
                CURRENT_RANGE_DISPLAY: "current_range_display",
                RANGES_PAGE_SIZE     : "ranges_page_size",
                MAX_RANGE_DISPLAY    : "max_range_display"
            },
            DETAIL_GRAPHS     : {
                KEY       : "/api/graphs/panel/detail/loading/",
                METRIC    : 'metric',
                WIDTH_HOST: 'width_host'
            },
            WIDGET            : {
                CATALOG: "/api/widgets/"
            },
            WEATHER           : {
                BASIC_STATISTICS: "/service-weather/api/V1/get-basic-statistics"
            },
            DEP_GRAPH         : {
                DEEP: "/deep"
            }
        },
        PUT      : {
            SHARE: "/share"
        },
        POST     : {
            SHARE         : "share",
            ACTION_COMMAND: {
                URL             : "action",
                TYPE_COMMAND    : "type_action",
                ELEMENT_ID      : "element_id",
                ARGS            : "args",
                CONFIGURATION_ID: "configuration_id"
            },
            WEATHER       : {
                CREATION: "/service-weather/api/V1/create"
            }
        },
        TIMER    : {
            RECHECK_TIME_MANAGE: 5000,
            RECHECK_INTERVAL   : 2000
        }
    }
};
SHINKEN.NETWORK            = {
    HTTP_CODE : {
        NONE                       : -1,
        _200_SUCCESS               : 200,
        _400_BAD_REQUEST           : 400,
        _401_UNAUTHORIZED          : 401,
        _403_FORBIDDEN             : 403,
        _404_NOT_FOUND             : 404,
        _409_CONFLICT              : 409,
        _410_CONFIGURATION_OUTDATED: 410,
        _500_INTERNAL_ERROR        : 500,
        _514_MODULE_NOT_WORKING    : 514
    },
    ERROR_TYPE: {
        USER_SWITCHED: "userSwitched"
    },
    ADRESSES  : {
        LOCALHOST : "localhost",
        _127_0_0_1: "127.0.0.1",
        HTTP      : "http://",
        HTTPS     : "https://"
    },
    URL_STATUS: {
        VALID            : "valid",
        WRONG_FORMAT_HTTP: "format_unvalid_http"
    }
    
};
SHINKEN.HIGHWAY = (function ( self ) {
    "use strict";
    self.goToParentUrl                  = function () {
        var _floors        = location.pathname.split( '/' );
        var _new_path_name = "";
        var _size          = _floors.length;
        for ( var i = 1; i < _size - 1; i++ ) {
            _new_path_name += "/";
            _new_path_name += _floors[ i ];
        }
        switch ( _new_path_name ) {
            case "":
            case "/elements/my_working_area":
            case "/elements/working_area":
            case "/elements":
            case "/analyzers":
            case "/tagger":
            case "/elements/add":
                _new_path_name = "/main";
                break;
            case "/sources":
                _new_path_name = "/main";
                var _params    = this.getParams();
                if ( _params[ 'conf-id' ] || _params[ 'synchronizer-id' ] ) {
                    delete _params[ 'conf-id' ];
                    delete _params[ 'synchronizer-id' ];
                    delete _params[ 'source-name' ];
                    _new_path_name = this.getPathWithoutOrigin() + window.SHINKEN.HIGHWAY.buildParamsToUrl( _params );
                }
                break;
            case "/elements/add/working_area":
                _new_path_name = "/elements/working_area/hosts";
                break;
            case "/sources/server-analyzer/discovery":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
            case "/sources/server-analyzer/discovery/add":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery/add":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
        }
        switch ( location.pathname ) {
            case "/elements/add/cluster":
            case "/elements/add/clustertpl":
            case "/elements/add/hosttpl":
            case "/elements/add/hostgroup":
            case "/elements/add/serviceshost":
            case "/elements/add/serviceshosttpl":
            case "/elements/add/servicescluster":
            case "/elements/add/servicesclustertpl":
            case "/elements/add/servicetpl":
            case "/elements/add/contact":
            case "/elements/add/contacttpl":
            case "/elements/add/contactgroup":
            case "/elements/add/escalation":
            case "/elements/add/notificationway":
            case "/elements/add/command":
            case "/elements/add/businessimpactmodulation":
            case "/elements/add/macromodulation":
            case "/elements/add/resultmodulation":
            case "/elements/add/timeperiod":
                _new_path_name = "/elements/" + _floors[ _size - 1 ] + 's';
                break;
        }
        window.location = location.origin + _new_path_name;
    };
    self.goToElementTab                 = function ( tab_name ) {
        var _path     = self.getPath();
        var _params   = self.getParams();
        var _old_name = _params[ 'tab' ];
        if ( _old_name === tab_name ) {
            return;
        }
        _params[ 'tab' ]       = tab_name;
        var _new_params_string = self.buildParamsToUrl( _params );
        self.changeUrl( _path + _new_params_string );
    };
    self.changeUrl                      = function ( new_url ) {
        new_url = new_url || location.pathname;
        window.history.pushState( "object or string", "Title", new_url );
    };
    self.getOrigin                      = function () {
        return location.origin;
    };
    self.getHost                        = function () {
        return location.host;
    };
    self.getHash                        = function () {
        return location.hash;
    };
    self.getHostName                    = function () {
        return location.hostname;
    };
    self.getPath                        = function () {
        return location.origin + this.getPathWithoutOrigin();
    };
    self.getPathFull                    = function () {
        return self.getPath() + self.buildParamsToUrl( self.getParams() );
    };
    self.getPathOrigin                  = function () {
        return location.origin;
    };
    self.getPathWithoutOrigin           = function () {
        return location.pathname;
    };
    self.getPathWithParamsWithoutOrigin = function () {
        return location.pathname + self.buildParamsToUrl( self.getParams() );
    };
    self.buildParamsToUrl               = function ( params ) {
        var _keys = Object.keys( params );
        var _size = _keys.length;
        if ( !_size ) {
            return '';
        }
        var _to_return = COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                _to_return += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            }
            _to_return += _keys[ i ] + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + params[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.getParams                      = function ( param ) {
        var vars = {};
        window.location.href.replace( location.hash, '' ).replace(
            /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
            function ( m, key, value ) { // callback
                vars[ key ] = value !== undefined ? value : '';
            }
        );
        
        if ( param ) {
            return vars[ param ] ? vars[ param ] : null;
        }
        return vars;
    };
    self.is                             = function ( type ) {
        switch ( type ) {
            case COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT: //PATCH BUG 4022 TO REMOVE
                return location.pathname === "/elements/elements";
            case COMMUNICATION.PAGE_TYPE.LIST_WORKING_AREA:
                return location.pathname === "/elements/working_area/hosts" || location.pathname === "/elements/my_working_area/hosts";
        }
    };
    self.getListType                    = function () {
        var _to_return = self.getPath().split( "/" );
        return _to_return[ _to_return.length - 1 ];
    };
    self.getNavigationType              = function ( event ) {
        if ( !event ) {
            return SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NORMAL;
        }
        switch ( event.which ) {
            case 1:
                return event.ctrlKey ? SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.TARGET_BLANK : SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NORMAL;
            case 2:
                return SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.TARGET_BLANK;
        }
        return SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NONE;
    };
    self.goTo                           = function ( url, event ) {
        var _navigation_type = self.getNavigationType( event );
        switch ( _navigation_type ) {
            case SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.TARGET_BLANK:
                return self.goToBlank( url, event );
            case SHINKEN.HIGHWAY.CONST.NAVIGATION_TYPE.NORMAL:
                if ( event ) {
                    event.stopPropagation();
                    event.preventDefault();
                }
                window.location = url;
                break;
        }
    };
    self.goToBlank                      = function ( url, event ) {
        if ( event ) {
            event.stopPropagation();
            event.preventDefault();
        }
        window.open( url, '_blank' ).focus();
    };
    self.refreshCurrentPage             = function () {
        location.reload();
    };
    self.removeItemIdFromHistory        = function ( item_id ) {
        var histories = App.HistoryManager.histories();
        for ( var i = histories.length - 1; i >= 0; i-- ) {
            var _previousUrl = histories[ i ];
            if ( SHINKEN.TOOLS.STRING.contains( _previousUrl, item_id ) ) {
                histories.splice( i, 1 );
            }
        }
        App.HistoryManager.setHandlers();
    };
    self.setParam                       = function ( param_key, param_value ) {
        var params = self.getParams();
        if ( param_value ) {
            params[ param_key ] = SHINKEN.TOOLS.STRING.urlEncode( param_value );
        }
        else {
            delete params[ param_key ];
        }
        self.changeUrl( self.buildParamsToUrl( params ) );
    };
    self.handleResponse                 = function ( status ) {
        switch ( status ) {
            case COMMUNICATION.CODE.UNAUTHORIZED:
                SHINKEN.HIGHWAY.goTo( '/user/login?error=' + _( 'login.invalid_user' ) );
                break;
            default:
                break;
        }
    };
    self.isDocumentationOn              = function () {
        return typeof __shinken_documentation_on__ !== 'undefined';
    };
    return self;
})( SHINKEN.HIGHWAY || {} );
SHINKEN.HIGHWAY.CONST = {
    NAVIGATION_TYPE: {
        TARGET_BLANK: "TARGET_BLANK",
        NORMAL      : "NORMAL",
        NONE        : "NONE"
    }
};
SHINKEN.OBJECT.NotificationsOfChange = {};
SHINKEN.OBJECT.NotificationsOfChange._interface = function () {
};
SHINKEN.OBJECT.NotificationsOfChange._interface.prototype = {
    init     : function ( data ) {
        this.timeout_ask_play_notification = null;
        if ( data ) {
            this.updateData( data );
        }
    },
    initPhase: function () {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( "init_phase" );
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( "reset_object" );
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].initPhase();
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "ask_play_notifications":
                if ( this.timeout_ask_play_notification ) {
                    clearTimeout( this.timeout_ask_play_notification );
                }
                var self = this;
                this.timeout_ask_play_notification = setTimeout( function (  ) {
                    self.doActionAfter( "ask_play_notification_visual_blink", param );
                    self.doActionAfter( "ask_play_notification_of_sound", param );
                }, 200 );
                break;
            case "shinken_view_set_has_change":
                this.shinken_view_has_change = param;
                break;
            case "notification-configuration-set-dom-element-with-data":
            case "init_with_dom_element":
            case "click_done":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( event_name, param );
                break;
            case "change_value_notification_of_change_visual_blink":
            case "user_has_disabled_blink_notification":
            case "ask_play_notification_visual_blink":
            case "shinken_view_has_disabled_blink_notification":
            case "set_phase_blink_depending_number_of_change":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                break;
            case "ask_play_notification_of_sound":
            case "change_value_notification_of_change_sound":
            case "shinken_view_has_disabled_sound_notification":
            case "user_has_volume_muted_notification":
            case "set_phase_sound_depending_number_of_change":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( event_name, param );
                break;
            default:
                console.log( "[_interface - doActionAfter]", "[not managed case]", event_name, param );
                break;
        }
    },
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND:
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL:
                this[ key ].updateData( value );
                break;
            default:
                console.warn( "[NotificationsOfChange]", "[IGNORED DATA]", "[" + key + "]", value );
        }
    },
    getSoundValue               : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getValue();
    },
    getVolumeValue              : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getValue();
    },
    getBlinkValue               : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].getBlinkValue();
    },
    getDataToSave: function () {
        var _to_return                                                         = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ]  = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getDataToSave();
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ] = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].getDataToSave();
        return _to_return;
    }
};
SHINKEN.OBJECT.Dropdown = SHINKEN.OBJECT.Dropdown || {};
SHINKEN.OBJECT.Dropdown._interface           = function () {
};
SHINKEN.OBJECT.Dropdown._interface.prototype = {
    init: function ( dom_element_target, dom_element_content, placement ) {
        this.initPhase();
        this.setDomTargetElement( dom_element_target );
        this.dom_element_content = dom_element_content;
        this.placement           = placement || SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
        this.uuid                = SHINKEN.TOOLS.STRING.buildUUID();
    },
    getUUID  : function () {
        return this.uuid;
    },
    getMaxTry: function () {
        return SHINKEN.OBJECT.Dropdown.CONST.MAX_TRY_IN_SCREEN;
    },
    getClass : function () {
        return "shinken-dropdown-container";
    },
    show     : function () {
        if ( !this.getDomElement() ) {
            this.initDomElement();
        }
        this._show();
        
    },
    _show    : function () {
        this.try = 0;
        this.getSize();
        this.setPosition();
    },
    
    initDomElement: function () {
        this.setDomElement( DOM.Service.createElement( "div", { "id": this.getUUID(), "class": this.getClass() }, SHINKEN.OBJECT.Dropdown.CONST.HTML ) );
        this.setPhaseDomElement( this.getDomElement() );
        DOM.BodyService.addChild( this.getDomElement() );
        DOM.Service.addElementTo( this.dom_element_content, this.getDomElement().querySelector( ".shi-tip-text" ) );
        this.doActionAfter( "do_action_after_init_dom_element" );
    },
    
    getSize               : function () {
        var _sizes  = this.getDomElement().getBoundingClientRect();
        this.width  = _sizes.width;
        this.height = _sizes.height;
    },
    doPlacementArrow      : function () {
    },
    setPosition           : function () {
        var _rect = this.dom_element_target.getBoundingClientRect();
        
        this.computePosition( _rect, _rect.width );
        
        if ( this.isInScreen() ) {
            if ( this.try > this.getMaxTry() ) {
                this.computePosition( _rect, _rect.width );
            }
            var self         = this;
            this.timeout_pop = setTimeout( function () {
                self.getDomElement().style.top  = self.pos_top + 'px';
                self.getDomElement().style.left = self.pos_left + 'px';
                DOM.Service.setDataSet( self.getDomElement(), "dataPlacement", self.placement );
                self.getDomElement().classList.remove( "shinken-no-opacity" );
                self.doPlacementArrow();
            }, 10 );
        }
        else {
            this.setPosition();
        }
    },
    setPositionAfterResize: function () {
        var _rect = this.dom_element_target.getBoundingClientRect();
        this.computePosition( _rect, _rect.width );
        if ( this.isInScreen() ) {
            this.getDomElement().style.top  = this.pos_top + 'px';
            this.getDomElement().style.left = this.pos_left + 'px';
        }
        else {
            this.setPosition();
        }
    },
    setDomTargetElement   : function ( to_set ) {
        this.dom_element_target = to_set;
    },
    computeAfterResize    : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            this.setPositionAfterResize();
        }
    },
    computePosition       : function ( _rect, _width_rect ) {
        switch ( this.placement ) {
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                this.pos_top  = (_rect.top - this.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = (_rect.left + _width_rect / 2 - this.width / 2);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                this.pos_top  = (_rect.top - this.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = _rect.left - this.width + _width_rect + 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                this.pos_top  = (_rect.top - this.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = _rect.left - 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                this.pos_top  = (_rect.top + _rect.height / 2 - this.height / 2);
                this.pos_left = (_rect.left - this.width);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                this.pos_top  = (_rect.top + _rect.height / 2 - this.height / 2);
                this.pos_left = (_rect.left + _width_rect);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                this.pos_top  = (_rect.bottom - SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = (_rect.left + _width_rect / 2 - this.width / 2);
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                this.pos_top  = (_rect.bottom - SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE);
                this.pos_left = _rect.left - 2 * SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                break;
            case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                this.pos_top  = _rect.top + _rect.height + SHINKEN.OBJECT.Dropdown.CONST.STYLE.ARROW_SIZE;
                this.pos_left = _rect.left + _width_rect / 2 - this.width;
                break;
            default:
                console.warn( "[shi-type]", this.placement, "NOT MANAGED" );
        }
    },
    isInScreen            : function () {
        var _to_return     = true;
        var _left_parent   = -10;
        var _right_parent  = window.innerWidth - 10;
        var _top_parent    = -10;
        var _bottom_parent = window.innerHeight - 10;
        
        
        
        if ( this.pos_left < _left_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (this.pos_left + this.width) > _right_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( this.pos_top < _top_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (this.pos_top + this.height) > _bottom_parent ) {
            _to_return = false;
            switch ( this.placement ) {
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.LEFT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_LEFT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_LEFT;
                    break;
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.BOTTOM_RIGHT:
                case SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.RIGHT:
                    this.placement = SHINKEN.OBJECT.Dropdown.CONST.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        this.try++;
        if ( this.try > this.getMaxTry() ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            _to_return = true;
        }
        return _to_return;
    },
    
    parseFormToObject: function ( to_set ) {
        if ( to_set === "ON" ) {
            return true;
        }
        if ( to_set === "OFF" ) {
            return false;
        }
        return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
    },
    parseObjectToForm: function ( to_set ) {
        if ( to_set === true ) {
            return "ON";
        }
        if ( to_set === false ) {
            return "OFF";
        }
        return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
    },
    
    
    
    
    
    
    callbackForPhase: function () {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.show();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                break;
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown._interface, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Dropdown._interface, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.Dropdown.CONST = {
    PLACEMENT        : {
        LEFT        : 'left',
        RIGHT       : 'right',
        TOP         : 'top',
        TOP_LEFT    : 'top-left',
        TOP_RIGHT   : 'top-right',
        BOTTOM      : 'bottom',
        BOTTOM_LEFT : 'bottom-left',
        BOTTOM_RIGHT: 'bottom-right'
    },
    STYLE            : {
        ARROW_SIZE: 5
    },
    MAX_TRY_IN_SCREEN: 10,
    
    HTML: '<table>' +
          '<tr>' +
          '<td></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-top-left"><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-left"></div></td>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-middle"></div></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-top-right"><div class="shi-tip-arrow tooltip-arrow-top" id="tooltip-arrow-top-right"></div></td>' +
          '<td></td>' +
          '</tr>' +
          '<tr>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-left" id="tooltip-arrow-left-middle"></div></td>' +
          '<td colspan="3"><div class="shi-tip-text"></div></td>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-right" id="tooltip-arrow-right-middle"></div></td>' +
          '</tr>' +
          '<tr>' +
          '<td></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-bottom-left"><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-left"></div></td>' +
          '<td><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-middle"></div></td>' +
          '<td class="shinken-cell-arrow-side shinken-arrow-bottom-right"><div class="shi-tip-arrow tooltip-arrow-bottom" id="tooltip-arrow-bottom-right"></div></td>' +
          '<td></td>' +
          '</tr>' +
          '</table>'
};
SHINKEN.OBJECT.SoundNotificationOfChange           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.SoundNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "init_with_dom_element":
                if ( this.getDomElement() ) {
                    return;
                }
                if ( !param ) {
                    return;
                }
                this.setDomElement( param.querySelector( ".shinken-sound-notification-container" ) );
                this.setPhaseDomElement( param, "soundNotification" );
                break;
            case "change_value_notification_of_change_sound":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED, param );
                break;
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "shinken_view_has_disabled_sound_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "user_has_volume_muted_notification":
                this.setPhaseSpecific( SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER );
                break;
            case "set_phase_sound_depending_number_of_change":
                this.setPhaseSpecific( param ? SHINKEN.OBJECT.CONST.PHASE.READY : SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
            case "ask_play_notification_of_sound":
                this.flat_user_volume = param;
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.READY );
                break;
            case "ask_simulate_play_notification_of_sound":
                this.simulatePlayAudio( param );
                break;
            case "reset_object":
                this.setDomElement();
                break;
            case "click_done":
                SHINKEN_TOOLTIP.hideTooltip();
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR ) ) {
                    this.setPhase( this.getPreviousPhase() );
                    return;
                }
                break;
        }
    },
    getValue         : function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
    },
    playAudio        : function () {
        var audio    = MANAGER.DistributorResourcesManager.getInstance().getResource( "global_sound_notification" ).getContent();
        var _self    = this;
        audio.volume = this.flat_user_volume / 100;
        audio.play().then(
            function success ( response ) {
                _self.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
            },
            function error ( response ) {
                console.error( response );
                _self.setPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR );
            } );
    },
    simulatePlayAudio: function ( value ) {
        var audio    = MANAGER.DistributorResourcesManager.getInstance().getResource( "global_sound_notification" ).getContent();
        audio.volume = value / 100;
        audio.pause();
        audio.currentTime = 0;
        audio.play();
    },
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED:
                if ( typeof value === "object" ) {
                    this[ key ] = value.value;
                }
                else {
                    this[ key ] = value;
                }
                break;
        }
    },
    setPhaseSpecific: function ( to_set ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR ) ) {
            this.setPreviousPhaseForced( to_set );
        }
        else {
            this.setPhase( to_set );
        }
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        this.setTooltipHtml( "" );
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.playAudio();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER:
                this.setTooltipHtml( _( "notification.sound_user_warning", [DICTIONARY_COMMON_UI] ) );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR:
                this.setTooltipHtml( _( "notification.sound_navigator_warning", [DICTIONARY_COMMON_UI] ) );
                SHINKEN_TOOLTIP.showTooltip( this.getDomElement() );
                break;
            default:
                break;
        }
    },
    getDataToSave: function () {
        var _to_return                                                          = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] = this.getValue();
        return _to_return;
    },
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #sound-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SoundNotificationOfChange, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SoundNotificationOfChange, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN_LIST.Filter           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.Filter.prototype = {
    init          : function () {
        this._is_active = false;
    },
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.Select( this.dom_element, this.type, false, this );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
            case COMPONENT.CONST.TYPE.INPUT_STRING_ARRAY:
                this.component = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input-table" ), this );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.component = new COMPONENT.InputWithDropDown( this.dom_element, this, true );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_NOT_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS );
                break;
        }
    },
    setType          : function ( to_set ) {
        switch ( to_set ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                to_set = COMPONENT.CONST.TYPE.SINGLE_SELECT;
                break;
        }
        this.type = to_set;
    },
    getUUID          : function () {
        return this.getName();
    },
    isValid          : function () {
        return (this.name && this.type);
    },
    isSet            : function () {
        this._computeState();
        return this.isActive();
    },
    getParentName    : function () {
        return this.name;
    },
    getValue         : function () {
        return this.component ? this.component.getValue() : "";
    },
    getName          : function () {
        return this.name;
    },
    getFinalValue    : function () {
        return this.component.getFinalValue();
    },
    setActive        : function ( to_set ) {
        to_set = !!to_set;
        if ( to_set ) {
            this.dom_element.classList.add( 'shinken-active' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
        }
        this._is_active = to_set;
    },
    isActive         : function () {
        return !!this._is_active;
    },
    setValue         : function ( to_set ) {
        this.component.setValueFromJs( to_set );
    },
    getListElement   : function () {
        return this.component.getListElement();
    },
    getChildrenObject: function () {
        if ( !this.component ) {
            return [];
        }
        return [this.component];
    },
    initWhenInputReady: function () {
        var self = this;
        setTimeout( function () {
            self.component.validateValueInput();
            self._computeState();
            DOM.Service.setDataSet( self.dom_element, 'inputStatus', self.component.getStatus() );
        }, 300 );
    },
    clickOnSelector        : function () {
        this.component.clickOnSelector();
    },
    clickOnItemSelector    : function ( key_name, dom_element, selector, event ) {
        this.component.clickOnItemSelector( '', key_name, event );
        this._computeState();
        this.hidePopup();
        
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component.computeTitle();
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                if ( CONTROLLER.List ) {
                    var forced = !(key_name !== '');
                    CONTROLLER.List.getFilterAndReload( forced );
                }
                break;
        }
    },
    doChangeFilterSelect   : function () {
        this.component.doChangeFilterSelect();
    },
    askComputeAfterChange  : function ( dom_element, parent, args ) {
        this.component.askComputeAfterChange( dom_element, parent || this, args );
    },
    doActionAfterChange    : function ( args ) {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.LABEL:
                return;
        }
        this._computeState();
        if ( this.component ) {
            this.component.computeAfterChange();
            DOM.Service.setDataSet( this.dom_element, 'inputStatus', this.component.getStatus() );
        }
        switch ( args.controller_name ) {
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                CONTROLLER.List.updateCleanButtonStatus();
                break;
        }
    },
    clickChangeFilterSelect: function () {
        this.component.clickChangeFilterSelect();
    },
    clickOnInput           : function () {
        this.component.clickOnInput();
    },
    hidePopup              : function (exception) {
        if ( exception === this ){
            return;
        }
        this.setNeedValidation( true );
        this.doActionAfterChange( {} );
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component.hidePopup();
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.component.hidePopup();
                break;
        }
    },
    _computeState          : function () {
        var _value = this.getValue();
        if ( _value === SHINKEN_LIST.CONST.FILTER.ALL ) {
            _value = false;
        }
        this.setActive( !!_value );
    },
    validateValueInput     : function () {
        this.component.validateValueInput();
    },
    keydown                : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
                if ( this.component.hasAutoSelect() ) {
                    event.stopPropagation();
                    event.preventDefault();
                    this.component.validSelectedOrFirstElement();
                }
                else {
                    this.component.finishActionBeforeReload();
                    CONTROLLER.List.getFilterAndReload( true );
                }
                break;
            default:
                this.component.keydown( event, key_code );
        }
    },
    applySiblingSettings: function ( list_filter ) {
        this.component.applySiblingSettings( list_filter.component );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN_LIST.Filters           = function () {
    this.init();
};
SHINKEN_LIST.Filters.prototype = {
    init: function () {
        this.initContents();
    },
    getActiveFilters: function () {
        var _to_return = [];
        var _keys      = Object.keys( this.contents );
        var _current_key;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSet() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( dom_element, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getContentByUUID( _parent_dom_element.dataset.name ).askComputeAfterChange( dom_element, parent || this, { 'type': _type } );
                break;
        }
    },
    onClick              : function ( event ) {
        var _filter = this.getContentByEvent( event );
        this.hidePopup(_filter);
    },
    clickOnSelector      : function ( event ) {
        var _filter = this.getContentByEvent( event );
        this.hidePopup(_filter);
        if ( _filter ) {
            _filter.clickOnSelector();
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _option             = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getContentByUUID( _parent_dom_element.dataset.name ).clickOnItemSelector( _option.dataset.keyName, _parent_dom_element, false, event );
                break;
        }
    },
    clickOnInput      : function ( event ) {
        var _filter = this.getContentByEvent( event );
        if ( _filter ) {
            _filter.clickOnInput();
        }
    },
    getObjectsType       : function () {
        return "shinken-list-filter";
    },
    applySiblingSettings: function ( list_filters ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].applySiblingSettings( list_filters.contents[ _keys[ i ] ] );
        }
    },
    hidePopup: function ( filter_exception ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].hidePopup( filter_exception );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filters, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN_LIST.Header           = function () {
    this.init();
};
SHINKEN_LIST.Header.prototype = {
    init: function ( dom_element ) {
    },
    hidePopup: function () {
    },
    getUUID: function () {
        return this.uuid || this.name;
    },
    getObjectType    : function () {
        return "shinken-list-header";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Header, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN_LIST.Headers           = function () {
    this.initContents();
};
SHINKEN_LIST.Headers.prototype = {
    getActiveSortingHeaders: function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            var _index = this.contents[ i ].getSortingIndex();
            if ( _index ) {
                _to_return[_index - 1] = this.contents[ i ];
            }
        }
        return _to_return;
    },
    getObjectsType: function () {
        return "shinken-list-header";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Headers, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN_LIST.LineCell           = function () {
    this.init();
};
SHINKEN_LIST.LineCell.prototype = {
    init                  : function () {
    },
    getValue              : function () {
        return this.value || SHINKEN_LIST.CONST.FILTER.EMPTY;
    },
    getLabel              : function () {
        return this.label;
    },
    setValue              : function ( to_set ) {
        this.value = to_set;
    },
    getValueForApplyFilter: function () {
        return this.getValue();
    },
    setSortingValue       : function ( value ) {
        this.sorting_value = value;
    },
    getSortingValue       : function ( value ) {
        return this.sorting_value;
    },
    cancelUserModification: function () {
    },
    changeDomElementContent: function () {
        this.computeLabel();
        this.dom_element_content.innerHTML = this.getLabel();
    },
    computeLabel           : function () {
        this.label = this.getValue();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCell, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN_LIST.Line           = function () {
    this.init();
};
SHINKEN_LIST.Line.prototype = {
    init: function () {
        this.initContents();
        this.initPhase();
    },
    clickOnInput         : function ( event ) {
        var _cell = this.getContentByEvent( event );
        if ( _cell ) {
            _cell.clickOnInput();
        }
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _cell = this.getContentByDomElement( dom_element );
        if ( _cell ) {
            _cell.askComputeAfterChange( dom_element, parent );
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _cell = this.getContentByEvent( event );
        if ( _cell ) {
            _cell.clickOnItemSelector( event );
        }
    },
    getContentByDomElement: function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, 'shinken-list-cell', 20 );
        if ( !_parent_dom_element ) {
            return null;
        }
        return this.getContentByUUID( _parent_dom_element.dataset.uuid );
    },
    getContentByEvent     : function ( event ) {
        return this.getContentByDomElement( event.target );
    },
    applyFilter                                        : function ( filters ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.getCellValueForApplyFilter( filters[ i ].getName() );
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                    _filter = this.getFilterStatusForSingleSelect( _value_filter, _value_cell, _filter );
                    break;
                case COMPONENT.CONST.TYPE.STRING_INPUT:
                case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                    _filter = this.getFilterStatusForInputString( _value_filter, _value_cell, _filter );
                    break;
                case COMPONENT.CONST.TYPE.INPUT_STRING_ARRAY:
                    _filter = this.getFilterStatusForInputStringArray( _value_filter, _value_cell, _filter );
                    break;
            }
        }
        this.setFilter( _filter );
    },
    getFilterStatusForSingleSelect                         : function ( _value_filter, _value_cell, _filter ) {
        if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
            return _filter;
        }
        else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
            if ( Array.isArray( _value_cell ) ) {
                if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                }
            }
            else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
            return _filter;
        }
        if ( Array.isArray( _value_cell ) ) {
            if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_cell !== _value_filter ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    },
    getFilterStatusForInputString: function ( _value_filter, _value_cell, _filter) {
        if ( SHINKEN.TOOLS.STRING.contains( _value_filter, "&" ) ) {
            var _values_filters = _value_filter.split( "&" );
            var _found          = false;
            for ( var j = 0, _size_j = _values_filters.length; j < _size_j; j++ ) {
                if ( SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _values_filters[ j ] ) ) {
                    _found = true;
                }
            }
            if ( !_found ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_filter === '=""' ) {
            if ( _value_cell ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_filter === '!=""' ) {
            if ( !_value_cell ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( _value_filter, "!" ) ) {
            if ( SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter.substr( 1 ) ) ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( !SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter ) ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    },
    getFilterStatusForInputStringArray                     : function ( _value_filter, _value_cell, _filter) {
        var _list  = _value_filter.split( "," );
        var _found = false;
        for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
            if ( _list[ j ] === _value_cell ) {
                _found = true;
                break;
            }
        }
        if ( !_found ) {
            return SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        else {
            return _filter;
        }
    },
    setFilter                                          : function ( to_set ) {
        this.is_filtered = to_set;
        switch ( this.is_filtered ) {
            case SHINKEN_LIST.CONST.FILTER.STATUS.ON:
                DOM.Service.addClasses( this.dom_element, "shinken-is-filtered" );
                break;
            case SHINKEN_LIST.CONST.FILTER.STATUS.OFF:
                DOM.Service.removeClasses( this.dom_element, "shinken-is-filtered" );
                break;
        }
        this.doActionAfterFilterChange();
    },
    doActionAfterFilterChange                          : function () {
    },
    isFiltered                                         : function () {
        return this.is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.ON;
    },
    getUUID                   : function () {
        return this.uuid;
    },
    toggleSelect              : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected             : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        if ( this.checkbox ) {
            this.checkbox.setChecked( this.is_selected );
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter    : function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet                : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.getCellValue( if_key ), if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.getCellValue( if_key ), if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected                : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered      : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    isCollapsedOrFiltered     : function () {
        if ( this.is_filtered ) {
            return true;
        }
        return this.is_collapse;
    },
    getData                   : function ( key ) {
        return this.dom_element.dataset[ key ];
    },
    getCellValue              : function ( key ) {
        return this.getContentByUUID( key ).getValue();
    },
    getCellValueForApplyFilter: function ( key ) {
        return this.getContentByUUID( key ).getValueForApplyFilter();
    },
    changeElementValue        : function ( key, to_set ) {
        if ( this.getContentByUUID( key ) !== undefined ) {
            this.dom_element.querySelector( '.shinken-list-cell[data-filter="' + key + '"]' ).innerHTML = to_set;
        }
    },
    simulateToggleSelect      : function () {
        this.dom_element.click();
    },
    isSibling                 : function ( list_line ) {
        return (list_line.parent_uuid === this.parent_uuid && list_line.uuid === this.uuid);
    },
    setIndexOriginal          : function ( to_set ) {
        this.index_origin = to_set;
    },
    toggleCollapse        : function ( childrens ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
            childrens[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, childrens ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( childrens ) {
            for ( var i = 0, _size_i = childrens.length; i < _size_i; i++ ) {
                childrens[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    simulateToggleCollapse: function () {
        DOM.Service.SimulateAction.click( this.dom_element.querySelector( ".shinken-collapse-listener" ) );
    },
    getDataToExport             : function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = headers.length; i < _size_i; i++ ) {
            _to_return.push( this.getCellValue( headers[ i ] ) || "" );
        }
        return _to_return;
    },
    updateAfterActionDoneOK     : function ( action ) {
        this.setMessages();
        var _current = this.getContentByUUID( this.parseToFindCellUuid( action.key ) );
        _current.updateAfterActionDoneOK( action );
        this.addMessages( _current.getMessages() );
        this.extraActionAfterActionDoneOK( action );
    },
    extraActionAfterActionDoneOK: function ( action ) {
    },
    extraActionAfterDone        : function ( data ) {
    },
    updateAfterActionDoneNOK    : function ( action ) {
        this.setMessages();
        var _current = this.getContentByUUID( this.parseToFindCellUuid( action.key ) );
        _current.updateAfterActionDoneNOK( action );
        this.addMessages( _current.getMessages() );
    },
    parseToFindCellUuid         : function ( key ) {
        return key;
    },
    applySiblingSettings  : function ( list_line ) {
        if ( this.isSelected() !== list_line.isSelected() ) {
            this.simulateToggleSelect();
        }
        if ( this.is_collapse !== list_line.is_collapse ) {
            this.simulateToggleCollapse();
        }
        DOM.Service.applySiblingSettings( this.dom_element, list_line.dom_element );
    },
    cancelUserModification: function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).cancelUserModification();
        }
    },
    remove                : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
        this.resetCounters();
    },
    getObjectsType        : function () {
        return "shinken-list-cell";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN_LIST.Lines           = function () {
};
SHINKEN_LIST.Lines.prototype = {
    init: function () {
        this.initContents();
    },
    clickOnSelector      : function ( event ) {
        var _line = this.getContentByEvent( event );
        if ( _line ) {
            _line.clickOnSelector( event );
        }
    },
    clickOnInput         : function ( event ) {
        var _line = this.getContentByEvent( event );
        if ( _line ) {
            _line.clickOnInput( event );
        }
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        var _line = this.getContentByDomElement( dom_element );
        if ( _line ) {
            _line.askComputeAfterChange( dom_element, parent );
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _line = this.getContentByEvent( event );
        if ( _line ) {
            _line.clickOnItemSelector( event );
        }
    },
    getContentByDomElement  : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, 'shinken-list-line', 60 );
        if ( !_parent_dom_element ) {
            return null;
        }
        return this.getContentByUUID( _parent_dom_element.dataset.uuid );
    },
    getContentByEvent       : function ( event ) {
        if ( !event ) {
            return;
        }
        return this.getContentByDomElement( event.target );
    },
    updateAfterActionsDone  : function ( data ) {
        this.setMessages();
        var _current_action;
        for ( var k = 0, _size_k = data[ "results" ].length; k < _size_k; k++ ) {
            _current_action = data[ "results" ][ k ];
            if ( _current_action[ "action_done" ] ) {
                this.updateAfterActionDoneOK( _current_action, data );
            }
            else {
                this.updateAfterActionDoneNOK( _current_action, data );
            }
        }
        var _line = this.getContentByUUID( data[ "uuid" ] );
        if ( _line ) { //WE TEST BECAUSE THE LINE CAN BE DELETED
            _line.extraActionAfterDone( data );
        }
    },
    updateAfterActionDoneOK : function ( action, data ) {
        var _current = this.getContentByUUID( data[ "uuid" ] );
        switch ( action.key ) {
            case SHINKEN_LIST.CONST.ACTION.REMOVE:
                this.removeContent( data[ "uuid" ] );
                break;
            case SHINKEN_LIST.CONST.ACTION.CHANGE_OWNER:
                _current.updateAfterActionDoneOK( action );
                this.addMessages( _current.getMessages() );
                break;
            default:
                _current.updateAfterActionDoneOK( action );
                break;
        }
    },
    updateAfterActionDoneNOK: function ( action, data ) {
        var _current = this.getContentByUUID( data[ "uuid" ] );
        switch ( action.key ) {
            case SHINKEN_LIST.CONST.ACTION.CHANGE_OWNER:
                _current.updateAfterActionDoneNOK( action );
                if ( _current.isPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_DELETED ) ) {
                    this.removeContent( data[ "uuid" ] );
                }
                this.addMessages( _current.getMessages() );
                break;
            default:
                _current.updateAfterActionDoneNOK( action );
                this.addMessages( _current.getMessages() );
                break;
        }
    },
    setSelectAllData       : function ( to_set ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setIsSelected( to_set );
        }
    },
    getNbSelected          : function () {
        return this.getSelected().length;
    },
    getSelected            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSelected() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getNotSelected         : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].is_selected !== SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getSizeNotFiltered     : function () {
        return this.getNotFiltered().length;
    },
    setAllLinesDataSet     : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
        }
    },
    isAllActiveLineSelected: function () {
        var _nb_active = 0;
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ].isSelectedOrFiltered();
            switch ( _current ) {
                case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                    _nb_active++;
                    break;
                case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                    return false;
            }
        }
        return !!_nb_active;
    },
    applyFilter   : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
    },
    hideAllLines  : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
        }
    },
    getNotFiltered: function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isFiltered() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    applySorting     : function ( active_headers ) {
        if ( active_headers.length ) {
            var _current_is_increasing;
            var _value_1;
            var _value_2;
            for ( var i = active_headers.length - 1; i >= 0; i-- ) {
                _current_is_increasing = active_headers[ i ].getSortingStatus() === SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING;
                this.contents.sort( function ( a, b ) {
                    _value_1 = _current_is_increasing ? b : a;
                    _value_2 = _current_is_increasing ? a : b;
                    _value_1 = _value_1.getContentByUUID( active_headers[ i ].name ).getSortingValue();
                    _value_2 = _value_2.getContentByUUID( active_headers[ i ].name ).getSortingValue();
                    if ( _value_1 === _value_2 ) {
                        return 0;
                    }
                    if ( _value_1 > _value_2 ) {
                        return -1;
                    }
                    return 1;
                } );
            }
        }
        else {
            this.contents.sort( function ( a, b ) {
                return a.index_origin - b.index_origin;
            } );
        }
        this.displayDomByOrder();
        this.computeMapping();
    },
    displayDomByOrder: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            DOM.Service.addElementWithIndex( this.contents[ i ].getDomElement(), this.getDomElement(), i );
        }
    },
    getDataToExport: function ( headers ) {
        var _to_return = [];
        var _to_add;
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered ) {
                continue;
            }
            _to_return.push( _current.getDataToExport( headers ) );
        }
        return _to_return;
    },
    applySiblingSettings  : function ( list_lines ) {
        var _current;
        for ( var i = 0, _size_i = list_lines.contents.length; i < _size_i; i++ ) {
            _current = this.getSiblingElement( list_lines.contents[ i ] );
            if ( _current ) {
                _current.applySiblingSettings( list_lines.contents[ i ] );
            }
        }
    },
    getSiblingElement     : function ( list_line ) {
        for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
            if ( this.contents[ j ].isSibling( list_line ) ) {
                return this.contents[ j ];
            }
        }
        return null;
    },
    cancelUserModification: function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).cancelUserModification();
        }
    },
    getObjectsType        : function () {
        return "shinken-list-line";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Lines, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
"use strict";
SHINKEN_LIST.Set           = function () {
    this.init();
    this.edit_mode = false;
};
SHINKEN_LIST.Set.prototype = {
    init: function () {
    },
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
        this.lines.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        var _type = args[ "type" ];
        switch ( _type ) {
            case "shinken-list-filter":
                this.applyFilter();
                break;
            case "shinken-hide-all-element":
                this.lines.hideAllLines();
                break;
            case "shinken-list-sorting":
                this.lines.applySorting( this.headers.getActiveSortingHeaders() );
                break;
        }
    },
    doActionAfter    : function (event_name, param ) {
        this._doActionAfter(event_name, param)
    },
    _doActionAfter    : function (event_name, param ) {
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.getContentByUUID( name ).toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.lines.toggleCollapse( uuid );
        this.setIsCollapseAllData( this.lines.isAllActiveLineCollapsed() );
    },
    clickOnSelector      : function ( event, param ) {
        this._clickOnSelector( event, param );
    },
    _clickOnSelector      : function ( event, param  ) {
        this.filters.clickOnSelector( event, param  );
        this.lines.clickOnSelector( event, param  );
    },
    clickOnInput         : function ( event ) {
        this.filters.clickOnInput( event );
        this.lines.clickOnInput( event );
    },
    clickOnItemSelector  : function ( event, parent_name, element ) {
        this._clickOnItemSelector(event, parent_name, element)
    },
    _clickOnItemSelector  : function ( event, parent_name, element ) {
        this.filters.clickOnItemSelector( event, parent_name, element );
        this.lines.clickOnItemSelector( event, parent_name, element );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, "name", 20 );
        this.doActionAfterChange( { "type": _parent_dom_element.dataset.objectType } );
    },
    onClick              : function ( event ) {
        this._onClick(event);
    },
    _onClick              : function ( event ) {
        if ( this.lines ) {
            this.lines.onClick( event );
        }
        if ( this.headers ) {
            this.headers.onClick( event );
        }
        if ( this.filters ) {
            this.filters.onClick( event );
        }
    },
    addLineWithData: function ( data ) {
        this.lines.addLineWithData( data, this.headers );
        this.updateHtml();
    },
    applyFilter: function () {
        this.lines.applyFilter( this.filters.getActiveFilters() );
        this.setSelectAllStatus();
    },
    setHeaders: function ( to_set ) {
        this.headers = to_set;
    },
    setFilters: function ( to_set ) {
        this.filters = to_set;
    },
    setLines  : function ( to_set ) {
        this.lines = to_set;
    },
    setIsCollapseAllData  : function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData       : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus    : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
        if ( this.checkbox ) {
            this.checkbox.setChecked( this.is_all_data_selected );
        }
    },
    selectAllData         : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines      : function () {
        return this.lines.getSelected();
    },
    getFirstSelectedLine  : function () {
        var _to_return = this.getSelectedLines();
        if ( _to_return.length ) {
            return _to_return[ 0 ];
        }
        return null;
    },
    getNotSelectedLines   : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet    : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    removeLine            : function ( uuid ) {
        this.lines.remove( uuid );
        this.updateHtml();
    },
    getLineByUUID         : function ( uuid ) {
        return this.lines.getContentByUUID( uuid );
    },
    getSum                : function ( header_name ) {
        var _to_return = 0;
        var _lines     = this.lines.getNotFiltered();
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _to_return += parseInt( _lines[ i ].getCellValue( header_name ) || 0 );
        }
        return _to_return;
    },
    getSumBy              : function ( header_name, header_value ) {
        var _to_return = {};
        var _lines     = this.lines.getNotFiltered();
        var _current;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _current = _lines[ i ].getCellValue( header_name );
            if ( !_to_return[ _current ] ) {
                _to_return[ _current ] = 0;
            }
            _to_return[ _current ] += parseInt( _lines[ i ].getCellValue( header_value ) || 0 );
        }
        return _to_return;
    },
    toggleEditionMode     : function () {
        this.edit_mode = !this.edit_mode;
        this.selectAllData( this.edit_mode ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
    },
    updateAfterActionsDone: function ( data ) {
        this.setMessages();
        this.lines.updateAfterActionsDone( data );
        this.addMessages( this.lines.getMessages() );
    },
    hidePopup             : function ( _filter ) {
        if ( this.headers ) {
            this.headers.hidePopup( _filter );
        }
        if ( this.filters ) {
            this.filters.hidePopup( _filter );
        }
        if ( this.lines ) {
            this.lines.hidePopup( _filter );
        }
    },
    updateHtml            : function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    applySiblingSettings  : function ( list_set ) {
        this.filters.applySiblingSettings( list_set.filters );
        this.lines.applySiblingSettings( list_set.lines );
    },
    cancelUserModification: function () {
        this.lines.cancelUserModification();
    },
    getDataToSave  : function ( type ) {
        return this.lines.getDataToSave( type );
    },
    getDataToExport: function () {
        var _to_return     = [];
        var _headers_name  = [];
        var _headers_label = [];
        for ( var i = 0, _size_i = this.headers.length; i < _size_i; i++ ) {
            _headers_name.push( this.headers[ i ].name );
            _headers_label.push( this.headers[ i ].label );
        }
        _to_return.push( _headers_label );
        return SHINKEN.TOOLS.ARRAY.concat( _to_return, this.lines.getDataToExport( _headers_name ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.ShinkenObjectHtml );
"use strict";
CONTROLLER.CommonUI = (function ( self ) {
    "use strict";
    self.controller_name = MANAGER.CONST.CONTROLLER.COMMON_UI;
    self.init            = function () {
    };
    self.clickOnButton   = function ( event, event_name, param ) {
        switch ( event_name ) {
            case "close_popup_progress_bar":
                var _dom_element_parent = DOM.Service.findParentElementWithClass( event.target, "shinken-popup-progress-bar-container", 10 );
                DOM.Service.setDataSet( _dom_element_parent, 'currentPhase', SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "toggle_display_popup_progress_bar_message":
                var _dom_element_parent   = DOM.Service.findParentElementWithClass( event.target, "shinken-popup-progress-bar-container", 10 );
                var _is_message_displayed = _dom_element_parent.dataset.messageDisplayed === "1";
                DOM.Service.setDataSet( _dom_element_parent, 'messageDisplayed', _is_message_displayed ? "0" : "1" );
                break;
        }
        if ( event_name ) {
            event.stopPropagation();
        }
    };
    
    
    return self;
})
( CONTROLLER.CommonUI || {} );
COMPONENT.InterfaceButton           = function () {
};
COMPONENT.InterfaceButton.prototype = {
    init: function ( dom_element ) {
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltip( _tooltip_by_state );
        }
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    addClass         : function ( to_add ) {
        this.dom_element.classList.add( to_add );
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltip       : function ( to_set, type ) {
        if ( to_set ) {
            this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            this.dom_element.setAttribute( 'shi-tip-html', to_set );
            if ( type ) {
                this.dom_element.setAttribute( 'shi-tip-type', type );
            }
        }
        else {
            this.dom_element.setAttribute( 'shi-tip-html', '' );
        }
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, COMPONENT.Interface );
COMPONENT.Button           = function ( dom_element, name ) {
    this.__class_name__ = 'COMPONENT.Button';
    this.uuid   = SHINKEN.TOOLS.STRING.buildUUID();
    this.state  = COMPONENT.CONST.BTN_STATE.OFF;
    this.status = COMPONENT.CONST.BTN_STATUS.NONE;
    this.name   = name;
    this.value  = '';
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement: function () {
        this.value = this.dom_element.value;
        if ( this.dom_element.classList.contains( 'shinken-error' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.ERROR;
        }
        else if ( this.dom_element.classList.contains( 'shinken-warning' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.WARNING;
        }
    },
    _computeState: function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, COMPONENT.InterfaceButton );
COMPONENT.ButtonFromData = function ( event_name, class_to_add ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.init( event_name, class_to_add );
};
COMPONENT.ButtonFromData.prototype = {
    init       : function ( event_name, class_to_add ) {
        this.name         = event_name;
        this.class_to_add = class_to_add;
        this.state        = COMPONENT.CONST.BTN_STATE.OFF;
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-label " + this.class_to_add, onclick: "MANAGER.EventManager.clickOnButton(event, '" + this.name + "' )" }, "" ) );
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltip( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonFromData, COMPONENT.InterfaceButton );
COMPONENT.Checkbox           = function ( dom_element, parent ) {
    this.init( dom_element, parent );
};
COMPONENT.Checkbox.prototype = {
    init                       : function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initCounters( parent );
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ), this );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ), this );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ), this );
        this.initInterface();
    },
    toggleCheckedUser          : function () {
        var _value = !this.isCheckedUser();
        this.setCheckedUser( _value );
    },
    isCheckedUser              : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance       : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault           : function () {
        return this.checkbox_default.isChecked();
    },
    setCheckedUser             : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
        this.doExtraAction();
    },
    setCheckedInheritance      : function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    getChildrenObject              : function () {
        return [this.checkbox_user, this.checkbox_inherited, this.checkbox_default];
    },
    updateUrlWithValue         : function () {
        var _value = this.isCheckedUser() ? '1' : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Checkbox, COMPONENT.Interface );
COMPONENT.Generic           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Generic.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement: function () {
        this.value = this.dom_element.dataset.value;
    },
    _computeState : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        this.setState( this.dom_element.classList.contains( "shinken-active" ) ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
    },
    getUUID       : function () {
        return this.getValue();
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.setClassWithState();
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    setClassWithState: function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    getValue         : function () {
        return this.value;
    },
    setValue         : function ( to_set ) {
        this.value = to_set;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Generic, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Generic, COMPONENT.Interface );
COMPONENT.InputRange           = function ( dom_element, property ) {
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init: function ( dom_element ) {
        this.dom_element_parent    = dom_element;
        this.dom_input_range       = dom_element.querySelector( ".shinken-range-container input" );
        this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
        this.value                 = 0;
        this.min                   = this.dom_input_range.min;
        this.max                   = this.dom_input_range.max;
        this.unit                  = dom_element.dataset.unit;
    },
    doActionAfter   : function ( event_name, param ) {
        switch ( event_name ) {
            case "value_changed":
                this.setValue( this.dom_input_range.value );
                break;
        }
    },
    setValue        : function ( to_set ) {
        this.value = to_set;
        this.updateLabel();
        DOM.Service.setDataSet( this.dom_element_parent, "value", to_set );
    },
    setValueFromUser: function ( to_set ) {
        this.dom_input_range.value = to_set;
        this.setValue( to_set );
    },
    updateLabel     : function () {
        var _to_set = this.value + this.unit;
        this.component_label_input.updateLabel( _to_set );
    },
    getValue: function () {
        return this.value;
    },
    getUnit : function () {
        return this.unit || "";
    },
    setDefaultValue: function ( to_set ) {
        this.dom_element_parent.setAttribute( "data-default-value", to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );
COMPONENT.InterfaceInputWithDropDown           = function () {
};
COMPONENT.InterfaceInputWithDropDown.prototype = {
    init: function () {
    },
    keydown              : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.select.validSelectedOrFirstElement();
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, key_code ) ) {
                    event.preventDefault();
                    event.stopPropagation();
                }
        }
    },
    askComputeAfterChange: function ( dom_element, parent, args ) {
        this.input.askComputeAfterChange( dom_element, this, args );
    },
    clickOnItemSelector  : function ( parent_name, key_name, event ) {
        if ( event ) {
            event.stopPropagation();
        }
        if ( !key_name && event ) {
            var _dom_parent = DOM.Service.findParentElementWithClass( event.target, "shinken-option", 20 );
            if ( _dom_parent ) {
                key_name = _dom_parent.dataset.keyName;
            }
        }
        var _previous_value     = this.input.getValue();
        var first_part          = _previous_value.substring( 0, this.first_separator );
        var second_part         = _previous_value.substring( this.last_separator, _previous_value.length );
        var _is_specific_option = false;
        if ( event ) {
            var _parent_dom = DOM.Service.findParentElementWithDataSet( event.target, 'type', 10 );
            if ( _parent_dom && _parent_dom.dataset.type === 'is-always-visible' ) {
                _is_specific_option = true;
            }
        }
        if ( _is_specific_option ) {
            this.input.setValueFromJs( key_name );
        }
        else {
            this.input.setValueFromJs( first_part + key_name + second_part );
        }
        this.setCurrentFilter( true );
    },
    clickOnInput         : function () {
        this.setCurrentFilter();
    },
    setIsProtected    : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? "password" : this.type );
    },
    setPlaceholder    : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder = to_set;
        this.input.setPlaceholder( to_set );
    },
    setValidationRules: function ( _to_set ) {
        this.input.setValidationRules( _to_set );
    },
    hasBeenChanged    : function () {
        return this.current_value !== this.original_value;
    },
    getParentName     : function () {
        return this.parent.getParentName();
    },
    getChildrenObject : function () {
        return [this.input];
    },
    getValue          : function () {
        return this.input.getValue();
    },
    setValueFromJs    : function ( to_set ) {
        this.input.setValueFromJs( to_set );
    },
    getFinalValue     : function () {
        if ( this.timeout_ask_compute_after_change ) {
            clearTimeout( this.timeout_ask_compute_after_change );
            this.computeAfterChange();
        }
        return this.getValue();
    },
    setCurrentFilter  : function ( focus_on_last_separator, bypass_do_filter, validation_done ) {
        if ( this.select.list_element.list.length > 0 ) {
            this.select.openSelector();
        }
        var _value           = this.input.getValue();
        var _previous_filter = this.current_filter ? this.current_filter : "";
        var _cursor_position = this.input.dom_element_input.selectionStart;
        this.first_separator = 0;
        this.last_separator  = _value.length;
        
        var _in_quotes = false;
        for ( var i = 0; i < _cursor_position; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.first_separator = i + 1;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        for ( i = _cursor_position; i < _value.length; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.last_separator = i;
                break;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        
        if ( (this.first_separator) >= this.last_separator ) {
            this.current_filter = "";
        }
        else {
            this.current_filter = _value.substring( this.first_separator, this.last_separator ).trim();
        }
        if ( focus_on_last_separator ) {
            this.input.restoreCursorLocation( this.last_separator );
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( this.current_filter, "=" ) ) {
            this.current_filter = this.current_filter.substring( 1 );
        }
        if ( this.use_quotes ) {
            this.current_filter = this.current_filter.replace( /"/g, '' );
        }
        this.select.setResearchDisplay( this.current_filter );
        if ( !bypass_do_filter || this.current_filter !== _previous_filter ) {
            this.select.doFilter( this.current_filter );
        }
        if ( !validation_done ) {
            this.validateValueInput();
        }
    },
    hasAutoSelect     : function () {
        return this.select.hasAutoSelect();
    },
    getDataSetLink    : function () {
        return this.select.getDataSetLink();
    },
    getListElement    : function () {
        return this.select.getListElement();
    },
    getStatus         : function () {
        return this.input.getStatus();
    },
    addValidationRule : function ( to_add, type ) {
        this.input.addValidationRule( to_add, type );
    },
    computeAfterChange: function ( validation_done ) {
        this.setCurrentFilter( false, !this.input.need_validation, validation_done );
    },
    hidePopup: function () {
        this.select.hidePopup();
    },
    validSelectedOrFirstElement: function () {
        this.select.validSelectedOrFirstElement();
    },
    validateValueInput         : function () {
        this.input.validateValueInput();
    },
    finishActionBeforeReload   : function () {
        this.input.finishActionBeforeReload();
    },
    doActionAfterChange        : function () {
        this.computeAfterChange();
    },
    isReallyInQuotes           : function ( in_quotes ) {
        return this.use_quotes ? in_quotes : false;
    },
    applySiblingSettings: function ( component ) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInputWithDropDown, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInputWithDropDown, SHINKEN.OBJECT.CounterInterface );
COMPONENT.InputWithDropDown           = function ( dom_element, parent, use_quotes, type ) {
    this.init( dom_element, parent, use_quotes, type );
};
COMPONENT.InputWithDropDown.prototype = {
    init: function ( dom_element, parent, use_quotes, type ) {
        this.parent = parent;
        this.initCounters( parent );
        this.type            = type;
        this.dom_element     = dom_element;
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.input           = new COMPONENT.Input( this.dom_element.querySelector( '.shinken-input-table' ), parent || this, true );
        this.select          = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container' ), COMPONENT.CONST.TYPE.SINGLE_SELECT, false, this, false, true );
        this.separators      = this.dom_element.dataset.separator.split( "$^$" );
        this.separator_regex = new RegExp( "[" + this.separators.join( "" ) + "]" );
        if ( use_quotes == undefined ) {
            use_quotes = false;
        }
        this.use_quotes = !!use_quotes;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDown, COMPONENT.InterfaceInputWithDropDown );
COMPONENT.InputWithDropDownFomData           = function ( type ) {
    this.type = type;
    this.init();
};
COMPONENT.InputWithDropDownFomData.prototype = {
    init: function () {
        this.uuid      = SHINKEN.TOOLS.STRING.buildUUID();
        this.input     = new COMPONENT.InputFromData();
        this.select    = new COMPONENT.SelectFromData( COMPONENT.CONST.TYPE.SINGLE_SELECT );
        this.data_name = "";
    },
    setOptionsFromArray: function ( to_set ) {
        this.select.setOptionsFromArray( to_set );
    },
    addOption          : function ( to_add ) {
        this.select.addOption( to_add );
    },
    setPlaceholder     : function ( to_set ) {
        this.input.setPlaceholder( to_set );
    },
    computeHtml: function () {
        this.input.computeHtml();
        this.select.computeHtml();
        this.dom_element = DOM.Service.createElement( "div",
            {
                class              : "shinken-list-select-input shinken-list-filter-container",
                "data-type"        : "input-string-with-dropdown",
                "data-name"        : this.data_name || "input-string-with-dropdown",
                "data-input-status": "shinken-no-status"
            }
        );
        DOM.Service.addElementTo( this.input.dom_element, this.dom_element );
        DOM.Service.addElementTo( this.select.dom_element, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDownFomData, COMPONENT.InterfaceInputWithDropDown );
COMPONENT.InterfaceInput           = function () {
    this.__class_name__ = 'COMPONENT.Input';
    this.init();
};
COMPONENT.InterfaceInput.prototype = {
    init: function () {
    },
    clickOnInput           : function () {
    },
    hasFocus         : function () {
        return DOM.Service.hasFocus( this.dom_element_input );
    },
    getDomValue      : function () {
        return this.dom_element_input.value;
    },
    getValue         : function () {
        return this.current_value;
    },
    setValueFromJs   : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        DOM.Service.setInputValue( this.dom_element_input, to_set );
        this.validateValueInput();
        this.updateView();
        this.doExtraAction();
    },
    setValueFromInput: function () {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        if ( this.need_validation ) {
            this.updateView();
        }
        this.doExtraAction();
    },
    setStatus        : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus        : function () {
        return this.status;
    },
    setIsProtected   : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element_input.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ? "password" : "shinken-password" : this.type );
    },
    setDisabled      : function ( to_set ) {
        if ( to_set ) {
            this.dom_element_input.setAttribute( "readonly", '' );
        }
        else {
            this.dom_element_input.removeAttribute( "readonly", '' );
        }
    },
    setPlaceholder   : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || "";
        }
        to_set           = SHINKEN.TOOLS.STRING.unescape_xss( to_set );
        this.placeholder = to_set;
        if ( this.dom_element_input ) {
            this.dom_element_input.placeholder = this.placeholder;
        }
    },
    skipValidation   : function ( to_set ) {
        this.skip_validation = to_set;
    },
    hasBeenChanged   : function () {
        return this.getValue() !== this.original_value;
    },
    setTooltip              : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip         : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip       : function ( type, text ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( text ) {
                text += "<br>";
            }
            text += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', text );
        
        text && this.hasFocus() ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setMessage              : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, this.__buildMessageForTooltip( message ) );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, this.__buildMessageForTooltip( message ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, this.__buildMessageForTooltip( message ) );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? this.__buildMessageForTooltip( message ) : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    __buildMessageForTooltip: function ( message ) {
        return message.buildMessage();
    },
    restoreCursorLocation: function ( location ) {
        this.dom_element_input.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element_input.selectionStart = this.last_cursor_location;
        this.dom_element_input.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation   : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation    : function () {
        return this.dom_element_input.selectionStart;
    },
    updateView           : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && has_inheritance ) {
            _to_write = '';
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element_input, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        if ( this.dom_element_input.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
    },
    askComputeHeight     : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element_input ) && DOM.Service.getBoundingClientRect( self.dom_element_input, 'height' ) < 150 ) {
                self.dom_element_input.style.height = Math.min( 150, self.dom_element_input.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, self.time_out_compute_after_change );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValueFromInput();
        if ( !args ) {
            args = {};
        }
        args[ 'validation_done' ] = this.validateValueInput();
        args[ 'input_object' ]    = this;
        if ( parent ) {
            parent.doActionAfterChange( args );
        }
    },
    validateValueInput   : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            if (this.validation_parameter){
                return this.validateValueInputNewFormat(forced, ignore_focus);
            }
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else if ( this.key_validation ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
                
            }
            else {
                return false;
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    validateValueInputNewFormat   : function () {
        if ( this.need_validation ) {
            var _to_set = COMPONENT.CONST.STATUS.NONE;
            if ( !SHINKEN_VALIDATION.Service.isValid( this.getValue(), this.validation_parameter )  ){
                _to_set = COMPONENT.CONST.STATUS.ERROR;
            }
            this.setStatus(_to_set)
            this.need_validation = false;
            return true;
        }
        return false;
    },
    addValidationRule    : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules   : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation: function () {
        if ( this.skip_validation ) {
            return;
        }
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.need_validation = true;
        }
    },
    getValidationRules   : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    setValidationParameter   : function ( validation_parameter ) {
        this.validation_parameter = validation_parameter;
    },
    updateUrlWithValue: function () {
        var _value = this.current_value ? this.current_value : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    },
    applySiblingSettings          : function ( input ) {
        if ( this.current_value === input.current_value ) {
            return;
        }
        this.simulateUserInteractionWriting( input.current_value );
    },
    simulateUserInteractionWriting: function ( value ) {
        this.setValueFromJs( value );
        this.time_out_compute_after_change = 0;
        DOM.Service.SimulateAction.keyUp( this.dom_element_input );
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput, COMPONENT.Interface );
COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    this.__class_name__ = 'COMPONENT.Input';
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init: function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        
        if ( this.dom_element.classList.contains( 'shinken-input' ) || this.dom_element.classList.contains( 'shinken-input-key' ) || this.dom_element.classList.contains( 'shinken-input-search' ) ) {
            this.dom_element_input = dom_element;
        }
        else {
            this.dom_element_input = dom_element.querySelector( '.shinken-input' );
        }
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element_input.getAttribute( 'value' ) || this.dom_element_input.value;
        this.type                    = this.dom_element_input.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element_input.placeholder;
        this.placeholder             = this.placeholder_no_template;
        this.is_resizable            = this.dom_element_input.tagName === 'TEXTAREA';
        this.need_validation         = true;
        this.key_validation          = {
            "prop_name"     : parent ? parent.getParentName() : '',
            "component_name": extra_key_validation || ''
        };
        this.initInterface();
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, COMPONENT.InterfaceInput );
COMPONENT.InputFromData           = function () {
    this.__class_name__ = 'COMPONENT.InputFromData';
    this.init();
};
COMPONENT.InputFromData.prototype = {
    init: function () {
        this.current_value = "";
    },
    computeHtml: function () {
        this.dom_element       = DOM.Service.createElement( "table", {
                class       : "shinken-input-table",
                onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
            }
        );
        var tr                 = DOM.Service.createElement( "tr" );
        var td                 = DOM.Service.createElement( "td", { class: "shinken-input-container-cell" } );
        var div                = DOM.Service.createElement( "div", { class: "shinken-input-container" } );
        var _on_change         = "MANAGER.EventManager.onChangeOnInput(event)";
        this.dom_element_input = DOM.Service.createElement( "input", {
            class      : "shinken-input",
            type       : "text",
            oncut      : _on_change,
            onpaste    : _on_change,
            onkeyup    : _on_change,
            onclick    : "MANAGER.EventManager.clickOnInput(event)",
            placeholder: this.placeholder
        } );
        
        DOM.Service.addElementTo( this.dom_element_input, div );
        DOM.Service.addElementTo( div, td );
        DOM.Service.addElementTo( td, tr );
        DOM.Service.addElementTo( tr, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromData, COMPONENT.InterfaceInput );
COMPONENT.InterfaceLabel           = function () {
    this.__class_name__ = 'COMPONENT.Label';
    this.init();
};
COMPONENT.InterfaceLabel.prototype = {
    init: function () {
    },
    setLabel: function (to_set) {
        this.label = to_set;
    },
    getValue: function () {
        return "";
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, COMPONENT.Interface );
COMPONENT.Label           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    },
    updateLabel: function ( to_set ) {
        this.label                 = to_set;
        this.dom_element.innerHTML = this.label;
    }
};
COMPONENT.LabelFromData           = function () {
    this.__class_name__ = 'COMPONENT.LabelFromData';
    this.init();
};
COMPONENT.LabelFromData.prototype = {
    init: function () {
        this.current_value = "";
    },
    computeHtml: function () {
        this.dom_element       = DOM.Service.createElement( "div", {
                class: "shinken-label-container"
            }
        );
        this.dom_element_label = DOM.Service.createElement( "span", {
            class: "shinken-label"
        } );
        this.dom_element_label.innerHTML = this.label;
        DOM.Service.addElementTo( this.dom_element_label, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData, COMPONENT.InterfaceLabel );
COMPONENT.ListSelectElement           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered   = false;
        this.reason_to_set = [];
        this.element = new OBJECT.ElementList();
        if ( dom_element ) {
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'shinken-selected' );
        }
    },
    initElement        : function () {
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    setFilteringOption : function ( to_set ) {
        this.filtering_option = to_set;
    },
    doFilter           : function ( filter ) {
        if ( !filter ) {
            this.setIsFiltered( false );
            return this.element.type === OBJECT.CONST.ELEMENT_LIST.TYPE.USER;
        }
        if ( this.filtering_option === OBJECT.CONST.ELEMENT_LIST.FILTER_OPTION.IGNORED ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
COMPONENT.InterfaceListSelectElement_V2           = function () {
    this.init();
};
COMPONENT.InterfaceListSelectElement_V2.prototype = {
    init: function () {
        this.element = new OBJECT.ElementList();
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getUUID            : function () {
        return this.element.getUUID();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    setFilteringOption: function ( to_set ) {
        this.filtering_option = to_set;
    },
    doFilter          : function ( filter ) {
        if ( !filter ) {
            this.setIsFiltered( false );
            return this.element.type === OBJECT.CONST.ELEMENT_LIST.TYPE.USER;
        }
        if ( this.filtering_option === OBJECT.CONST.ELEMENT_LIST.FILTER_OPTION.IGNORED ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    updateHtmlLabel: function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceListSelectElement_V2, SHINKEN.OBJECT.ShinkenObjectHtml );
COMPONENT.ListSelectElementFromData_V2           = function (key_name, label) {
    this.initSpecific(key_name, label);
};
COMPONENT.ListSelectElementFromData_V2.prototype = {
    initSpecific: function (key_name, label) {
        this.init();
        this.getElement().setName(key_name);
        this.getElement().setLabel(label);
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            class           : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION, "data-key-name": this.getName(),
            onmouseup : "MANAGER.EventManager.clickOnItemSelector(event,'', this)",
            "data-key-label": this.getLabel()
        } ) );
        this.addDomElement( DOM.Service.createElement( "span", { class: "shinken-space" }, this.getLabel() ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ListSelectElementFromData_V2, COMPONENT.InterfaceListSelectElement_V2 );
COMPONENT.InterfaceListSelect           = function () {
    this.init();
};
COMPONENT.InterfaceListSelect.prototype = {
    init                     : function () {
    },
    toggleStateSelectedInList: function ( key_name, class_to_add ) {
        var _list_select_element = this.list[ this._getIndexElementInMapping( key_name ) ];
        if ( !_list_select_element ) {
            var _to_return = new COMPONENT.ListSelectElement();
            _to_return.getElement().setName( key_name );
            return _to_return;
        }
        _list_select_element.setSelected( !_list_select_element.is_selected, class_to_add );
        return _list_select_element.getElement();
    },
    unselectAllElement       : function ( extra_class ) {
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            _current.setSelected( false, extra_class );
        }
    },
    doChangeFilterSelect     : function () {
    
    },
    addNewElementUnknown     : function ( key_name, prop_name ) {
        var _to_add    = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-state"        : "unknown",
                "data-key-name"     : key_name,
                "data-key-label"    : key_name,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onmouseup           : "MANAGER.EventManager.clickOnItemSelector('event','" + prop_name + "', this)"
            },
            "<span class='shinken-space'>" + key_name + " ( " + _( 'element.unknown' ) + " )" + "</span>"
        );
        var _to_return = new COMPONENT.ListSelectElement( _to_add );
        this.addNewElement( key_name, _to_return );
        return _to_return;
    },
    addNewElement            : function ( key_name, list_select_element ) {
        this.list[ this.size_list ]                            = list_select_element;
        this.list_mapping[ key_name ]                          = this.size_list;
        if ( typeof key_name === "string" ){
            this.list_mapping_lower_case[ key_name.toLowerCase() ] = this.size_list;
        }
        this.size_list++;
    },
    _getIndexElementInMapping: function ( key_name ) {
        if ( !key_name ) {
            return;
        }
        var _index = this.list_mapping[ key_name ];
        if ( _index === undefined ) {
            _index = this.list_mapping_lower_case[ key_name.toLowerCase() ];
        }
        return _index;
    },
    getElement               : function ( key_name ) {
        var _index = this._getIndexElementInMapping( key_name );
        if ( _index === undefined ) {
            return null;
        }
        return this.list[ _index ].getElement();
    },
    getListSelectElement     : function ( key_name ) {
        var _index = this._getIndexElementInMapping( key_name );
        return this.list[ _index ];
    },
    getSelectedElements      : function () {
        var _to_return = [];
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                _to_return.push( _current_element );
            }
        }
        return _to_return;
    },
    getFirstSelectedElement  : function ( exclude_hidden ) {
        var _current_element;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current_element = this.list[ i ];
            if ( _current_element.is_selected ) {
                if ( exclude_hidden && _current_element.dom_element.classList.contains( "shinken-hidden" ) ) {
                    continue;
                }
                return _current_element;
            }
        }
        return null;
    },
    setState                 : function ( state ) {
        this.state = state;
        this.setLastAutoSelectElement( false );
        return this.state;
    },
    focusOnResearchInput: function () {
        if ( this.dom_element_input_research ) {
            this.dom_element_input_research.focus();
            if ( this.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.doFilter( this.current_filter );
            }
        }
    },
    setResearchDisplay  : function ( value ) {
        if ( this.dom_element_display_research ) {
            this.dom_element_display_research.innerHTML = value;
        }
    },
    toggleState         : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    },
    doFilter         : function ( filter ) {
        if ( this.current_filter && filter === this.current_filter ) {
            return;
        }
        this.current_filter           = filter;
        this.nbr_in_list_after_filter = 0;
        var _current;
        for ( var i = 0; i < this.size_list; i++ ) {
            _current = this.list[ i ];
            if ( _current.doFilter( filter ) ) {
                this.nbr_in_list_after_filter++;
            }
        }
        if ( filter ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.FILTERING_ON );
        }
        if ( this.nbr_in_list_after_filter ) {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        else {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT.CLASS.NO_RESULT );
        }
        if ( this.dom_element_counter_research ) {
            this.dom_element_counter_research.innerHTML = this.nbr_in_list_after_filter;
        }
        this.setLastAutoSelectElement( false );
        
    },
    cleanFilter      : function () {
        this.dom_element_input_research.value = "";
        this.doFilter( '' );
    },
    addNewElementList: function ( value ) {
        var _to_add = new COMPONENT.ListSelectElement( _list_element[ i ] );
    },
    hasAutoSelect                       : function () {
        return this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND;
    },
    setLastAutoSelectElement            : function ( to_set, action_type, avoid ) {
        if ( to_set ) {
            this.current_index_auto_select_element = this.current_index_auto_select_element || 0;
            DOM.ScrollService.bindWith( this.dom_element_select_content, this.list[ this.current_index_auto_select_element ].dom_element, this.previous_position_vertical, action_type );
            this.list[ this.current_index_auto_select_element ].dom_element.classList.add( 'shinken-select-focused' );
        }
        else {
            if ( !avoid ) {
                this.previous_position_vertical = 0;
            }
            if ( this.current_index_auto_select_element !== COMPONENT.CONST.NOT_FOUND ) {
                if ( !avoid ) {
                    this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.list[ this.current_index_auto_select_element ].dom_element, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                }
                this.list[ this.current_index_auto_select_element ].dom_element.classList.remove( 'shinken-select-focused' );
            }
            this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        }
    },
    selectSelectedOrFirstFilteredElement: function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            this.updateLastAutoSelectIndex( SHINKEN.TOOLS.ARRAY.findFirstIndexWith( this.list, "is_filtered", false ), COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.KEY_INPUT );
        }
    },
    validAutoSelect                     : function () {
        if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
            return false;
        }
        DOM.Service.SimulateAction.mouseUp( this.list[ this.current_index_auto_select_element ].dom_element );
        this.setLastAutoSelectElement( false );
        return true;
    },
    moveAutoSelectCursor                : function ( move_down ) {
        if ( this.state !== COMPONENT.CONST.BTN_STATE.ON ) {
            return;
        }
        if ( !this.size_list ) {
            return;
        }
        var action_type = move_down ? COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN : COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP;
        var _dom_target = this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ? null : this.list[ this.current_index_auto_select_element ].dom_element;
        
        if ( !DOM.ScrollService.isVisible( this.dom_element_select_content, _dom_target, 0, action_type ) ) {
            var _dom_element;
            if ( this.current_index_auto_select_element === COMPONENT.CONST.NOT_FOUND ) {
                _dom_element = DOM.ScrollService.getFirstVisibleDom( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            else {
                _dom_element = DOM.ScrollService.getCloserVisibleDomFromMiddle( this.dom_element_select_content, ".shinken-option:not(.shinken-hidden):not(.shinken-selected)", move_down );
            }
            if ( _dom_element ) {
                this.previous_position_vertical = DOM.Service.getBoundingClientRect( this.dom_element_select_content, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                this.updateLastAutoSelectIndex( this._getIndexElementInMapping( _dom_element.dataset.keyName ), action_type, true );
            }
            return;
        }
        var _current_counter = this.current_index_auto_select_element;
        var _current;
        var _found           = false;
        
        while ( move_down ? _current_counter < this.size_list : _current_counter >= COMPONENT.CONST.NOT_FOUND ) {
            move_down ? _current_counter++ : _current_counter--;
            _current = this.list[ _current_counter ];
            if ( !_current ) {
                this.updateLastAutoSelectIndex( this.current_index_auto_select_element, action_type );
                continue;
            }
            var _display = DOM.Service.getComputedStyle( _current.dom_element, DOM.CONST.STYLE.DISPLAY );
            if ( _display === DOM.CONST.VALUE.NONE ) {
                continue;
            }
            if ( _current.isSelected() && !this.allow_multiple_select ) {
                continue;
            }
            _found = true;
            break;
        }
        if ( _found ) {
            this.updateLastAutoSelectIndex( _current_counter, action_type );
        }
    },
    updateLastAutoSelectIndex           : function ( index, action_type, avoid ) {
        var _type = "";
        switch ( action_type ) {
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOUSE:
                if ( this.prevent_mouse_enter ) {
                    return;
                }
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_DOWN:
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
                this.prevent_mouse_enter = true;
                break;
            case COMPONENT.CONST.AUTO_SELECT_ACTION_TYPE.MOVE_UP:
                this.prevent_mouse_enter = true;
                _type                    = DOM.CONST.ATTRIBUTE.SCROLL_TOP;
                break;
        }
        if ( this.prevent_mouse_enter ) {
            var _self = this;
            if ( this.timeout_mouse_down ) {
                clearTimeout( this.timeout_mouse_down );
            }
            this.timeout_mouse_down = setTimeout( function () {
                _self.prevent_mouse_enter = false;
                _self.timeout_mouse_down  = null;
            }, 200 );
        }
        this.setLastAutoSelectElement( false, _type, avoid );
        this.current_index_auto_select_element = index;
        this.setLastAutoSelectElement( true, _type );
    }
};
COMPONENT.ListSelect           = function ( dom_element, parent_name, allow_multiple_select ) {
    this.init( dom_element, parent_name, allow_multiple_select );
};
COMPONENT.ListSelect.prototype = {
    init           : function ( dom_element, parent_name, allow_multiple_select ) {
        allow_multiple_select = !!allow_multiple_select;
        this.dom_element      = dom_element;
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element_counter_research      = dom_element.querySelector( '.shinken-counter-current' );
        this.dom_element_counter_total         = dom_element.querySelector( '.shinken-counter-total' );
        this.dom_element_input_research        = dom_element.querySelector( '.shinken-input-search' );
        this.dom_element_display_research      = dom_element.querySelector( '.shinken-display-search .shinken-value' );
        this.dom_element_select_content        = dom_element.querySelector( '.list-select-content' );
        this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
        this.state                             = COMPONENT.CONST.BTN_STATE.OFF;
        this.parent_name                       = parent_name;
        this.allow_multiple_select             = allow_multiple_select;
        this.initListElement();
    },
    initListElement: function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.list_mapping_lower_case  = {};
        this.nbr_in_list_after_filter = 0;
        var _list_element             = this.dom_element.querySelectorAll( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION );
        this.size_list                = _list_element.length;
        for ( var i = 0; i < this.size_list; i++ ) {
            this.list[ i ]                                                         = new COMPONENT.ListSelectElement( _list_element[ i ] );
            this.list_mapping[ this.list[ i ].getName() ]                          = i;
            this.list_mapping_lower_case[ this.list[ i ].getName().toLowerCase() ] = i;
        }
    },
    addNewElement: function ( key_name, list_select_element ) {
        this.list[ this.size_list ]                            = list_select_element;
        this.list_mapping[ key_name ]                          = this.size_list;
        this.list_mapping_lower_case[ key_name.toLowerCase() ] = this.size_list;
        this.dom_element_counter_total.innerHTML               = parseInt( this.dom_element_counter_total.innerHTML ) + 1;
        this.size_list++;
        this.dom_element_select_content.appendChild( list_select_element.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ListSelect, COMPONENT.InterfaceListSelect );
COMPONENT.ListSelectFromData           = function () {
    this.init();
};
COMPONENT.ListSelectFromData.prototype = {
    init           : function () {
        this.initListElement();
        this.state                             = COMPONENT.CONST.BTN_STATE.OFF;
        this.current_index_auto_select_element = COMPONENT.CONST.NOT_FOUND;
    },
    initListElement: function () {
        this.list                     = [];
        this.list_mapping             = {};
        this.list_mapping_lower_case  = {};
        this.nbr_in_list_after_filter = 0;
        this.size_list                = 0;
    },
    addFromString: function ( key_name, label, filtering_option ) {
        var _dom_element = DOM.Service.createElement( 'div', {
                class               : COMPONENT.CONST.SELECT.SELECTOR_LIST_OPTION,
                "data-key-name"     : key_name,
                "data-key-label"    : label,
                "data-type"         : "user",
                "data-is-disabled"  : "false",
                "data-force-to-null": "false",
                "data-uuid"         : "",
                onmouseup           : "MANAGER.EventManager.clickOnItemSelector(event, this)"
            },
            "<span class='shinken-space'>" + label + "</span>"
        );
        var _to_return   = new COMPONENT.ListSelectElement( _dom_element );
        _to_return.setFilteringOption(filtering_option);
        this.addNewElement( key_name, _to_return );
    },
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-list-select" } );
        this.dom_element_select_content = DOM.Service.createElement( "div", { class: "list-select-content shinken-user-select-none" } );
        DOM.Service.addElementTo( this.dom_element_select_content, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ListSelectFromData, COMPONENT.InterfaceListSelect );
COMPONENT.InterfaceListSelect_V2           = function () {
};
COMPONENT.InterfaceListSelect_V2.prototype = {
    init: function () {
    },
    setState   : function ( state ) {
        this.state = state;
        return this.state;
    },
    toggleState: function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                break;
            default:
                console.error( "Error::toggleState is outside its perimeter" );
        }
        return this.state;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceListSelect_V2, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
COMPONENT.ListSelectFromData_V2           = function () {
    this.init();
};
COMPONENT.ListSelectFromData_V2.prototype = {
    init: function () {
        this.initContents();
        this.state = COMPONENT.CONST.BTN_STATE.OFF;
    },
    addFromString: function ( key_name, label ) {
        var _to_return = new COMPONENT.ListSelectElementFromData_V2( key_name, label );
        this.add( _to_return );
    },
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-select" } ) );
        this.dom_element_select_content = DOM.Service.createElement( "div", { class: "list-select-content shinken-user-select-none" } );
        this.addDomElement( this.dom_element_select_content );
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            _current.computeHtml();
            DOM.Service.addElementTo( _current.getDomElement(), this.dom_element_select_content );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ListSelectFromData_V2, COMPONENT.InterfaceListSelect_V2 );
COMPONENT.InterfaceSelect           = function () {
};
COMPONENT.InterfaceSelect.prototype = {
    init        : function () {
    },
    hidePopup   : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    openSelector: function () {
        if ( this.list_element.state === COMPONENT.CONST.BTN_STATE.OFF ) {
            this.clickOnSelector();
        }
    },
    clickOnSelector          : function () {
        DOM.Service.setDataSet( this.dom_element, COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
        this.list_element.focusOnResearchInput();
    },
    clickOnItemSelector      : function ( parent_name, key_name, class_to_add ) {
        this.setLastSelectedElementName( key_name );
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                var _element = this.list_element.toggleStateSelectedInList( key_name, class_to_add );
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                this.getActiveListForUser().addTag( parent_name, _element );
                break;
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.clickOnItemSelector( key_name );
                break;
        }
        if ( MANAGER.__instance_property_distributor ) {
            MANAGER.__instance_property_distributor.hidePopups();
        }
    },
    clickOnDeleteItemSelector: function ( key_name ) {
        var _element = this.list_element.toggleStateSelectedInList( key_name );
        this.getActiveListForUser().deleteTag( _element );
    },
    askComputeAfterChange    : function ( dom_element ) {
        switch ( dom_element.name ) {
            case 'multi-search':
                this.component_input_search.askComputeAfterChange( dom_element, this );
                break;
        }
    },
    doActionAfterChange      : function ( args ) {
        if ( args[ 'validation_done' ] ) {
            this.doFilter( this.component_input_search.getValue() );
        }
    },
    simulateClickOnItem      : function ( key_name ) {
        DOM.Service.SimulateAction.mouseUp( this.list_element.getListSelectElement( key_name ).dom_element );
    },
    dragStartShinken: function ( type_element, key_name ) {
        switch ( type_element ) {
            case PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM:
                return this.getActiveListForUser().dragStartShinken( key_name );
        }
    },
    resetDragging   : function () {
        this.list_element_selected.resetDragging();
    },
    setTitle                  : function ( _to_set ) {
        if ( !this.is_editable ) {
            return;
        }
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    setResearchDisplay        : function ( _to_set ) {
        this.list_element.setResearchDisplay( _to_set );
    },
    isSet                     : function () {
        return !this.getActiveListForUser().isEmpty();
    },
    cleanAllTags              : function () {
        this.getActiveListForUser().emptyList();
    },
    getActiveListForUser      : function () {
        if ( this.is_override ) {
            return this.list_element_override;
        }
        else {
            return this.list_element_selected;
        }
    },
    cleanAllItemsSelected     : function ( extra_class ) {
        this.list_element.unselectAllElement( extra_class );
    },
    getValue                  : function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                return this.getActiveListForUser().getValue();
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                return this.getLastSelectedElementName();
        }
    },
    getValueToSave            : function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                return this.getTagsValueToSave();
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                if ( this.last_selected_key_name ) {
                    return this.getLastSelectedElement().getElement().getValueFinal();
                }
                return;
        }
    },
    getTagsValueToSave        : function () {
        var _to_return = [];
        var _tags      = this.getActiveListForUser().getTags();
        for ( var i = 0, size = _tags.length; i < size; i++ ) {
            _to_return.push( _tags[ i ].getValueFinal() );
        }
        return _to_return;
    },
    computeTitle              : function ( add_extra, extra_label ) {
        if ( this.last_selected_key_name === undefined ) {
            var _selected = this.list_element.getSelectedElements();
            if ( _selected[ 0 ] !== undefined ) {
                this.setLastSelectedElementName( _selected[ 0 ].element.name );
            }
        }
        var _selected_element = this.getLastSelectedElement();
        var _title_to_set     = '';
        if ( _selected_element ) {
            _title_to_set = _selected_element.element.getLabel();
        }
        if ( extra_label ) {
            _title_to_set += extra_label;
        }
        this.setTitle( _title_to_set );
    },
    getLastSelectedElement    : function () {
        return this.list_element.getListSelectElement( this.last_selected_key_name );
    },
    getLastSelectedElementName: function () {
        return this.last_selected_key_name || '';
    },
    setLastSelectedElementName: function ( to_set ) {
        if ( this.last_selected_key_name ) {
            this.previous_selected_key_name = this.last_selected_key_name;
        }
        this.last_selected_key_name = to_set;
    },
    hasTag                    : function ( name ) {
        return !this.list_element_selected.hasTag( name ) || !this.list_elements_inherited.hasTag( name );
    },
    getMissingItemSelectorWith: function ( property ) {
        return this.list_element_selected.getMissingItemSelectorWith( property );
    },
    getExtraItemSelectorWith  : function ( property ) {
        return this.list_element_selected.getExtraItemSelectorWith( property );
    },
    setMaximumSelected        : function ( to_set ) {
        this.maximum_selected = to_set;
    },
    getMaximumSelected        : function () {
        return this.maximum_selected;
    },
    isLimitReached            : function () {
        return (this.getActiveListForUser().getSizeTags() + this.list_elements_inherited.getSizeTags() - this.maximum_selected);
    },
    isLimitReachedForSelected : function () {
        return (this.getActiveListForUser().getSizeTags() - this.maximum_selected);
    },
    disabledTagsOutOfLimit    : function ( limit ) {
        this.list_elements_inherited.disabledTagsOutOfLimit( limit );
    },
    getErrors                 : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getErrors( prop_name ) + this.list_elements_inherited.getErrors( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterError().getValue();
        return _to_return;
    },
    getWarnings               : function ( state, prop_name ) {
        var _to_return = 0;
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
                switch ( state ) {
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                        _to_return = this.list_element_selected.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                        _to_return = this.list_element_selected.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                        _to_return = this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_AND_PLUS:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE:
                        _to_return = this.list_element_override.getWarnings( prop_name ) + this.list_elements_inherited.getWarnings( prop_name );
                        break;
                    case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                    case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                        break;
                }
                break;
        }
        _to_return += this.getCounterWarning().getValue();
        return _to_return;
    },
    setMessage                : function ( message ) {
        var _status = COMPONENT.CONST.STATUS.NONE;
        if ( typeof message === 'string' ) {
            _status = COMPONENT.CONST.STATUS.INFO;
        }
        else if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.INFO:
                this.addShinkenTooltip( "", message );
                break;
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    addShinkenTooltip         : function ( type, message ) {
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setStatus                 : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setDataSetLink            : function ( to_set ) {
        this.dataSetLink = to_set;
        if ( this.dataSetLink ) {
            this.computeTitle();
        }
    },
    getDataSetLink            : function () {
        return this.dataSetLink;
    },
    getListElement            : function () {
        return this.list_element;
    },
    doFilter            : function ( filter ) {
        this.list_element.doFilter( filter );
    },
    doChangeFilterSelect: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.list_element.doChangeFilterSelect();
                break;
        }
    },
    cleanFilter         : function () {
        this.list_element.cleanFilter();
    },
    validOrCreateTag    : function ( name_element, prop_name ) {
        var _existing = this.list_element.getListSelectElement( name_element );
        if ( _existing ) {
            return _existing;
        }
        return this.list_element.addNewElementUnknown( name_element, prop_name );
    },
    buildLinkOpenNewTab: function ( link, id ) {
        var _span_link                         = '<span class="shinken-link-icon-button"><span class="shinken-link-icon shinicon shinicon-open"></span></span>';
        this.dom_link_icon_container.innerHTML = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, id, _span_link, "shinken-link" ).outerHTML;
    },
    pulsateTag: function ( name ) {
        var _existing = this.getActiveListForUser().getTagByName( name );
        if ( _existing ) {
            _existing.pulsateTag();
        }
        else if ( this.list_elements_inherited ) {
            _existing = this.list_elements_inherited.getTagByName( name );
            if ( _existing ) {
                _existing.pulsateTag();
            }
        }
    },
    hasAutoSelect                 : function () {
        return this.list_element.hasAutoSelect();
    },
    moveAutoSelectCursor          : function ( move_down ) {
        if ( this.component_input_search ) {
            this.component_input_search.need_validation = false;
        }
        this.list_element.moveAutoSelectCursor( move_down );
    },
    validAutoSelect               : function () {
        return this.list_element.validAutoSelect();
    },
    isAllElementsSelectedDisabled : function () {
        return this.getActiveListForUser().isAllElementsSelectedDisabled();
    },
    hasInvalidElementForProduction: function () {
        return this.getActiveListForUser().hasInvalidElementForProduction();
    },
    validSelectedOrFirstElement   : function () {
        this.list_element.selectSelectedOrFirstFilteredElement();
        this.validAutoSelect();
    },
    applySiblingSettings: function ( select_comp ) {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.SINGLE_SELECT_WITH_INPUT:
                var _value = select_comp.getValue();
                if ( _value ) {
                    this.simulateClickOnItem( _value );
                }
                else {
                    this.cleanAllItemsSelected();
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSelect, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSelect, SHINKEN.OBJECT.ShinkenObjectHtml );
COMPONENT.Select           = function ( dom_element, type, is_override, parent, datasetLink, allow_multiple_select ) {
    this.__class_name__ = 'COMPONENT.Select';
    this.type                  = type;
    this.is_override           = is_override;
    this.allow_multiple_select = !!allow_multiple_select;
    this.is_editable           = true;
    this.init( dom_element, parent );
    this.setDataSetLink( datasetLink );
    this.__class = SHINKEN.TOOLS.CLASS.CONST.COMPONENT.SELECT;
};
COMPONENT.Select.prototype = {
    init                      : function ( dom_element, parent ) {
        this.uuid        = SHINKEN.TOOLS.STRING.buildUUID();
        this.dom_element = dom_element;
        this.dom_select  = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR );
        if ( this.dom_select ) {
            this.dom_link_icon_container = this.dom_select.querySelector( '.shinken-link-icon-container' );
            this.dom_link_icon_button    = this.dom_select.querySelector( '.shinken-link-icon-button' );
        }
        else {
            this.is_editable = false;
        }
        var _dom_list_select = dom_element.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_LIST );
        this.list_element    = new COMPONENT.ListSelect( _dom_list_select, parent.getParentName(), this.allow_multiple_select );
        this.initSearchElement();
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.MULTI_SELECT:
                var _dom_list_selected       = dom_element.querySelector( '.shinken-list-selected-in-select' );
                var _dom_list_inherited      = dom_element.querySelector( '.shinken-list-inherited' );
                var _dom_list_override       = dom_element.querySelector( '.shinken-list-override' );
                this.list_element_selected   = new COMPONENT.ListTag( _dom_list_selected, parent.name );
                this.list_elements_inherited = new COMPONENT.ListTag( _dom_list_inherited );
                this.list_element_override   = new COMPONENT.ListTag( _dom_list_override );
                break;
            case COMPONENT.CONST.TYPE.MULTI_SELECT_BASIC:
                var _dom_list_selected     = dom_element.querySelector( '.shinken-list-selected-in-select' );
                this.list_element_selected = new COMPONENT.ListTag( _dom_list_selected, parent.name );
                break;
        }
        this.initCounters( parent );
    },
    initSearchElement         : function () {
        var _dom = this.dom_element.querySelector( ".shinken-input-search" );
        if ( _dom ) {
            this.component_input_search = new COMPONENT.Input( _dom );
        }
    },
    updateWithTemplateSpecific: function ( tags ) {
        this.list_elements_inherited.addTags( tags );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Select, COMPONENT.InterfaceSelect );
COMPONENT.SelectFromData           = function ( type ) {
    this.__class_name__ = 'COMPONENT.SelectFromData';
    this.type           = type;
    this.is_editable    = true;
    this.default_label_for_select  = '-- --';
    this.init();
};
COMPONENT.SelectFromData.prototype = {
    init: function () {
        this.uuid         = SHINKEN.TOOLS.STRING.buildUUID();
        this.list_element = new COMPONENT.ListSelectFromData();
    },
    setDefaultLabelForSelector: function ( to_set ) {
        this.default_label_for_select = to_set;
    },
    setOptionsFromArray: function ( to_set ) {
        for ( var i = 0, _size_i = to_set.length; i < _size_i; i++ ) {
            this.addOption( to_set[ i ] );
        }
    },
    addOption          : function ( to_add ) {
        this.list_element.addFromString( to_add.name, to_add.label, to_add.filtering_option );
        if ( to_add.is_selected ) {
            this.setLastSelectedElementName( to_add.name );
        }
    },
    computeHtml: function () {
        this.list_element.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-select-container", "data-state-selector": 0 } ) );
        
        this.dom_select = DOM.Service.createElement( "div",
            {
                class  : "shinken-select-selector shinken-user-select-none",
                onclick: "MANAGER.EventManager.clickOnSelector(event)"
            }, '<span class="shinken-selector-label shinken-space">' + this.default_label_for_select  + '</span><span class="caret"></span>' );
        if ( this.getLastSelectedElement() ) {
            this.dom_select.innerHTML = '<span class="shinken-selector-label shinken-space">' + this.getLastSelectedElement().getLabel() + '</span><span class="caret"></span>';
        }
        
        for ( var i = 0, _size_i = this.list_element.size_list; i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.list_element.list[ i ].dom_element, this.list_element.dom_element_select_content );
        }
        DOM.Service.addElementTo( this.dom_select, this.dom_element );
        DOM.Service.addElementTo( this.list_element.dom_element, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SelectFromData, COMPONENT.InterfaceSelect );
COMPONENT.InterfaceSingleSelect           = function () {
};
COMPONENT.InterfaceSingleSelect.prototype = {
    init     : function () {
        this.last_selected_key_name   = "";
        this.default_label_for_select = '--';
        this.uuid                     = SHINKEN.TOOLS.STRING.buildUUID();
    },
    hidePopup: function () {
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    clickOnSelector    : function () {
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
    },
    clickOnItemSelector: function ( key_name, parent ) {
        this.setLastSelectedElementName( key_name );
        this.hidePopup();
        if ( parent ) {
            parent.doActionAfter( "click_on_item_selector", this );
        }
    },
    getLastSelectedElement    : function () {
        return this.list_element.getContentByUUID( this.last_selected_key_name );
    },
    setTitle                  : function ( _to_set ) {
        if ( !this.is_editable ) {
            return;
        }
        if ( !this.dom_select) {
            return;
        }
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    getValue                  : function () {
        return this.getLastSelectedElementName();
    },
    getLabel                  : function () {
        return this.getLastSelectedElement().getLabel();
    },
    computeTitle              : function () {
        this.setTitle( this.last_selected_key_name !== "" ? this.getLabel() : this.default_label_for_select );
    },
    getLastSelectedElementName: function () {
        return this.last_selected_key_name;
    },
    setLastSelectedElementName: function ( to_set ) {
        this.previous_selected_key_name = this.last_selected_key_name;
        this.last_selected_key_name     = to_set;
        this.computeTitle();
    },
    setStatus                 : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.getDomElement(), 'status', to_set );
    },
    getListElement            : function () {
        return this.list_element;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSingleSelect, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSingleSelect, SHINKEN.OBJECT.ShinkenObjectHtml );
COMPONENT.SingleSelectFromData           = function () {
    this.__class_name__ = 'COMPONENT.SingleSelectFromData';
    this.is_editable    = true;
    this.initSpecific();
};
COMPONENT.SingleSelectFromData.prototype = {
    initSpecific: function () {
        this.init();
        this.list_element = new COMPONENT.ListSelectFromData_V2();
        this._onclick     = "MANAGER.EventManager.clickOnSelector(event)";
    },
    setOptionsFromArray: function ( to_set ) {
        this.list_element.initContents();
        for ( var i = 0, _size_i = to_set.length; i < _size_i; i++ ) {
            this.addOption( to_set[ i ] );
        }
    },
    addOption          : function ( to_add ) {
        this.list_element.addFromString( to_add.name, to_add.label );
        if ( to_add.is_selected ) {
            this.setLastSelectedElementName( to_add.name );
        }
    },
    setClickEventName  : function ( to_set ) {
        this.specific_event_name = to_set;
        this._onclick            = "MANAGER.EventManager.clickOnSelector(event, '" + this.specific_event_name + "')";
    },
    computeHtml: function () {
        this.list_element.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-select-container", "data-state-selector": 0 } ) );
        
        this.dom_select = DOM.Service.createElement( "div",
            {
                class  : "shinken-select-selector shinken-user-select-none",
                onclick: this._onclick
            }, '<span class="shinken-selector-label shinken-space">' + this.default_label_for_select + '</span><span class="caret"></span>' );
        this.computeTitle();
        this.addDomElement( this.dom_select );
        this.addDomElement( this.list_element.getDomElement() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SingleSelectFromData, COMPONENT.InterfaceSingleSelect );
SHINKEN_LIST.FilterFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.FilterFromData.prototype = {
    init          : function () {
    },
    getComponent: function () {
        return this.component;
    },
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "td", { class: "shinken-list-filter", "data-name": this.name, "data-object-type": "shinken-list-filter", "data-type": this.type } );
        switch (this.type ) {
            case COMPONENT.CONST.TYPE.HIDDEN:
                this.dom_element.classList.add("shinken-text-centred");
                this.addDomElement( DOM.Service.createElement("span", {}, "--" ));
                break;
            default:
                this.getComponent().computeHtml();
                this.addDomElement( this.getComponent().dom_element );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterFromData, SHINKEN_LIST.Filter );
SHINKEN_LIST.FiltersFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.FiltersFromData.prototype = {
    init               : function () {
        this.initContents();
    },
    
    
    
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", { class: "shinken-filter-line" } );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtml();
            DOM.Service.addElementTo( this.contents[ i ].getDomElement(), this.dom_element );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersFromData, SHINKEN_LIST.Filters );
SHINKEN_LIST.HeaderFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.HeaderFromData.prototype = {
    init: function () {
    },
    computeHtml: function () {
        this.setDomElement(DOM.Service.createElement( "td", { class: "shinken-list-header", "data-name": this.name, "data-object-type": this.getObjectType() } ));
        this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-list-cell-content" }, this.label ));
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromData, SHINKEN_LIST.Header );
SHINKEN_LIST.HeaderFromDataWithSort           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.HeaderFromDataWithSort.prototype = {
    init: function () {
        this.initSorting();
        this.initSortingAvailability();
    },
    clickOnButton: function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-header-popup":
            case "click-on-option-header-popup":
            case "click-on-header":
                this.clickOnButtonSorting( event, event_name, param );
                break;
        }
    },
    computeHtmlCounters: function () {
        this.dom_counter_cell        = null;
    },
    computeHtml: function () {
        this.computeHtmlSorting();
        this.computeHtmlCounters();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-header", "data-name": this.name, "data-display-sort-popup": true, "data-object-type": this.getObjectType() } ) );
        this.cell_content            = DOM.Service.createElement( "div", { class: "shinken-list-cell-content", onclick: "MANAGER.EventManager.clickOnButton(event, 'click-on-header', '" + this.name + "')" } );
        var _table                   = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-header-table" } );
        var _line                    = DOM.Service.createElement( "tr", {} );
        var _label_cell              = DOM.Service.createElement( "td", { class: "shinken-list-header-name-cell" }, "<div class='shinken-list-header-name'>" + this.label + "</div>" );
        this.dom_sort_priority_cell  = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-cell" } );
        this.dom_actions_button_cell = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-button-cell" } );
        
        
        DOM.Service.addElementTo( _label_cell, _line );
        DOM.Service.addElementTo( this.dom_counter_cell, _line );
        DOM.Service.addElementTo( this.dom_sort_priority_cell, _line );
        DOM.Service.addElementTo( this.dom_actions_button_cell, _line );
        DOM.Service.addElementTo( _line, _table );
        DOM.Service.addElementTo( _table, this.cell_content );
        DOM.Service.addElementTo( this.cell_content, this.dom_element );
        
        DOM.Service.addElementTo( this.sorting_object.sort_priority_dom_element, this.dom_sort_priority_cell );
        DOM.Service.addElementTo( this.sorting_object.sort_popup_button, this.dom_actions_button_cell );
        DOM.Service.addElementTo( this.sorting_object.popup_sort_container, this.cell_content );
        
        this.setDomParentForSorting( this.dom_element );
    },
    hidePopup  : function () {
        this.hidePopupSorting();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromDataWithSort, SHINKEN_LIST.HeaderFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromDataWithSort, SHINKEN.OBJECT.SortingInterface );
SHINKEN_LIST.HeadersFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.HeadersFromData.prototype = {
    init: function () {
        this.initContents();
    },
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", { class: "shinken-header-line" } );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtml();
            DOM.Service.addElementTo( this.contents[ i ].getDomElement(), this.dom_element );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersFromData, SHINKEN_LIST.Headers );
SHINKEN_LIST.HeadersWithSortFromData           = function () {
    this.current_index_sorting = 0;
};
SHINKEN_LIST.HeadersWithSortFromData.prototype = {
    init                       : function () {
    },
    _computeCurrentIndexSorting: function ( is_cumulative ) {
        this.current_index_sorting = (this.current_index_sorting && is_cumulative) ? this.current_index_sorting + 1 : 1;
    },
    cleanSorting               : function () {
        var _active_headers = this.getActiveSortingHeaders();
        for ( var i = 0, size_i = _active_headers.length; i < size_i; i++ ) {
            _active_headers[ i ].setSortingStatus( SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE );
        }
    },
    clickOnHeaderSorting       : function ( event, event_name, param ) {
        var _header = this.getContentByUUID( param );
        if ( !event.shiftKey && (_header.getSortingStatus() === SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE || this.current_index_sorting > 1) ) {
            this.cleanSorting();
        }
        if ( _header.getSortingIndex() ) {
            _header.clickOnButton( event, event_name, _header.getSortingIndex() );
        }
        else {
            this._computeCurrentIndexSorting( event.shiftKey );
            _header.clickOnButton( event, event_name, this.current_index_sorting );
        }
        this._computeAllIndexes();
    },
    _computeAllIndexes         : function () {
        var _active_headers = SHINKEN.TOOLS.ARRAY.cleanEmpty( this.getActiveSortingHeaders() );
        for ( var i = 0, size_i = _active_headers.length; i < size_i; i++ ) {
            _active_headers[ i ].setSortingIndex( i + 1 );
        }
        if ( !size_i ){
            this.current_index_sorting = 0;
        }
    },
    clickOnOptionHeaderSorting : function ( event, event_name, param ) {
        var _option_dom = DOM.Service.findParentElementWithClass( event.target, "shinken-list-header-sort-popup-option" );
        var _header     = this.getContentByUUID( param );
        var _to_set     = {};
        if ( _option_dom.dataset.status === SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE ) {
            var _index = _header.getSortingIndex();
            _to_set.index = 0;
        }
        else {
            if ( !this.getContentByUUID( param ).getSortingIndex() ) {
                this._computeCurrentIndexSorting( true );
                _to_set.index = this.current_index_sorting;
            }
            else {
                _to_set.index = this.getContentByUUID( param ).getSortingIndex();
            }
        }
        _to_set.status = _option_dom.dataset.status;
        _header.clickOnButton( event, event_name, _to_set );
        this._computeAllIndexes();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersWithSortFromData, SHINKEN_LIST.HeadersFromData );
SHINKEN_LIST.LineCellFromData           = function ( name, value ) {
    this.name  = name;
    this.value = value;
    this.init();
};
SHINKEN_LIST.LineCellFromData.prototype = {
    init: function () {
    },
    getUUID: function () {
        return this.name;
    },
    computeFilterValue: function () {
        this.data_filter_html = "";
    },
    computeContentHtml: function () {
        this.computeLabel();
        this.computeFilterValue();
        this.dom_element_content = DOM.Service.createElement( "div", { class: "shinken-list-cell-content", "data-filter": this.name }, this.label );
    },
    computeHtml       : function () {
        this.computeContentHtml();
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-cell", "data-name": this.name } ) );
        this.addDomElement( this.dom_element_content );
    },
    getDataToSave: function () {
        return null;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellFromData, SHINKEN_LIST.LineCell );
SHINKEN_LIST.LineFromData           = function ( type ) {
    this.type        = type;
    this.init();
};
SHINKEN_LIST.LineFromData.prototype = {
    init: function () {
        this.initContents();
    },
    
    
    computeHtml: function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.dom_element = DOM.Service.createElement( "tr", { class: "shinken-list-line" } );
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineFromData, SHINKEN_LIST.Line );
SHINKEN_LIST.LinesFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.LinesFromData.prototype = {
    init: function () {
        this.initContents();
    },
    
    
    
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "tbody", { class: "shinken-list-tbody" } ) );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromData, SHINKEN_LIST.Lines );
SHINKEN_LIST.SetFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromData.prototype = {
    init: function () {
    },
    computeHtml        : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml  : function () {
        this.headers.computeHtml();
        this.filters.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container" } ) );
        var _table = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead = DOM.Service.createElement( "thead" );
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead );
        DOM.Service.addElementTo( this.filters.getDomElement(), _thead );
        DOM.Service.addElementTo( _thead, _table );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table );
        this.addDomElement( _table );
        this.computeHtmlExtra();
    },
    computeLinesHtml   : function () {
        this.lines.computeHtml();
    },
    computeSpecificHtml: function () {
    
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromData, SHINKEN_LIST.Set );
SHINKEN_LIST.SetFromDataWithFixHeaderFilter           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromDataWithFixHeaderFilter.prototype = {
    computeHtml: function () {
        this.headers.computeHtml();
        this.filters.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container" } ) );
        
        var _container_header_filter   = DOM.Service.createElement( "div", {
            class: "shinken-list-container-fix-header-filter"
        } );
        var _table_header_filter       = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead_table_header_filter = DOM.Service.createElement( "thead" );
        
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead_table_header_filter );
        DOM.Service.addElementTo( this.filters.getDomElement(), _thead_table_header_filter );
        DOM.Service.addElementTo( _thead_table_header_filter, _table_header_filter );
        DOM.Service.addElementTo( _table_header_filter, _container_header_filter );
        this.addDomElement( _container_header_filter );
        
        var _container_header_list = DOM.Service.createElement( "div", {
            class: "shinken-list-container-with-scroll"
        } );
        var _table_list            = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead_table_list      = DOM.Service.createElement( "thead" );
        
        
        DOM.Service.addElementTo( _thead_table_list, _table_list );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table_list );
        DOM.Service.addElementTo( _table_list, _container_header_list );
        this.addDomElement( _container_header_list );
        
        this.computeHtmlExtra();
        this.computeSpecificHtml();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithFixHeaderFilter, SHINKEN_LIST.SetFromData );
SHINKEN_LIST.LinesFromDataWithPagination           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.LinesFromDataWithPagination.prototype = {
    init: function () {
        this.initContents();
    },
    
    
    
    computeHtml: function ( pagination ) {
        if ( this.getDomElement() ) {
            DOM.Service.empty( this.getDomElement() );
        }
        else {
            this.setDomElement( DOM.Service.createElement( "tbody", { class: "shinken-list-tbody" } ) );
        }
        var _first_element_to_display = pagination.getDisplayStartingIndex();
        var _size_end_display         = Math.min( pagination.getDisplayEndingIndex(), this.getSize() );
        
        var _current;
        var _running_index = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.is_filtered ) {
                continue;
            }
            if ( _running_index >= _first_element_to_display && _running_index < _size_end_display ) {
                _current.computeHtml();
                this.addDomElement( _current.getDomElement() );
            }
            _running_index++;
        }
        if ( _running_index === 0 ) {
            this.computeMessageNoContentHml();
        }
    },
    computeMessageNoContentHml: function ( pagination ) {
    
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromDataWithPagination, SHINKEN_LIST.LinesFromData );
SHINKEN_LIST.FilterFromHtml           = function ( dom_element, type ) {
    this.setType( type );
    this.init( dom_element );
};
SHINKEN_LIST.FilterFromHtml.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        this.name        = this.dom_element.dataset.name;
        this._is_active  = false;
        if ( this.dom_element.dataset.type ) {
            this.setType( this.dom_element.dataset.type );
        }
        this.initComponents();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FilterFromHtml, SHINKEN_LIST.Filter );
SHINKEN_LIST.FiltersFromHtml           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.FiltersFromHtml.prototype = {
    init               : function ( dom_element ) {
        this.initContents();
        this.initContentsWithDom( DOM.Service.querySelectorAllWithOutChild( dom_element, "shinken-list-filter", "shinken-list-table" ) );
    },
    initContentsWithDom: function ( dom_elements ) {
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.FilterFromHtml( dom_elements[ i ], this.type );
            if ( _current.isValid() ) {
                this.add( _current );
            }
        }
    }
    
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.FiltersFromHtml, SHINKEN_LIST.Filters );
SHINKEN_LIST.HeaderFromHtml           = function ( dom_element, type ) {
    this.type        = type;
    this.dom_element = dom_element;
    this.init();
};
SHINKEN_LIST.HeaderFromHtml.prototype = {
    init: function () {
        this.name  = this.dom_element.dataset.headerName || this.dom_element.dataset.name;
        this.label = this.dom_element.innerText;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromHtml, SHINKEN_LIST.Header );
SHINKEN_LIST.HeadersFromHtml           = function ( dom_element, type ) {
    this.dom_element = dom_element;
    this.type        = type;
    this.init();
};
SHINKEN_LIST.HeadersFromHtml.prototype = {
    init       : function () {
        this.initContents();
        this.initHeaders();
    },
    initHeaders: function () {
        var dom_elements = DOM.Service.querySelectorAllWithOutChild( this.dom_element, "shinken-list-header", "shinken-list-table" );
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.add( new SHINKEN_LIST.HeaderFromHtml( dom_elements[ i ], this.type ) );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersFromHtml, SHINKEN_LIST.Headers );
SHINKEN_LIST.LineCellFromHtml           = function ( dom_element, type ) {
    this.init( dom_element );
    this.type = type;
};
SHINKEN_LIST.LineCellFromHtml.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initWithDom();
    },
    initWithDom: function () {
        this.name = this.dom_element.dataset.filter;
        if ( this.dom_element.dataset.filterValueArray ) {
            this.value = this.dom_element.dataset.filterValueArray.split( "," );
        }
        else if ( this.dom_element.dataset.filterValue ) {
            this.value = this.dom_element.dataset.filterValue;
        }
        else {
            this.value = DOM.Service.getInnerText( this.dom_element );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this[ 'data_name_array' ] = this.uuid;
                break;
        }
    },
    getUUID: function () {
        return this.name;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCellFromHtml, SHINKEN_LIST.LineCell );
SHINKEN_LIST.LineFromHtml           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.LineFromHtml.prototype = {
    init          : function ( dom_element ) {
        this.initContents();
        this.dom_element = dom_element;
        this.is_filtered = this.dom_element.classList.contains( "shinken-is-filtered" ) ? SHINKEN_LIST.CONST.FILTER.STATUS.ON : SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        this.is_collapse = false;
        this.uuid        = this.dom_element.dataset.uuid;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.host    = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidItem ) );
                this.parent  = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidParent ) );
                this.check   = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeCheck, this.dom_element.dataset.uuidCheck ) );
                this.dfe_key = this.dom_element.dataset.dfeKey;
                break;
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.parent_uuid           = this.dom_element.dataset.uuidParent;
                this.parent_select_element = DOM.Service.findParentElementWithClass( this.dom_element, this.dom_element.dataset.parentSelectClass, 20 );
                break;
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.uuid = this.dom_element.dataset.name;
                break;
        }
        this.initIsSelected();
        this.initCellsValue();
    },
    initIsSelected: function () {
        if ( this.dom_element.classList.contains( "shinken-selected-disabled" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        else if ( this.dom_element.classList.contains( "shinken-selected" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
        }
        else {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_selected_counter = new SHINKEN.OBJECT.Counter();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                if ( !this.parent_uuid ) {
                    this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_element_selected );
                }
                this.updateSelectionCounter();
                if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                    this.initCounters( CONTROLLER.MassChange.steps.get().button_next, true );
                }
                break;
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_checks_selected );
                break;
        }
        var _check_box = DOM.Service.askFindChildElementWithClass( this.dom_element, "shinken-list-line-checkbox", "shinken-list-table" );
        if ( _check_box ) {
            this.checkbox = new OBJECT.ElementCheckbox( _check_box.querySelector( ".shinken-checkbox" ) );
        }
    },
    initCellsValue: function () {
        var _cells = DOM.Service.querySelectorAllWithOutChild( this.dom_element, "shinken-list-cell", "shinken-list-table" );
        var _current;
        for ( var i = 0, _size_i = _cells.length; i < _size_i; i++ ) {
            this.add( new SHINKEN_LIST.LineCellFromHtml( _cells[ i ], this.type ) );
        }
    },
    
    
    getDataToSave: function ( type ) {
        var _to_return;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                switch ( type ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        _to_return       = {};
                        _to_return.value = this.isSelected() ? true : false;
                        if ( this.dom_element.dataset.originalSelected === "1" ) {
                            _to_return.value = !_to_return.value;
                        }
                        _to_return.check_link = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        break;
                    default:
                        _to_return      = [];
                        _to_return[ 0 ] = this.host.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 1 ] = this.parent.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 2 ] = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 3 ] = this.dfe_key;
                        break;
                }
            
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineFromHtml, SHINKEN_LIST.Line );
SHINKEN_LIST.LinesFromHtml           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.LinesFromHtml.prototype = {
    init               : function ( dom_element ) {
        this.initContents();
        this.mapping_parents = {};
        this.initContentsWithDom( DOM.Service.querySelectorAllWithOutChild( dom_element, "shinken-list-line", "shinken-list-table" ) );
    },
    initContentsWithDom: function ( dom_elements ) {
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.LineFromHtml( dom_elements[ i ], this.type );
            this.add( _current );
            this.addMappingParent( _current.parent_uuid, _current.uuid );
        }
    },
    addMappingParent   : function ( parent_uuid, uuid ) {
        if ( !parent_uuid ) {
            if ( !this.mapping_parents[ uuid ] ) {
                this.mapping_parents[ uuid ] = [];
            }
        }
        else {
            if ( !this.mapping_parents[ parent_uuid ] ) {
                this.mapping_parents[ parent_uuid ] = [];
            }
            this.mapping_parents[ parent_uuid ].push( this.getContentByUUID( uuid ) );
        }
    },
    removeMappingParent: function ( parent_uuid, _to_remove ) {
        if ( parent_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElement( this.mapping_parents[ parent_uuid ], _to_remove );
        }
    },
    remove             : function ( uuid ) {
        var _to_remove = this.mapping[ uuid ];
        delete this.mapping[ uuid ];
        this.removeMappingParent( _to_remove.parent_uuid, _to_remove );
        SHINKEN.TOOLS.ARRAY.removeElement( this.contents, _to_remove );
    },
    addLineWithDom: function ( dom_element ) {
        var _to_add = new SHINKEN_LIST.LineFromHtml( dom_element, this.type );
        this.add( _to_add );
        this.addMappingParent( _to_add.parent_uuid, _to_add.uuid );
    },
    toggleCollapse          : function ( uuid ) {
        this.getContentByUUID( uuid ).toggleCollapse( this.mapping_parents[ uuid ] );
    },
    setIsCollapseAllData    : function ( to_set ) {
        var _keys = Object.keys( this.mapping_parents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getContentByUUID( _current_key ).setIsCollapsed( to_set, this.mapping_parents[ _current_key ] );
        }
    },
    isAllActiveLineCollapsed: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isCollapsedOrFiltered() ) {
                return false;
            }
        }
        return true;
    },
    applyFilter               : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.filterParentWithNoChildren();
                break;
        }
    },
    filterParentWithNoChildren: function () {
        var _current;
        var _filter;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered !== SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN ) {
                continue;
            }
            if ( _current.parent_uuid ) {
                continue;
            }
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                if ( this.contents[ j ].parent_uuid === _current.getUUID() && this.contents[ j ].is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.OFF ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
                    break;
                }
            }
            _current.setFilter( _filter );
        }
    },
    getDataToSave: function ( type ) {
        var _to_return = type === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE ? {} : [];
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.isSelected() ) {
                switch ( this.type ) {
                    case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                        switch ( type ) {
                            case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                                _current_data = _current.getDataToSave( type );
                                if ( !_to_return[ _current.host.getUUID() ] ) {
                                    _to_return[ _current.host.getUUID() ] = [];
                                }
                                _to_return[ _current.host.getUUID() ].push( _current_data );
                                break;
                            
                            default:
                                _to_return.push( _current.getDataToSave( type ) );
                                break;
                        }
                        break;
                    default:
                        _to_return.push( _current.getDataToSave( type ) );
                        break;
                }
            }
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromHtml, SHINKEN_LIST.Lines );
SHINKEN_LIST.SetFromHtml           = function ( dom_element, type ) {
    this.type             = type;
    this.structure_format = SHINKEN_LIST.CONST.STRUCTURE_FORMAT.GENERIC;
    this.init( dom_element );
    this.edit_mode = false;
};
SHINKEN_LIST.SetFromHtml.prototype = {
    init               : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initStructureFormat();
        this.initHeaders();
        this.initFilters();
        this.initLines();
        this.is_all_data_selected  = this.dom_element.classList.contains( "shinken-selected" ) ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        this.is_all_data_collapsed = false;
        this.updateHtml();
        var _check_box = DOM.Service.askFindChildElementWithClass( this.dom_element, "shinken-all-elements-check-box-filter", "shinken-list-table" );
        if ( _check_box ) {
            this.checkbox = new OBJECT.ElementCheckbox( _check_box.querySelector( ".shinken-checkbox" ) );
        }
        this.setSelectAllStatus();
    },
    initStructureFormat: function () {
        if ( this.dom_element.querySelector( '.shinken-fix-container' ) ) {
            this.structure_format = SHINKEN_LIST.CONST.STRUCTURE_FORMAT.WITH_HEADER_FIX;
        }
    },
    initFilters        : function () {
        this.filters = new SHINKEN_LIST.FiltersFromHtml( this.dom_element.querySelector( ".shinken-filter-line" ), this.type );
    },
    initLines          : function () {
        var dom_element = this.dom_element;
        switch ( this.structure_format ) {
            case SHINKEN_LIST.CONST.STRUCTURE_FORMAT.GENERIC:
                if ( !dom_element.classList.contains( "shinken-list-table" ) ) {
                    var temp_dom_element = DOM.Service.askFindChildElementWithClass( dom_element, "shinken-list-table", "shinken-list-line" );
                    if ( temp_dom_element ) {
                        dom_element = temp_dom_element;
                    }
                }
                break;
            case SHINKEN_LIST.CONST.STRUCTURE_FORMAT.WITH_HEADER_FIX:
                dom_element = dom_element.querySelector( ".shinken-scrollable-container .shinken-list-table" );
                break;
        }
        this.lines = new SHINKEN_LIST.LinesFromHtml( dom_element, this.type );
    },
    addLineWithDom: function ( dom_element ) {
        this.lines.addLineWithDom( dom_element );
        this.updateHtml();
    },
    
    initHeaders: function () {
        this.headers = new SHINKEN_LIST.HeadersFromHtml( this.dom_element.querySelector( ".shinken-header-line" ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromHtml, SHINKEN_LIST.Set );
MANAGER.DistributorControllerManager = (function ( self ) {
    "use strict";
    self.findControllerByEvent = function ( event, controller_name ) {
        var _controller_name = controller_name || self.findControllerName( event );
        if ( !_controller_name ) {
            return;
        }
        return MANAGER.DistributorControllerManager.getController( _controller_name );
    };
    self.findControllerName = function ( event, dom_element ) {
        if ( !event && !dom_element) {
            return;
        }
        var _target             = dom_element || event.target;
        var _parent_dom_element = DOM.Service.findParentElementWithClass( _target, "shinken-parent-event-listener", 500 );
        if ( !_parent_dom_element ) {
            return;
        }
        return _parent_dom_element.dataset.controller;
    };
    self.getController         = function ( _controller ) {
        switch ( _controller ) {
            case MANAGER.CONST.CONTROLLER.MASS_CHANGE:
                return CONTROLLER.MassChange;
            case MANAGER.CONST.CONTROLLER.LIST_ALL:
                return CONTROLLER.List;
            case MANAGER.CONST.CONTROLLER.SHINKEN_ELEMENT:
                return CONTROLLER.ShinkenElement;
            case MANAGER.CONST.CONTROLLER.SOURCES:
                return CONTROLLER.Source;
            case MANAGER.CONST.CONTROLLER.MAIN:
                return CONTROLLER.Main;
            case MANAGER.CONST.CONTROLLER.APPLY:
                return CONTROLLER.Apply;
            case MANAGER.CONST.CONTROLLER.WEATHER:
                return CONTROLLER.Weather;
            case MANAGER.CONST.CONTROLLER.COMMON_UI:
                return CONTROLLER.CommonUI;
            case MANAGER.CONST.CONTROLLER.UI_VISUALISATION:
                return CONTROLLER.UiVisualisation;
            case MANAGER.CONST.CONTROLLER.UI_PANELS:
                return CONTROLLER.UiPanels;
            case MANAGER.CONST.CONTROLLER.UI_PANELS_VIEW:
                return CONTROLLER.UiPanelsView;
            case MANAGER.CONST.CONTROLLER.UI_VIEW_WEATHER_MANAGER:
                return CONTROLLER.UiViewWeatherManager;
            case MANAGER.CONST.CONTROLLER.UI_LOGIN:
                return CONTROLLER.Login;
            case "SHINKEN-TODO":
                break;
            default:
                console.warn( "NO CONTROLLER FOUND FOR ", "[" + _controller + "]" );
        }
    };
    return self;
})( MANAGER.DistributorControllerManager || {} );
MANAGER.DistributorElementManager           = function () {
    this.elements        = {};
    this.mapping_by_name = {};
};
MANAGER.DistributorElementManager.prototype = {
    createElement                 : function ( data ) {
        var _to_return = new SHINKEN.OBJECT.ShinkenElement();
        _to_return.updateData( data );
        this.addElement( _to_return );
        return _to_return;
    },
    findElement                   : function ( uuid, data ) {
        if ( !uuid ) {
            return;
        }
        var _to_return = this.getElement( uuid );
        if ( !_to_return ) {
            _to_return = this.createElement( data );
        }
        else {
            _to_return.updateData( data );
        }
        return _to_return;
    },
    getElement                    : function ( uuid ) {
        return this.elements[ uuid ];
    },
    addElement                    : function ( element ) {
        this.elements[ element.getUUID() ]      = element;
        this.mapping_by_name[ element.getName() ] = element.getUUID();
    },
    getElementByName                    : function (name) {
        return this.elements[ this.mapping_by_name[ name ] ];
    },
};
MANAGER.__instance_element_distributor      = new MANAGER.DistributorElementManager();
MANAGER.DistributorObjectManager           = function () {
    this.objects = {};
};
MANAGER.DistributorObjectManager.prototype = {
    addObject : function ( _id, object ) {
        this.objects[ _id ] = object;
    },
    findObject: function ( _id ) {
        return this.objects[ _id ];
    },
    reset     : function () {
        this.objects = {};
    }
};
MANAGER.__instance_object_distributor      = new MANAGER.DistributorObjectManager();
MANAGER.DistributorResourcesManager           = function () {
    this.contents = {};
};
MANAGER.DistributorResourcesManager.prototype = {
    createResource: function ( uuid, data ) {
        var _to_return = new SHINKEN.OBJECT.Resource();
        _to_return.updateData( data );
        this.addResource( _to_return );
        return _to_return;
    },
    findResource  : function ( uuid, data ) {
        if ( !uuid ) {
            return;
        }
        var _to_return = this.getResource( uuid );
        if ( !_to_return ) {
            _to_return = this.createResource( uuid, data );
        }
        else {
            _to_return.updateData( data );
        }
        return _to_return;
    },
    getResource   : function ( uuid ) {
        return this.contents[ uuid ];
    },
    addResource   : function ( resource ) {
        this.contents[ resource.getUUID() ] = resource;
    }
};
MANAGER.__instance_resources_distributor      = new MANAGER.DistributorResourcesManager();
MANAGER.DistributorResourcesManager.factory = function ( key, data ) {
    switch ( key ) {
        case "resources":
            var _keys = Object.keys( data );
            var _size = _keys.length;
            var _currentKey;
            for ( var i = 0; i < _size; i++ ) {
                _currentKey = _keys[ i ];
                MANAGER.DistributorResourcesManager.factory( _currentKey, data[ _currentKey ] );
            }
            break;
        case "audio":
            var _keys = Object.keys( data );
            var _size = _keys.length;
            var _currentKey;
            for ( var i = 0; i < _size; i++ ) {
                _currentKey                          = _keys[ i ];
                data[ _currentKey ][ "resource_id" ] = _currentKey;
                data[ _currentKey ][ "type" ]        = "audio/mpeg";
                MANAGER.__instance_resources_distributor.findResource( _currentKey, data[ _currentKey ] );
            }
            break;
    }
};
MANAGER.DistributorResourcesManager.getInstance = function () {
    try {
        if ( window.parent.MANAGER.__instance_resources_distributor ) {
            return window.parent.MANAGER.DistributorResourcesManager.getInstance();
        }
    }
    catch ( e ) {
    }
    return MANAGER.__instance_resources_distributor;
};
MANAGER.DistributorWindowManager           = function () {
    this.windows        = {};
    this.parent_windows = {};
};
MANAGER.DistributorWindowManager.prototype = {
    createWindow                      : function ( name, is_menu, has_properties ) {
        var _id          = WINDOW.CONST.ID.WINDOW_TAB + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = has_properties ? new WINDOW.ElementWithProperties( name, _dom_element, is_menu ) : new WINDOW.Element( name, _dom_element, is_menu );
        this.setWindow( name, _to_return );
        MANAGER.__instance_object_distributor.addObject( _to_return.getID(), _to_return );
        return _to_return;
    },
    createParentWindow                : function ( name ) {
        var _to_return = new WINDOW.ElementGroup( name );
        this.setParentWindow( name, _to_return );
        return _to_return;
    },
    findWindow                        : function ( name, is_menu, parent_id, has_properties ) {
        if ( !name ) {
            return;
        }
        if ( parent_id ) {
            var _parent = this.findParentWindow( parent_id );
            if ( _parent ) {
                return _parent.getElementByName( name );
            }
        }
        var _to_return = this.getWindow( name );
        if ( !_to_return ) {
            _to_return = this.createWindow( name, is_menu, has_properties );
        }
        return _to_return;
    },
    findParentWindow                  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getParentWindow( name );
        if ( !_to_return ) {
            _to_return = this.createParentWindow( name );
        }
        return _to_return;
    },
    setWindow                         : function ( name, window ) {
        this.windows[ name ] = window;
    },
    setParentWindow                   : function ( name, parent_window ) {
        this.parent_windows[ name ] = parent_window;
    },
    getWindow                         : function ( name ) {
        return this.windows[ name ];
    },
    clickOnFirstWindowInParentWithName: function ( name ) { //FOR DOCUMENTATION
        var _keys = Object.keys( this.parent_windows );
        this.parent_windows[ _keys[ 0 ] ].clickOnWindow( name );
    },
    getParentWindow                   : function ( name ) {
        return this.parent_windows[ name ];
    },
    reset                             : function () {
        this.windows        = {};
        this.parent_windows = {};
    }
};
MANAGER.__instance_window_distributor      = new MANAGER.DistributorWindowManager();
MANAGER.DragNDropManager = (function ( self ) {
    "use strict";
    self.last_element_hovered    = null;
    self.current_parent_name     = null;
    self.type_drag_start         = null;
    self.list_element            = null;
    self.single_element_drag     = null;
    self.options                 = null;
    self._name_origin_controller = null;
    
    self.dragStartSingle           = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementByClassWithClassExcluded( event.target, "shinken-draggable", 'shinken-drag-exclude', 50 );
        if ( !self.single_element_drag ) {
            return;
        }
        self.single_element_drag.classList.add( "shinken-drag-active" );
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        var _body             = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-drag-in-progress" );
        _body.addEventListener( 'mouseleave', self.dragEndSingle, false );
        document.documentElement.addEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.addEventListener( 'mouseup', self.dragEndSingle, false );
        self._initParametersIsInWindow();
        self._callbackDragStart();
        event.stopPropagation();
        window.getSelection().removeAllRanges();
    };
    self.dragSingle                = function ( event ) {
        var _position_x = parseInt( event.clientX ) - self._mouse_x_origin + self._bounding_origin.left;
        var _position_y = parseInt( event.clientY ) - self._mouse_y_origin + self._bounding_origin.top;
        
        if ( self.options._is_in_screen ) {
            var _result = self._computeIsInScreen( _position_x, _position_y );
            _position_x = _result.x;
            _position_y = _result.y;
        }
        DOM.Service.setStyles( self.single_element_drag, { "top": _position_y + 'px', "left": _position_x + 'px' } );
        self._callbackDragMove( parseInt( event.clientX ) - self._mouse_x_origin, parseInt( event.clientY ) - self._mouse_y_origin );
    };
    self.dragEndSingle             = function () {
        document.documentElement.removeEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.removeEventListener( 'mouseup', self.dragEndSingle, false );
        var _body = document.querySelector( 'body' );
        _body.removeEventListener( 'mouseleave', self.dragEndSingle, false );
        document.querySelector( 'body' ).classList.remove( "shinken-has-drag-in-progress" );
        self.single_element_drag.classList.remove( "shinken-drag-active" );
        self._callbackDragStop();
        self.single_element_drag     = null;
        self._name_origin_controller = null;
    };
    self.dragStartShinken          = function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        e.dataTransfer.setData( 'text', 'anything' );
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width + 'px';
        }
    };
    self.dragOverShinken           = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken            = function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    self.dropShinken               = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    self._computeIsInScreen        = function ( _delta_x, _delta_y ) {
        var _to_return = { x: _delta_x, y: _delta_y };
        if ( _delta_x < 0 ) {
            _to_return.x = 0;
        }
        else if ( (_delta_x + self._bounding_origin.width) > self.options._is_in_screen.parameters.window_width ) {
            _to_return.x = self.options._is_in_screen.parameters.window_width - self._bounding_origin.width - self.options._is_in_screen.parameters.scrollbar_x_width;
        }
        
        if ( _delta_y < 0 ) {
            _to_return.y = 0;
        }
        else if ( (_delta_y + self._bounding_origin.height) > self.options._is_in_screen.parameters.window_height ) {
            _to_return.y = self.options._is_in_screen.parameters.window_height - self._bounding_origin.height - self.options._is_in_screen.parameters.scrollbar_y_height;
        }
        return _to_return;
    };
    self._initParametersIsInWindow = function () {
        self.options = {
            _is_in_screen: {
                is_active : false,
                parameters: {}
            }
        };
        if ( !self.single_element_drag ) {
            return;
        }
        if ( !DOM.Service.hasKeyInDataSet( self.single_element_drag, 'dragIsInScreen' ) ) {
            return;
        }
        self.options._is_in_screen.is_active = true;
        
        var _body                             = document.querySelector( 'body' );
        self.options._is_in_screen.parameters = {
            window_width      : window.innerWidth,
            window_height     : window.innerHeight,
            scrollbar_x_width : DOM.Service.scrollbarIsVisible( _body, 'width' ) ? 17 : 0,
            scrollbar_y_height: DOM.Service.scrollbarIsVisible( _body, 'height' ) ? 17 : 0
        };
    };
    self._getDragNameForCallback   = function () {
        var _name = self.single_element_drag.dataset[ 'dragResizeElementName' ];
        if ( _name ) {
            return _name;
        }
    };
    self._callbackDragStart        = function () {
        if ( MANAGER && MANAGER.DistributorControllerManager ) {
            self._name_origin_controller = MANAGER.DistributorControllerManager.findControllerName( "", self.single_element_drag );
        }
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragStart( self._name_origin_controller, self._getDragNameForCallback(), self._mouse_x_origin, self._mouse_y_origin );
        }
    };
    self._callbackDragMove         = function ( delta_x, delta_y ) {
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragMove( self._name_origin_controller, self._getDragNameForCallback(), delta_x, delta_y );
        }
    };
    self._callbackDragStop         = function () {
        if ( MANAGER && MANAGER.EventManager && self._name_origin_controller ) {
            MANAGER.EventManager.onDragStop( self._name_origin_controller, self._getDragNameForCallback() );
        }
    };
    return self;
})
( MANAGER.DragNDropManager || {} );
MANAGER.EventManager = {
    last_element_hovered: null,
    stop_propagation    : false,
    mouse_down_target   : null,
    mouse_on_target     : null,
    openIframeModal      : function ( url, id ) {
        MANAGER.__instance_window_modal_manager.setIframe( url, id );
    },
    closeModal           : function () {
        if ( MANAGER.__instance_window_modal_manager ) {
            MANAGER.__instance_window_modal_manager.askDoClose();
        }
    },
    closeNotify          : function ( notify_id ) {
        MANAGER.__instance_notify_manager.close( notify_id );
    },
    clickOnToggleCollapse: function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-parent", 25 );
        if ( !_parent_dom_element ) {
            return;
        }
        _parent_dom_element.classList.toggle( "shinken-collapsed" );
    },
    logout: function () {
        window.location = '/logout';
        sessionStorage.removeItem( "user_id" );
    },
    onFocus        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onFocus();
    },
    onFocusIn      : function ( event, event_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( !_controller ) {
            console.warn( "[EventManager - onFocusIn]", "Controller not found", event.target );
            return;
        }
        _controller.onFocusIn( event, event_name );
    },
    onFocusOut     : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onFocusOut( event );
    },
    stopPropagation: function ( event ) {
        if ( event ) {
            event.stopPropagation();
        }
        else {
            this.stop_propagation = true;
            var self              = this;
            setTimeout( function () {
                self.stop_propagation = false;
            }, 50 );
        }
    },
    clickOnRadioBtn: function ( event, event_name, param ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnRadioBtn( event, event_name, param );
    },
    clickOnButton  : function ( event, event_name, param ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( !_controller ) {
            console.warn( "[EventManager - clickOnButton]", "Controller not found", event.target );
            return;
        }
        if ( !event_name ) {
            var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 50 );
            if ( _parent_dom_element ) {
                event_name = _parent_dom_element.dataset.name;
            }
            else {
                console.warn( "[EventManager - clickOnButton]", "not element with data set 'name' found", event.target );
                return;
            }
        }
        event.stopPropagation();
        _controller.clickOnButton( event, event_name, param );
    },
    onKeyUp        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onKeyUp( event );
    },
    onKeyDown      : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onKeyDown( event );
    },
    onPaste        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onPaste( event );
    },
    onDragStart: function ( _controller_name, element_name, origin_x, origin_y ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragStart( element_name, origin_x, origin_y );
        }
    },
    onDragMove : function ( _controller_name, element_name, delta_x, delta_y ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragMove( element_name, delta_x, delta_y );
        }
    },
    onDragStop : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onDragStop( element_name );
        }
    },
    onResizeStart: function ( _controller_name, element_name, width, height ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeStart( element_name );
        }
    },
    onResizeMove : function ( _controller_name, element_name, width, height ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeMove( element_name, width, height );
        }
    },
    onResizeStop : function ( _controller_name, element_name ) {
        var _controller = MANAGER.DistributorControllerManager.getController( _controller_name );
        if ( _controller ) {
            _controller.onResizeStop( element_name );
        }
    },
    onChangeOnInputKey           : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.askComputeKeyAfterChange( event.target );
    },
    clickOnAddNewLocalMacro      : function () {
        return App.Elements.DataTab.addNewData();
    },
    clickOnDeletePropertyBtn     : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.delete();
    },
    clickDataCollapseButtonGlobal: function () {
        App.Elements.DataTab.toggleCollapseButtonGlobal();
    },
    clickDataCollapseButton      : function ( dom_element ) {
        App.Elements.DataTab.toggleCollapseButton( dom_element );
    },
    goToDataView           : function ( data_name ) {
        MANAGER.EventManager.clickOnWindowNavigation( null, MANAGER.__instance_element_distributor.current_element.uuid, true, WINDOW.CONST.ELEMENT.DATAS );
        var _prop = MANAGER.__instance_property_distributor.getDataWithName( data_name );
        if ( _prop && _prop.group_data ) {
            MANAGER.EventManager.clickOnDataNavigation( _prop.group_data.uuid );
        }
    },
    clickOnDataNavigation  : function ( group_uuid ) {
        App.Elements.DataTab.clickOnDataNavigation( group_uuid );
    },
    clickOnWindowNavigation: function ( event, name, update_url, window_name ) {
        if ( !window_name ) {
            var _nav_tab = DOM.Service.findParentElementWithClass( event.target, WINDOW.CONST.CLASS.WINDOW_TAB, 10 );
            if ( !_nav_tab ) {
                return;
            }
            window_name = _nav_tab.dataset.name;
        }
        var _parent_window = MANAGER.__instance_window_distributor.findParentWindow( name );
    
        _parent_window.clickOnWindow( window_name );
        if ( update_url ) {
            SHINKEN.HIGHWAY.goToElementTab( window_name );
        }
        
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        try {
            _controller.computeSizes();
        }
        catch ( e ) {
        }
    },
    clickOnCheckboxInput: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCheckboxInput( event );
    },
    onChangeOnInput: function ( event, event_name, param ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.onChangeOnInput( event, event_name, param );
    },
    onResize       : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var parent_name         = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onResize( dom_element );
    },
    onMoveRangeCursor: function ( parent_name, ask_after_action, event ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.onMoveRangeCursor( null, event );
        if ( ask_after_action ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( _object );
        }
    },
    clickOnBtnPlus           : function ( parent_name, event ) {
        this.stopPropagation();
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnPlus( event );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnSelector          : function ( event, param, controller_name ) {
        event.stopPropagation();
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnSelector( event, param );
    },
    clickOnAllItemsSelector  : function ( parent_name, limit ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAllItemsSelector( limit );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnItemSelector      : function ( event, parent_name, element, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        _controller.clickOnItemSelector( event, parent_name, element );
    },
    clickOnDeleteItemSelector: function ( parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnDeleteItemSelector( key_name );
        MANAGER.ListenerEventManager.askAfterActionProperty( _object );
    },
    clickOnBtnInheritance: function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnBtnInheritance();
    },
    clickOnInput         : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnInput( event );
    },
    muteEvent            : function ( event ) {
        event.preventDefault();
        event.stopPropagation();
    },
    mutePropagation      : function ( event ) {
        event.stopPropagation();
    },
    clickOnToggleViewSource        : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnToggleViewSource( event );
    },
    clickOnActivatedSource         : function ( event ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedSource]", "[not admin]", "refused" );
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.toggleSourceEnable( event );
    },
    clickOnActivatedDiscoverySource: function ( source_name, discovery_id ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnActivatedDiscoverySource]", "[not admin]", "refused" );
            return;
        }
        var _source    = MANAGER.__instance_source_distributor.findSource( source_name );
        var _discovery = _source[ SOURCE.CONST.FIELD.IP_RANGES ].getRangeById( discovery_id );
        _discovery.toggleEnable();
    },
    clickOnForceSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnForceSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.askForceImport();
    },
    clickOnCleanSource             : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnCleanSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.cleanImport();
    },
    clickOnLastExecutionSource     : function ( name ) {
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            console.warn( "[clickOnLastExecutionSource]", "[not admin]", "refused" );
            return;
        }
        var _source = MANAGER.__instance_source_distributor.findSource( name );
        _source.redirectToSourceLastExecution();
    },
    clickOnWorkflowTab       : function ( name ) {
        var dom_element = document.querySelector( "#shinken-workflow-container" );
        DOM.Service.setDataSet( dom_element, 'selected', name );
        dom_element.classList.toggle( 'PATCH_IE' );
    },
    clickOpenNewWindow       : function ( event, link, id ) {
        var _path = "/elements/";
        _path += link + '/';
        _path += id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    clickOnLinkForWorkingArea: function ( event, id ) { //NE MARCHE QUE POUR LES HOSTS
        var _path = "/elements/working_area/hosts/" + id;
        if ( event.ctrlKey ) {
            window.open( _path, '_blank' );
        }
        else {
            window.location = _path;
        }
    },
    keydown                     : function ( event ) {
        var _key_code = event.keyCode;
        switch ( _key_code ) {
            case SHINKEN.CONST.KEY_CODE.F1:
                if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
                    window.onhelp = function () {
                        return false;
                    };
                }
                event.preventDefault();
                event.stopPropagation();
                break;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.keydown( event, _key_code );
        }
    },
    mouseEnter                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseEnter( event );
        }
    },
    mouseLeave                  : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.mouseLeave( event );
        }
    },
    mouseMove                   : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseMove( event );
        }
    },
    mouseWheel                  : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseWheel( event );
        }
    },
    mouseDown                   : function ( event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.mouseDown( event );
        }
    },
    onClick                     : function ( event ) {
        if ( this.stop_propagation ) {
            this.stop_propagation = false;
            return;
        }
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.onClick( event );
        }
    },
    onScroll                    : function ( event, controller_name, param ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.onScroll( event, param );
        }
    },
    clickOnForcedHelpButton     : function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 20 );
        var name                = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( name );
        _object.clickOnForcedHelpButton();
    },
    clickOnForcedHelpButtonCheck: function ( event, dom_element ) {
        event.preventDefault();
        event.stopPropagation();
        MANAGER.HelpManager.setForced( 'help_title_try_checks', dom_element, true );
    },
    clickOnPaste                : function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        if ( _controller ) {
            _controller.clickOnPaste( event );
        }
    },
    clickOnModeTab              : function ( element, do_blink_animation ) {
        var _parent = document.getElementById( 'id-shinken-window-checks-target' );
        DOM.Service.setDataSet( _parent, 'tabSelected', element.dataset.value );
        if ( do_blink_animation ) {
            DOM.Service.askAddClass( element, 'shinken-pulsate', 2000 );
        }
        if ( element.dataset.value !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            var _elements = document.querySelectorAll( '.shinken-tab-check-col-tags' );
            for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
                _elements[ i ].classList.remove( "shinken-active" );
            }
            var _elements_tr = document.querySelectorAll( '.shinken-tr-check-override' );
            for ( var i = 0, _size = _elements_tr.length; i < _size; i++ ) {
                _elements_tr[ i ].classList.add( "shinken-hidden" );
            }
        }
        MANAGER.__instance_navigator_size.tab_data_exclude();
    },
    clickOnSetOverride          : function ( dom_uuid ) {
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE + '"]' ), true );
        }
        App.Elements.ChecksTab.getCheckOverrideData( dom_uuid );
        MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.CLICK_ON_SERVICE_OVERRIDE );
    },
    clickOnSetExclude           : function ( dom_uuid, event, ignore_if_on_status_exclude ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _element = document.getElementById( 'id-shinken-window-checks-target' );
        if ( _element.dataset.tabSelected !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE ) {
            this.clickOnModeTab( _element.querySelector( '.shinken-check-mode-menu-tab[data-value="' + OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE + '"]' ), true );
        }
        else if ( !ignore_if_on_status_exclude ) {
            var _check_in_host = App.Elements.ChecksTab.getCheckInHostElement( dom_uuid );
            _check_in_host.changeExcludeStatus();
        }
    },
    clickOnDeleteInvalidOverride: function ( type, name ) {
        MANAGER.__instance_override_unvalid.deleteOverride( type, name );
        App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
    },
    clickOnCleanCheckOverrides  : function ( event, check_uuid ) {
        event.stopPropagation();
        var _confirm = confirm( _( 'element.confirm_remove_override' ) );
        if ( _confirm ) {
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }
    },
    clickOnFocusOnDuplicateCheck: function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckByID( check_uuid );
        _check_in_page_host.dom_element.scrollIntoView( false );
        DOM.Service.askAddClass( _check_in_page_host.dom_element.querySelector( '.shinken-tab-check-col-name' ), 'shinken-pulsate-focus', 3000 );
    },
    clickOnTryCheck     : function ( check_uuid, is_exec, is_on_poller ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.askTryCheck( is_exec, is_on_poller );
    },
    clickOnCleanTryCheck: function ( check_uuid ) {
        var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( check_uuid );
        _check_in_page_host.hide_eval_check();
    },
    clickOnMultiLineObjectAdd: function ( parent_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        _object.clickOnAddLine();
    },
    clickOnDeleteLine        : function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, PROPERTY.CONST.CLASS.SKINKEN_LINE, 25 );
        var _name               = _parent_dom_element.dataset.name;
        var _object             = MANAGER.__instance_property_distributor.findElement( _name );
        _object.deleteLine( dom_element );
    },
    clickOnHooksPopup: function ( event, element ) {
        event.stopImmediatePropagation();
        var target    = element;
        var parent    = target.parentNode;
        var is_active = target.classList.contains( 'active' );
        if ( is_active ) {
            target.classList.remove( 'active' );
            parent.classList.remove( "shinken-force-display-block" );
        }
        else {
            target.classList.add( 'active' );
            parent.classList.add( "shinken-force-display-block" );
        }
    },
    clickOnCollapseButton: function ( event ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.clickOnCollapseButton( event );
    },
    simulateClickOnFilter: function ( event, header_name, value ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event );
        _controller.simulateClickOnFilter( event, header_name, value );
    },
    clickOnForceImportInSource: function ( source_name ) {
        $.ajax( {
            url    : COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.URL
                     + source_name
                     + COMMUNICATION.QUERY.GET.SOURCE.FORCE_IMPORT.OPTIONS.TIMESTAMP
                     + DATE_TIME.getTimestampNow(),
            success: function ( data ) {
                var _sources = MANAGER.__instance_source_distributor.findSources( SOURCE.CONST.TYPES.ALL );
                _sources.refresh();
            },
            error  : function ( data, txt ) {
                console.log( 'Got bad result for' + data );
            }
        } );
    },
    shinkenBroadcast: function ( key, value_object, event, controller_name ) {
        var _controller = MANAGER.DistributorControllerManager.findControllerByEvent( event, controller_name );
        if ( _controller ) {
            _controller.shinkenBroadcast( key, value_object );
        }
    }
};
MANAGER.ResizeManager = (function ( self ) {
    "use strict";
    self.dom_element_resize      = null;
    self._bounding_origin        = null;
    self._mouse_x_origin         = null;
    self._mouse_y_origin         = null;
    self._width_origin           = null;
    self._height_origin          = null;
    self._name_origin_controller = null;
    
    
    self.simulateResize            = function ( dom_element ) {
        var _event = {
            "clientX"      : 0,
            "clientY"      : 0,
            stopPropagation: function () {
            }
        };
        setTimeout( function () {
            self.resizeStart( _event, dom_element );
            self.doResize( _event );
            self.resizeEnd();
        }, 0 );
    };
    self.resizeStart               = function ( event, dom_element_target ) {
        var _dom_target         = dom_element_target || event.target;
        self.dom_element_resize = DOM.Service.findParentElementWithClass( _dom_target, "shinken-resizable", 50 );
        self._bounding_origin   = DOM.Service.getBoundingClientRect( self.dom_element_resize );
        self._min_width         = parseInt( _dom_target.dataset[ 'resizeMinWidth' ] );
        self._max_width         = parseInt( _dom_target.dataset[ 'resizeMaxWidth' ] );
        self._min_height        = parseInt( _dom_target.dataset[ 'resizeMinHeight' ] );
        self._max_height        = parseInt( _dom_target.dataset[ 'resizeMaxHeight' ] );
        self._mouse_x_origin    = parseInt( event.clientX );
        self._mouse_y_origin    = parseInt( event.clientY );
        self._width_origin      = self._bounding_origin.width;
        self._height_origin     = self._bounding_origin.height;
        self._type              = self.dom_element_resize.dataset.resizeType;
        self.dom_element_resize.classList.add( "shinken-resize-active" );
        
        var _body = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-resize-in-progress" );
        _body.addEventListener( 'mouseleave', self.resizeEnd, false );
        
        document.documentElement.addEventListener( 'mousemove', self.doResize, false );
        document.documentElement.addEventListener( 'mouseup', self.resizeEnd, false );
        self._callbackResizeStart( event );
        event.stopPropagation();
    };
    self.doResize                  = function ( event ) {
        var _width  = self._width_origin;
        var _height = self._height_origin;
        switch ( self._type ) {
            case MANAGER.CONST.RESIZE.TYPE.LEFT:
                _width = (self._width_origin - event.clientX + self._mouse_x_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.RIGHT:
                _width  = (self._width_origin + event.clientX - self._mouse_x_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.TOP:
                _height = (self._height_origin - event.clientY + self._mouse_y_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM:
                _height  = (self._height_origin + event.clientY - self._mouse_y_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM_RIGHT:
                _width  = (self._width_origin + event.clientX - self._mouse_x_origin);
                _height = (self._height_origin + event.clientY - self._mouse_y_origin);
                break;
        }
        
        if ( self._min_width && self._min_width > _width ) {
            _width = self._min_width;
        }
        if ( self._min_height && self._min_height > _height ) {
            _height = self._min_height;
        }
        if ( self._max_width && self._max_width < _width ) {
            _width = self._max_width;
        }
        if ( self._max_height && self._max_height < _height ) {
            _height = self._max_height;
        }
        
        switch ( self._type ) {
            case MANAGER.CONST.RESIZE.TYPE.LEFT:
            case MANAGER.CONST.RESIZE.TYPE.RIGHT:
                DOM.Service.setStyles( self.dom_element_resize, { width: _width + 'px' } );
                break;
            case MANAGER.CONST.RESIZE.TYPE.TOP:
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM:
                DOM.Service.setStyles( self.dom_element_resize, { height: _height + 'px' } );
                
                break;
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM_RIGHT:
                DOM.Service.setStyles( self.dom_element_resize, { width: _width + 'px', height: _height + 'px' } );
                break;
        }
        
        self._callbackResizeMove(_width, _height);
    };
    self.resizeEnd                 = function () {
        document.documentElement.removeEventListener( 'mousemove', self.doResize, false );
        document.documentElement.removeEventListener( 'mouseup', self.resizeEnd, false );
        var _body = document.querySelector( 'body' );
        _body.removeEventListener( 'mouseleave', self.resizeEnd, false );
        document.querySelector( 'body' ).classList.remove( "shinken-has-resize-in-progress" );
        self.dom_element_resize.classList.remove( "shinken-resize-active" );
        self._callbackResizeEnd();
        self.dom_element_resize = null;
        self._min_width         = null;
        self._min_height        = null;
        self._type              = null;
    };
    self._getResizeNameForCallback = function () {
        var _name = self.dom_element_resize.dataset[ 'dragResizeElementName' ];
        if ( _name ) {
            return _name;
        }
        console.error( "MANAGER.DragNDropManager : The dataset callbackResizeElementName was not found " );
    };
    self._callbackResizeStart      = function ( event ) {
        if ( MANAGER && MANAGER.DistributorControllerManager ) {
            self._name_origin_controller = MANAGER.DistributorControllerManager.findControllerName( event );
        }
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeStart( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    self._callbackResizeMove       = function (width, height) {
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeMove( self._name_origin_controller, self._getResizeNameForCallback(), width, height );
        }
    };
    self._callbackResizeEnd        = function () {
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeStop( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    return self;
})
( MANAGER.ResizeManager || {} );
MANAGER.WindowModalManager           = function () {
    this.dom_element         = document.getElementById( 'id-shinken-window-modal' );
    this.dom_element_content = this.dom_element.querySelector( '.shinken-window-modal-content' );
    this.dom_element_loading = this.dom_element.querySelector( '.shinken-loading-text' );
    this.dom_element_close   = this.dom_element.querySelector( '#id-shinken-window-modal-close' );
    this.class_added         = "";
    this.is_open             = false;
};
MANAGER.WindowModalManager.prototype = {
    setContent        : function ( to_set ) {
        this.dom_element_content.innerHTML = to_set;
        this.dom_element.classList.remove( "shinken-hidden" );
        this.is_open = true;
    },
    showCloseContainer: function () {
        this.dom_element_close.classList.remove( "shinken-hidden" );
    },
    addClass          : function ( to_set ) {
        this.class_added = to_set;
        this.dom_element.classList.add( to_set );
    },
    addCloseEvent     : function ( event_to_ask_to_iframe, controller ) {
        this.close_event            = event_to_ask_to_iframe;
        this.close_event_controller = controller;
    },
    setIframe         : function ( url_to_set, id ) {
        if ( this.dom_element_loading ){
            this.dom_element_content.classList.add( "shinken-hidden" );
            this.dom_element_loading.classList.remove( "shinken-hidden" );
        }
        if ( id ) {
            this.setIframeID( id );
        }
        var _id     = this._id ? 'id="' + this._id + '"' : '';
        var _to_set = '<iframe ' + _id + ' src="' + url_to_set + '"></iframe>';
        this.setContent( _to_set );
    },
    setIframeID       : function ( to_set ) {
        this._id = to_set;
    },
    iframeLoaded      : function () {
        this.dom_element_content.classList.remove( "shinken-hidden" );
        this.dom_element_loading.classList.add( "shinken-hidden" );
    },
    askDoClose        : function () {
        if ( this.close_event ) {
            SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD.doActionAfter( this._id, this.close_event );
        }
        else {
            MANAGER.__instance_window_modal_manager.close();
        }
    },
    close        : function () {
        this.doClose();
        if ( this.close_event_controller ) {
            this.close_event_controller.doActionAfter( this.close_event, true );
            this.close_event_controller = null;
        }
        this.close_event = null;
    },
    doClose           : function () {
        this.is_open                       = false;
        this.dom_element_content.innerHTML = '';
        this.dom_element.classList.add( "shinken-hidden" );
        this.dom_element_close.classList.add( "shinken-hidden" );
        if ( this.class_added ) {
            this.dom_element.classList.remove( this.class_added );
            this.class_added = "";
        }
    }
};
MANAGER.__instance_window_modal_manager; //INIT IN LOADING MANAGER
SHINKEN.OBJECT.callbacksAfterCloseModal           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.callbacksAfterCloseModal";
    this.init();
};
SHINKEN.OBJECT.callbacksAfterCloseModal.prototype = {
    init        : function () {
        this.resetActions();
    },
    addCallback : function ( method, param_1, param_2 ) {
        this.contents.push( new SHINKEN.OBJECT.callbackAfterCloseModal( method, param_1, param_2 ) );
    },
    doActions   : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents.pop().doAction();
        }
    },
    resetActions: function () {
        this.contents = [];
    }
};
SHINKEN.OBJECT.callbackAfterCloseModal            = function ( method, param_1, param_2 ) {
    this.__class_name__ = "SHINKEN.OBJECT.callbackAfterCloseModal";
    this.method         = method;
    this.param_1        = param_1;
    this.param_2        = param_2;
    this.init();
};
SHINKEN.OBJECT.callbackAfterCloseModal.prototype  = {
    init    : function () {
    },
    doAction: function () {
        this.method( this.param_1, this.param_2 );
    }
};
SHINKEN.OBJECT.ConfirmationPopup           = function () {
    this.dom_element       = null;
    this.dom_element_popup = null;
    this.init();
};
SHINKEN.OBJECT.ConfirmationPopup.prototype = {
    init: function () {
    },
    show: function () {
        this.dom_element.classList.remove( "shinken-hidden" );
    },
    hide: function () {
        this.dom_element.classList.add( "shinken-hidden" );
        this.reset();
    },
    computeHtmlDomElement: function () {
        this.dom_element = DOM.Service.createElement( "div", {
            "class"          : "shinken-parent-event-listener shinken-hidden",
            "id"             : "id-shinken-confirmation-popup-container",
            "data-controller": "ui_visualisation"
        } );
        this.computeHtmlPopup();
        DOM.Service.addElementTo( this.dom_element, document.body );
    },
    computeHtmlPopup     : function () {
        this.dom_element_popup = DOM.Service.createElement( "div", { "class": "shinken-confirmation-popup" } );
        this.computeHtmlHeader();
        this.computeHtmlContent();
        this.computeHtmlFooter();
        DOM.Service.addElementTo( this.dom_element_popup, this.dom_element );
    },
    computeHtmlHeader    : function () {
        var _container         = DOM.Service.createElement( "div", { "class": "shinken-header-confirmation-popup" } );
        var _table             = DOM.Service.createElement( "table", { "class": "shinken-width-100" } );
        var _tr                = DOM.Service.createElement( "tr", { "class": "shinken-header-confirmation-popup" } );
        this.dom_element_title = DOM.Service.createElement( "td", { "class": "shinken-title-confirmation-popup" } );
        var _onclick_attribute_close = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-confirmation-popup")';
        var _td_close          = DOM.Service.createElement( "td", { "class": "shinken-confirmation-popup-cell-close",  "onclick": _onclick_attribute_close }, "<span class='shinkon-times'></span>" );
        DOM.Service.addElementTo( this.dom_element_title, _tr );
        DOM.Service.addElementTo( _td_close, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _container );
        DOM.Service.addElementTo( _container, this.dom_element_popup );
    },
    computeHtmlContent   : function () {
        this.dom_element_content = DOM.Service.createElement( "div", { "class": "shinken-content-confirmation-popup" } );
        DOM.Service.addElementTo( this.content, this.dom_element_content );
        DOM.Service.addElementTo( this.dom_element_content, this.dom_element_popup );
    },
    computeHtmlFooter    : function () {
        var _container        = DOM.Service.createElement( "div", { "class": "shinken-footer-confirmation-popup" } );
        var _table            = DOM.Service.createElement( "table", { "class": "shinken-footer-table-confirmation-popup" } );
        var _tr               = DOM.Service.createElement( "tr", {} );
        var _td               = DOM.Service.createElement( "td", {} );
        var _table_buttons    = DOM.Service.createElement( "table", { "class": "shinken-action-button-table-confirmation-popup" } );
        var _tr_buttons       = DOM.Service.createElement( "tr", {} );
        var _td_validate      = DOM.Service.createElement( "td", {} );
        var _onclick_validate = 'MANAGER.EventManager.clickOnButton(event, "click-on-validate-confirmation-popup")';
        var _validate_button  = DOM.Service.createElement( "div", {
            "class"  : "shinken-action-button-confirmation-popup shinken-validate-button",
            "onclick": _onclick_validate
        }, _( "confirmation_popup.validate_button", [DICTIONARY_COMMON_UI] ) );
        var _td_cancel        = DOM.Service.createElement( "td", {} );
        var _onclick_cancel   = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-confirmation-popup")';
        var _cancel_button    = DOM.Service.createElement( "div", {
            "class"  : "shinken-action-button-confirmation-popup shinken-cancel-button",
            "onclick": _onclick_cancel
        }, _( "confirmation_popup.cancel_button", [DICTIONARY_COMMON_UI] ) );
        
        
        DOM.Service.addElementTo( _validate_button, _td_validate );
        DOM.Service.addElementTo( _td_validate, _tr_buttons );
        
        DOM.Service.addElementTo( _cancel_button, _td_cancel );
        DOM.Service.addElementTo( _td_cancel, _tr_buttons );
        
        DOM.Service.addElementTo( _tr_buttons, _table_buttons );
        DOM.Service.addElementTo( _table_buttons, _td );
        DOM.Service.addElementTo( _td, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _container );
        DOM.Service.addElementTo( _container, this.dom_element_popup );
    },
    setContent           : function ( to_set ) {
        if ( !this.dom_element ) {
            this.computeHtmlDomElement();
        }
        DOM.Service.addElementTo( to_set, this.dom_element_content );
    },
    setTitle             : function ( to_set ) {
        if ( !this.dom_element ) {
            this.computeHtmlDomElement();
        }
        this.dom_element_title.innerHTML = to_set;
    },
    setController        : function ( to_set ) {
        if ( !this.dom_element ) {
            this.computeHtmlDomElement();
        }
        DOM.Service.setDataSet( this.dom_element, "controller", to_set );
    },
    reset                : function () {
        DOM.Service.empty( this.dom_element_content );
        DOM.Service.empty( this.dom_element_title );
        DOM.Service.setDataSet( this.dom_element, "controller", "ui_visualisation" );
    }
};
MANAGER.__instance_confirmation_popup      = new SHINKEN.OBJECT.ConfirmationPopup();
SHINKEN.OBJECT.DataHistoric                = function () {
    this.init();
};
SHINKEN.OBJECT.DataHistoric.prototype      = {
    init               : function () {
        this._original = null;
        this.resetPreviews();
    },
    resetPreviews      : function () {
        this._valid_previewing = [];
        this.resetInvalidPreview();
    },
    resetInvalidPreview: function () {
        this._invalid_preview = null;
    },
    getLastValid     : function () {
        if ( this._invalid_preview ) {
            this.resetInvalidPreview();
            if ( this.hasValidPreview() ) {
                return this._valid_previewing[ this._valid_previewing.length - 1 ];
            }
            return this._original;
        }
        if ( this.hasValidPreview() ) {
            this._valid_previewing.pop();
            if ( this.hasValidPreview() ) {
                return this._valid_previewing[ this._valid_previewing.length - 1 ];
            }
        }
        return this._original;
    },
    hasValidPreview  : function () {
        return this._valid_previewing.length;
    },
    setOriginal      : function ( to_set ) {
        this._original = new SHINKEN.OBJECT.DataEntryHistoric( to_set );
    },
    getOriginal      : function () {
        return this._original;
    },
    addValidPreview  : function ( to_add ) {
        this.resetInvalidPreview();
        this._valid_previewing.push( new SHINKEN.OBJECT.DataEntryHistoric( to_add ) );
    },
    setInvalidPreview: function ( to_set ) {
        this._invalid_preview = to_set;
    }
};
SHINKEN.OBJECT.DataEntryHistoric           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DataEntryHistoric.prototype = {
    init: function ( data ) {
        this.setData( data );
    },
    getData   : function () {
        return this.data;
    },
    setData   : function ( to_set ) {
        this.data = to_set;
    },
    updateData: function ( to_add ) {
        var _keys = Object.keys( to_add );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key              = _keys[ i ];
            this.data[ _current_key ] = to_add[ _current_key ];
        }
    }
};
SHINKEN.OBJECT.DefaultConfiguration           = function ( default_configuration ) {
    this.init( default_configuration );
};
SHINKEN.OBJECT.DefaultConfiguration.prototype = {
    init        : function ( default_configuration ) {
        this.initInternal();
        this.updateData( default_configuration );
    },
    initInternal: function () {
        this.children_object = [];
        this.children_dict   = {};
        this.own_property    = [];
    },
    getValidOwnProperty        : function () {
        if ( typeof this.valid_own_property === "undefined" ) {
            this.valid_own_property = this._getValidOwnProperty();
        }
        return this.valid_own_property;
    },
    _getValidOwnProperty       : function () {
        return false;
    },
    getValidOwnChildren        : function () {
        if ( typeof this.valid_own_children === "undefined" ) {
            this.valid_own_children = this._getValidOwnChildren();
        }
        return this.valid_own_children;
    },
    _getValidOwnChildren       : function () {
        return false;
    },
    getChildrenObject          : function () {
        return this.children_object;
    },
    getChildrenObjectDict      : function () {
        return this.children_dict;
    },
    _getObjectToJson           : function () {
        var _valid_own_property = this.getValidOwnProperty() ? this.getValidOwnProperty().getKeys() : false;
        var _to_add             = _valid_own_property || this.own_property || [];
        var to_return           = {};
        for ( var i = 0, _size_i = _to_add.length; i < _size_i; i++ ) {
            if ( typeof this[ _to_add[ i ] ] === 'undefined' ) {
                continue;
            }
            to_return[ _to_add[ i ] ] = this[ _to_add[ i ] ].getObjectToJson();
        }
        return to_return;
    },
    getDefaultValueLabel       : function () {
        return "default";
    },
    setUnknownValue                : function ( key, value_object ) {
        if ( !this.unknown_property ) {
            this.unknown_property = {};
        }
        this.unknown_property[ key ] = value_object instanceof SHINKEN.OBJECT.Param ? value_object : new SHINKEN.OBJECT.Param( key, value_object );
        this._setUnknownValue()
    },
    _setUnknownValue                : function ( key, value ) {
    },
    setIsNotTheExpectedObject      : function ( key, value_object ) {
        if ( !this.not_valid_format_property ) {
            this.not_valid_format_property = {};
        }
        this.not_valid_format_property[ key ]          = value_object instanceof SHINKEN.OBJECT.Param ? value_object : new SHINKEN.OBJECT.Param( key, value_object );
        this._setIsNotTheExpectedObject()
    },
    _setIsNotTheExpectedObject                : function ( key, value ) {
    },
    updateData           : function ( data ) {
        if ( !data ) {
            return;
        }
        
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData              : function ( key, value ) {
        return this._setData( key, value );
    },
    _setData             : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
            default:
                if ( typeof value === 'object' && value !== null && value !== undefined ) {
                    if ( !this._setDataDefaultObject( key, value ) ) {
                        this.setUnknownValue( key, value );
                    }
                    this.children_object.push( this[ key ] );
                    this.children_dict[ key ] = this[ key ];
                }
                else {
                    this.setValueDefault( key, value );
                }
                break;
        }
    },
    _setDataDefaultObject: function ( key, value ) {
        this[ key ] = new SHINKEN.OBJECT.DefaultConfiguration( value );
        return true;
    },
    setValueDefault      : function ( key, value ) {
        this[ key ]               = new SHINKEN.OBJECT.Param( key, {} );
        this[ key ].user_value = value
        var _valid_own_properties = this.getValidOwnProperty();
        if ( _valid_own_properties ) {
            var _parameter = _valid_own_properties.getParameter( key );
            if ( !_parameter ) {
                var _valid_own_children_keys = this.getValidOwnChildren();
                if ( _valid_own_children_keys && SHINKEN.TOOLS.ARRAY.contains( _valid_own_children_keys.getKeys(), key ) ) {
                    this.setIsNotTheExpectedObject( key, this[ key ] );
                }
                else {
                    this.setUnknownValue( key, this[ key ] );
                }
                return;
            }
            else {
                this.changeToDefaultValueIfNeeded(key, value, _parameter);
            }
        }
        this.own_property.push( key );
    },
    changeToDefaultValueIfNeeded         : function ( key, value, parameter ) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfiguration, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty.prototype = {
    _setDataDefaultObject      : function ( key, value_object ) {
        var _current = this.getValidOwnChildren().getConfigurationChild( key );
        if ( _current ) {
            if ( typeof value_object === "undefined" ) {
                this[ key ] = eval( "new " + _current.class_constructor + "({})" );
            }
            else {
                this[ key ] = eval( "new " + _current.class_constructor + "(value_object)" );
            }
            if ( _current.extra_action ) {
                eval( "this[ key ]." + _current.extra_action );
            }
            return true;
        }
        return false;
    },
    _getValidOwnProperty       : function () {
        return new SHINKEN_VALIDATION.Parameters();
    },
    _getValidOwnChildren       : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren();
    },
    getChildrenObject          : function () {
        var _to_return         = [];
        var _own_children_keys = this._getValidOwnChildren().getKeys();
        var _to_add            = null;
        for ( var i = 0, _size_i = _own_children_keys.length; i < _size_i; i++ ) {
            _to_add = this.getChild( _own_children_keys[ i ] );
            if ( _to_add ) {
                _to_return.push( _to_add );
            }
        }
        return _to_return;
    },
    getChildrenObjectDict      : function () {
        var _to_return         = {};
        var _own_children_keys = this._getValidOwnChildren().getKeys();
        var _to_add            = null;
        for ( var i = 0, _size_i = _own_children_keys.length; i < _size_i; i++ ) {
            _to_add = this.getChild( _own_children_keys[ i ] );
            if ( _to_add ) {
                _to_return[ _own_children_keys[ i ] ] = _to_add;
            }
        }
        return _to_return;
    },
    getChild                   : function ( key ) {
        if ( !this[ key ] || typeof this[ key ] === 'string' ) {
            this._setDataDefaultObject( key );
        }
        return this[ key ];
    },
    getValue                   : function ( key ) {
        if ( !this[ key ] ) {
            this.setValueDefault( key );
        }
        return this[ key ].getValue();
    },
    getBooleanValue            : function ( key ) {
        return SHINKEN.TOOLS.BOOLEAN.parseToBoolean( this.getValue( key ) );
    },
    isValid                    : function ( key ) {
        if ( !this[ key ] ) {
            this.setValueDefault( key );
        }
        return !this[ key ].hasError();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty, SHINKEN.OBJECT.DefaultConfiguration );
SHINKEN.OBJECT.DefaultConfigurationChildren           = function ( parameters ) {
    this.content = [];
    if ( parameters ) {
        this.init( parameters );
    }
};
SHINKEN.OBJECT.DefaultConfigurationChildren.prototype = {
    init                 : function ( parameters ) {
        for ( var i = 0, _size_i = parameters.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN.OBJECT.DefaultConfigurationChild( parameters[ i ] ) );
        }
    },
    getConfigurationChild: function ( key ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            if ( this.content[ i ].key === key ) {
                return this.content[ i ];
            }
        }
        return null;
    },
    getKeys              : function () {
        return SHINKEN.TOOLS.ARRAY.extractKey( this.content, 'key' );
    },
    getContent           : function () {
        return this.content;
    }
};
SHINKEN.OBJECT.DefaultConfigurationChild           = function ( args ) {
    this.key               = args[ 0 ];
    this.class_constructor = args[ 1 ];
    this.extra_action      = args[ 2 ];
};
SHINKEN.OBJECT.DefaultConfigurationChild.prototype = {};
OBJECT.ElementCheckbox           = function ( dom_element, parent ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( dom_element, parent );
};
OBJECT.ElementCheckbox.prototype = {
    init           : function ( dom_element, parent ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.is_checked = dom_element.classList.contains( 'shinken-checked' );
        }
        this.computeCounters();
    },
    setChecked     : function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        this.is_checked = !!to_set;
        this.updateView();
    },
    getValue       : function () {
        return this.is_checked ? '1' : '0';
    },
    isChecked      : function () {
        return this.is_checked;
    },
    computeCounters: function () {
        if ( !this.dom_element ) {
            return ;
        }
        var _number_error   = this.dom_element.classList.contains( "shinken-error" ) ? 0 : 0;
        var _number_warning = this.dom_element.classList.contains( "shinken-warning" ) ? 0 : 0;
        this.getCounterError().update( this.uuid, _number_error );
        this.getCounterWarning().update( this.uuid, _number_warning );
    },
    updateView     : function () {
        if ( this.is_checked ) {
            this.dom_element.classList.add( 'shinken-checked' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-checked' );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.ElementCheckbox, SHINKEN.OBJECT.CounterInterface );
OBJECT.ElementList           = function () {
    this.init();
};
OBJECT.ElementList.prototype = {
    init                 : function () {
        this.is_disabled = false;
        this.is_useless  = false;
    },
    getName              : function () {
        return this.name;
    },
    getUUID             : function () {
        return this.getName();
    },
    getState             : function () {
        return this.state;
    },
    getType              : function () {
        return this.type;
    },
    getItemType          : function () {
        return this.item_type ? this.item_type : '';
    },
    getLabel             : function () {
        return this.label;
    },
    setName              : function ( to_set, dom_element ) {
        this.name = to_set;
        this.setLabel( to_set, dom_element );
    },
    setLabel             : function ( to_set ) {
        this.label = to_set;
    },
    setState             : function ( to_set ) {
        this.state = to_set;
    },
    setIsDisabled        : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_disabled = !!to_set;
    },
    setIsUseless         : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_useless = !!to_set;
    },
    setIsForceToNull     : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_force_to_null = !!to_set;
    },
    setIsHiddenForAdminSi: function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_hidden_for_admin_si = !!to_set;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        this.findShinkenElement();
    },
    findShinkenElement   : function () {
        if ( this.uuid && this.item_type ) {
            var _shinken_element = MANAGER.__instance_element_distributor.getElementByDict( this );
            if ( _shinken_element ) {
                this.setShinkenElement( _shinken_element );
            }
        }
    },
    setShinkenElement    : function ( to_set ) {
        this.shinken_element = to_set;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setItemType          : function ( to_set ) {
        this.item_type = to_set;
        this.findShinkenElement();
    },
    clone                : function () {
        var _to_return = new OBJECT.ElementList();
        var _keys      = Object.keys( this );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key               = _keys[ i ];
            _to_return[ _current_key ] = this[ _current_key ];
        }
        return _to_return;
    },
    getClass             : function () {
        var _to_return = "";
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _to_return += " shinken-element-new";
        }
        else if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            _to_return += " shinken-element-unknown";
        }
        else if ( this.is_disabled ) {
            _to_return += " shinken-element-disabled";
        }
        return _to_return;
    },
    getError             : function () {
        if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.IT_SELF ) {
            return 1;
        }
        if ( this.is_disabled ) {
            return 1;
        }
        return 0;
    },
    getTooltip           : function () {
        var _to_return = "";
        if ( this.is_useless ) {
            switch ( this.type ) {
                case 'user' :
                    _to_return = _( 'element.tooltip_edition_contact_not_expert' );
                    break;
            }
        }
        if ( this.is_disabled ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += _( 'element.tooltip_disabled' );
        }
        switch ( this.state ) {
            case COMPONENT.CONST.TAG.STATE.NEW :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_new_disabled' );
                }
                else {
                    _to_return = _( 'element.tooltip_new' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.WORKING :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_working_disabled' );
                }
                else {
                    _to_return = _( 'element.tooltip_working' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.UNKNOWN :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN :
                _to_return = _( 'element.tooltip_undefined' );
                break;
            case COMPONENT.CONST.TAG.STATE.IT_SELF :
                _to_return = _( 'element.tooltip_it_self' );
                break;
        }
        if ( this.is_force_to_null ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += SHINKEN.TOOLS.STRING.format( _( 'element.double_link_long_warning' ), this.getLabel() );
        }
        return _to_return;
    },
    getValueFinal        : function () {
        var _to_return = {};
        switch ( this.getState() ) {
            case OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
            case OBJECT.CONST.TEMPLATE.STATUS.NEW:
            case COMPONENT.CONST.TAG.STATE.UNKNOWN:
            case COMPONENT.CONST.TAG.STATE.NEW:
                _to_return.name   = this.name;
                _to_return.exists = false;
                break;
            default:
                _to_return.name      = this.name;
                _to_return.item_type = this.getItemType();
                _to_return._id       = this.uuid;
                _to_return.exists    = true;
                break;
        }
        return _to_return;
    }
};
OBJECT.MESSAGE  = {
    ICON       : {
        ERROR  : '<span class="shinken-icon-error shinkon-warning"></span>',
        WARNING: '<span class="shinken-icon-warning shinkon-warning"></span>',
        BEWARE : '<span class="shinken-icon-warning shinkon-warning-light"></span>'
    },
    MAX_ERROR  : 5,
    MAX_WARNING: 5
};
OBJECT.Messages = function ( footer ) {
    this.init( footer );
};
OBJECT.Messages.prototype = {
    init                : function ( footer ) {
        this.messages_error   = [];
        this.messages_warning = [];
        this.messages_beware  = [];
        this.messages_info    = [];
        this.is_dfe           = false;
        this.is_dfe_protected = false;
        this.footer           = footer;
        this.no_duplicate     = false;
    },
    addMessage          : function ( type_message, text ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.Message( type_message, text ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.Message( type_message, text ) );
                break;
            default:
                this.messages_info.push( new OBJECT.Message( type_message, text ) );
                break;
        }
    },
    addMessages         : function ( messages ) {
        if ( !messages ) {
            return;
        }
        var _size = messages.length;
        var _current_message;
        for ( var i = 0; i < _size; i++ ) {
            _current_message = messages[ i ];
            this.addMessage( _current_message._type, _current_message._text );
        }
    },
    hasMessage          : function () {
        return this.hasError() || this.hasWarning() || this.hasBeware() || this.hasInfo();
    },
    getNumberErrors     : function () {
        return this.messages_error.length;
    },
    getNumberWarnings   : function () {
        return this.messages_warning.length;
    },
    hasError            : function () {
        return this.getNumberErrors() > 0;
    },
    hasWarning          : function () {
        return this.getNumberWarnings() > 0;
    },
    hasBeware           : function () {
        return this.messages_beware.length > 0;
    },
    hasInfo             : function () {
        return this.messages_info.length > 0;
    },
    getStatus           : function () {
        if ( this.hasError() ) {
            return COMPONENT.CONST.STATUS.ERROR;
        }
        if ( this.hasWarning() ) {
            return COMPONENT.CONST.STATUS.WARNING;
        }
        if ( this.hasBeware() ) {
            return COMPONENT.CONST.STATUS.BEWARE;
        }
        return COMPONENT.CONST.STATUS.NONE;
    },
    hasStatus           : function () {
        return this.getStatus() !== COMPONENT.CONST.STATUS.NONE;
    },
    buildMessage        : function ( is_default, template_name, has_no_max, skip_invalid_syntax ) {
        
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return          = '<div class="shinken-tooltip-message text-left shinken-drag-exclude">';
        var _show_extra_message = false;
        if ( this.hasError() ) {
            _show_extra_message = true;
            if ( !skip_invalid_syntax ) {
                _to_return += '<span class="text-underline">' + _( 'messages.invalid_syntax', [DICTIONARY_COMMON_UI] ) + '</span><br>';
            }
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'messages.tag_error', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error, has_no_max ? '' : OBJECT.MESSAGE.MAX_ERROR );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _show_extra_message = true;
            _to_return += OBJECT.MESSAGE.ICON.WARNING + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning, has_no_max ? '' : OBJECT.MESSAGE.MAX_WARNING );
            _to_return += '</ol>';
        }
        if ( !this.is_dfe_protected && _show_extra_message && this.is_dfe ) {
            var _format_to_follow        = is_default ? _( 'messages.tooltip_dfe_common_default_value' ) : _( 'element.tooltip_dfe_common' );
            var _note_to_update_template = template_name ? '<div class=\'container-legend \'>' + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_common_go_tpl' ), template_name ) + '</div>' : "";
            _to_return                   = _to_return +
                                           '<div class=\'container-legend\'>' + _format_to_follow + '</div>' +
                                           _note_to_update_template;
            
        }
        if ( this.hasBeware() && this.is_dfe ) {
            if ( !this.is_dfe_protected && _show_extra_message ) {
                _to_return += '<hr>';
            }
            _to_return += '<ol>' + OBJECT.MESSAGE.ICON.BEWARE + SHINKEN.TOOLS.STRING.format( _( 'element.tooltip_dfe_deleted_part_1' ), this.property_name );
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
            _to_return += '</ol>';
        }
        else if ( this.hasBeware() ) {
            _to_return += OBJECT.MESSAGE.ICON.BEWARE + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '<br>';
            _to_return += this.buildMessageForList( this.messages_beware, 999 );
        }
        if ( this.footer ) {
            _to_return += this.footer;
        }
        
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageGeneric : function () {
        var _status = this.getStatus();
        if ( _status === COMPONENT.CONST.STATUS.NONE ) {
            return '';
        }
        var _to_return = '<div class="shinken-message-container">';
        if ( this.hasError() ) {
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'messages.tag_error', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_error );
            _to_return += '</ol>';
        }
        if ( this.hasWarning() ) {
            _to_return += OBJECT.MESSAGE.ICON.ERROR + _( 'messages.tag_warning', [DICTIONARY_COMMON_UI] ) + '<br><ol>';
            _to_return += this.buildMessageForList( this.messages_warning );
            _to_return += '</ol>';
        }
        _to_return += '</div>';
        return _to_return;
    },
    buildMessageForList : function ( list, max ) {
        var _to_return = '';
        var _size      = list.length;
        if ( max ) {
            _size = Math.min( list.length, _size );
        }
        var _to_add;
        var _duplicate = {};
        for ( var i = 0; i < _size; i++ ) {
            _to_add = list[ i ].buildHtml();
            if ( this.no_duplicate ) {
                var _md5 = SHINKEN.TOOLS.MD5.MD5( _to_add );
                if ( _duplicate[ _md5 ] ) {
                    continue;
                }
                _duplicate[ _md5 ] = true;
            }
            _to_return += _to_add;
        }
        return _to_return;
    },
    getAllMessages      : function () {
        var to_return = [];
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_error );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_warning );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_info );
        to_return     = SHINKEN.TOOLS.ARRAY.concat( to_return, this.messages_beware );
        return to_return;
    },
    _getObjectToJson    : function () {
        return {};
    },
    countMessageWithText: function ( type_message, text ) {
        var messages   = null;
        var _to_return = 0;
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                messages = this.messages_error;
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                messages = this.messages_warning;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                messages = this.messages_beware;
                break;
            default:
                messages = this.messages_info;
                break;
        }
        var messages_length = messages.length;
        
        for ( var i = 0; i < messages_length; i++ ) {
            if ( SHINKEN.TOOLS.STRING.contains( messages[ i ]._text, text ) ) {
                _to_return++;
            }
        }
        return _to_return;
    }
};
OBJECT.MessagesConfig = function () {
    this.init();
};
OBJECT.MessagesConfig.prototype = {
    getUUID         : function () {
        if ( !this.uuid ) {
            this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        }
        return this.uuid;
    },
    addMessage      : function ( type_message, object_message ) {
        switch ( type_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.messages_error.push( new OBJECT.MessageConfig( type_message, object_message, this.getUUID() ) );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.messages_warning.push( new OBJECT.MessageConfig( type_message, object_message, this.getUUID() ) );
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.messages_beware.push( new OBJECT.MessageConfig( type_message, object_message, this.getUUID() ) );
                break;
            default:
                this.messages_info.push( new OBJECT.MessageConfig( type_message, object_message, this.uuid ) );
                break;
        }
    },
    _getObjectToJson: function () {
        var _to_return           = {};
        _to_return.contents      = [];
        _to_return.with_list_key = [];
        var _messages            = this.getAllMessages();
        var _current;
        for ( var i = 0, _size_i = _messages.length; i < _size_i; i++ ) {
            _current = _messages[ i ]._getObjectToJson();
            if ( _current.list_keys ) {
                _to_return.with_list_key.push( _to_return.contents.push( _current ) - 1 );
            }
            else {
                _to_return.contents.push( _current );
            }
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.MessagesConfig, OBJECT.Messages );
OBJECT.Message = function ( type, text, line_index ) {
    this._type = type;
    this._text = text;
};
OBJECT.Message.prototype = {
    buildHtml: function () {
        return '<li class=\'' + this._type + '\'>' + this._text + '</li>';
    }
};
OBJECT.MessageConfig = function ( type, object_message, uuid ) {
    this._type       = type;
    this._text       = object_message.text;
    this._list_keys  = object_message.list_keys;
    this.parent_uuid = uuid;
};
OBJECT.MessageConfig.prototype = {
    buildHtml       : function () {
        var _to_return = DOM.Service.createElement( "li", { class: this._type } );
        var _table     = DOM.Service.createElement( "table", { class: "shinken-table" } );
        var _tr        = DOM.Service.createElement( "tr" );
        var _td_1      = DOM.Service.createElement( "td", { class: "shinken-text-cell" }, "<div>" + this._text + "</div>" );
        DOM.Service.addElementTo( _table, _to_return );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _td_1, _tr );
        
        if ( this._list_keys !== "__SHINKEN_NONE__" ) {
            var _td_2 = DOM.Service.createElement( "td", { class: "shinken-json-link-cell" } );
            var _link = DOM.Service.createElement( "span", { class: "shinken-data-user shinken-json-link", onclick: "MANAGER.EventManager.clickOnButton(event, 'focus-on-anchor-json', '" + this.parent_uuid + "')" }, 'JSON' );
            DOM.Service.addElementTo( _td_2, _tr );
            DOM.Service.addElementTo( _link, _td_2 );
        }
        return _to_return.outerHTML;
    },
    getCategory     : function () {
        return this._category;
    },
    _getObjectToJson: function () {
        var _to_return     = {};
        _to_return.uuid    = this.parent_uuid;
        _to_return.tooltip = this._text;
        switch ( this._type ) {
            case COMPONENT.CONST.STATUS.ERROR:
            case COMPONENT.CONST.STATUS.WARNING:
                _to_return.class = SHINKEN.OBJECT.JsonEditor.CONST.CLASS_ERROR;
                break;
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.MessagesConfig, OBJECT.Messages );
OBJECT.MessageService = (function ( self ) {
    "use strict";
    self.parseBackendStatus = function ( status ) {
        switch ( status ) {
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.WARNINGS:
                return COMPONENT.CONST.STATUS.WARNING;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.CRITICAL:
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.ERRORS:
                return COMPONENT.CONST.STATUS.ERROR;
        }
    };
    return self;
})( OBJECT.MessageService || {} );
SHINKEN.OBJECT.NOTIFICATION.Container           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.NOTIFICATION.CONTAINER';
    this.dom_element    = null;
    this.notifications  = null;
};
SHINKEN.OBJECT.NOTIFICATION.Container.prototype = {
    init: function () {
        this.notifications = [];
    },
    
    addNotification            : function ( message, status, element_to_bind_with, notification_placement, time_before_remove, skip_close ) {
        if ( !this.dom_element ) {
            this.createNotificationContainer();
        }
        
        var _user_notification = new
        SHINKEN.OBJECT.NOTIFICATION.User();
        
        this.cleanAllNotification();
        _user_notification.init();
        _user_notification.createNotification( message, status, skip_close );
        _user_notification.setTimerToCloseNotification( this.dom_element, time_before_remove );
        if ( element_to_bind_with ) {
            _user_notification.bindToElement( element_to_bind_with, notification_placement );
        }
        
        this.notifications.push( _user_notification );
        DOM.Service.addElementTo( _user_notification.dom_element, this.dom_element );
        return _user_notification;
    },
    addNotificationStyled      : function ( message, status, styles, time_before_remove ) {
        var _user_notification = this.addNotification( message, status );
        
        if ( styles ) {
            _user_notification.addStyles( styles );
        }
    },
    createNotificationContainer: function () {
        this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-notification-popup-container", "onclick": "this.firstChild.classList.add('shinken-removed');event.stopPropagation();" } );
        DOM.BodyService.addChild( this.dom_element );
    },
    cleanAllNotification       : function () {
        DOM.Service.empty( this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NOTIFICATION.Container, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.VisualNotificationOfChange = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.VisualNotificationOfChange.prototype = {
    init: function ( data ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ] = new SHINKEN.OBJECT.BlinkNotificationOfChange();
        if ( data ) {
            this.updateData( data );
        }
    },
    doActionAfter: function ( event_name, param ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].doActionAfter( event_name, param );
    },
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK:
                this[ key ].updateData( value );
                break;
        }
    },
    getBlinkValue: function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].getValue();
    },
    getDataToSave             : function () {
        var _to_return                                                        = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ] = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].getDataToSave();
        return _to_return;
    },
    isBlinkNotificationEnabled: function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].isEnabled();
    }
};
SHINKEN.OBJECT.BlinkNotificationOfChange = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.BlinkNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "init_phase":
                this.doActionAfter( "reset_object" );
                this.initPhase();
                break;
            case "init_with_dom_element":
                if ( this.getDomElement() ) {
                    return;
                }
                if ( !param ) {
                    return;
                }
                this.setDomElement( param.querySelector( ".shinken-blink-notification-container" ) );
                this.setPhaseDomElement( param, "blinkNotification" );
                break;
            case "change_value_notification_of_change_visual_blink":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED, param );
                break;
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "shinken_view_has_disabled_blink_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "play_blink_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
            case "user_has_disabled_blink_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER );
                break;
            case "set_phase_blink_depending_number_of_change":
                this.setPhase( param ? SHINKEN.OBJECT.CONST.PHASE.READY : SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
            case "ask_play_notification_visual_blink":
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.READY );
                break;
            case "reset_object":
                this.setDomElement();
                break;
            case "click_done":
                break;
        }
    },
    getValue: function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
    },
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED:
                if ( typeof value === "object" ) {
                    this[ key ] = value.value;
                }
                else {
                    this[ key ] = value;
                }
                break;
        }
    },
    getDataToSave: function () {
        var _to_return = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] = this.getValue();
        return _to_return;
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        this.setTooltipHtml( "" );
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.READY, 3000 );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER:
                this.setTooltipHtml( _( "notification.blink_user_warning", [DICTIONARY_COMMON_UI] ) );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING:
                this.setTooltipHtml( _( "notification.no_change", [DICTIONARY_COMMON_UI] ) );
                break;
            default:
                break;
        }
    },
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #visual-blink-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.BlinkNotificationOfChange, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.BlinkNotificationOfChange, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.VolumeNotificationOfChange = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.VolumeNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "change_value_notification_of_change_sound":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME, param );
                break;
        }
    },
    getValue: function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME ];
    },
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME:
                this[ key ] = value;
                break;
        }
    },
    getDataToSave: function () {
        var _to_return                                                         = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VOLUME ] = this.getValue();
        return _to_return;
    },
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #sound-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};
SHINKEN.OBJECT.NotificationsOfChangeDefaultValues           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.NotificationsOfChangeDefaultValues.prototype = {
    init: function ( data ) {
        this.users  = new SHINKEN.OBJECT.NotificationsOfChangeUser();
        this.hives  = new SHINKEN.OBJECT.NotificationsOfChangeView();
        this.lists  = new SHINKEN.OBJECT.NotificationsOfChangeView();
        this.events = new SHINKEN.OBJECT.NotificationsOfChangeView();
        if ( data ) {
            this.updateData( data );
        }
    },
    updateData               : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                  : function ( key, value ) {
        switch ( key ) {
            case "default_notifications_settings__event_container__visual__blink__enabled":
                this.events.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            case "default_notifications_settings__event_container__sound__enabled":
                this.events.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__hives__visual__blink__enabled":
                this.hives.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            case "default_notifications_settings__hives__sound__enabled":
                this.hives.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__lists__visual__blink__enabled":
                this.lists.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            case "default_notifications_settings__lists__sound__enabled":
                this.lists.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__users__sound__volume_percent":
                this.users.doActionAfter( "change_value_notification_of_change_sound", value );
                break;
            case "default_notifications_settings__users__visual__blink__enabled":
                this.users.doActionAfter( "change_value_notification_of_change_visual_blink", value );
                break;
            default:
                break;
        }
    },
    computeViewSettings      : function ( shinken_view ) {
        this.computeViewSettingsVisual( shinken_view );
        shinken_view.sound_notification_of_change_enabled = this.computeViewSettingsSound( shinken_view );
    },
    computeViewSettingsVisual: function ( shinken_view ) {
        shinken_view.visual_notification_of_change_enabled = this.computeViewSettingsBlink( shinken_view );
    },
    computeViewSettingsBlink : function ( shinken_view ) {
        if ( shinken_view.notifications_of_change.getBlinkValue() !== SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            return shinken_view.notifications_of_change.getBlinkValue();
        }
        switch ( shinken_view.type ) {
            case "hive":
                return this.hives.getBlinkValue();
            case "list":
                return this.lists.getBlinkValue();
            case "event-tub":
                return this.events.getBlinkValue();
            default:
                console.warn( "[NotificationsOfChangeDefaultValues - computeViewSettingsBlink]", shinken_view.type, "NOT MANAGED" );
                break;
            
        }
    },
    computeViewSettingsSound : function ( shinken_view ) {
        if ( shinken_view.notifications_of_change.getSoundValue() !== SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            return shinken_view.notifications_of_change.getSoundValue();
        }
        switch ( shinken_view.type ) {
            case "hive":
                return this.hives.getSoundValue();
            case "list":
                return this.lists.getSoundValue();
            case "event-tub":
                return this.events.getSoundValue();
            default:
                console.warn( "[NotificationsOfChangeDefaultValues - computeViewSettingsBlink]", shinken_view.type, "NOT MANAGED" );
                break;
        }
    },
    getFlatUserVolume        : function ( notification_of_change_from_user ) {
        var _to_return = notification_of_change_from_user.getVolumeValue();
        if ( _to_return === SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            _to_return = this.getUserVolumeValue();
        }
        return _to_return;
    },
    getFlatUserBlink         : function ( notification_of_change_from_user ) {
        var _to_return = notification_of_change_from_user.getBlinkValue();
        if ( _to_return === SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT ) {
            _to_return = this.getUserBlinkValue();
        }
        return _to_return;
    },
    getUserVolumeValue       : function () {
        return this.users.getVolumeValue();
    },
    getUserBlinkValue        : function () {
        return this.users.getBlinkValue();
    }
};
SHINKEN.OBJECT.NotificationsOfChangeUser = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.OBJECT.NotificationsOfChangeUser.prototype = {
    initSpecific: function ( data ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ]  = new SHINKEN.OBJECT.VolumeNotificationOfChange();
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ] = new SHINKEN.OBJECT.VisualNotificationOfChange();
        this.init( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NotificationsOfChangeUser, SHINKEN.OBJECT.NotificationsOfChange._interface );
SHINKEN.OBJECT.NotificationsOfChangeView = function ( data ) {
    this.initSpecific( data );
};
SHINKEN.OBJECT.NotificationsOfChangeView.prototype = {
    initSpecific: function ( data ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ]  = new SHINKEN.OBJECT.SoundNotificationOfChange();
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ] = new SHINKEN.OBJECT.VisualNotificationOfChange();
        this.init(data);
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NotificationsOfChangeView, SHINKEN.OBJECT.NotificationsOfChange._interface );
SHINKEN.OBJECT.NOTIFICATION.User           = function () {
    this.__class_name__                = 'SHINKEN.OBJECT.NOTIFICATION.USER';
    this.dom_element                   = null;
    this.message                       = null;
    this.timeout_to_close_notification = null;
};
SHINKEN.OBJECT.NOTIFICATION.User.prototype = {
    init                       : function () {
    },
    createNotification         : function ( message, status, skip_close ) {
        this.createMessageDom();
        
        if ( !skip_close ) {
            var _cross = DOM.Service.createElement( 'div', { class: "shinkon shinkon-times-bold" } );
            this.dom_element.appendChild( _cross );
            var self = this;
            _cross.addEventListener( 'click', function () {
                self.close();
            } );
        }
        this.message = message;
        
        if ( status ) {
            this.addTypeToNotification( status );
        }
        var _dom_text_notification = DOM.Service.createElement( 'span', {}, this.message );
        DOM.Service.addElementTo( _dom_text_notification, this.dom_element );
        
    },
    addTypeToNotification      : function ( status ) {
        var _icon = DOM.Service.createElement( 'span', { 'class': "shinkon" } );
        switch ( status ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR:
                _icon.classList.add( 'shinkon-warning' );
                this.dom_element.classList.add( "notification-error" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.WARNING:
                _icon.classList.add( 'shinkon-warning' );
                this.dom_element.classList.add( "notification-warning" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO:
                _icon.classList.add( 'info-circle' );
                this.dom_element.classList.add( "notification-info" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.SUCCESS:
                _icon.classList.add( 'info-circle' );
                this.dom_element.classList.add( "notification-success" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS:
                this.dom_element.classList.add( "shinken-notification-copy-success" );
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED:
                this.dom_element.classList.add( "shinken-notification-copy-failed" );
                break;
        }
        DOM.Service.addElementTo( _icon, this.dom_element );
    },
    setTimerToCloseNotification: function ( parent_element, time_before_remove ) {
        time_before_remove              = time_before_remove || 8000;
        var self                        = this;
        this.timeoutToCloseNotification = setTimeout( function () {
            self.dom_element.classList.add( "shinken-removed" );
        }, time_before_remove );
    },
    bindToElement              : function ( element, notification_placement ) {
        var _size   = element.getBoundingClientRect();
        var _styles = {};
        switch ( notification_placement ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.TOP:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] - 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 50;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.BOTTOM:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 50;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_TITLE_HIVE: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 60;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ];
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_TITLE_LIST: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 55;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ];
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_COPY_WEATHER_JSON:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ] + 35;
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 20;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS: // TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] - 35;
                if ( _styles[ DOM.CONST.STYLE.TOP ] < 0 ) {
                    _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] + 35;
                }
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 25;
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED:// TODO Repenser le placement des notifs
                _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] - 35;
                if ( _styles[ DOM.CONST.STYLE.TOP ] < 0 ) {
                    _styles[ DOM.CONST.STYLE.TOP ] = _size[ DOM.CONST.STYLE.TOP ] + 35;
                }
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] - 100;
                break;
            default:
                _styles[ DOM.CONST.STYLE.TOP ]  = _size[ DOM.CONST.STYLE.TOP ];
                _styles[ DOM.CONST.STYLE.LEFT ] = _size[ DOM.CONST.STYLE.LEFT ] + 50;
                break;
        }
        DOM.Service.setStyles( this.dom_element, _styles );
    },
    createMessageDom           : function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-notification-popup" } );
    },
    close                      : function () {
        clearTimeout( this.timeoutToCloseNotification );
        DOM.Service.removeElement( this.dom_element );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.NOTIFICATION.User, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.OBJECT.Param           = function ( key, value_object, parameter, default_value ) {
    this.init( key, value_object, parameter, default_value );
};
SHINKEN.OBJECT.Param.prototype = {
    init                    : function ( key, value_object, parameter, default_value ) {
        this.__class_name__ = 'SHINKEN.OBJECT.Param';
        this.initCounters();
        if ( ! value_object ){
            console.warn( "[Param - init FAILED]", key, value_object, parameter, default_value );
            return;
        }
        if ( value_object.validation_messages ){
            this.setMessages( value_object.validation_messages );
        }
        this.key        = key;
        this.setValue(value_object.value);
        this.cfg_value  = value_object.cfg_value;
        this.setUserValue( value_object.source_value === undefined ? "" : value_object.source_value );
        if ( parameter && this.user_value === "" && !parameter.is_mandatory ) {
            this.user_value = default_value;
        }
    },
    doActionAfterAddMessages: function () {
        this.setWarning( this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setError( this.getObjectClassName(), this.messages.getNumberErrors() );
    },
    _getObjectToJson: function () {
        return this;
    },
    getUserValue            : function () {
        return this.user_value;
    },
    setUserValue                : function ( to_set ) {
        this.user_value = to_set;
    },
    setValue                : function ( to_set ) {
        this.value = to_set;
    },
    getValue                : function () {
        return this.value;
    },
    getUUID                 : function () {
        return this.uuid;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.ShinkenObjectJson );
"use strict";
SHINKEN.OBJECT.PROGRESS_BAR_CONST = {
    SAVING_DEFAULT                  : {
        PREPARATION_CALL        : 1,
        CALL_IN_PROGRESS        : 2,
        BACKEND_RETURN_TREATMENT: 3,
        END                     : 4
    },
    SAVING_WITH_TREATMENT_AFTER_CALL: {
        PREPARATION_CALL        : 1,
        CALL_IN_PROGRESS        : 2,
        BACKEND_RETURN_ANALYSE  : 3,
        BACKEND_RETURN_TREATMENT: 4,
        END                     : 5
    }
};
SHINKEN.OBJECT.Progressbar           = function ( parent, nb_steps, min_timeout, dom_element_parent ) {
    this.__class_name__ = "SHINKEN.OBJECT.Progressbar";
    this._parent        = parent;
    this._nb_steps      = nb_steps;
    this._min_timeout   = min_timeout;
    this.setDomElementParent( dom_element_parent );
    this.init();
};
SHINKEN.OBJECT.Progressbar.prototype = {
    init     : function () {
        this.dom_element_parent.innerHTML = __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__.replace( "$$$$__COLLAPSE__TITLE__$$$$", _( "progress_bar.toggle_display_message_label", [DICTIONARY_COMMON_UI] ) );
        this.setDomElement( this.dom_element_parent.firstChild );
        this._dom_progress_bar = this.getDomElement().querySelector( ".shinken-progress-bar" );
        this._dom_title        = this.getDomElement().querySelector( ".shinken-popup-title" );
        this._dom_message      = this.getDomElement().querySelector( ".shinken-progress-bar-message" );
        this.starting_time     = null;
        this.initPhase( this.getDomElement() );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
    },
    reset    : function () {
        this._timeout_run  = null;
        this._current_step = 0;
        this.setMessagesDisplayed( false );
        this.initSteps();
    },
    initSteps: function () {
        this._steps = [];
        for ( var i = 0; i <= this._nb_steps; i++ ) {
            this._steps.push( new SHINKEN.OBJECT.ProgressbarStep( i ) );
        }
    },
    setMessagesDisplayed: function ( to_set ) {
        DOM.Service.setDataSet( this.getDomElement(), 'messageDisplayed', !!to_set ? "1" : "0" );
    },
    getCurrentStep      : function () {
        return this._steps[ this._current_step ];
    },
    getStep             : function ( step ) {
        return this._steps[ step ];
    },
    setParamStep        : function ( step, to_set ) {
        this._steps[ step ].setParam( to_set );
    },
    setMessageStep      : function ( step, to_set ) {
        this._steps[ step ].setMessage( to_set );
    },
    setDomElementParent : function ( to_set ) {
        this.dom_element_parent = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.addElementTo( this.getDomElement(), this.dom_element_parent );
        }
    },
    setTitleStep        : function ( step, to_set ) {
        this._steps[ step ].setTitle( to_set );
    },
    callbackForPhase    : function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.reset();
                break;
        }
    },
    kill: function () {
        DOM.Service.removeElement( this.getDomElement() );
    },
    doProgress: function ( expected_step, phase, param, message, title ) {
        if ( expected_step === 1 ) {
            this.reset();
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        }
        var _step = this._steps[ expected_step ];
        _step.setPhase( phase );
        _step.setParam( param );
        _step.setMessage( message );
        _step.setTitle( title );
        _step.askForRun();
        this._run();
    },
    _run      : function () {
        if ( this._timeout_run ) {
            return;
        }
        if ( !this._steps[ this._current_step + 1 ].needToBeRun() ) {
            return;
        }
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK ) ) {
            return;
        }
        this._current_step++;
        var _current_step = this.getCurrentStep();
        this._parent.doActionWhenProgressStart( this._current_step, _current_step.getParam(), this );
        this._updateHtml( _current_step );
        if ( this._timeout_run ) {
            return;
        }
        var self = this;
        
        this._timeout_run = setTimeout( function () {
            self._parent.doActionWhenProgressEnd( self._current_step, _current_step.getParam(), self );
            self._timeout_run = null;
            if ( self._current_step < self._nb_steps ) {
                self._run();
            }
        }, this._min_timeout );
    },
    _updateHtml    : function ( current_step ) {
        if ( current_step.getPhase() ) {
            this.setPhase( current_step.getPhase() );
        }
        if ( current_step.getTitle() ) {
            this.updateTitleHtml( current_step.getTitle() );
        }
        if ( current_step.getMessage() ) {
            this._dom_message.innerHTML = current_step.getMessage();
        }
        this._updateBarHtml();
    },
    _updateBarHtml : function () {
        DOM.Service.setStyle( this._dom_progress_bar, DOM.CONST.STYLE.WIDTH, (this._current_step / this._nb_steps * 100) + "%" );
        DOM.Service.setDataSet( this.getDomElement(), "isComplete", (this._current_step === this._nb_steps) ? "1" : "0" );
    },
    updateTitleHtml: function ( to_set ) {
        this._dom_title.innerHTML = to_set;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Progressbar, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Progressbar, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.OBJECT.ProgressbarStep           = function ( index ) {
    this._index        = index;
    this._phase        = null;
    this._title        = null;
    this._message      = null;
    this._param        = null;
    this._run_expected = false;
};
SHINKEN.OBJECT.ProgressbarStep.prototype = {
    setPhase   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._phase = to_set;
        }
    },
    setMessage : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._message = to_set;
        }
    },
    getTitle   : function ( to_set ) {
        return this._title;
    },
    setTitle   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._title = to_set;
        }
    },
    getMessage : function ( to_set ) {
        return this._message;
    },
    setParam   : function ( to_set ) {
        if ( to_set !== undefined ) {
            this._param = to_set;
        }
    },
    askForRun  : function () {
        this._run_expected = true;
    },
    needToBeRun: function () {
        return this._run_expected;
    },
    getParam   : function () {
        return this._param;
    },
    getPhase   : function () {
        return this._phase;
    },
    isPhase    : function ( to_test ) {
        return this._phase === to_test;
    }
};
SHINKEN.OBJECT.ProgressbarInterface           = function () {
};
SHINKEN.OBJECT.ProgressbarInterface.prototype = {
    doActionWhenProgressStart        : function ( current_step, param, progress_bar_object ) {
        if ( current_step === progress_bar_object._nb_steps ) {
            this.doActionWhenProgressionIsComplete( progress_bar_object );
        }
        this._doActionWhenProgressStart( current_step, param );
    },
    doActionWhenProgressEnd          : function ( current_step, param, progress_bar_object ) {
        if ( (current_step === progress_bar_object._nb_steps - 1) && progress_bar_object.getCurrentStep().isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK ) ) {
            progress_bar_object.doProgress( progress_bar_object._nb_steps );
        }
        this._doActionWhenProgressEnd( current_step, param );
    },
    _doActionWhenProgressStart       : function ( current_step, param ) {
    },
    _doActionWhenProgressEnd         : function ( current_step, param ) {
    },
    doActionWhenProgressionIsComplete: function ( progress_bar_object ) {
        if ( progress_bar_object.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK ) ) {
            progress_bar_object.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, 2000 );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ProgressbarInterface, SHINKEN.OBJECT.ShinkenObject );
var __SHINKEN_TEMPLATE_HTML_PROGRESS_BAR__ = '<div class="shinken-popup-progress-bar-container shinken-parent-event-listener" data-controller="common_ui" data-message-displayed="0">\n' +
                                             '    <div class="shinken-popup-title"></div>\n' +
                                             '    <div class="shinken-progress-bar-container">\n' +
                                             '        <div class="shinken-progress-bar"></div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-collapse-button-container">\n' +
                                             '    <div class="shinken-collapse-button-container">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button shinken-popup-message-detail-collapse" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="toggle_display_popup_progress_bar_message">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell">\n' +
                                             '                        <span class="">$$$$__COLLAPSE__TITLE__$$$$</span>\n' +
                                             '                    </div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-popup-close">\n' +
                                             '        <div class="shinken-button-container">\n' +
                                             '            <div class="shinken-button" onclick="MANAGER.EventManager.clickOnButton(event)" data-name="close_popup_progress_bar">\n' +
                                             '                <div class="shinken-display-table">\n' +
                                             '                    <div class="shinken-display-table-cell"><span class=""><span class="shinkon shinkon-times"></span></span></div>\n' +
                                             '                </div>\n' +
                                             '            </div>\n' +
                                             '        </div>\n' +
                                             '    </div>\n' +
                                             '    <div class="shinken-progress-bar-message"></div>\n' +
                                             '</div>';
SHINKEN.OBJECT.Resource           = function () {
};
SHINKEN.OBJECT.Resource.prototype = {
    reset     : function () {
        this.content = null;
    },
    getContent: function () {
        if ( !this.content ) {
            this.content = new Audio( this.path );
        }
        return this.content;
    },
    getUUID   : function () {
        return this.uuid;
    },
    getName   : function () {
        return this.label;
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {.0
        switch ( key ) {
            case "resource_id" :
                this.uuid = value;
                break;
            case "display_name" :
                this.label = value;
                break;
            case "resource_hash" :
                this.reset();
                this.resource_hash = value;
                this.path          = "/static/" + __SHINKEN_HTTP_START_TIME__ + "/common_ui/sounds/" + this.resource_hash + ".mp3";
                break;
            case "type" :
            case "file_info_path" :
            case "loading_date_time" :
            case "original_name" :
            case "resource_path" :
            case "use_file_provided_by_shinken" :
                this[ key ] = value;
                break;
        }
    }
};
SHINKEN.CARTO.ShinkenCarto = function ( data ) {
    this.init( data );
};
SHINKEN.CARTO.ShinkenCarto.prototype = {
    init           : function ( data ) {
        if ( data ) {
            this.updateData( data );
            this.setIsValid();
        }
    },
    updateData     : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData        : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.CARTO.CONST.NAME:
            case SHINKEN.CARTO.CONST.URL:
                this[ key ] = value;
                break;
        }
    },
    setIsValid     : function () {
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this[ SHINKEN.CARTO.CONST.URL ], SHINKEN.NETWORK.ADRESSES.LOCALHOST )
             || SHINKEN.TOOLS.STRING.containsIgnoreCase( this[ SHINKEN.CARTO.CONST.URL ], SHINKEN.NETWORK.ADRESSES._127_0_0_1 )
        ) {
            this[ SHINKEN.CARTO.CONST.IS_VALID ] = false;
        }
        else {
            this[ SHINKEN.CARTO.CONST.IS_VALID ] = true;
        }
    },
    hasLocalHostUrl: function () {
        return SHINKEN.TOOLS.STRING.startsWith( this.url, "http://localhost" );
    },
    computeHtml: function () {
            var _css_selector = this.hasLocalHostUrl() ? "#shinken-architecture-template .shinken-template-architecture-cartos-start-with-localhost" : "#shinken-architecture-template .shinken-template-architecture-cartos";
            var _template     = document.querySelector( _css_selector ).outerHTML;
            _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_cartos_name_$$$", SHINKEN.TOOLS.STRING.cleanXss( this.name ) );
            _template         = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_cartos_url_$$$", SHINKEN.TOOLS.STRING.cleanXss( this.url ) );
            var _temp         = DOM.Service.createElement( "div", {}, _template );
            this.dom_element  = _temp.firstChild;
        
    }
};
SHINKEN.OBJECT.ShinkenElement           = function () {
    this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN;
};
SHINKEN.OBJECT.ShinkenElement.prototype = {
    init: function ( data ) {
        this.updateData( data );
    },
    getUUID                           : function () {
        return this.uuid;
    },
    getName                           : function () {
        return this.name;
    },
    getType                           : function () {
        return this.item_type;
    },
    setUUID                           : function ( to_set ) {
        this.uuid = to_set;
    },
    isExisting                        : function () {
        if ( !this.getUUID() || !this[ OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE ] ) {
            return false;
        }
        return this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ];
    },
    setExists                         : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING ] = to_set;
        return true;
    },
    isNotAuthorized                   : function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] = to_set;
        return true;
    },
    setVisibilityWithoutAuthentication: function ( to_set ) {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW ] === to_set ) {
            return false;
        }
        this[ OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW ] = to_set;
        return true;
    },
    setName                           : function ( to_set ) {
        if ( this.name === to_set ) {
            return false;
        }
        this.name = to_set;
        return true;
    },
    setVisualisationName              : function ( to_set ) {
        if ( this.visualisation_name === to_set ) {
            return false;
        }
        this.visualisation_name = to_set;
        return true;
    },
    setContext                        : function ( to_set ) {
        this.previous_context = this.previous_context || new SHINKEN.Status();
        if ( this.context ) {
            this.previous_context.setCode( this.context.getCode() );
        }
        if ( this.context && this.context.isByCode( to_set ) ) {
            return false;
        }
        this.context = this.context || new SHINKEN.Status();
        this.context.setCode( to_set );
        return true;
    },
    setStatus                         : function ( to_set ) {
        this.previous_status = this.previous_status || new SHINKEN.Status();
        if ( this.status ) {
            this.previous_status.setCode( this.status.getCode() );
        }
        if ( this.status && this.status.isByCode( to_set ) ) {
            return false;
        }
        this.status = this.status || new SHINKEN.Status();
        this.status.setCode( to_set );
        return true;
    },
    setSlaValue                       : function ( to_set ) {
        if ( this.sla_value === to_set ) {
            return false;
        }
        this.sla_value        = to_set;
        this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN;
        this.sla_quality      = null;
        return true;
    },
    setSlaTendency                    : function ( to_set ) {
        if ( this.tendency === to_set ) {
            return false;
        }
        this.tendency = to_set;
        return true;
    },
    setSlaThreshold                   : function ( key, value ) {
        if ( this[ "sla_" + key ] === value ) {
            return false;
        }
        this[ "sla_" + key ]  = value;
        this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN;
        this.sla_quality      = null;
        return true;
    },
    getSlaValueStatus                 : function ( key, value ) {
        
        if ( this.sla_value_status === OBJECT.CONST.ELEMENT.SLA.STATUS.UNKNOWN ) {
            if ( parseFloat( this.sla_value ) < this.sla_critical_threshold ) {
                this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.CRITICAL;
            }
            else if ( parseFloat( this.sla_value ) < this.sla_warning_threshold ) {
                this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.WARNING;
            }
            else {
                this.sla_value_status = OBJECT.CONST.ELEMENT.SLA.STATUS.OK;
            }
        }
        return this.sla_value_status;
    },
    getSlaQuality                     : function () {
        if ( this[ OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER ] ) {
            this.sla_quality = new SHINKEN.SlaQuality();
        }
        else if ( typeof this.sla_value === "undefined" || typeof this.status === 'undefined' ) {
            this.sla_quality = new SHINKEN.SlaQuality();
        }
        else if ( !this.sla_quality ) {
            this.sla_quality = new SHINKEN.SlaQuality( this.status.getCode(), this.getSlaValueStatus() );
        }
        return this.sla_quality;
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "item_uuid":
            case OBJECT.CONST.ELEMENT.FIELD_UI.UUID:
                this.setUUID( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.STATUS:
                this.setStatus( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.IS_EXISTING:
                this.setExists( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.IS_NOT_AUTHORIZED_FOR_USER:
                this.isNotAuthorized( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW:
                this.setVisibilityWithoutAuthentication( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.CONTEXT:
                this.setContext( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.__KEY__:
                this.updateData( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.VALUE:
                this.setSlaValue( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.TENDENCY:
                this.setSlaTendency( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.WARNING_THRESHOLD:
            case OBJECT.CONST.ELEMENT.FIELD_UI.SLA.CRITICAL_THRESHOLD:
                this.setSlaThreshold( key, value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.NAME:
            case "item_name":
                this.setName( value );
                break;
            case OBJECT.CONST.ELEMENT.FIELD_UI.VISUALISATION_NAME:
            case OBJECT.CONST.ELEMENT.FIELD_UI.ITEM_TYPE:
                this[ key ] = value;
                break;
            default:
                console.warn( "[IGNORED DATA]", key, value );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenElement, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.OBJECT.Refresh = function ( countdown, parent, do_once ) {
    this.parent_object     = parent;
    this.countdown         = countdown || 60000;
    this.countdown_tic     = 1000;
    this.current_countdown = this.countdown;
    this.do_once           = do_once || true;
    this.ui_components     = [];
    this.phase             = new SHINKEN.OBJECT.Phase( this );
    this.interval_tic_tac  = null;
};
SHINKEN.OBJECT.Refresh.prototype = {
    addUiComponent    : function ( to_add ) {
        this.ui_components.push( to_add );
    },
    computePercent        : function () {
        this.percent_computed = (1 - this.current_countdown / this.countdown) * 100;
    },
    setLastComputeDate: function ( to_set ) {
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].setLastComputeDate( to_set );
        }
    },
    askParentPhaseUpdated: function () {
        if ( !this.ui_components ) {
            return;
        }
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].phaseUpdated( this.phase.current_phase, this );
        }
    },
    updateCountdown: function () {
        if ( this.phase.isPhase( SHINKEN.OBJECT.CONST.PHASE.STUCK ) ) {
            return;
        }
        this.current_countdown -= this.countdown_tic;
        this.current_countdown = Math.max( this.current_countdown, 0 );
        this.computePercent();
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].updateCountdown( this );
        }
    },
    reset          : function () {
        clearInterval( this.interval_tic_tac );
        this.current_countdown = this.countdown;
    },
    tictac         : function () {
        var _phase_value = this.phase.current_phase;
        this.updateCountdown();
        if ( this.current_countdown <= 0 ) {
            switch ( _phase_value ) {
                case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                    this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                    break;
                case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                    if ( !SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                        this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                    }
                    break;
            }
        }
    },
    callbackForPhase: function () {
        this.askParentPhaseUpdated();
        switch ( this.phase.current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING :
                var _self = this;
                if ( this.phase.previous_phase !== SHINKEN.OBJECT.CONST.PHASE.STOPPING ) {
                    this.reset();
                }
                this.interval_tic_tac = setInterval( function () {
                    _self.tictac();
                }, this.countdown_tic );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING :
                if ( SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                    this.phase.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                }
                else {
                    clearInterval( this.interval_tic_tac );
                    if ( this.parent_object ) {
                        this.parent_object.refresh();
                    }
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING :
                clearInterval( this.interval_tic_tac );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Refresh, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.ClockComponent           = function ( dom_element_parent ) {
    this.initDomElement(dom_element_parent);
    this.init();
};
SHINKEN.TOOLS.ClockComponent.prototype = {
    
    init: function () {
        this.color  = '#5C5C5C';
    },
    initDomElement: function (dom_element_parent) {
        this.dom_element_container_clock_2 = dom_element_parent.querySelector(".shinken-container-clock-2");
        this.dom_element_container_clock_2.innerHTML = "<svg width='100%' height='100%' class=\"shinken-clock shinken-clock-refresh\" viewbox=\"0 0 121 121\">\n" +
                                       "<circle cx=\"60\" cy=\"60\" r=\"59\" stroke=\"#5C5C5C\" stroke-width=\"2\" fill=\"none\" />" +
                                       "<path id=\"id-shinken-clock-path\" fill=\"#5C5C5C\" transform=\"translate(60,60)\"/>\n" +
                                       "</svg>";
        this.dom_element = dom_element_parent.querySelector(".shinken-clock-refresh");
        this.dom_element_path = this.dom_element.getElementById( "id-shinken-clock-path" );
    },
    setColor: function ( color ) {
        this.color = color;
    },
    
    set_refreshing_content  : function () {
        DOM.Service.addClasses( this.dom_element_container_clock_2, 'shinken-clock-refreshing' );
    },
    unset_refreshing_content: function () {
        DOM.Service.removeClasses( this.dom_element_container_clock_2, 'shinken-clock-refreshing' );
    },
    updateHtml              : function (parent_object) {
        this.dom_element_path.setAttribute( "d", this.computePathAttribute(parent_object.percent_computed) );
    },
    computePathAttribute: function (percent) {
        percent = percent || 0;
        var angle = (360 * percent / 100) % 360;
        
        var rad   = (angle * Math.PI) / 180;
        var x     = Math.sin( rad ) * 60;
        var y     = Math.cos( rad ) * -60;
        var mid   = angle > 180 ? 1 : 0;
        return "M 0 0 v -60 A 60 60 1 " + mid + " 1 " + x + " " + y + " z";
    },
    eventIsRunning   : function (parent_object) {
        this.unset_refreshing_content();
        this.updateCountdown(parent_object);
    },
    eventIsRefreshing: function (parent_object) {
        this.set_refreshing_content();
    },
    updateCountdown  : function ( parent_object ) {
        this.updateHtml( parent_object );
    },
    eventIsStopping  : function (parent_object) {
        this.set_refreshing_content();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.ClockComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );
SHINKEN.TOOLS.UpdateAtComponent           = function ( dom_element ) {
    this.dom_element      = dom_element;
    this.dom_element_date = this.dom_element.querySelector( ".shinken-time-label" );
};
SHINKEN.TOOLS.UpdateAtComponent.prototype = {
    
    
    setLastComputeDate: function ( to_set ) {
        if ( !to_set ) {
            this.dom_element_date.innerHTML = _( 'service_weather.generate_at.generation_in_progress', [DICTIONARY_COMMON_UI] );
        }
        else {
            this.dom_element_date.innerHTML = DATE_TIME.FORMAT.get_time_from_timestamp( to_set );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.UpdateAtComponent, SHINKEN.TOOLS.InterfaceRefreshComponent );
SHINKEN.SERVER.ShinkenServer = function ( data ) {
    this.init( data );
};
SHINKEN.SERVER.ShinkenServer.prototype = {
    init          : function ( data ) {
        this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ] = [];
        if ( data ) {
            this.updateData( data );
        }
    },
    updateData    : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData       : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.SERVER.CONST.NAME:
                this.setName( value );
                break;
            
            case SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO:
                this.addCartoToList( value );
                break;
        }
    },
    setName       : function ( to_set ) {
        this[ SHINKEN.SERVER.CONST.NAME ] = to_set;
    },
    addCartoToList: function ( data ) {
        var _size = data.length;
        for ( var i = 0; i < _size; i++ ) {
            this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ].push( new SHINKEN.CARTO.ShinkenCarto( data[ i ] ) );
        }
    },
    computeHtml: function () {
        var _template         = document.querySelector( '#shinken-architecture-template .shinken-template-architecture-map' ).outerHTML;
        _template             = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_architecture_name_$$$", this.name );
        var _temp             = DOM.Service.createElement( "ul", {}, _template );
        this.dom_element      = _temp.firstChild;
        var _container_for_li = this.dom_element.querySelector( "ul.shinken-container" );
        for ( var i = 0, _size_i = this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ].length; i < _size_i; i++ ) {
            this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ][ i ].computeHtml();
            DOM.Service.addElementTo( this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ][ i ].dom_element, _container_for_li );
        }
        
    }
};
SHINKEN.SERVER.ShinkenServers = function ( data ) {
    this.init( data );
};
SHINKEN.SERVER.ShinkenServers.prototype = {
    init: function ( data ) {
        this.size    = 0;
        this.list    = [];
        this.need_compute_html = false;
        if ( !data ) {
            return;
        }
        this.updateData( data );
    },
    updateData: function ( datas ) {
        this.size              = datas.length;
        var _current_hash =  SHINKEN.TOOLS.STRING.hashCode( JSON.stringify( datas ) );
        if(this.hash === _current_hash) {
            return;
        }
        this.list = [];
        this.hash = _current_hash;
        this.need_compute_html = true;
        for ( var i = 0; i < this.size; i++ ) {
            this.list.push( new SHINKEN.SERVER.ShinkenServer( datas[ i ] ) );
        }
    },
    hasServers: function () {
        return !!this.size;
    },
    computeHtml: function () {
        if ( this.need_compute_html ) {
            for ( var i = 0; i < this.size; i++ ) {
                this.list[ i ].computeHtml();
            }
            this.need_compute_html = false;
        }
    }
};
SHINKEN.SlaQualityService = (function ( self ) {
    "use strict";
    self.templates            = {};
    self.getTemplateInnerHtml = function ( sla_quality ) {
        var _name = sla_quality.name;
        if ( !self.templates[ _name ] ) {
            var _dom = document.querySelector( "#id-shinken-template-view #id-shinken-sla-quality-template-" + _name );
            if ( _dom ) {
                self.templates[ _name ] = _dom.innerHTML;
            }
            else {
                self.templates[ _name ] = "";
                console.warn("[StatusService - getTemplateInnerHtml]", "Missing resources template : " + _name );
            }
        }
        return self.templates[ _name ];
    };
    
    return self;
})( SHINKEN.StatusService || {} );
SHINKEN.SlaQuality = function ( status_code, sla_status_code ) {
    this.init( status_code, sla_status_code );
};
SHINKEN.SlaQuality.prototype = {
    init                   : function ( status_code, sla_status_code ) {
        this.status_code     = status_code;
        this.sla_status_code = sla_status_code;
        if ( typeof this.status_code === "undefined" && typeof this.sla_status_code === "undefined" ) {
            this.name = SHINKEN.SLA_QUALITY.LOCK;
        }
        else {
            this.name = SHINKEN.SLA_QUALITY.MAPPING[ sla_status_code ][ status_code ];
        }
    },
    getPath                : function () {
        return "img/sla_quality/" + this.name + ".svg";
    },
    getInnerHtmlViaTemplate: function () {
        if ( this.name === SHINKEN.SLA_QUALITY.LOCK ) {
            return '<div class="shinken-user-no-right-to-see"><span class="shinkon shinkon-lock"\n' +
                   ' onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"\n' +
                   ' onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"\n' +
                   ' shi-tip-html="' + _( "widget.weather.shinken_element_user_no_right" ) + '"></span></div>';
        }
        else {
            return SHINKEN.SlaQualityService.getTemplateInnerHtml( this );
        }
    }
};
SHINKEN.SLA_QUALITY = {
    MAPPING    : [
        ["sun", "cloud_sunny", "cloud", "sun"],
        ["sun_cloudy", "dark_cloud", "storm", "cloud"],
        ["cloud", "dark_cloud", "storm", "storm"]
    ],
    LOCK : "lock"
};
SHINKEN.SLA_TENDENCY = {
    ARROW_UP_OK            : "arrow-up-ok",
    ARROW_UP_45_OK         : "arrow-up-45-ok",
    ARROW_STAGNANT_OK      : "arrow-stagnant-ok",
    ARROW_STAGNANT_CRITICAL: "arrow-stagnant-critical",
    ARROW_DOWN_45_CRITICAL : "arrow-down-45-critical",
    ARROW_DOWN_CRITICAL    : "arrow-down-critical",
    NO_DATA                : "no-data"
};
SHINKEN.OBJECT.InterfaceSlidePanelHorizontal           = function () {
};
SHINKEN.OBJECT.InterfaceSlidePanelHorizontal.prototype = {
    init    : function ( name, dom_element_main_part, min_width, max_width ) {
        this.initCommon();
        this.setName( name );
        this.setMainPartDomElement( dom_element_main_part );
        this.setMinWidth( min_width );
        this.setMaxWidth( max_width );
    },
    initSize: function ( init_with_ratio ) {
        this.width_screen   = window.innerWidth;
        this.width_original = DOM.Service.getBoundingClientRect( this.dom_element_main_part.parentElement, DOM.CONST.STYLE.WIDTH );
        this.computeAfterResize( this.width_original * (init_with_ratio || 0.5) );
    },
    initSizePixel: function ( pixels ) {
        this.width_screen   = window.innerWidth;
        this.width_original = DOM.Service.getBoundingClientRect( this.dom_element_main_part.parentElement, DOM.CONST.STYLE.WIDTH );
        this.computeAfterResize( pixels );
    },
    onDragStop: function () {
        this.current_width = DOM.Service.getBoundingClientRect( this.td_content, DOM.CONST.STYLE.WIDTH );
    },
    askClose  : function () {
        DOM.Service.addOrRemoveClasses( this.td_content, true, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, true, "shinken-hidden" );
    },
    askOpen   : function () {
        DOM.Service.addOrRemoveClasses( this.td_content, false, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, false, "shinken-hidden" );
    },
    computePinButtons : function ( current_width ) {
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.min_width === current_width, "shinken-min-width-on" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.getMaxWidth() === current_width, "shinken-max-width-on" );
    },
    doActionAfter    : function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_after_resize_done":
                this.computePinButtons( this.current_width );
                break;
        }
    },
    computeAfterResize  : function ( width ) {
        if ( width < this.min_width ) {
            width = this.min_width;
        }
        else if ( width > this.max_width ) {
            width = this.max_width;
        }
        this.current_width = width;
        DOM.Service.setStyle( this.td_content, DOM.CONST.STYLE.WIDTH, this.current_width );
        this.doActionAfter( "compute_after_resize_done" );
    },
    computeAfterDragMove: function ( delta_x ) {
        var _new_width = this.current_width - delta_x;
        if ( _new_width < this.min_width ) {
            _new_width = this.min_width;
        }
        if ( _new_width > this.getMaxWidth() ) {
            _new_width = this.getMaxWidth();
        }
        DOM.Service.setStyle( this.td_content, DOM.CONST.STYLE.WIDTH, _new_width );
        this.computePinButtons( _new_width );
    },
    computeSizes        : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        var _new_width = window.innerWidth;
        var _ratio     = _new_width / this.width_screen;
        this.computeAfterResize( this.current_width * _ratio );
        this.width_screen = _new_width;
    },
    getMaxWidth    : function () {
        return this.max_width;
    },
    setMinWidth    : function ( to_set ) {
        this.min_width = to_set;
    },
    setMaxWidth    : function ( to_set ) {
        this.max_width = to_set;
    },
    getCurrentRatio: function () {
        return this.current_width / this.width_original;
    },
    computeButtonHtml      : function () {
        var _to_return  = DOM.Service.createElement( "td", { class: "shinken-slide-panel-table-cell-buttons" } );
        var _buttons    = DOM.Service.createElement( "div", { class: "shinken-slide-panel-buttons shinken-user-select-none" } );
        var _div_shadow = DOM.Service.createElement( "div", { class: "shinken-slide-panel-buttons-shadow" } );
        DOM.Service.addElementTo( _div_shadow, _buttons );
        DOM.Service.addElementTo( _buttons, _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-right",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-type": "slide-panel-horizontal",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_RIGHT
        } ), _buttons );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class                          : "shinken-slide-panel-button shinkon shinkon-resize-vertical shinken-draggable",
            "data-drag-is-in-screen"       : true,
            "data-drag-resize-element-name": this.name,
            "data-type"                    : "slide-panel-horizontal",
            onmousedown                    : "MANAGER.DragNDropManager.dragStartSingle(event)"
        } ), _buttons );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-left",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-type": "slide-panel-horizontal",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_LEFT
        } ), _buttons );
        return _to_return;
    },
    _computeHtml           : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            class: "shinken-slide-panel-content shinken-height-100"
        } ) );
        if ( this.content_html ) {
            this.addDomElement( this.content_html );
        }
        this.modifyStructureMainPart();
    },
    modifyStructureMainPart: function () {
        var _dom_parent        = this.dom_element_main_part.parentElement;
        var _main_container    = DOM.Service.createElement( "div", { class: "shinken-slide-panel-content-all", "data-type": this.type } );
        var _table_structure   = DOM.Service.createElement( "table", { class: "shinken-table" } );
        this._tr_structure     = DOM.Service.createElement( "tr" );
        this._td_for_main_part = DOM.Service.createElement( "td", { class: "shinken-main-part-cell shinken-vertical-align-top" } );
        this.td_content        = DOM.Service.createElement( "td", { class: "shinken-slide-panel-table-cell-content shinken-vertical-align-top" } );
        this.td_buttons        = this.computeButtonHtml();
        DOM.Service.addElementTo( this.getDomElement(), this.td_content );
        DOM.Service.addElementTo( this._tr_structure, _table_structure );
        DOM.Service.addElementTo( _table_structure, _main_container );
        DOM.Service.addElementTo( _main_container, _dom_parent );
        DOM.Service.addElementTo( this.dom_element_main_part, this._td_for_main_part );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceSlidePanelHorizontal, SHINKEN.OBJECT.InterfaceSlidePanel );
SHINKEN.OBJECT.SlidePanelRight           = function ( name, dom_element_main_part, min_width, max_width ) {
    this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT );
    this.init( name, dom_element_main_part, min_width, max_width );
};
SHINKEN.OBJECT.SlidePanelRight.prototype = {
    pinToRight: function () {
        var _width = this.min_width || 0;
        this.computeAfterResize( _width );
    },
    pinToLeft : function () {
        this.computeAfterResize( this.getMaxWidth() || this.width_original );
    },
    
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this._td_for_main_part, this._tr_structure );
        DOM.Service.addElementTo( this.td_buttons, this._tr_structure );
        DOM.Service.addElementTo( this.td_content, this._tr_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelRight, SHINKEN.OBJECT.InterfaceSlidePanelHorizontal );
SHINKEN.OBJECT.SlidePanelLeft           = function ( name, dom_element_main_part, min_width, max_width ) {
    this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT );
    this.init( name, dom_element_main_part, min_width, max_width );
};
SHINKEN.OBJECT.SlidePanelLeft.prototype = {
    pinToRight: function () {
        this.computeAfterResize( this.getMaxWidth() || this.width_original );
    },
    pinToLeft : function () {
        var _width = this.min_width || 0;
        this.computeAfterResize( _width );
    },
    
    
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this.td_content, this._tr_structure );
        DOM.Service.addElementTo( this.td_buttons, this._tr_structure );
        DOM.Service.addElementTo( this._td_for_main_part, this._tr_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelLeft, SHINKEN.OBJECT.InterfaceSlidePanelHorizontal );
SHINKEN.OBJECT.SlidePanelLeftFromHtml           = function ( name, dom_element, min_width, max_width ) {
    this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT );
    this.initSpecific( name, dom_element, min_width, max_width );
};
SHINKEN.OBJECT.SlidePanelLeftFromHtml.prototype = {
    initSpecific: function ( name, dom_element, min_width, max_width ) {
        this.init( name, dom_element.querySelector( ".shinken-slide-panel-main-part" ), min_width, max_width );
        this.td_content        = dom_element.querySelector( ".shinken-slide-panel-table-cell-content" );
        this.td_buttons        = dom_element.querySelector( ".shinken-slide-panel-table-cell-buttons" );
        this._td_for_main_part = dom_element.querySelector( ".shinken-main-part-cell" );
    },
    pinToRight: function () {
        this.computeAfterResize( this.getMaxWidth() || this.width_original );
    },
    pinToLeft : function () {
        var _width = this.min_width || 0;
        this.computeAfterResize( _width );
    },
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelLeftFromHtml, SHINKEN.OBJECT.InterfaceSlidePanelHorizontal );
SHINKEN.OBJECT.InterfaceSlidePanelVertical           = function () {
};
SHINKEN.OBJECT.InterfaceSlidePanelVertical.prototype = {
    initSize: function ( init_with_ratio ) {
        this.height_original = DOM.Service.getBoundingClientRect( this.dom_element_main_part.parentElement, DOM.CONST.STYLE.HEIGHT );
        if ( !this.height_original ) {
            var self = this;
            setTimeout( function () {
                self.initSize( init_with_ratio );
            }, 200 );
            return;
        }
        this.height_screen = window.innerHeight;
        DOM.Service.setStyle( this.main_structure, DOM.CONST.STYLE.HEIGHT, this.height_original );
        this.computeAfterResize( this.height_original * (init_with_ratio || 0.2) );
    },
    onDragStop       : function () {
        this.current_height = DOM.Service.getBoundingClientRect( this.getDomElement(), DOM.CONST.STYLE.HEIGHT );
    },
    askClose         : function () {
        DOM.Service.addOrRemoveClasses( this.getDomElement(), true, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, true, "shinken-hidden" );
        this.computeAfterResize( 0 );
    },
    askOpen          : function () {
        DOM.Service.addOrRemoveClasses( this.getDomElement(), false, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, false, "shinken-hidden" );
    },
    computePinButtons: function ( current_height ) {
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.min_height === current_height, "shinken-max-height-on" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.getMaxHeight() === current_height, "shinken-min-height-on" );
    },
    doActionAfter    : function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_after_resize_done":
                this.computePinButtons( this.current_height );
                break;
        }
    },
    computeAfterResize  : function ( height ) {
        if ( !this.content_html ) {
            DOM.Service.setStyle( this.dom_element_main_part, DOM.CONST.STYLE.HEIGHT, this.height_original );
            return;
        }
        if ( height > this.height_screen || height < this.min_height ) {
            height = this.min_height;
        }
        else if ( height > this.getMaxHeight() ) {
            height = this.getMaxHeight();
        }
        this.current_height = height;
        DOM.Service.setStyle( this.getDomElement(), DOM.CONST.STYLE.HEIGHT, this.current_height );
        DOM.Service.setStyle( this.dom_element_main_part, DOM.CONST.STYLE.HEIGHT, this.height_original - this.current_height - this.getHeightButtons() );
        this.doActionAfter( "compute_after_resize_done" );
    },
    computeAfterDragMove: function ( delta_y ) {
        var _new_height = this.current_height + delta_y;
        if ( _new_height < this.min_height ) {
            _new_height = this.min_height;
        }
        if ( _new_height > this.getMaxHeight() ) {
            _new_height = this.getMaxHeight();
        }
        DOM.Service.setStyle( this.getDomElement(), DOM.CONST.STYLE.HEIGHT, _new_height );
        DOM.Service.setStyle( this.dom_element_main_part, DOM.CONST.STYLE.HEIGHT, this.height_original - _new_height - this.getHeightButtons() );
        this.computePinButtons( _new_height );
    },
    computeSizes        : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        this.main_structure.classList.add( "shinken-hidden" ); //NEEDED IN ORDER TO IGNORE SIZE HARD SET.
        var _new_height          = window.innerHeight;
        var _ratio               = _new_height / this.height_screen;
        var _old_height_original = this.height_original;
        this.height_original     = DOM.Service.getBoundingClientRect( this.dom_element_parent, DOM.CONST.STYLE.HEIGHT );
        DOM.Service.setStyle( this.main_structure, DOM.CONST.STYLE.HEIGHT, this.height_original );
        if ( this.height_original ) {
            this.computeAfterResize( this.current_height * (this.height_original / _old_height_original) );
        }
        this.height_screen = _new_height;
        this.main_structure.classList.remove( "shinken-hidden" );
    },
    getHeightButtons: function () {
        return 22;
    },
    setMinHeight    : function ( to_set ) {
        this.min_height = to_set || 0;
    },
    setMaxHeight    : function ( to_set ) {
        this.max_height = to_set || this.height_original;
    },
    getMaxHeight    : function () {
        return this.max_height - this.getHeightButtons();
    },
    getCurrentRatio : function () {
        return this.current_height / this.height_original;
    },
    computeButtonHtml      : function () {
        var _to_return  = DOM.Service.createElement( "div", { class: "shinken-slide-table-panel-buttons-container" } );
        var _table      = DOM.Service.createElement( "table", { class: "shinken-slide-table-panel-buttons" } );
        var _tr         = DOM.Service.createElement( "tr" );
        var _div_button = DOM.Service.createElement( "td", { class: "shinken-slide-panel-buttons shinken-user-select-none" } );
        var _div_shadow = DOM.Service.createElement( "td", { class: "shinken-slide-panel-buttons-shadow" } );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-down",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_BOTTOM,
            "data-type": "slide-panel-vertical",
            value      : this.max_width
        } ), _div_button );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class                          : "shinken-slide-panel-button shinkon shinkon-resize-horizontal shinken-draggable",
            "data-drag-is-in-screen"       : true,
            "data-drag-resize-element-name": this.name,
            "data-type"                    : "slide-panel-vertical",
            onmousedown                    : "MANAGER.DragNDropManager.dragStartSingle(event)"
        } ), _div_button );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-up",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-type": "slide-panel-vertical",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_TOP
        } ), _div_button );
        DOM.Service.addElementTo( _div_shadow, _tr );
        DOM.Service.addElementTo( _div_button, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _to_return );
        return _to_return;
    },
    _computeHtml           : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            class: "shinken-slide-panel-content shinken-height-100"
        } ) );
        if ( this.content_html ) {
            this.addDomElement( this.content_html );
        }
        this.modifyStructureMainPart();
    },
    modifyStructureMainPart: function () {
        var _dom_parent     = this.dom_element_main_part.parentElement;
        this.main_structure = DOM.Service.createElement( "div", { class: "shinken-slide-panel-content-all shinken-height-100", "data-type": this.type } );
        this.td_buttons     = this.computeButtonHtml();
        DOM.Service.addElementTo( this.main_structure, _dom_parent );
    }
};
SHINKEN.OBJECT.SlidePanelTop           = function ( name, dom_element_main_part, min_height, max_height ) {
    this.init( name, dom_element_main_part, min_height, max_height );
};
SHINKEN.OBJECT.SlidePanelTop.prototype = {
    init: function ( name, dom_element_main_part, min_height, max_height ) {
        this.initCommon();
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP );
        this.setName( name );
        this.setMainPartDomElement( dom_element_main_part );
        this.setMinHeight( min_height );
        this.setMaxHeight( max_height );
    },
    pinToTop   : function () {
        this.computeAfterResize( this.min_height );
    },
    pinToBottom: function () {
        this.computeAfterResize( (this.getMaxHeight() || this.height_original) );
    },
    
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this.getDomElement(), this.main_structure );
        DOM.Service.addElementTo( this.td_buttons, this.main_structure );
        DOM.Service.addElementTo( this.dom_element_main_part, this.main_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelTop, SHINKEN.OBJECT.InterfaceSlidePanelVertical );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelTop, SHINKEN.OBJECT.InterfaceSlidePanel );
SHINKEN.OBJECT.SlidePanelBottom           = function ( name, dom_element_main_part, min_height, max_height ) {
    this.init( name, dom_element_main_part, min_height, max_height );
};
SHINKEN.OBJECT.SlidePanelBottom.prototype = {
    init: function ( name, dom_element_main_part, min_height, max_height ) {
        this.initCommon();
        this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM );
        this.setName( name );
        this.setMainPartDomElement( dom_element_main_part );
        this.setMinHeight( min_height );
        this.setMaxHeight( max_height );
    },
    pinToTop   : function () {
        this.computeAfterResize( (this.getMaxHeight() || this.height_original) );
    },
    pinToBottom: function () {
        this.computeAfterResize( this.min_height );
    },
    
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this.dom_element_main_part, this.main_structure );
        DOM.Service.addElementTo( this.td_buttons, this.main_structure );
        DOM.Service.addElementTo( this.getDomElement(), this.main_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelBottom, SHINKEN.OBJECT.InterfaceSlidePanelVertical );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelBottom, SHINKEN.OBJECT.InterfaceSlidePanel );
SHINKEN.StatusService = (function( self ) {
    "use strict";
    
    self.buildPaths     = function ( status, context ) {
        var _to_return = {
            path      : null,
            path_extra: null
        };
        if ( context.is( SHINKEN.STATUS.DISABLED ) ) {
            _to_return.path = context.getPath();
        }
        else if ( !context.is( SHINKEN.STATUS.NOTHING ) ) {
            _to_return.path       = context.getPath();
            _to_return.path_extra = status.getPath();
        }
        else {
            _to_return.path = status.getPath();
        }
        return _to_return;
    };
    self.buildTilePaths = function ( status, context ) {
        return  {
            path      : status.getPath(),
            path_extra: context.getPath()
        };
    };
    self.parseToPartial = function ( code ) {
        var _to_return;
        switch ( code ) {
            case  SHINKEN.STATUS.ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE;
                break;
            case SHINKEN.STATUS.DOWNTIME.CODE:
            case SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE;
                break;
            case SHINKEN.STATUS.FLAPPING.CODE:
                _to_return = SHINKEN.STATUS.PARTIAL_FLAPPING.CODE;
                break;
            default:
                _to_return = code;
                break;
        }
        return _to_return;
    };
    self.isPartial      = function ( code ) {
        switch ( code ) {
            case SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
            case SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
            case SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return true;
        }
        return false;
    };
    self.isContext      = function ( context, type ) {
        var _code = context.getCode();
        switch ( type ) {
            case SHINKEN.STATUS.ACKNOWLEDGED:
                switch ( _code ) {
                    case SHINKEN.STATUS.ACKNOWLEDGED.CODE:
                    case SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
                    case SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.DOWNTIME:
                switch ( _code ) {
                    case SHINKEN.STATUS.DOWNTIME.CODE:
                    case SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
                    case SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.FLAPPING:
                switch ( _code ) {
                    case SHINKEN.STATUS.FLAPPING.CODE:
                    case SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.DISABLED:
                switch ( _code ) {
                    case SHINKEN.STATUS.DISABLED.CODE:
                        return true;
                }
                break;
            case SHINKEN.STATUS.NOTHING:
                switch ( _code ) {
                    case SHINKEN.STATUS.NOTHING.CODE:
                        return true;
                }
                break;
        }
        return false;
    };
    
    return self;
})( SHINKEN.StatusService  || {} );
SHINKEN.Status = function () {
};
SHINKEN.Status.prototype = {
    setCode      : function ( toSet ) {
        this.code = toSet;
        this.key  = SHINKEN.STATUS.CODE_TO_KEY[ this.code ];
        this.initEnd();
    },
    setKey       : function ( toSet ) {
        this.key  = toSet;
        this.code = SHINKEN.STATUS[ this.key ].CODE;
        this.initEnd();
    },
    initEnd      : function ( toSet ) {
        this.setName();
        this.priority = SHINKEN.STATUS[ this.key ].PRIORITY;
        this.label    = this.name;
        this.buildPath();
    },
    getCode      : function () {
        return this.code;
    },
    getLabel     : function () {
        return this.label;
    },
    getName      : function () {
        return this.name;
    },
    getPriority  : function () {
        return this.priority;
    },
    is           : function ( type ) {
        return this.isByCode( type.CODE );
    },
    isByCode     : function ( code ) {
        return this.code === code;
    },
    getPath      : function () {
        return this.path;
    },
    setPathExtra : function ( name ) {
    },
    getClass     : function () {
        var _to_return = this.getName();
        if ( this.is_inherited ) {
            _to_return = 'inherited-' + _to_return;
        }
        return _to_return;
    },
    setName      : function () {
        this.name = SHINKEN.STATUS[ this.key ].NAME;
    },
    equals       : function ( status ) {
        if ( !status ) {
            return false;
        }
        if ( status.code !== this.code ) {
            return false;
        }
        if ( this.path_extra && status.path_extra && this.path_extra !== status.path_extra ) {
            return false;
        }
        return true;
    },
    buildPath    : function () {
        if ( this.name === SHINKEN.STATUS.NOTHING.NAME ) {
            this.path = '';
        }
        else  {
            this.path = '/static/' + __SHINKEN_HTTP_START_TIME__ + '/img/icons/' + this.name + '.svg';
        }
    },
    buildHtml    : function () {
    },
    getCodeSample: function () {
        switch ( this.code ) {
            case  SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
            case  SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                return SHINKEN.STATUS.DOWNTIME.CODE;
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                return SHINKEN.STATUS.ACKNOWLEDGED.CODE;
            case  SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return SHINKEN.STATUS.FLAPPING.CODE;
        }
        return this.code;
    },
    getNameSample: function () {
        switch ( this.code ) {
            case  SHINKEN.STATUS.INHERITED_DOWNTIME.CODE:
            case  SHINKEN.STATUS.PARTIAL_DOWNTIME.CODE:
                return SHINKEN.STATUS.DOWNTIME.NAME;
            case  SHINKEN.STATUS.INHERITED_ACKNOWLEDGED.CODE:
            case  SHINKEN.STATUS.PARTIAL_ACKNOWLEDGED.CODE:
                return SHINKEN.STATUS.ACKNOWLEDGED.NAME;
            case  SHINKEN.STATUS.PARTIAL_FLAPPING.CODE:
                return SHINKEN.STATUS.FLAPPING.NAME;
        }
        return this.name;
    }
};
SHINKEN.STATUS = {
    OK                        : {
        CODE    : 0,
        NAME    : 'ok',
        KEY     : 'OK',
        PRIORITY: 0,
        ORDER   : 0,
        TYPE    : 'status',
        PATH    : 'assets/images/status/ok.svg'
    },
    WARNING                   : {
        CODE    : 1,
        NAME    : 'warning',
        KEY     : 'WARNING',
        PRIORITY: 2,
        ORDER   : 1,
        TYPE    : 'status',
        PATH    : 'assets/images/status/warning.svg'
    },
    CRITICAL                  : {
        CODE    : 2,
        NAME    : 'critical',
        KEY     : 'CRITICAL',
        PRIORITY: 3,
        ORDER   : 2,
        TYPE    : 'status',
        PATH    : 'assets/images/status/critical.svg'
    },
    UNKNOWN                   : {
        CODE    : 3,
        NAME    : 'unknown',
        KEY     : 'UNKNOWN',
        PRIORITY: 1,
        ORDER   : 3,
        TYPE    : 'status',
        PATH    : 'assets/images/status/unknown.svg'
    },
    MISSING_DATA              : {
        CODE    : 4,
        NAME    : 'missing-data',
        KEY     : 'MISSING_DATA',
        PRIORITY: 0,
        ORDER   : 4,
        TYPE    : 'status'
    },
    PENDING                   : {
        CODE    : 4,
        NAME    : 'missing-data',
        KEY     : 'MISSING_DATA',
        PRIORITY: 0,
        ORDER   : 4,
        TYPE    : 'status'
    },
    SHINKEN_INACTIVE          : {
        CODE    : 5,
        NAME    : 'shinken-inactive',
        KEY     : 'SHINKEN_INACTIVE',
        PRIORITY: 0,
        ORDER   : 5,
        TYPE    : 'status'
    },
    NOTHING                   : {
        CODE    : 'NOTHING',
        NAME    : 'nothing',
        PRIORITY: 0,
        ORDER   : 0,
        TYPE    : 'context'
    },
    ACKNOWLEDGED              : {
        CODE    : 'ACKNOWLEDGED',
        NAME    : 'acknowledged',
        PRIORITY: 15,
        ORDER   : 1,
        TYPE    : 'context'
    },
    PARTIAL_ACKNOWLEDGED      : {
        CODE    : 'PARTIAL-ACKNOWLEDGED',
        NAME    : 'partial-acknowledged',
        PRIORITY: 19,
        ORDER   : 2,
        TYPE    : 'context'
    },
    INHERITED_ACKNOWLEDGED    : {
        CODE    : 'INHERITED-ACKNOWLEDGED',
        NAME    : 'inherited-acknowledged',
        PRIORITY: 10,
        ORDER   : 2,
        TYPE    : 'context'
    },
    DOWNTIME                  : {
        CODE    : 'DOWNTIME',
        NAME    : 'downtime',
        PRIORITY: 35,
        ORDER   : 3,
        TYPE    : 'context',
        PATH    : 'assets/images/status/downtime.svg'
    },
    PARTIAL_DOWNTIME          : {
        CODE    : 'PARTIAL-DOWNTIME',
        NAME    : 'partial-downtime',
        PRIORITY: 39,
        ORDER   : 3,
        TYPE    : 'context'
    },
    INHERITED_DOWNTIME        : {
        CODE    : 'INHERITED-DOWNTIME',
        NAME    : 'inherited-downtime',
        PRIORITY: 30,
        ORDER   : 3,
        TYPE    : 'context'
    },
    FLAPPING                  : {
        CODE    : 'FLAPPING',
        NAME    : 'flapping',
        PRIORITY: 25,
        ORDER   : 4,
        TYPE    : 'context'
    },
    PARTIAL_FLAPPING          : {
        CODE    : 'PARTIAL-FLAPPING',
        NAME    : 'partial-flapping',
        PRIORITY: 29,
        ORDER   : 5,
        TYPE    : 'context'
    },
    DISABLED                  : {
        CODE    : 'DISABLED',
        NAME    : 'disabled',
        PRIORITY: 404,
        ORDER   : 6,
        TYPE    : 'context'
    },
    STATUS_COUNT              : 6,
    CODE_TO_KEY               : {
        0                       : 'OK',
        1                       : 'WARNING',
        2                       : 'CRITICAL',
        3                       : 'UNKNOWN',
        4                       : 'MISSING_DATA',
        5                       : 'SHINKEN_INACTIVE',
        NOTHING                 : 'NOTHING',
        ACKNOWLEDGED            : 'ACKNOWLEDGED',
        'PARTIAL-ACKNOWLEDGED'  : 'PARTIAL_ACKNOWLEDGED',
        'INHERITED-ACKNOWLEDGED': 'INHERITED_ACKNOWLEDGED',
        DOWNTIME                : 'DOWNTIME',
        'PARTIAL-DOWNTIME'      : 'PARTIAL_DOWNTIME',
        'INHERITED-DOWNTIME'    : 'INHERITED_DOWNTIME',
        FLAPPING                : 'FLAPPING',
        'PARTIAL-FLAPPING'      : 'PARTIAL_FLAPPING',
        DISABLED                : 'DISABLED'
    },
    NAME_TO_CODE              : {
        ok      : 0,
        warning : 1,
        critical: 2,
        unknown : 3
    },
    LIST_CONTEXT_WIDGET_DETAIL: {
        0: 'NOTHING',
        1: 'ACKNOWLEDGED',
        2: 'FLAPPING',
        3: 'DOWNTIME'
    },
    TYPE                      : {
        STATUS : 'status',
        CONTEXT: 'context'
    }
    
};
SHINKEN.ELEMENT.UiUserAcl = function ( data ) {
    this.make_downtime                = true;
    this.make_acknowledge             = true;
    this.force_result_check           = true;
    this.show_historic_sla            = true;
    this.show_historic_historic       = true;
    this.show_historic_sla_range      = true;
    this.show_historic_historic_range = true;
    this.init( data );
};
SHINKEN.ELEMENT.UiUserAcl.prototype = {
    init                    : function ( data ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ]   = new SHINKEN.ELEMENT.UiUserAclShareExtend();
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ]     = new SHINKEN.ELEMENT.UiUserAclShareExtend();
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ] = new SHINKEN.ELEMENT.UiUserAclShareExtend();
        this.updateData( data );
    },
    updateData              : function ( datas ) {
        var _keys     = Object.keys( datas );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, datas[ _currentKey ] );
        }
        this.setRightToCreateNewShare();
        this.setDisplayFavoritePanel();
    },
    setData                 : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.ELEMENT.USER.PARAM.ACL.MAKE_DOWNTIME:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.MAKE_ACKNOWLEDGE:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.FORCE_RESULT:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.RECHECK_NOW:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW:
                this.setHistoricShow( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.HISTORIC_RANGE:
                this.show_historic_historic_range = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SLA_RANGE:
                this.show_historic_sla_range = value;
                break;
            
            case SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY:
                this[ key ].init( value );
                break;
            default:
                break;
            
        }
    },
    setHistoricShow         : function ( value ) {
        switch ( value ) {
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_BOTH:
                this.show_historic_sla      = true;
                this.show_historic_historic = true;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_HISTORY_ONLY:
                this.show_historic_sla      = false;
                this.show_historic_historic = true;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_SLA_ONLY:
                this.show_historic_sla      = true;
                this.show_historic_historic = false;
                break;
        }
    },
    setRightToCreateNewShare: function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ] ) {
            return;
        }
    },
    hasRightToCreateFavorite: function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ].create && this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ].read;
    },
    canCreateFavorite       : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ].hasRight( "create" );
    },
    setDisplayFavoritePanel : function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ] ) {
            return;
        }
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ] ) {
            return;
        }
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ] ) {
            return;
        }
    },
    getHistoricDisplayMode  : function () {
        if ( this.show_historic_historic && this.show_historic_sla ) {
            return SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_BOTH;
        }
        if ( this.show_historic_historic ) {
            return SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_HISTORY_ONLY;
        }
        if ( this.show_historic_sla ) {
            return SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_SLA_ONLY;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUserAcl, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.ELEMENT.UiUserAclShareExtend = function () {
    this.read     = false;
    this.create   = false;
    this.organize = false;
    this.update   = false;
    this.delete   = false;
};
SHINKEN.ELEMENT.UiUserAclShareExtend.prototype = {
    init    : function ( data ) {
        var _data = data.split( '' );
        var _size = _data.length;
        var _key;
        for ( var i = 0; i < _size; i++ ) {
            _key = SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE[ i ];
            if ( !_key ) {
                console.error( "[UNKNOWN SHARE ACL STRUCTURE]" );
                continue;
            }
            this[ _key ] = !!parseInt( _data[ i ] );
        }
    },
    hasRight: function ( type ) {
        if ( !this.read ) {
            return false;
        }
        return this[ type ];
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUserAclShareExtend, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.ELEMENT.UiUserPrefs = function () {
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME ]           = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ]         = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME ]     = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ]           = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH ]     = 200;
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME ]        = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ]                 = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ] = new SHINKEN.OBJECT.NotificationsOfChangeUser();
};
SHINKEN.ELEMENT.UiUserPrefs.prototype = {
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "change_value_notification_of_change_sound":
            case "change_value_notification_of_change_visual_blink":
                this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].doActionAfter( event_name, param );
                break;
        }
    },
    updateData             : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME:
                this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].updateData( value );
                
                break;
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.PANELS.NAME:
                break;
            default:
                this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ][ key ] = value;
                break;
        }
    },
    getDataToSave          : function () {
        var to_return                                                             = {};
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME ]           = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ]         = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME ]     = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ]           = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME ]        = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ]                 = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ] = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].getDataToSave();
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.PANELS.NAME ]                 = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.PANELS.NAME ].getDataToSave();
        if ( EXTERNAL.COMMUNICATION.NEW_DETAIL_WIDTH ) {
            to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH ] = EXTERNAL.COMMUNICATION.NEW_DETAIL_WIDTH;
        }
        return to_return;
    },
    getNotificationOfChange: function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ];
    }
};
SHINKEN.ELEMENT.UiUser = function ( data ) {
    this.init( data );
};
SHINKEN.ELEMENT.UiUser.prototype = {
    getDataForSelector: function () {
        return { name: this.getName(), label: this.getName() };
    },
    getDefaultUrlFromSettings    : function () {
        return this.getSettings() [ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.DEFAULT_URL ];
    },
    getDefaultView               : function () {
        return this.getDefaultUrlFromSettings() || this.getDefaultUrl();
    },
    init                         : function ( data ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] = true;
        if ( data ) {
            this.updateData( data );
        }
    },
    setDefaultUrlToCurrentView   : function () {
        this.getSettings().default_url = SHINKEN.HIGHWAY.getHash();
    },
    updateData                   : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                      : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.ELEMENT.USER.PARAM.ACL.KEY:
                this.setACL( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.GROUPS:
                break;
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME:
                this.setPrefs( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD:
                this.setSettings( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.STATUS:
                this.setStatus( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.UI:
                this.setUI( value );
                break;
            case "user_name":
            case SHINKEN.ELEMENT.USER.PARAM.USER_NAME:
                this.setName( value );
                break;
            case "user_uuid":
            case SHINKEN.ELEMENT.USER.PARAM.UUID:
                this.setUUID( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.VERSION:
                this.setVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.VERSION_FULL:
                this.setVersionFull( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY_BACKEND:
                this.setTilesFormat( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ARCHITECTURE:
                this.setServers( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES:
                this.setModules( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN:
                this.setIsAdmin( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION:
                this.setShinkenVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION_SHORT:
                this.setShinkenShortVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION:
                this.setCssVersion( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TIME_ZONE_BACKEND:
                break;
            case SHINKEN.ELEMENT.USER.PARAM.EVENT_CONTAINER_DAY_KEEP_DATA:
            case SHINKEN.ELEMENT.USER.PARAM.EVENTS_CSV_EXPORT_LIMIT:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.EVENTS_EXPORT_MAX_RETRY:
                break;
            case "backend_localtime_epoch":
                this.setLocalTime( value );
                break;
            case "configuration_id":
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.EXISTS:
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS__USERS__SOUND__VOLUME_PERCENT:
            case SHINKEN.ELEMENT.USER.PARAM.DEFAULT_NOTIFICATIONS_SETTINGS__USERS__VISUAL__BLINK__ENABLED:
                this[ key ] = value;
                break;
            default:
                this._setData( key, value );
        }
    },
    _setData                     : function ( key, value ) {
    },
    setSettings                  : function ( value ) {
        var _keys        = Object.keys( value );
        var _size_object = _keys.length;
        for ( var i = 0; i < _size_object; i++ ) {
            this.getSettings()[ _keys[ i ] ] = value[ _keys[ i ] ];
        }
    },
    setStatus                    : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.STATUS ] = value;
    },
    setUI                        : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.UI ] = value;
    },
    getName                      : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ];
    },
    getUUID                      : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.UUID ];
    },
    setUUID                      : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.UUID ] = value || "";
    },
    setName                      : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] = value || "";
    },
    setACL                       : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.KEY ] = new SHINKEN.ELEMENT.UiUserAcl( value );
        
    },
    setVersion                   : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] = value;
    },
    setVersionFull               : function ( value ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.VERSION_FULL ] = value;
    },
    setTilesFormat               : function ( value ) {
        switch ( value ) {
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                this[ SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY ] = SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.TYPE.DEFAULT;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                this[ SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY ] = SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.TYPE.CONTEXT_UP;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                this[ SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.KEY ] = SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.TYPE.STATUS_UP;
                break;
            default:
                if ( APP_INFO.DEBUG ) {
                    console.warn( "tiles_background unknown", "[" + value + "]", "Default value used" );
                }
                break;
        }
    },
    getDefaultUrl                : function () {
        return "#/hive/" + this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.UUID ];
    },
    getNameDefaultView           : function () {
        return this.getSettings()[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.NAME_DEFAULT_VIEW ];
    },
    _validateData                : function () {
        if ( !this.getSettings()[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.DEFAULT_URL ] && this.getPrefs().defaultScreen.uuid ) {
            var _settings                                                = {};
            _settings[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.DEFAULT_URL ] = LocationService.getUrlHiveDefaultView( this.getPrefs().defaultScreen.uuid );
            this.setSettings( _settings );
        }
    },
    clean                        : function () {
        return Http.query( {
            path  : COMMUNICATION.QUERY.GET.SHINKEN.ELEMENT.USER.KEY + '/' + this.uuid + '/clean',
            method: 'DELETE'
        } );
    },
    doesExists                   : function () {
        var _to_return = $q.defer();
        this.get().then(
            function success () {
                _to_return.resolve( true );
            },
            function error ( response ) {
                switch ( response.status ) {
                    case NETWORK.HTTP_CODE._404_NOT_FOUND:
                        _to_return.resolve( false );
                        break;
                    default:
                        RefreshService.askChangeStatus( REFRESH.STATUS.BACKEND_CALL_FAILED );
                        _to_return.reject( response );
                        break;
                }
            }
        );
        return _to_return.promise;
    },
    getUserSaveData              : function getUserSaveData () {
        var OLD_USER_SAVE_PATH = 'usersave/';
        var defer              = $q.defer();
        Http.query( {
            method: 'GET',
            path  : OLD_USER_SAVE_PATH
        } ).then(
            function success ( response ) {
                defer.resolve( response.data );
            },
            function error ( response ) {
                response.status === 404 ? defer.resolve( null ) : defer.reject( response );
            }
        );
        return defer.promise;
    },
    checkMigrationNeeded         : function () {
        var to_return = $q.defer();
        var _self     = this;
        this.getUserSaveData().then( function ( data ) {
            if ( data && data[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] === MIGRATION.VERSION.V02_03_03_U1 && !_self[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] ) {
                to_return.resolve( MIGRATION.VERSION.V02_03_03_U1 );
            }
            else if ( data && _self[ SHINKEN.ELEMENT.USER.PARAM.VERSION ] ) {
                to_return.resolve( MIGRATION.VERSION.V02_04_00_with_U1_data_to_clean );
            }
            else {
                to_return.resolve( false );
            }
            
        } );
        return to_return.promise;
    },
    isOwner                      : function isOwnerUserFn ( item ) {
        return this.uuid === item.owner.uuid;
    },
    setIsAdmin                   : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ]                 = to_set;
        this[ SHINKEN.ELEMENT.USER.PARAM.CAN_EDIT_WEATHER_SERVICE ] = !!this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ];
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION_TOOLTIP ]  = this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ] ? this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] : '';
    },
    setShinkenShortVersion       : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION_SHORT ] = to_set;
    },
    setShinkenVersion            : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.SHINKEN_VERSION ] = to_set;
    },
    setCssVersion                : function ( to_set ) {
        if ( this[ SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION ] && this[ SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION ] !== to_set ) {
            ScreenService.askReloadPageNewShinkenVersion().then(
                function success () {
                    LocationService.reloadPage();
                }
            );
        }
        this[ SHINKEN.ELEMENT.USER.PARAM.CSS_CHECK_VERSION ] = to_set;
    },
    setLocalTime                 : function ( to_set ) {
    },
    isAdmin                      : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.IS_ADMIN ];
    },
    setServers                   : function ( data ) {
        if ( this.servers === undefined ) {
            this.servers = new SHINKEN.SERVER.ShinkenServers();
        }
        this.servers.updateData( data );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_ARCHITECTURE_MODULE ] = !!this.servers.size;
        CONTROLLER.NavigationBar.askUpdateArchitectureExportMenu( this.servers );
    },
    setModules                   : function ( to_set ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.KNOWN_MODULES ]              = to_set;
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ]       = SHINKEN.TOOLS.ARRAY.contains( to_set, 'event_container' );
        this[ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] = SHINKEN.TOOLS.ARRAY.contains( to_set, 'webui_module_service_weather' );
    },
    hasServiceWeatherModule      : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_WEATHER_SERVICE_MODULE ] || false;
    },
    hasEventTubModule            : function () {
        return this [ SHINKEN.ELEMENT.USER.PARAM.HAS_EVENT_TUB_MODULE ] || false;
    },
    getSettings                  : function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ] ) {
            this[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ] = {};
        }
        return this[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ];
    },
    getPrefs                     : function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ] ) {
            this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ] = new SHINKEN.ELEMENT.UiUserPrefs();
        }
        return this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ];
    },
    getPref                      : function ( pref_name ) {
        return this.getPrefs()[ pref_name ];
    },
    getDetailGraphHostWidth      : function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH ];
    },
    setShowHistoricOutputs       : function ( to_set ) {
        this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SHOW_OUTPUTS ] = to_set;
    },
    getShowHistoricOutputs       : function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SHOW_OUTPUTS ];
    },
    setCollapseAllHistoricOutputs: function ( to_set ) {
        this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.COLLAPSE_ALL_OUTPUT ] = to_set;
    },
    getCollapseAllHistoricOutputs: function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.COLLAPSE_ALL_OUTPUT ];
    },
    getSizeSlaColumn             : function () {
        return this.getPrefs()[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SIZE_SLA_COLUMNN ];
    },
    getDataToSave                : function () {
        var toReturn                                          = {};
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.UUID ]           = this[ SHINKEN.ELEMENT.USER.PARAM.UUID ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ]      = this[ SHINKEN.ELEMENT.USER.PARAM.USER_NAME ] || localStorageService.get( 'shinken-ui-user' );
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.VERSION ]        = this[ SHINKEN.ELEMENT.USER.PARAM.VERSION ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.VERSION_FULL ]   = APP_INFO.VERSION_FULL;
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ]     = this.getPrefs().getDataToSave();
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.STATUS ]         = this[ SHINKEN.ELEMENT.USER.PARAM.STATUS ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.UI ]             = this[ SHINKEN.ELEMENT.USER.PARAM.UI ];
        toReturn[ SHINKEN.ELEMENT.USER.PARAM.SETTINGS.FIELD ] = this.getSettings();
        delete toReturn[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ][ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.SIZE_SLA_COLUMNN ];
        return toReturn;
    },
    getLabel: function ( default_label_if_no_name ) {
        if ( !this.getName() ) {
            if ( default_label_if_no_name ) {
                return "<div class='shinken-label'>" + default_label_if_no_name + "</div>";
            }
            return "";
        }
        var _class     = this[ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] ? "shinken-label" : "shinken-label shinken-user-removed";
        var _user_name = SHINKEN.TOOLS.STRING.cleanXss( this.getName() );
        var _attribute = this[ SHINKEN.ELEMENT.USER.PARAM.EXISTS ] ? "" : 'onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="' + _( 'users.errors.user_doesnt_exist', [DICTIONARY_COMMON_UI] ) + '"';
        return '<div class="' + _class + '" ' + _attribute + '>' + _user_name + '</div>';
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUser, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.ELEMENT.UiUsers = function () {
    this.init();
};
SHINKEN.ELEMENT.UiUsers.prototype = {
    init: function () {
        this.initContents();
    },
    getDataForSelector: function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return.push( this.getContent( i ).getDataForSelector() );
        }
        return _to_return;
    },
    getUserByName     : function ( name ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( this.getContent( i ).getName() === name ) {
                return this.getContent( i );
            }
        }
        return null;
    },
    exists         : function ( name_to_find ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( this.getContent( i ).getName() === name_to_find ) {
                return true;
            }
        }
        return false;
    },
    existsPartially: function ( name_to_find ) {
        if ( !name_to_find ) {
            return true;
        }
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.STRING.contains( this.getContent( i ).getName(), name_to_find ) ) {
                return true;
            }
        }
        return false;
    },
    getDataFromBackend: function ( parent_object ) {
        var self     = this;
        var _success = function ( _status, data ) {
            switch ( _status ) {
                case COMMUNICATION.CODE.SUCCESS:
                    for ( var i = 0, _size_i = data[ "output" ][ "users" ].length; i < _size_i; i++ ) {
                        self.add( new SHINKEN.ELEMENT.UiUser( data[ "output" ][ "users" ][ i ] ) );
                    }
                    parent_object.doActionAfterCall( "SHINKEN.ELEMENT.UiUsers.getDataFromBackend" );
                    break;
            }
        };
        var _error   = function ( _status, data ) {
        };
        SHINKEN.COMUNICATION.requestGet( SHINKEN.COMUNICATION.CONST.QUERY.GET.USERS.KEY, _success, _error, null );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUsers, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.OBJECT.View           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.View.prototype = {
    init      : function ( data ) {
        this.shares_uuid                              = [];
        this[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = 0;
        this[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = 0;
        if ( data ) {
            this.updateData( data );
        }
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.PARAM.NAME:
                this.setName( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.UUID:
                this.setUUID( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS._KEY:
                this.updateUsers( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.EXTERNAL_LINKS:
                this.setExternalLinks( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.NOTIFICATIONS:
            case SHINKEN.OBJECT.VIEW.PARAM.TYPE:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS:
                this [ key ] = value;
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.VIEW]", "[IGNORED DATA]", key, value );
                break;
        }
    },
    updateUsers: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.addUserInfo( _currentKey, data[ _currentKey ] );
        }
    },
    addUserInfo: function ( key, value ) {
        
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.OWNER:
                this.setOwner( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.PREVIOUS_OWNER:
                this.setPreviousOwner( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.CREATOR:
                this.setCreator( value );
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.VIEW]", "[IGNORED USER DATA]", key, value );
                break;
        }
    },
    setName            : function ( to_set ) {
        this[ SHINKEN.OBJECT.VIEW.PARAM.NAME ] = to_set;
    },
    setUUID            : function ( to_set ) {
        this[ SHINKEN.OBJECT.VIEW.PARAM.UUID ] = to_set;
    },
    getUUID            : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.UUID ];
    },
    getScreenType      : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.TYPE ];
    },
    getName            : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NAME ];
    },
    getShareNumber     : function () {
        return 0;
    },
    getNumberOfErrors  : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ];
    },
    getNumberOfWarnings: function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ];
    },
    getOwner           : function () {
        return this.owner_user;
    },
    getProblems        : function () {
        var _problems                                      = {};
        _problems[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = this.getNumberOfErrors();
        _problems[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = this.getNumberOfWarnings();
        return _problems;
    },
    setOwner           : function ( value ) {
        this.owner_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    getPreviousOwner   : function () {
        return this.previous_owner_user;
    },
    setPreviousOwner   : function ( value ) {
        this.previous_owner_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    getCreator         : function () {
        return this.creator_user;
    },
    setCreator         : function ( value ) {
        this.creator_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    setExternalLinks   : function ( value ) {
        this.external_links = new WEATHER.ExternalLinks( value );
    },
    getNotifications         : function () {
        return this.notifications;
    },
    setNotifications         : function ( value ) {
        this.notifications = new WEATHER.Notifications( value );
    },
};
SHINKEN.OBJECT.Views           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.Views.prototype = {
    init: function ( data ) {
        this.initContents();
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.add( new SHINKEN.OBJECT.View( data[ i ] ) );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Views, SHINKEN.OBJECT.ShinkenObjectContainer );
PROPERTY.RadioListGeneric           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.RadioListGeneric.prototype = {
    init: function ( dom_element ) {
        this.initDomElement( dom_element );
        this.state                = null;
        this.component_radio_list = new COMPONENT.RadioListGeneric( dom_element, this );
    },
    ___clickOnRadioBtn: function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this._computeState();
        this.updateView();
    },
    doActionAfter: function ( event_name, param ) {
        
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                break;
            case "value_changed":
                this.component_radio_list.doActionAfter( event_name, param );
                break;
        }
    },
    ___unset        : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser: function ( value ) {
        if ( !value ) {
            value = PROPERTY.CONST.COMMON.VALUE.DEFAULT;
        }
        this.clickOnRadioBtn( null, value );
    },
    setDefaultValue : function ( to_set ) {
        this.component_radio_list.setDefaultValue( to_set );
    },
    _computeState: function () {
    },
    getValue          : function () {
        return this.component_radio_list.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListGeneric, PROPERTY.InterfaceCommon );
PROPERTY.RangeGeneric           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.RangeGeneric.prototype = {
    init: function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input_range         = new COMPONENT.InputRange( dom_element, this );
        this.component_btn_default         = new COMPONENT.Generic( dom_element.querySelector( ".shinken-input-range-radio-element" ) );
        this.component_label_default_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-notification-sound-default-value" ) );
        this.number_digit_after_comma      = 0;
    },
    doActionAfter            : function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                this.component_label_default_input.updateLabel( this.component_btn_default.getValue() + this.component_input_range.getUnit() );
                break;
            case "value_changed":
                this.component_input_range.doActionAfter( event_name, param );
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case "use_default_value":
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    onMoveRangeCursor        : function ( value_to_set, is_default ) {
        if ( this.is_disabled ) {
            return;
        }
        value_to_set = SHINKEN.TOOLS.NUMBER.roundTo( value_to_set, this.number_digit_after_comma );
        this.component_input_range.setValueFromUser( value_to_set );
        this.changeDefaultButtonStatus( is_default ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
    },
    ___clickOnRadioBtn       : function ( value ) {
        var _value_to_set = this.default_value;
        this.component_input_range.setValue( _value_to_set );
    },
    changeDefaultButtonStatus: function ( value ) {
        this.component_btn_default.setState( value );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', value );
        if ( this.component_btn_default.isOn() ) {
            this.component_input_range.setValueFromUser( this.component_btn_default.getValue() );
        }
    },
    setDefaultValue          : function ( to_set ) {
        this.component_input_range.setDefaultValue( to_set );
        this.component_btn_default.setValue( to_set );
    },
    ___unset                 : function () {
        this.setValueFromUser( "" );
    },
    setValueFromUser         : function ( value ) {
        var is_default = false;
        if ( value === PROPERTY.CONST.COMMON.VALUE.DEFAULT || value === undefined ) {
            value      = this.component_btn_default.getValue();
            is_default = true;
        }
        this.onMoveRangeCursor( parseFloat( value ), is_default );
    },
    getValue: function () {
        return this.component_input_range.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RangeGeneric, PROPERTY.InterfaceCommon );
CONTROLLER.Help = (function ( self ) {
    "use strict";
    self._dom_element_help = null;
    self.toggleHelp        = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        if ( !self._dom_element_help ) {
            self._dom_element_help = document.getElementById( 'id-shinken-help-pop-up' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            return;
        }
        self._dom_element_help.classList.toggle( 'shinken-hidden' );
    };
    self.closeHelp         = function () {
        if ( !self._dom_element_help ) {
            return;
        }
        self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    return self;
})( CONTROLLER.Help || {} );
MANAGER.HelpGenerator = (function ( self ) {
    "use strict";
    self.content                   = [];
    self.size                      = 0;
    self.init                              = function (type_trad) {
        self.type_trad = type_trad;
        self.initContent();
        if ( !self.size ) {
            return;
        }
        self.buildButtonHtml();
        self.buildContentHtml();
        self.initEventListener();
    };
    self.initContent               = function () {
        var _found = document.querySelectorAll( ".shinken-help-container .shinken-help-content" );
        for ( var i = 0, _size_i = _found.length; i < _size_i; i++ ) {
            self.content.push( new OBJECT.Help( _found[ i ] ) );
            DOM.Service.removeElement( _found[ i ] );
        }
        self.size    = self.content.length;
        self.content = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( self.content, [ "order_tab", "name_tab", "order" ] );
    };
    self.initEventListener         = function () {
        document.addEventListener( 'keydown', function ( event ) {
            MANAGER.EventManager.keydown( event );
        } );
    };
    self.buildButtonHtml           = function () {
        var _button_f1       = DOM.Service.createElement( 'div', { class: "shinken-help-button-container", onclick: "CONTROLLER.Help.toggleHelp(event)", 'data-name': "toggle_help" } );
        _button_f1.innerHTML = '<button class="shinken-button"><table><tr><td><span class="key">F1</span></td><td>' + _( 'common.help.label', self.type_trad ) + '</td></tr></table></button>';
        document.body.appendChild( _button_f1 );
    };
    self.buildContentHtml          = function (class_to_add) {
        var _content_to_html  = DOM.Service.createElement( 'div', {
            id     : "id-shinken-help-pop-up",
            class  : "shinken-hidden " + class_to_add,
            onclick: "MANAGER.EventManager.stopPropagation(event)"
        } );
        var _container_html   = DOM.Service.createElement( 'div', { class: "shinken-help-container" } );
        var _container_html_2 = DOM.Service.createElement( 'div', { class: "shinken-help-container-2" } );
        var _container_html_3 = DOM.Service.createElement( 'div', { class: "shinken-help-container-3" },
            "<div class='shinken-text-centred'><div class='shinken-help-title'>" + _( 'common.help.label', self.type_trad ) + "</div></div>" );
        var _current_tab;
        var _current_tab_name = "";
        for ( var i = 0, _size_i = self.size; i < _size_i; i++ ) {
            if ( _current_tab_name !== self.content[ i ].tab ) {
                _current_tab_name = self.content[ i ].tab;
                _current_tab      = WINDOW.ElementService.getWindowTargetHtml( 'div', _current_tab_name, !i );
                _container_html_3.appendChild( _current_tab );
            }
            _current_tab.appendChild( self.content[ i ].getHtml() );
        }
        _content_to_html.appendChild( _container_html );
        _container_html.appendChild( _container_html_2 );
        _container_html_2.appendChild( self.buildWindowsLineHtml() );
        _container_html_2.appendChild( _container_html_3 );
        document.body.appendChild( _content_to_html );
        document.body.appendChild( _content_to_html );
    };
    self.buildWindowsLineHtml      = function () {
        var _to_return = DOM.Service.createElement( 'div', {
            class      : "shinken-help-windows-title-menu shinken-window-group",
            "data-name": "help-group",
            onclick    : "MANAGER.EventManager.clickOnWindowNavigation(event,'help-group')"
        } );
        var _tab_list  = SHINKEN.TOOLS.ARRAY.extractKeys( this.content, [ 'tab', 'name_tab' ], true, true );
        _tab_list      = SHINKEN.TOOLS.ARRAY.removeDuplicateArray( _tab_list );
        _tab_list      = self.concatDuplicationWindowID( _tab_list );
        var _current;
        for ( var i = 0, _size_i = _tab_list.length; i < _size_i; i++ ) {
            _current = _tab_list[ i ];
            _to_return.appendChild( WINDOW.ElementService.getWindowHtml( "div", _current[ 0 ], _current[ 1 ], "help-group", !i ) );
        }
        var _button_close = DOM.Service.createElement( 'div', { class: "shinken-help-close-button shinkon-times-bold", onclick: "CONTROLLER.Help.toggleHelp(event)" } );
        _to_return.appendChild( _button_close );
        return _to_return;
    };
    self.concatDuplicationWindowID = function ( tab_list ) {
        var _to_return = [];
        var _mapping   = {};
        var _current;
        var _index;
        for ( var i = 0, _size_i = tab_list.length; i < _size_i; i++ ) {
            _current = tab_list[ i ];
            if ( _mapping[ _current[ 0 ] ] ) {
                _index                    = _mapping[ _current[ 0 ] ] - 1;
                _to_return[ _index ][ 1 ] = _to_return[ _index ][ 1 ] + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + _current[ 1 ];
            }
            else {
                _mapping[ _current[ 0 ] ] = _to_return.push( _current );
            }
        }
        return _to_return;
    };
    return self;
})( MANAGER.HelpGenerator || {} );
OBJECT.Help = function ( dom_element ) {
    this.dom_element = dom_element;
    this.tab         = dom_element.dataset.tab;
    this.order       = parseInt( dom_element.dataset.order ) || 1;
    this.order_tab   = parseInt( dom_element.dataset.tabOrder ) || 1;
    this.name_tab    = dom_element.dataset.tabName || "??";
};
OBJECT.Help.prototype = {
    getHtml: function () {
        return this.dom_element;
    }
};
SHINKEN.TOOLS.IFRAME = (function ( self ) {
    "use strict";
    self.getIframeJs            = function ( element_css_selector ) {
        var iframe = document.querySelector( element_css_selector );
    
        if ( !iframe ) {
            return;
        }
    
        return iframe.contentWindow || iframe;
    };
    self.doActionAfter            = function ( element_css_selector, event_name, param ) {
        var iframe = self.getIframeJs(element_css_selector);
        try {
            iframe.EXTERNAL.COMMUNICATION.doAction( event_name, param );
        }
        catch ( e ) {
        }
    };
    return self;
})( SHINKEN.TOOLS.IFRAME || {} );
SHINKEN.TOOLS.NOTIFICATION = {};
SHINKEN.TOOLS.NOTIFICATION = (function ( self ) {
    "use strict";
    
    var __instance_notification_container = new SHINKEN.OBJECT.NOTIFICATION.Container();
    
    
    
    self.cleanAllNotification   = function () {
        __instance_notification_container.cleanAllNotification();
    };
    self.addNotification        = function ( message, status, element_to_bind_with, notification_placement, time_before_remove, skip_close ) {
        __instance_notification_container.init();
        __instance_notification_container.addNotification( message, status, element_to_bind_with, notification_placement, time_before_remove, skip_close );
    };
    self.addNotificationStyled  = function ( message, status, styles, time_before_remove ) {
        __instance_notification_container.init();
        __instance_notification_container.addNotificationStyled( message, status, styles, time_before_remove );
    };
    self.addNotificationForSave = function ( message, status ) {
        __instance_notification_container.init();
        __instance_notification_container.addNotificationStyled(
            message,
            status,
            {
                top            : '172px',
                right          : '10px',
                padding        : '2px 5px 2px 5px',
                'border-radius': '3px'
            },
            2500 );
    };
    return self;
})( SHINKEN.TOOLS.NOTIFICATION || {} );
var SHINKEN_GRID   = {};
SHINKEN_GRID.CONST = {
    PARAM        : {
        GRID     : {
            SHINKEN_GRID_UUID              : "shinken_grid_uuid",
            TYPE                           : "type",
            GRID_ELEMENTS                  : "grid_elements",
            ORDERING                       : "ordering",
            TILES_MAX_X                    : "nb_tiles_in_width",
            TILES_MAX_Y                    : "nb_tiles_in_height",
            SEPARATION_GRID_ELEMENT_MIN    : "separation_grid_element_min",
            SEPARATION_GRID_ELEMENT_MAX    : "separation_grid_element_max",
            SEPARATION_GRID_ELEMENT_PERCENT: "separation_grid_element_percent"
        },
        GRID_CELL: {
            POSITION_X            : "position_x",
            POSITION_Y            : "position_y",
            HEIGHT                : "height",
            WIDTH                 : "width",
            CONTENT               : "content"
        }
    },
    SPECIAL_VALUE: {
        SEPARATION_GRID_ELEMENT_MAX_UNLIMITED: "unlimited",
        ALL: "all"
    }
};
SHINKEN_GRID.Cell           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cell.prototype = {
    init: function ( data ) {
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.initInternal();
        this.initPhase();
        this.class = "shinken-grid-cell shinken-draggable";
        this.updateData( data );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
    },
    onScroll: function ( event, shinken_grid ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) && shinken_grid.isInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.EDITING] ) ) {
            this.computeHtml( shinken_grid );
        }
    },
    getUUID       : function () {
        return this.uuid;
    },
    getContentUUID: function () {
        if ( this.content ) {
            return this.content.getUUID();
        }
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty"]
        ] );
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    },
    
    isVisible            : function () {
        var _box      = this.getDisplayBox();
        var _dom      = this.getDomScrollingParent();
        var _rect     = DOM.Service.getBoundingClientRect( _dom );
        var _box_cell = { top: _box.top + _rect.top, bottom: _box.top + _rect.top };
        var _box_grid = { top: _rect.top + _dom.scrollTop, bottom: _rect.bottom + _dom.scrollTop };
        return DOM.Service.isVisibleIntoScrollingVerticalParent_Box( _box_cell, _box_grid );
    },
    getDomScrollingParent: function () {
    },
    computeMapping: function ( mapping ) {
        if ( this.content && this.content.computeMapping ) {
            this.content.computeMapping( mapping );
        }
    },
    computeSizes  : function ( shinken_grid ) {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.READY:
                this.computeHtml( shinken_grid );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.updateSize( shinken_grid );
                break;
        }
    },
    updateSize    : function ( shinken_grid ) {
        if ( shinken_grid ) {
            this.tile_pixel_size = shinken_grid.tile_pixel_size;
            this.font_size       = shinken_grid.font_size;
        }
        
        DOM.Service.setStyles( this.dom_element, this.getStyle() );
        this.dom_element.className = this.getClass();
        this._updateSize();
        if ( this.content ) {
            this.content.updateSize();
        }
        this.dom_element.classList.remove( "shinken-no-opacity" );
    },
    _updateSize   : function () {
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        if ( this.content ) {
            _to_return = this.content.computeContentWithChange();
        }
        return _to_return;
    },
    
    
    
    computeHtml         : function ( shinken_grid ) {
        if ( this.dom_element ) {
            return;
        }
        if ( !__has_edit_mode__ && this.hasIssues() ) {
            return;
        }
        
        this.tile_pixel_size = shinken_grid.tile_pixel_size;
        this.font_size       = shinken_grid.font_size;
        
        this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X );
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN );
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX );
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT );
        
        if ( !this.confirmDoComputeHtml( shinken_grid ) ) {
            return;
        }
        if ( !this.isVisible( shinken_grid ) ) {
            return;
        }
        this.dom_element = DOM.Service.createElement( "div", this.getAttribute() );
        
        this.content_container        = DOM.Service.createElement( "div", { class: 'shinken-grid-cell-container shinken-height-100' } );
        var _widget_container_wrapped = this.wrapHtmlContainer( this.content_container );
        DOM.Service.addElementTo( _widget_container_wrapped, this.dom_element );
        DOM.Service.addElementTo( this.dom_element, shinken_grid.dom_element );
        if ( this.content ) {
            this.content.setDomElementParent( this.content_container );
            this.content.computeHtml( this.tile_pixel_size * this.getComputedWidth(), this.tile_pixel_size * this.height );
        }
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    wrapHtmlContainer   : function ( container ) {
        return container;
    },
    confirmDoComputeHtml: function () {
        return true;
    },
    getAttribute        : function () {
        var _to_return = {
            class: this.getClass(),
            style: DOM.Service.styleToHtml( this.getStyle() )
        };
        this.getUserInteraction( _to_return );
        return _to_return;
    },
    getUserInteraction  : function ( attributes ) {
        attributes[ "onclick" ] = "MANAGER.EventManager.clickOnButton(event, 'focus-on-shinken-cell-grid-from-cell', '" + this.getUUID() + "')";
    },
    getClass            : function () {
        return this.class + " shinken-no-opacity";
    },
    getComputedWidth    : function () {
        return this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) === WEATHER.CONST.WIDTH_ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] : this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH );
    },
    getStyle            : function () {
        var _to_return = this.getDisplayBox();
        var _padding   = parseInt( DOM.BodyService.getWidth() * this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] / 100 );
        if ( !_to_return[ DOM.CONST.STYLE.WIDTH ] || !_to_return[ DOM.CONST.STYLE.HEIGHT ] ) {
            _padding = 0;
        }
        else {
            if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED ) {
                _padding = Math.min( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] );
            }
            _padding = Math.max( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ] );
            
        }
        _to_return[ DOM.CONST.STYLE.PADDING ] = _padding / 2;
        return _to_return;
    },
    getDisplayBox       : function () {
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size * this.getComputedWidth();
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
        _to_return[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X );
        return _to_return;
    },
    
    callbackForPhase: function () {
        if ( this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) ) {
            this.updateSize();
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.InterfaceHtml );
SHINKEN_GRID.Cells           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cells.prototype = {
    init: function ( data ) {
        this.initContents();
        if ( data ) {
            this.initData( data );
        }
    },
    onScroll: function ( event, shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).onScroll( event, shinken_grid );
        }
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    getMaxTileInHeight: function () {
        var _box_content;
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return = Math.max(this.getContent(i).getValue(SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y)+this.getContent(i).getValue(SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT), _to_return);
        }
        return _to_return;
    },
    computeSizes: function ( shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes( shinken_grid );
        }
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return += this.getContent( i ).computeContentWithChange();
        }
        return _to_return;
    },
    
    computeHtml: function ( shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            DOM.Service.addElementTo( this.getContent( i ).computeHtml( shinken_grid ) );
        }
    },
    setListContent: function ( list_content ) {
        for ( var i = 0, _size_i = list_content.length; i < _size_i; i++ ) {
            this.addCell( list_content[ i ], i );
        }
    },
    addCell       : function ( data, index ) {
        var _to_return = new SHINKEN_GRID.Cell( data );
        this.add( _to_return );
        return _to_return;
    },
    doActionAfter : function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-shinken-cell-grid":
                var _cell = this.getContentByUUID( param );
                if ( !_cell || _cell.isVisible() ) {
                    return;
                }
                var _box                            = _cell.getDisplayBox();
                this.dom_scrolling_parent.scrollTop = _box[ DOM.CONST.STYLE.TOP ];
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN_GRID.Grid           = function ( data ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( data );
};
SHINKEN_GRID.Grid.prototype = {
    init: function ( data ) {
        this.initInternal();
        this.initPhase();
        this.tile_pixel_size = 0;
        this.updateData( data );
        if ( data ) {
            this.max_nb_tiles = this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].getMaxTileInHeight();
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
        }
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [ SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED, this.getDefaultValueLabel() ] ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT, SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE ],
            [ SHINKEN_GRID.CONST.PARAM.GRID.TYPE, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, [ "grid" ], true ]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS, "SHINKEN_GRID.Cells" ]
        ] );
    },
    onMouseMove : function ( event ) {
    },
    onMouseLeave: function ( event ) {
    },
    onScroll    : function ( event ) {
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].onScroll( event, this );
    },
    mouseWheel  : function ( event ) {
    },
    computeMapping : function ( mapping ) {
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] instanceof SHINKEN_GRID.Cells ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeMapping( mapping );
        }
    },
    computeSizes   : function () {
        this.computeTileSize();
        this._computeSizes();
        this.updateStyle();
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeSizes( this );
    },
    computeTileSize: function () {
        this.tile_pixel_size = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X );
    },
    _computeSizes  : function () {
        this.computeFontSize();
    },
    computeContentWithChange: function () {
        return this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeContentWithChange();
    },
    
    initDomElementHtml: function ( dom_parent ) {
        this.dom_element = DOM.Service.createElement( "div", { id: "id-shinken-" + this.uuid, class: "shinken-grid", style: "font-size:" + this.font_size + "px;" } );
    },
    computeHtml       : function () {
        this.initDomElementHtml();
        DOM.Service.addElementTo( this.dom_element, this.dom_element_parent_for_compute );
        DOM.Service.setDataSet( this.dom_element, 'gridUuid', this.uuid );
        
        this.computeTileSize();
        this._computeSizes();
        this.updateStyle();
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].computeHtml( this );
    },
    updateStyle       : function ( force_hidden ) {
        DOM.Service.setStyles( this.dom_element, this.getComputedStyle() );
    },
    getComputedStyle  : function () {
        var _nb_tiles                           = this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ? this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ) : this.max_nb_tiles;
        var _to_return                          = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ]    = this.tile_pixel_size * _nb_tiles;
        _to_return[ DOM.CONST.STYLE.FONT_SIZE ] = this.font_size;
        return _to_return;
    },
    computeFontSize   : function () {
        this.font_size = parseInt( DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / 85.7 );
    },
    updateContentData: function ( data ) {
        this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].updateContentData( data );
    },
    doActionAfter    : function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-shinken-cell-grid":
            case "focus-on-shinken-cell-grid-from-cell":
                this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].doActionAfter( event_name, param );
                break;
        }
    },
    callbackForPhase: function () {
        if ( this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) ) {
            this.computeHtml();
        }
        else if ( this.getCurrentPhase() != this.getPreviousPhase() ) {
            this.updateStyle();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.PhaseInterface );
SHINKEN_GRID.Grids           = function () {
};
SHINKEN_GRID.Grids.prototype = {
    init: function ( data ) {
        this.initContents();
        if ( data ) {
            this._initGrid( data );
        }
    },
    onMouseMove : function ( event ) {
    },
    onMouseLeave: function ( event ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).onMouseLeave( event );
        }
    },
    onScroll    : function ( event ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).onScroll( event );
        }
    },
    mouseWheel  : function ( event ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).mouseWheel( event );
        }
    },
    hasGrid              : function () {
        return this.getSize() > 0;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    getGridByUUID        : function ( grid_uuid ) {
        return this.getContentByUUID(grid_uuid);
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    setPhaseForAllGrids: function ( to_set, dom_element_parent ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            if ( dom_element_parent ){
                DOM.Service.addElementTo( this.getDomElement(), dom_element_parent );
                this.getContent(i).dom_element_parent_for_compute = this.getDomElement();
            }
            this.getContent(i).setPhase( to_set );
        }
    },
    _computeMapping: function () {
        this.mapping_uuid_content = {};
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeMapping( this.mapping_uuid_content );
        }
    },
    computeSizes   : function () {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes();
        }
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return += this.getContent( i ).computeContentWithChange();
        }
        return _to_return;
    },
    
    getDomElement: function ( dom_parent ) {
        if ( !this.dom_element ){
            this.dom_element = DOM.Service.createElement( "div", { class: "shinken-grids" } );
        }
        return this.dom_element
    },
    reset            : function () {
        this.initContents();
        DOM.Service.removeElement( this.getDomElement() );
    },
    _initGrid        : function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.add( new SHINKEN_GRID.Grid( data[ i ] ) );
        }
    },
    updateContentData: function ( data ) {
        for ( var i = 0, _size = this.getSize(); i < _size; i++ ) {
            this.getContent( i ).updateContentData( data )
        }
    },
    doActionAfter              : function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-shinken-cell-grid":
            case "focus-on-shinken-cell-grid-from-cell":
                for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[i].doActionAfter(event_name, param)
                }
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN_VALIDATION.Parameters           = function ( parameters ) {
    this.content = [];
    if ( parameters ) {
        this.init( parameters );
    }
};
SHINKEN_VALIDATION.Parameters.prototype = {
    init        : function ( parameters ) {
        for ( var i = 0, _size_i = parameters.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN_VALIDATION.Parameter( parameters[ i ] ) );
        }
    },
    getParameter: function ( key ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            if ( this.content[ i ].key === key ) {
                return this.content[ i ];
            }
        }
        return null;
    },
    getKeys     : function () {
        return SHINKEN.TOOLS.ARRAY.extractKey( this.content, 'key' );
    },
    getContent  : function () {
        return this.content;
    }
};
SHINKEN_VALIDATION.Parameter           = function ( args ) {
    this.key              = args[ 0 ];
    this.validation_type  = args[ 1 ];
    this.validation_value = args[ 2 ];
    this.is_mandatory     = args[ 3 ];
};
SHINKEN_VALIDATION.Parameter.prototype = {};
SHINKEN_VALIDATION.Service = (function ( self ) {
    "use strict";
    self.isValid            = function ( value, validation_parameter ) {
        if ( value === "default" && !validation_parameter.is_mandatory ) {
            return true;
        }
        return _isValid( value, validation_parameter.validation_type, validation_parameter.validation_value, validation_parameter.is_mandatory );
    };
    self.parseToValidFormat = function ( param_value, validation_parameter ) {
        if ( param_value.getValue() === "default" ) {
            return;
        }
        
        
        _parseToValidFormat( param_value, validation_parameter.validation_type, validation_parameter.is_mandatory );
    };
    var _isValid            = function ( value, validation_type, validation_value, is_mandatory ) {
        if ( is_mandatory && value === "" ) {
            return false;
        }
        switch ( validation_type ) {
            case SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY:
                if ( value ) {
                    if ( typeof value !== "string" ) {
                        return false;
                    }
                    if ( value.match( SHINKEN_VALIDATION.CONST.COLOR.CSS.REGEX ) ) {
                        return false;
                    }
                }
                break;
            case SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN:
                return SHINKEN.TOOLS.ARRAY.contains( validation_value, value );
            case SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE:
                if ( !SHINKEN.TOOLS.NUMBER.isNumber( value ) ) {
                    return false;
                }
                if ( value < 0 ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE:
                if ( !SHINKEN.TOOLS.NUMBER.isInteger( value ) ) {
                    return false;
                }
                if ( value < 0 ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN:
                if ( !SHINKEN.TOOLS.NUMBER.isInteger( value ) ) {
                    return false;
                }
                if ( value < validation_value[ 0 ] ) {
                    return false;
                }
                if ( value > validation_value[ 1 ] ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.STRING.NOT_EMPTY:
                if ( typeof value !== "string" ) {
                    return false;
                }
                if ( value === "" ) {
                    return false;
                }
                break;
            case SHINKEN_VALIDATION.CONST.STRING.DONT_HAVE_FORBIDDEN:
                if ( typeof value !== "string" ) {
                    return false;
                }
                for ( var i = 0, _size_i = validation_value.length; i < _size_i; i++ ) {
                    if ( SHINKEN.TOOLS.STRING.contains( value, validation_value[ i ] ) ) {
                        return false;
                    }
                }
                break;
            case SHINKEN_VALIDATION.CONST.STRING.IS_STRING:
                return typeof value === "string";
            
            case SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE:
                if ( SHINKEN.TOOLS.ARRAY.contains( validation_value, value ) ) {
                    return true;
                }
                return _isValid( value, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE );
            case SHINKEN_VALIDATION.CONST.BOOLEAN._KEY:
                return SHINKEN.TOOLS.BOOLEAN.isBoolean( value );
            case undefined:
            case "":
                break;
            default:
                console.warn( "SHINKEN_VALIDATION.Service [_isValid] UNKNOWN KEY", validation_type );
                break;
        }
        return true;
    };
    var _parseToValidFormat = function ( param_value, validation_type ) {
        var _parsed_value = undefined;
        switch ( validation_type ) {
            case SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE:
                _parsed_value = parseFloat( param_value.getValue() );
                break;
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE:
            case SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_BETWEEN:
                _parsed_value = parseInt( param_value.getValue() );
                break;
            case SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE:
                if ( SHINKEN.TOOLS.NUMBER.isInteger( param_value.getValue() ) ) {
                    _parsed_value = parseInt( param_value.getValue() );
                }
                break;
            case SHINKEN_VALIDATION.CONST.BOOLEAN._KEY:
                if ( SHINKEN.TOOLS.BOOLEAN.isBoolean( param_value.getValue() ) ) {
                    _parsed_value = SHINKEN.TOOLS.BOOLEAN.parseToBoolean( param_value.getValue() );
                }
                break;
        }
        if ( typeof _parsed_value !== 'undefined' && _parsed_value !== param_value.getValue() ) {
            param_value.setValue( _parsed_value );
        }
    };
    return self;
})( SHINKEN_VALIDATION.Service || {} );
SHINKEN.OBJECT.ElementWindowGroupSaveObject           = function () {
    this.saving_progress_bar      = null;
    this.dom_saving_bar_container = null;
    this._controller              = null;
    this.init();
};
SHINKEN.OBJECT.ElementWindowGroupSaveObject.prototype = {
    init: function ( controller ) {
        this._controller = controller;
        this.initCounters();
        this.initPhase();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    clickOnButton   : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-apply-button":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING );
                break;
            case "click-on-cancel-button":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL );
                break;
            case "click-on-validate-confirmation-popup":
                var _current_phase = this.getCurrentPhase();
                switch ( _current_phase ) {
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING:
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SAVING );
                        break;
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.CANCEL );
                        break;
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE:
                        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask-for-pop-up-close-accepted" );
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.CLOSE );
                        break;
                }
                MANAGER.__instance_confirmation_popup.hide();
                break;
            case "click-on-cancel-confirmation-popup":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                MANAGER.__instance_confirmation_popup.hide();
                SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask-for-pop-up-close-refused" );
                break;
        }
    },
    doActionAfter   : function ( event_name ) {
        switch ( event_name ) {
            case "ask-for-pop-up-close-event":
                if ( !this.getCounterUserSet().hasCounter() ) {
                    SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask-for-pop-up-close-accepted" );
                }
                else {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE );
                }
                break;
        }
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE:
                this.doConfirmationPopup();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
                this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.PREPARATION_CALL );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.CANCEL:
                this.getController().cancelUserModification();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.CLOSE:
                break;
            default:
                break;
        }
    },
    getController: function () {
        return this._controller;
    },
    _doActionWhenProgressStart: function ( current_step, param ) {
        switch ( current_step ) {
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.PREPARATION_CALL:
                this.saving_progress_bar.setTitleStep( current_step, _( "progress_bar.saving_in_progress", [DICTIONARY_COMMON_UI] ) );
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.CALL_IN_PROGRESS:
                this._askForSave();
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_ANALYSE:
                this.doTreatment( param );
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END:
                var _current_step = this.saving_progress_bar.getStep( current_step );
                var _message      = _current_step.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK_WITH_WARNING ) ?
                                    _( 'progress_bar.saving_succeed_with_warning', [DICTIONARY_COMMON_UI] ) :
                                    _( "progress_bar.saving_succeed", [DICTIONARY_COMMON_UI] );
                this.saving_progress_bar.setTitleStep( current_step, _message );
                break;
            default:
                break;
        }
    },
    _doActionWhenProgressEnd  : function ( current_step, param ) {
        switch ( current_step ) {
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.PREPARATION_CALL:
                this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.CALL_IN_PROGRESS );
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_TREATMENT:
                switch ( this.saving_progress_bar.getCurrentPhase() ) {
                    case SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK:
                        break;
                }
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END:
                this._doActionWhenSaveEnd();
                break;
        }
    },
    _doActionWhenSaveEnd      : function () {
    },
    doTreatment               : function ( param ) {
    },
    _askForSave               : function () {
    },
    computeHtml                      : function () {
        this.dom_element              = DOM.Service.createElement( "table", { "class": "shinken-window-group-save-table-action-button" } );
        var _tr                       = DOM.Service.createElement( "tr", {} );
        var _td_saving_bar            = DOM.Service.createElement( "td", { "class": "shinken-window-group-save-progress-bar-cell" } );
        var _td_apply                 = DOM.Service.createElement( "td", {} );
        var _td_cancel                = DOM.Service.createElement( "td", {} );
        this.dom_saving_bar_container = DOM.Service.createElement( "div", { "class": "shinken-window-group-save-container-saving-bar" } );
        var _apply_button_container   = DOM.Service.createElement( "div", { "class": "shinken-window-group-save-container-action-button" } );
        var _cancel_button_container  = DOM.Service.createElement( "div", { "class": "shinken-window-group-save-container-action-button" } );
        var _onclick_attribute_apply  = 'MANAGER.EventManager.clickOnButton(event, "click-on-apply-button")';
        var _apply_button             = DOM.Service.createElement( "div", {
            "class"  : "shinken-window-group-save-action-button shinken-window-group-save-apply-button",
            "onclick": _onclick_attribute_apply
        }, _( 'window_group_save.action_button.apply', [DICTIONARY_COMMON_UI] ) );
        var _onclick_attribute_cancel = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-button")';
        var _cancel_button            = DOM.Service.createElement( "div", {
            "class"  : "shinken-window-group-save-action-button shinken-window-group-save-cancel-button",
            "onclick": _onclick_attribute_cancel
        }, _( 'window_group_save.action_button.cancel', [DICTIONARY_COMMON_UI] ) );
        
        DOM.Service.addElementTo( this.dom_saving_bar_container, _td_saving_bar );
        
        DOM.Service.addElementTo( _apply_button, _apply_button_container );
        DOM.Service.addElementTo( _apply_button_container, _td_apply );
        
        DOM.Service.addElementTo( _cancel_button, _cancel_button_container );
        DOM.Service.addElementTo( _cancel_button_container, _td_cancel );
        
        DOM.Service.addElementTo( _td_saving_bar, _tr );
        DOM.Service.addElementTo( _td_apply, _tr );
        DOM.Service.addElementTo( _td_cancel, _tr );
        DOM.Service.addElementTo( _tr, this.dom_element );
        this.getCounterUserSet().addTargetsDomElement( this.dom_element );
        this.saving_progress_bar = new SHINKEN.OBJECT.Progressbar( this, SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END, 500, this.dom_saving_bar_container );
    },
    buildHtmlTitleConfirmationPopup  : function () {
        return "";
    },
    buildHtmlContentConfirmationPopup: function () {
        return DOM.Service.createElement( "div", {} );
    },
    doConfirmationPopup              : function () {
        MANAGER.__instance_confirmation_popup.reset();
        MANAGER.__instance_confirmation_popup.setTitle( this.buildHtmlTitleConfirmationPopup() );
        MANAGER.__instance_confirmation_popup.setContent( this.buildHtmlContentConfirmationPopup() );
        MANAGER.__instance_confirmation_popup.setController( this._controller.controller_name );
        MANAGER.__instance_confirmation_popup.show();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ElementWindowGroupSaveObject, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ElementWindowGroupSaveObject, SHINKEN.OBJECT.ProgressbarInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ElementWindowGroupSaveObject, SHINKEN.OBJECT.CounterInterface );
WINDOW.ElementGroup           = function ( name ) {
    this.name = SHINKEN.TOOLS.STRING.escapeBackslash( name );
    this.list = {};
    this.init();
};
WINDOW.ElementGroup.prototype = {
    init       : function () {
        this.initCounters();
    },
    initWindows: function () {
    },
    getActiveWindow                 : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.list[ _keys[ i ] ].is_active ) {
                return this.list[ _keys[ i ] ];
            }
        }
        return null;
    },
    clickOnWindow                   : function ( window_name ) {
        var _active_window = this.getActiveWindow();
        if ( _active_window && _active_window.getName() === window_name ){
            return;
        }
        var _current_window = this.getWindowByName(window_name);
        if ( _current_window && _current_window.is_disabled ){
            return;
        }
        var _keys = Object.keys( this.list );
        var _current;
        var current_window;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            _current.setActive( _current.getName() === window_name );
            if ( _current.is_active ) {
                current_window = _current;
            }
        }
        if ( current_window.hasProperties() ) {
            MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES, window_name );
        }
        this._doExtraActionAfterClickOnWindow( window_name );
    },
    _doExtraActionAfterClickOnWindow: function ( window_name ) {
    },
    getWindowByName                 : function ( window_name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === window_name ) {
                return _current;
            }
        }
    },
    getElementByID                  : function ( id ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getID() === id ) {
                return _current;
            }
        }
        return null;
    },
    getElementByName                : function ( name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === name ) {
                return _current;
            }
        }
        return null;
    },
    getDomElementTargets            : function () {
        return this.dom_element_targets;
    },
    setParentCounter                : function ( parent ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].setParentCounter( parent );
        }
    },
    setContentDomElementTarget      : function ( window_name, to_set ) {
        var _to_return = this.getWindowByName( window_name );
        this.getWindowByName( window_name ).setContentDomElementTarget( to_set );
        return _to_return;
    },
    hasProblems                     : function ( window_name ) {
        return this.getWindowByName(window_name).hasProblems();
    },
    focusOnFirstWindowWithProblem: function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if (this.list[_keys[i]].hasProblems() ) {
                this.clickOnWindow(this.list[_keys[i]].name);
                return;
            }
        }
    },
    pulsateElementIfNotActive: function ( window_name ) {
        if ( this.getActiveWindow().getName() !== window_name ) {
            DOM.Service.askAddClass( this.getElementByName( window_name ).dom_element, 'shinken-pulsate', 2000 );
        }
    },
    cancelUserModification   : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].cancelUserModification();
        }
    },
    
    getDataToSave: function () {
        var _keys      = Object.keys( this.list );
        var _to_return = [];
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, this.list[ _keys[ i ] ].getDataToSave() );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.ShinkenObjectHtml );
WINDOW.ElementService = (function ( self ) {
    self.getWindowTargetHtml = function ( dom_tag, tab_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-target" : "shinken-window-target shinken-hidden";
        var _to_return    = DOM.Service.createElement( dom_tag, { id: "id-shinken-window-" + tab_name + "-target", class: _class_to_add } );
        return _to_return;
    };
    self.getWindowHtml       = function ( dom_tag, window_id, label, group_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-element shinken-active" : "shinken-window-element";
        var _to_return    = DOM.Service.createElement( dom_tag, {
            class            : _class_to_add,
            "data-group-name": group_name,
            "data-name"      : window_id,
            id               : "id-shinken-window-" + window_id
        }, label );
        return _to_return;
    };
    return self;
})( WINDOW.ElementService || {} );
WINDOW.Element           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.Element';
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init          : function () {
        this.initCounters();
    },
    initDomElement: function () {
    },
    getName       : function () {
        return this.name;
    },
    getID         : function () {
        return this.id;
    },
    setHasRequired: function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setActive     : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    setDisabled     : function ( to_set ) {
        this.is_disabled = to_set;
        DOM.Service.addOrRemoveClasses(this.dom_element, this.is_disabled, "shinken-disabled");
    },
    hasProperties : function () {
        return false;
    },
    setContentDomElementTarget: function ( to_set ) {
        DOM.Service.addElementToAfterEmpty( to_set, this.dom_element_target );
    },
    hasProblems                     : function ( window_name ) {
        return !!(this.hasError() || this.hasWarning());
    },
    updateCounter: function ( name, value ) {
        this.counters[ name ].update( "counter", value );
    },
    getDataToSave: function () {
        return [];
    },
    cancelUserModification: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );
WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.ElementWithProperties';
    
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementWithProperties.prototype = {
    hasProperties: function () {
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );
WINDOW.ElementFromData           = function ( name, parent_name ) {
    this.__class_name__ = 'WINDOW.ElementFromData';
    this.name        = name;
    this.parent_name = parent_name;
    this.init();
};
WINDOW.ElementFromData.prototype = {
    init          : function () {
        this.initCounters();
        this.initId();
        this.initDomElements();
    },
    initId        : function () {
        this.id = "id-shinken-window-" + this.name + this.parent_name;
    },
    initController: function () {
    },
    getController     : function () {
        return "";
    },
    resizeDone        : function () {
        if ( this.getController() ){
            this.getController().resizeDone();
        }
    },
    initDomElements      : function () {
    },
    initDomElement       : function ( _label ) {
        this.dom_element = DOM.Service.createElement( "td", {
            "class"          : "shinken-window-element",
            "id"             : this.id,
            "data-group-name": this.parent_name,
            "data-name"      : this.name
        } );
        DOM.Service.addElementTo( this.computeLabelContainer( _label ), this.dom_element );
    },
    initDomTarget        : function () {
        var _class = "shinken-tab-pane property-tab-pane shinken-prop-table shinken-parent-tab-id-parent";
        if ( !this.is_active ){
            _class += " shinken-hidden";
        }
        this.dom_element_target = DOM.Service.createElement( "div", {
            "class"    : _class,
            "id"       : this.id + "-target",
            "data-name": this.name
        } );
    },
    computeLabelContainer: function ( _label ) {
        return DOM.Service.createElement( "span", { "class": "shinken-window-element-label" }, '<span class="shinken-window-label">' + _label + '</span>' );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementFromData, WINDOW.Element );
WINDOW.ElementGroupFromData           = function () {
    this.list = {};
    this.init();
};
WINDOW.ElementGroupFromData.prototype = {
    init           : function () {
        this.initCounters();
        this.initName();
        this.initWindows();
        MANAGER.__instance_window_distributor.setParentWindow( this.name, this );
    },
    initWindows    : function () {
    },
    initName       : function () {
        this.name = SHINKEN.TOOLS.STRING.buildUUID();
    },
    initControllers: function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].initController();
        }
    },
    resizeDone        : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].resizeDone();
        }
    },
    computeHtml       : function () {
        var _onclick_attribute = 'MANAGER.EventManager.clickOnWindowNavigation(event, "' + this.name + '")';
        var _dom_tr            = DOM.Service.createElement( "tr", {
            "class"    : "shinken-window-group",
            "data-name": this.name,
            "onclick"  : _onclick_attribute
        } );
        var _keys              = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            DOM.Service.addElementTo( this.list[ _keys[ i ] ].dom_element, _dom_tr );
        }
        this.dom_element = DOM.Service.createElement( "table", { "class": this.getMainClass() } );
        DOM.Service.addElementTo( _dom_tr, this.dom_element );
        this.computeHtmlTargets();
    },
    computeHtmlTargets: function ( dom_parent ) {
        this.dom_element_targets = DOM.Service.createElement( "div", {
            "class": "shinken-window-targets"
        } );
        var _keys                = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            DOM.Service.addElementTo( this.list[ _keys[ i ] ].dom_element_target, this.getDomElementTargets() );
        }
    },
    getMainClass       : function () {
        return "shinken-window-element-table shinken-table";
    },
    onClick: function ( event ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].onClick( event );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromData, WINDOW.ElementGroup );
WINDOW.ElementFromHtml           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.ElementFromHtml';
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementFromHtml.prototype = {
    init          : function () {
        this.initDomElement();
        if ( this.is_menu ) {
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters             = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current                                      = _dom_element_counters[ i ];
                this.counters[ _current.dataset.counterType ] = new SHINKEN.OBJECT.Counter();
                this.counters[ _current.dataset.counterType ].init( _current );
            }
        }
        else {
            this.initCounters();
        }
    },
    initDomElement: function () {
        this.id = this.dom_element.getAttribute( 'id' );
        if ( this.is_menu ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.is_active = true;
        }
        this.dom_element_target = document.getElementById( this.id + '-target' );
        if ( !this.dom_element_target ) {
            console.warn( "[LA STRUCTURE HTML des windows n'est pas correcte]", this.id, this.id + '-target  ==> not found' );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementFromHtml, WINDOW.Element );
WINDOW.ElementGroupFromHtml           = function ( name ) {
    this.name = name;
    this.list = {};
    this.init();
};
WINDOW.ElementGroupFromHtml.prototype = {
    init                     : function () {
        this.dom_element = document.querySelector( '.' + WINDOW.CONST.CLASS.WINDOW_GROUP + '[data-name="' + this.name + '"]' );
        this.initWindows();
    },
    initWindows              : function () {
        var _dom_elements = this.dom_element.querySelectorAll( '.' + WINDOW.CONST.CLASS.WINDOW_TAB + '[data-group-name="' + this.name + '"]' );
        this.size         = _dom_elements.length;
        var _current;
        var _current_name;
        var _has_properties;
        for ( var i = 0; i < this.size; i++ ) {
            _current                   = _dom_elements[ i ];
            _current_name              = _current.dataset.name;
            _has_properties            = _current.dataset.hasProperties;
            this.list[ _current_name ] = _has_properties ? new WINDOW.ElementWithProperties( _current_name, _current ) : new WINDOW.Element( _current_name, _current );
            MANAGER.__instance_object_distributor.addObject( this.list[ _current_name ].getID(), this.list[ _current_name ] );
        }
    },
    computeHtml: function () {
    
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroupFromHtml, WINDOW.ElementGroup );
