SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_FORM = (function ( self ) {
    self.DOM                      = {};
    self.ACTION                   = {};
    self.TEST                     = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getButtonNext        = function () {
        return document.getElementById( "id-shinken-btn-step3-next" );
    };
    self.getCounterUSerButtonNext = function () {
        return self.DOM.getButtonNext().querySelector( ".shinken-counter.shinken-user-set-counter" );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.numberActionStep3   = function ( timeout, number_action_valid ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT.TEST.numberOfPropertyToSave( 0, number_action_valid + 1 );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, self.DOM.getCounterUSerButtonNext(), number_action_valid );
        }, timeout );
        return 10;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_FORM || {} );

SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE             = (function ( self ) {
    self.DOM                                      = {};
    self.ACTION                                   = {};
    self.TEST                                     = {};
    //********************************************  DOM ELEMENT   **************************************************//
    self.DOM.getSelectorAction                    = function ( property_name, selector_only ) {
        var _to_return = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( '.shinken-select-container[data-name="mass_change_action"]' );
        if ( selector_only ) {
            _to_return = _to_return.querySelector( '.shinken-select-selector' );
        }
        return _to_return;
    };
    self.DOM.getLabelContainer                    = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( '.mass-change-default-label-cell' );
    };
    self.DOM.getNextButton                        = function ( step ) {
        return document.getElementById( "id-shinken-btn-step" + step + "-next" );
    };
    self.DOM.getPreviousButton                    = function ( step ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step' + step + ' .shinken-button-container[data-name="return"]' );
    };
    self.DOM.getStep2SelectAllButton              = function () {
        return document.querySelector( '#id-shinken-mass-change-list .shinken-all-elements-check-box[data-name="shinken-all-elements"] .shinken-checkbox-container' );
    };
    self.DOM.getStep2getProperty                  = function ( property_name ) {
        return document.querySelector( ".shinken-element-property-line[data-name=\"" + property_name + "\"]" );
    };
    self.DOM.getStep2SelectPropertySpecificOption = function ( property_name, option_to_get ) {
        return self.DOM.getStep2getProperty( property_name ).querySelector( ".shinken-option[data-key-name=\"" + option_to_get + "\"]" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.selectAndGoStep1                  = function ( timeout ) {
        timeout += SHINKEN.TOOLS.TEST_AUTO_LIST_ALL.ACTION.selectShinkenElement( timeout );
        timeout += SHINKEN.TOOLS.TEST_AUTO_LIST_ALL.ACTION.selectMassAction( timeout, ACTIONS.MASSIVE_CHANGE );
        timeout += SHINKEN.TOOLS.TEST_AUTO_LIST_ALL.ACTION.clickOnExecuteMassAction( timeout, true );
        return timeout;
    };
    self.ACTION.clickOnModificationType           = function ( timeout, type_modification ) {
        setTimeout( function () {
            document.querySelector( ".shinken-cell-radio-button[data-name='" + type_modification + "']" ).click();
        }, timeout );
        return 100;
    };
    self.ACTION.clickOnNextButton                 = function ( timeout, step ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnNextButton', step );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getNextButton( step ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnPreviousButton             = function ( timeout, step ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnPreviousButton', step );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getPreviousButton( step ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.step1ToStep2                      = function ( timeout, type_modification ) {
        var _to_return = 50;
        _to_return += SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.ACTION.clickOnModificationType( timeout + _to_return, type_modification );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.ACTION.clickOnNextButton( timeout + _to_return, 1 );
        return _to_return;
    };
    self.ACTION.clickOnSelectAllStep2             = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getStep2SelectAllButton() );
        }, timeout );
        return 100;
    };
    self.ACTION.step2ToStep3                      = function ( timeout ) {
        var _to_return = 50;
        _to_return += SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.ACTION.clickOnNextButton( timeout + _to_return, 2 );
        return _to_return;
    };
    self.ACTION.clickOnTabStep3                   = function ( timeout, window_name ) {
        setTimeout( function () {
            document.getElementById( "id-shinken-window-" + window_name + "-mass-change" ).click();
        }, timeout );
        return 100;
    };
    self.ACTION.step3ToStep4                      = function ( timeout ) {
        var _to_return = 1000;
        _to_return += SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.ACTION.clickOnNextButton( timeout + _to_return, 3 );
        return _to_return;
    };
    self.ACTION.step4ToStep3                      = function ( timeout ) {
        var _to_return = 50;
        _to_return += SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.ACTION.clickOnPreviousButton( timeout + _to_return, 4 );
        return _to_return;
    };
    self.ACTION.step4ToStep5                      = function ( timeout ) {
        var _to_return = 50;
        _to_return += SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.ACTION.clickOnNextButton( timeout + _to_return, 4 );
        return _to_return;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.currentStep                         = function ( timeout, step ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( CONTROLLER.MassChange.steps.current, step, 'currentStep' );
        }, timeout );
        return 100;
    };
    self.TEST.stateNextButton                     = function ( timeout, step, state ) {
        var style;
        switch ( state ) {
            case COMPONENT.CONST.BTN_STATE.OFF:
                style = ["pointerEvents", "none"];
                break;
            case COMPONENT.CONST.BTN_STATE.ON:
                style = ["pointerEvents", "auto"];
                break;
            default:
                return 100;
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getNextButton( step ), style[ 0 ], style[ 1 ] );
        }, timeout );
        return 100;
    };
    self.TEST.counterNextButton                   = function ( timeout, step, nb_error, nb_warning, nb_user ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.counter( 0, self.DOM.getNextButton( step ), nb_error, nb_warning, nb_user, undefined );
        }, timeout );
        return 100;
    };
    self.TEST.validAcionSelector                  = function ( timeout, property_name, state ) {
        var style;
        switch ( state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                style = ["backgroundColor", SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STYLE_CONST.ACTION_SELECTOR_USER_INHERITANCE];
                break;
            case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                style = ["backgroundColor", SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STYLE_CONST.ACTION_SELECTOR_USER_SET];
                break;
            default:
                return 100;
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE.DOM.getSelectorAction( property_name, true ), style[ 0 ], style[ 1 ] );
        }, timeout );
        return 100;
    };
    self.TEST.validStep1Display                   = function () {
        var _item_type = SHINKEN.HIGHWAY.getListType();
        switch ( _item_type ) {
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTERS:
            case OBJECT.CONST.ELEMENT.TYPE.MODULATION_DATA:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACT_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CONTACTS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_TPL_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
            case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
            case OBJECT.CONST.ELEMENT.TYPE.CLUSTER_TPLS:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.TEST.getStep1Cell( CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS ), "opacity", "1" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.TEST.getStep1Cell( CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS ), "opacity", "0.4" );
                break;
            case OBJECT.CONST.ELEMENT.TYPE.HOST_TPLS:
            case OBJECT.CONST.ELEMENT.TYPE.HOSTS:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.TEST.getStep1Cell( CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS ), "opacity", "1" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.TEST.getStep1Cell( CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS ), "opacity", "1" );
                break;
            default:
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.TEST.getStep1Cell( CONTROLLER.CONST.MASS_CHANGE.TYPE.DATAS ), "opacity", "0.4" );
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.TEST.getStep1Cell( CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS ), "opacity", "0.4" );
                break;
        }
        SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.TEST.getStep1CounterElement(), Object.keys( CONTROLLER.MassChange.lists_id ).length, "Counter nombre edition" );
    };
    self.TEST.getStep1Cell                        = function ( name ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step1 .shinken-cell-radio-button[data-name="' + name + '"]' );
    };
    self.TEST.getStep1CounterElement              = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step1 .shinken-title-container .shinken-nb-element-affected .shinken-label' );
    };
    self.TEST.selectStep2PropertyOptionIsLocked   = function ( timeout, property_name, option_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.selectPropertyOptionIsLocked', property_name + "-" + option_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var option = self.DOM.getStep2SelectPropertySpecificOption( property_name, option_name );
            if ( !option.classList.contains( "shinken-option-locked" ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Option " + option_name + " is not locked on property " + property_name );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE || {} );
SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STEP_4      = (function ( self ) {
    self.DOM                           = {};
    self.ACTION                        = {};
    self.TEST                          = {};
    self.FILTER_CONST                  = {
        ELEMENTS          : 'elements',
        CATEGORY          : 'category',
        PROPERTY          : 'property',
        INITIAL_VALUE_PLUS: 'initial-value-plus',
        INITIAL_VALUE     : 'initial-value',
        FINAL_VALUE_PLUS  : 'final-value-plus',
        FINAL_VALUE       : 'final-value',
        ACTION            : 'action',
        COUNTERS          : 'counters'
    };
    //********************************************  DOM ELEMENT   **************************************************//
    self.DOM.getSummaryElementLineById = function ( uuid ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step4 .shinken-list-line[data-uuid="' + uuid + '"]' );
    };
    self.DOM.getSummaryAction          = function () {
        return document.querySelector( "#id-shinken-mass-change-tunnel-step4 .shinken-mass-change-summary-actions" );
    };
    self.DOM.getListContainer          = function () {
        return document.querySelector( "#id-shinken-mass-change-tunnel-step4 .shinken-mass-change-summary-full" );
    };
    self.DOM.getCounterContainer       = function () {
        return document.querySelector( ".shinken-nb-element-affected .shinken-mass-change-counter-container" );
    };
    self.DOM.counterWarning            = function () {
        try {
            return self.DOM.getCounterContainer().querySelector( ".shinken-warning-counter" );
        }
        catch ( e ) {
            return null;
        }
    };
    self.DOM.getSelectAllButton        = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step4 .shinken-all-elements[data-name="shinken-all-elements"] .shinken-checkbox-container' );
    };
    self.DOM.getCollapseAllButton      = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step4 .shinken-collapse-listener[data-name="shinken-all-elements"] .shinken-collapse-container' );
    };
    self.DOM.getCollapseButton         = function ( uuid ) {
        return self.DOM.getSummaryElementLineById( uuid ).querySelector( '.shinken-cell-collapse-container[data-name="' + uuid + '"]' );
    };
    self.DOM.getFilterInput            = function ( filter_name ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step4 .shinken-list-filter[data-name="' + filter_name + '"] .shinken-input' );
    };
    self.DOM.getFilterSelect           = function ( filter_name ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step4 .shinken-list-filter[data-name="' + filter_name + '"] .shinken-list-select' );
    };
    self.DOM.getOnClickTogglDetail     = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step4 .shinken-mass-change-show-more .shinken-button-container' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnSelectAll       = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getSelectAllButton() );
        }, timeout );
        return 300;
    };
    self.ACTION.clickOnCollapseAll     = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getCollapseAllButton() );
        }, timeout );
        return 300;
    };
    self.ACTION.clickOnCollapse        = function ( timeout, uuid ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getCollapseButton( uuid ) );
        }, timeout );
        return 300;
    };
    self.ACTION.setFilterValue         = function ( timeout, filter_name, to_set ) {
        setTimeout( function () {
            switch ( filter_name ) {
                case SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STEP_4.FILTER_CONST.ACTION:
                    SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.ACTION.clickOnOption( 0, self.DOM.getFilterSelect( filter_name ), to_set, true );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.getFilterInput( filter_name ), to_set );
                    break;
            }
        }, timeout );
        return 300;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.collapseAllStatus        = function ( timeout, status ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.collapseAllStatus', status );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_list_container = self.DOM.getListContainer();
            switch ( status ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.COLLAPSED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( 0, _dom_list_container, "shinken-collapsed", false, "getListContainer" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.UN_COLLAPSED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( 0, _dom_list_container, "shinken-collapsed", true, "getListContainer" );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return 500;
    };
    self.TEST.validDetailNumberAction  = function ( timeout ) {
        setTimeout( function () {
            var _rows         = self.DOM.getListContainer().querySelectorAll( ".shinken-table-mass-change-full-sum-data-container" );
            var _to_test      = 1;
            var _switch_value = __shinken_test_type + "-" + __phase;
            switch ( _switch_value ) {
                case "00132-2":
                case "00174-1":
                    _to_test = 2;
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _rows, _to_test, "number detail line" );
        }, timeout );
        return 100;
    };
    self.TEST.validDetailNumberColumn  = function ( timeout ) {
        setTimeout( function () {
            var _cols         = self.DOM.getListContainer().querySelectorAll( ".shinken-list-header" );
            var _nb_columns   = 11;
            var _switch_value = __shinken_test_type + "-" + __phase;
            switch ( _switch_value ) {
                case "00067-1":
                case "00067-2":
                case "00068-1":
                case "00069-1":
                case "00074-1":
                case "00074-2":
                case "00075-1":
                case "00075-2":
                case "00076-1":
                case "00076-2":
                case "00077-1":
                case "00077-2":
                case "00093-1":
                case "00093-2":
                case "00093-3":
                case "00093-4":
                case "00093-5":
                case "00093-6":
                case "00093-7":
                case "00093-8":
                case "00094-1":
                case "00127-1":
                case "00128-1":
                case "00130-1":
                case "00130-3":
                case "00132-1":
                case "00132-2":
                case "00132-3":
                case "00132-4":
                case "00133-1":
                case "00133-2":
                case "00133-3":
                case "00133-4":
                case "00174-1":
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getListContainer().querySelector( ".shinken-list-header.shinken-initial-value-plus-cell-with-setter" ), "width", 0 );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getListContainer().querySelector( ".shinken-list-header.shinken-final-value-plus-cell-with-setter" ), "width", 0 );
                    break;
                case "00134-1":
                case "00134-2":
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getListContainer().querySelector( ".shinken-list-header.shinken-initial-value-plus-cell-with-setter" ), "width", 0 );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getListContainer().querySelector( ".shinken-list-header.shinken-final-value-plus-cell-with-setter" ), "width", 0 );
                    _nb_columns = 12;
                    break;
                case "00130-2":
                    _nb_columns = 12;
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getListContainer().querySelector( ".shinken-list-header.shinken-initial-value-plus-cell-with-setter" ), "width", 30 );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getListContainer().querySelector( ".shinken-list-header.shinken-final-value-plus-cell-with-setter" ), "width", 30 );
            }
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _cols, _nb_columns, "number column detail" );
        }, timeout );
        return 100;
    };
    self.TEST.validDetailContent       = function ( timeout ) {
        setTimeout( function () {
            var _switch_value = __shinken_test_type + "-" + __phase;
            var _dom          = self.DOM.getListContainer().querySelector( '.shinken-table-mass-change-full-sum-data-container' );
            switch ( _switch_value ) {
                case "00067-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralAdressePardéfautlenom[00001_test_auto]Pardéfautlenom[00001_test_auto]réalisationpossible...", "Action" );
                    break;
                case "00067-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralAdresselocalhostPardéfautlenom[00001_test_auto]réalisationpossible...", "Action" );
                    break;
                case "00068-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralAdressePardéfautlenom[00001_test_auto]Forcépardéfautlenom[00001_test_auto]réalisationpossible...", "Action" );
                    break;
                case "00069-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralAdressePardéfautlenom[00001_test_auto]test_autoréalisationpossible...", "Action" );
                    break;
                case "00070-2":
                case "00071-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritésValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]nonréalisable...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00074-1":
                case "00075-1":
                case "00076-1":
                case "00077-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritésValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]nonréalisable...", "Action" );
                    break;
                case "00078-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritésValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]nonréalisable...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00070-3":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_disabledtest_auto_validtest_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00070-4":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralGrouped'hôtesValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00070-5":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralGrouped'hôtestest_auto_validtest_auto_validnonréalisable...", "Action" );
                    break;
                case "00071-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_disabledtest_auto_disabledtest_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00072-1":
                case "00073-1":
                case "00080-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritésValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00072-2":
                case "00073-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_validtest_auto_validnonréalisable...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00074-2":
                case "00075-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_validtest_auto_validnonréalisable...", "Action" );
                    break;
                case "00076-2":
                case "00077-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_validtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00080-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_validtest_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00078-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_validtest_auto_valid_2réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00079-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritésValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00079-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]Valeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00093-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_1~=http://test_auto_1~=picture~=POPUP(70)réalisationpossible...", "Action" );
                    break;
                case "00093-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_1~=http://test_auto_1~=tag~=OPEN_IN_NEW_TABtest_auto_1~=http://test_auto_1~=tag~=OPEN_IN_NEW_TABnonréalisable...", "Action" );
                    break;
                case "00093-3":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_2~=http://test_auto_1~=tag~=OPEN_IN_NEW_TABtest_auto_2~=http://test_auto_1~=tag~=OPEN_IN_NEW_TAB~#~test_auto_1~=http://test_auto_1~=picture~=POPUP(70)réalisationpossible...", "Action" );
                    break;
                case "00093-4":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABtest_auto_1~=http://test_auto_1~=picture~=POPUP(70)~#~test_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABréalisationpossible...", "Action" );
                    break;
                case "00093-5":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_2~=http://test_auto_1~=tag~=OPEN_IN_NEW_TABtest_auto_2~=http://test_auto_1~=tag~=OPEN_IN_NEW_TAB~#~test_auto_1~=http://test_auto_1~=picture~=POPUP(70)réalisationpossible...", "Action" );
                    break;
                case "00093-6":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABtest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_1~=http://test_auto_1~=picture~=POPUP(70)~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABréalisationpossible...", "Action" );
                    break;
                case "00093-7":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABtest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_1~=http://test_auto_1~=picture~=POPUP(70)~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABréalisationpossible...", "Action" );
                    break;
                case "00093-8":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralListedesURLexternestest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABtest_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_1~=http://test_auto_1~=picture~=POPUP(70)~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TABréalisationpossible...", "Action" );
                    break;
                case "00094-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "test_auto_validtest_auto_validGénéralImpactmétierValeurhéritéeouvaleurpardéfaut[Mêmecomportementquesonparent(hôteoucluster)]Valeurhéritéeouvaleurpardéfaut[Mêmecomportementquesonparent(hôteoucluster)]réalisationpossible...", "Action" );
                    break;
                case "00123-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-3":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validtest_auto_validnonréalisable...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-4":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôtetest_auto_validValeurhéritéeouvaleurpardéfaut[Toutlemonde]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Toutlemonde]Valeurhéritéeouvaleurpardéfaut[Toutlemonde]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-5":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôtetest_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-6":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-7":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]nonréalisable...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-8":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifiertest_auto_validtest_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-9":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_disabledtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-10":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-11":
                case "00123-12":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_disabledtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-13":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifiertest_auto_validtest_auto_validnonréalisable...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_disabledtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-14":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_validtest_auto_disabledtest_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-15":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_validtest_auto_disabledtest_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validtest_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-16":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00123-17":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-18":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)test_auto_disabledValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validtest_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-19":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter200001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)test_auto_disabledValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_newréalisationpossible...", "Action" );
                    break;
                case "00123-20":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_newtest_auto_newréalisationpossible...", "Action" );
                    break;
                case "00123-21":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-22":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_disabledtest_auto_disabledtest_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_disabledtest_auto_validtest_auto_disabledtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00123-23":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validtest_auto_validtest_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_disabledtest_auto_validtest_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-24":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validtest_auto_validtest_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_disabledtest_auto_validtest_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-25":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)test_auto_validtest_auto_disabledtest_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-26":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter100001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôtetest_auto_disabledValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-27":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_1réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Toutlemonde]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-28":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_4réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Toutlemonde]adminréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)admintest_auto_disabledadminréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-29":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)test_auto_disabledtest_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00126-1":
                case "00126-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-3":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validtest_auto_validnonréalisable...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-4":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôtetest_auto_validValeurhéritéeouvaleurpardéfaut[Personne]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-5":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôtetest_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-6":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-7":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]nonréalisable...", "Action" );
                    break;
                case "00126-8":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifiertest_auto_validtest_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00126-9":
                case "00126-11":
                case "00126-12":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter100001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-10":
                case "00126-21":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-13":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter100001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifiertest_auto_validtest_auto_validnonréalisable...", "Action" );
                    break;
                case "00126-14":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter200001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_newréalisationpossible...", "Action" );
                    break;
                case "00126-15":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter400001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_newréalisationpossible...", "Action" );
                    break;
                case "00126-16":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-17":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter100001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-18":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter200001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)test_auto_disabledValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-19":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter200001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)test_auto_validValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)test_auto_disabledValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-20":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_newréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-22":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_disabledtest_auto_disabledtest_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-23":
                case "00126-24":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Synchronisation)test_auto_validtest_auto_validtest_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-25":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter200001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00126-26":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_autoConsulter200001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôtetest_auto_disabledValeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifier(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquipeuventmodifierlaconfigurationdel'hôte(Synchronisation)Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00126-27":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_1réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Personne]test_auto_disabledréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00126-28":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoGénéralModèlesd'hôtehéritéstest_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_3test_auto_valid_with_user_rights_4réalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Personne]adminréalisationpossible...00001_test_autoDroitsdel'utilisateurLesutilisateursquivoientl'hôte(Miseencohérence)admintest_auto_disabledadminréalisationpossible...00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôte(Miseencohérence)Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00126-29":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursquivoientl'hôteValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_disabledréalisationpossible...", "Action" );
                    break;
                case "00123-30":
                case "00126-30":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDroitsdel'utilisateurLesgroupesd'utilisateursànotifierValeurhéritéeouvaleurpardéfaut[Aucun][Aucun]réalisationpossible...", "Action" );
                    break;
                case "00127-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "test_auto_validtest_auto_validGénéralAttachésurlesgroupesd'hôtesValeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00128-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "test_auto_validtest_auto_validGénéralPériodesdetempsexcluesPardéfaut[Aucun]nonréalisable...", "Action" );
                    break;
                case "00130-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autoDonnées_PASSWORD[Donnée]CechampestprotégéCechampestprotégéréalisationpossible...", "Action" );
                    break;
                case "00130-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00001_test_auto00001_test_autotest_auto_validDonnées_PASSWORD[Donnée]ValeurducheckCechampestprotégéréalisationpossible...", "Action" );
                    break;
                case "00132-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_autoréalisationpossible...", "Action" );
                    break;
                case "00132-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_autoréalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00132_test_autoDonnées_TEST_AUTO_2[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_autoréalisationpossible...", "Action" );
                    break;
                case "00132-3":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO_TPL_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00132_test_autoDonnées_LOCAL_DATA[Donnée]TEST_AUTOtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00132-4":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO_TPL_3[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_2[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]Forcépardéfaut[Aucun]réalisationpossible...00132_test_autoDonnées_LOCAL_DATA[Donnée]TEST_AUTOtest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00133-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO_LOCAL_DFE_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00133-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO_TPL_DFE_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00133-3":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO_LOCAL_DFE_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_valid$(value1,value2)$,test_auto_valid_1$(value3,value2)$réalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_DFE_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_DFE_2[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]test_auto_validréalisationpossible...", "Action" );
                    break;
                case "00133-4":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00132_test_auto00132_test_autoDonnées_TEST_AUTO_LOCAL_DFE_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]Forcépardéfaut[Aucun]réalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_DFE_1[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...00132_test_autoDonnées_TEST_AUTO_TPL_DFE_2[Donnée]Valeurhéritéeouvaleurpardéfaut[Aucun]Valeurhéritéeouvaleurpardéfaut[Aucun]réalisationpossible...", "Action" );
                    break;
                case "00134-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00134_test_auto00134_test_auto00134_test_auto_1Données_TEST_AUTO_CHECK_1[Donnée]Valeurduchecktest_auto_validréalisationpossible...00134_test_auto00134_test_auto_2Données_TEST_AUTO_CHECK_1[Donnée]Valeurduchecktest_auto_validréalisationpossible...", "Action" );
                    break;
                case "00134-2":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00134_test_auto00134_test_auto00134_test_auto_1Données_TEST_AUTO_CHECK_1[Donnée]ValeurducheckValeurducheckréalisationpossible...00134_test_auto00134_test_auto_1Données_TEST_AUTO_CHECK_2[Donnée]ValeurducheckValeurducheckréalisationpossible...00134_test_auto00134_test_auto_2Données_TEST_AUTO_CHECK_1[Donnée]ValeurducheckValeurducheckréalisationpossible...00134_test_auto00134_test_auto_2Données_TEST_AUTO_CHECK_2[Donnée]ValeurducheckValeurducheckréalisationpossible...", "Action" );
                    break;
                case "00174-1":
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "00003_test_auto00003_test_autoChecksChecksàexclure(parchainedecaractère)Pardéfaut[Aucun]xxxréalisationpossible...00003_test_autoChecksChecksàexclurespécifiquementPardéfaut[Aucun]00003_test_autoréalisationpossible...", "Action" );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.__isFlatContentEqualTo( _dom, "TEST DEV ... TO DO", "Action" );
                    break;
                
            }
        }, timeout );
        return 100;
    };
    self.TEST.validate_Step4           = function ( timeout ) {
        var _to_return = 0;
        _to_return     = self.TEST.validSummaryNumberAction( timeout + _to_return );
        _to_return += self.TEST.validSummaryContent( timeout + _to_return );
        _to_return += self.TEST.validDetailNumberAction( timeout + _to_return );
        _to_return += self.TEST.validDetailNumberColumn( timeout + _to_return );
        _to_return += self.TEST.validDetailContent( timeout + _to_return );
        _to_return += self.TEST.events( timeout + _to_return );
        return _to_return;
    };
    self.TEST.validSummaryNumberAction = function ( timeout ) {
        setTimeout( function () {
            var _rows         = self.DOM.getSummaryAction().querySelectorAll( ".shinken-mass-change-summary-actions-row" );
            var _to_test      = 1;
            var _switch_value = __shinken_test_type + "-" + __phase;
            switch ( _switch_value ) {
                case '00123-9':
                case '00123-10':
                case '00123-11':
                case '00123-12':
                case '00123-21':
                case '00123-29':
                case '00126-1':
                case '00126-2':
                case '00126-3':
                case '00126-7':
                case '00126-8':
                case '00126-13':
                case '00132-3':
                case '00134-2':
                    _to_test = 2;
                    break;
                case '00070-2':
                case '00070-3':
                case '00071-1':
                case '00071-2':
                case '00072-1':
                case '00072-2':
                case '00073-1':
                case '00073-2':
                case '00078-1':
                case '00078-2':
                case '00079-1':
                case '00079-2':
                case '00080-1':
                case '00080-2':
                case '00123-1':
                case '00123-2':
                case '00123-3':
                case '00123-7':
                case '00123-8':
                case '00123-13':
                case '00123-14':
                case '00123-15':
                case '00123-25':
                case '00123-27':
                case '00126-16':
                case '00126-17':
                case '00126-18':
                case '00126-19':
                case '00126-20':
                case '00126-26':
                case '00126-27':
                case '00132-2':
                case '00133-3':
                case '00133-4':
                    _to_test = 3;
                    break;
                case '00123-19':
                case '00123-20':
                case '00123-26':
                case '00123-28':
                case '00126-22':
                case '00126-28':
                case '00132-4':
                    _to_test = 4;
                    break;
                case '00123-16':
                case '00123-17':
                case '00123-18':
                case '00123-22':
                case '00126-4':
                case '00126-5':
                case '00126-23':
                case '00126-24':
                    _to_test = 5;
                    break;
                case '00123-5':
                case '00123-23':
                case '00123-24':
                case '00126-6':
                    _to_test = 6;
                    break;
                case '00123-4':
                    _to_test = 7;
                    break;
                case '00123-6':
                    _to_test = 8;
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _rows, _to_test, "number action" );
        }, timeout );
        return 100;
    };
    self.TEST.validSummaryContent      = function ( timeout ) {
        setTimeout( function () {
            var _container = self.DOM.getSummaryAction();
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _container, "container summary action" );
            var _switch_value = __shinken_test_type + "-" + __phase;
            var _action       = null;
            var _value        = null;
            var _label        = null;
            var _target       = null;
            switch ( _switch_value ) {
                case "00067-1":
                    _action = "Vider la propriété";
                    break;
                case "00068-1":
                case "00069-1":
                case "00080-1":
                case "00080-2":
                case "00123-30":
                case "00126-30":
                    _action = "Tout remplacer par";
                    break;
                case "00070-2":
                case "00070-3":
                case "00070-4":
                case "00070-5":
                case "00071-1":
                case "00071-2":
                case "00072-1":
                case "00072-2":
                case "00073-1":
                case "00073-2":
                case "00093-1":
                case "00093-2":
                case "00093-3":
                case "00093-5":
                case "00093-4":
                case "00093-6":
                case "00093-7":
                case "00093-8":
                    _action = "Ajouter si absent";
                    break;
                case "00074-1":
                case "00074-2":
                case "00075-1":
                case "00075-2":
                case "00076-1":
                case "00076-2":
                case "00077":
                    _action = "Déplacer si existant";
                    break;
                case "00078-1":
                case "00078-2":
                    _action = "Remplacer";
                    break;
                case "00079-1":
                case "00079-2":
                    _action = "Supprimer si existant";
                    break;
            }
            switch ( _switch_value ) {
                case "00067-1":
                    _value = "";
                    break;
                case "00068-1":
                    _value = "Forcé par défaut [Aucun]";
                    break;
                case "00123-30":
                case "00126-30":
                    _value = "[Aucun]";
                    break;
                case "00069-1":
                    _value = "test_auto";
                    break;
                case "00070-2":
                case "00070-3":
                case "00070-4":
                case "00070-5":
                case "00071-1":
                case "00071-2":
                case "00072-1":
                case "00072-2":
                case "00073-1":
                case "00073-2":
                case "00074-1":
                case "00074-2":
                case "00075-1":
                case "00075-2":
                case "00076-1":
                case "00076-2":
                case "00077":
                case "00079-1":
                case "00079-2":
                case "00080-1":
                case "00080-2":
                    _value = "test_auto_valid";
                    break;
                case "00078-1":
                case "00078-2":
                    _value = "test_auto_valid_2";
                    break;
                case "00093-1":
                case "00093-2":
                case "00093-3":
                case "00093-5":
                    _value = "test_auto_1http://test_auto_1Popup70%endernier";
                    break;
                case "00093-4":
                    _value = "test_auto_1http://test_auto_1Popup70%enpremier";
                    break;
                case "00093-6":
                    _value = "test_auto_1http://test_auto_1Popup70%àlaposition2";
                    break;
                case "00093-7":
                    _value = "test_auto_1http://test_auto_1Popup70%aprèssiexistetest_auto_3";
                    break;
                case "00093-8":
                    _value = "test_auto_1http://test_auto_1Popup70%avantsiexistetest_auto_3";
                    break;
            }
            switch ( _switch_value ) {
                case "00070-2":
                case "00070-3":
                case "00074-1":
                case "00074-2":
                    _label = "avant si existe";
                    break;
                case "00071-1":
                case "00071-2":
                case "00075-1":
                case "00075-2":
                    _label = "après si existe";
                    break;
                case "00072-1":
                case "00072-2":
                case "00076-1":
                case "00076-2":
                    _label = "en premier";
                    break;
                case "00073-1":
                case "00073-2":
                case "00077":
                    _label = "en dernier";
                    break;
                case "00078-1":
                case "00078-2":
                    _label = "par";
                    break;
            }
            switch ( _switch_value ) {
                case "00070-2":
                case "00070-3":
                case "00071-1":
                case "00071-2":
                case "00074-1":
                case "00074-2":
                case "00075-1":
                case "00075-2":
                    _target = "test_auto_disabled";
                    break;
                case "00078-1":
                case "00078-2":
                    _target = "test_auto_valid";
                    break;
            }
            if ( _action !== null ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _container.querySelector( '.shinken-mass-change-summary-actions-row .shinken-action-cell' ), _action, "Action" );
            }
            if ( _value !== null ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _container.querySelector( '.shinken-mass-change-summary-actions-row .shinken-value-cell' ), _value, "Value" );
            }
            if ( _label !== null ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _container.querySelector( '.shinken-mass-change-summary-actions-row .shinken-label-cell' ), _label, "Label" );
            }
            if ( _target !== null ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _container.querySelector( '.shinken-mass-change-summary-actions-row .shinken-target-cell' ), _target, "Target" );
            }
        }, timeout );
        return 100;
    };
    self.TEST.events                   = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getOnClickTogglDetail() );
        }, timeout );
        return 100;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STEP_4 || {} );
SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STEP_5      = (function ( self ) {
    self.DOM                       = {};
    self.ACTION                    = {};
    self.TEST                      = {};
    self.FILTER_CONST              = {
        ELEMENTS          : 'elements',
        CATEGORY          : 'category',
        PROPERTY          : 'property',
        INITIAL_VALUE_PLUS: 'initial-value-plus',
        INITIAL_VALUE     : 'initial-value',
        FINAL_VALUE_PLUS  : 'final-value-plus',
        FINAL_VALUE       : 'final-value',
        ACTION            : 'action',
        COUNTERS          : 'counters'
    };
    //********************************************  DOM ELEMENT   **************************************************//
    self.DOM.getCollapseAllButton  = function () {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step5 .shinken-collapse-listener[data-name="shinken-all-elements"] .shinken-collapse-container' );
    };
    self.DOM.getFilterInput        = function ( filter_name ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step5 .shinken-list-filter[data-name="' + filter_name + '"] .shinken-input' );
    };
    self.DOM.getFilterSelect       = function ( filter_name ) {
        return document.querySelector( '#id-shinken-mass-change-tunnel-step5 .shinken-list-filter[data-name="' + filter_name + '"] .shinken-list-select' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnCollapseAll = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getCollapseAllButton() );
        }, timeout );
        return 300;
    };
    self.ACTION.setFilterValue     = function ( timeout, filter_name, to_set ) {
        setTimeout( function () {
            switch ( filter_name ) {
                case SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STEP_5.FILTER_CONST.ACTION:
                    SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.ACTION.clickOnOption( 0, self.DOM.getFilterSelect( filter_name ), to_set, true );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.getFilterInput( filter_name ), to_set );
                    break;
            }
        }, timeout );
        return 300;
    };
    //********************************************  TEST   **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STEP_5 || {} );
SHINKEN.TOOLS.TEST_AUTO_MASS_CHANGE_STYLE_CONST = {
    ACTION_SELECTOR_TRANSPARENT     : "rgba(0, 0, 0, 0)",
    ACTION_SELECTOR_USER_SET        : "rgba(30, 30, 30, 0.8)",
    ACTION_SELECTOR_USER_INHERITANCE: "rgb(217, 217, 217)",
    ACTION_SELECTOR_ERROR           : "rgb(236, 87, 87)",
    STATE                           : {
        HIDDEN                         : 0,
        VISIBLE                        : 1,
        USER_SET                       : 2,
        USER_SET_OR_VISIBLE_IF_HAS_PLUS: 3,
        ERROR                          : 4
    }
    
    
};