//priority 17
//__lib__ lib_common
'use strict';


COMPONENT.Interface = function() {
};

COMPONENT.Interface.prototype = {
    initInterface: function() {
        this.url_param_key = this.dom_element.dataset.urlParamKey;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doExtraAction: function() {
        if ( this.url_param_key ) {
            this.updateUrlWithValue();
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    //********************************************  COMPUTE  *********************************************************//
    updateUrlWithValue: function() {
    },
    //********************************************  HTML    **********************************************************//
    setTooltip       : function ( to_set, type ) {
        if ( to_set ) {
            this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            this.dom_element.setAttribute( 'shi-tip-html', to_set );
            if ( type ) {
                this.dom_element.setAttribute( 'shi-tip-type', type );
            }
        }
        else {
            this.dom_element.setAttribute( 'shi-tip-html', '' );
        }
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
    //********************************************  HELP    **********************************************************//
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Interface, SHINKEN.OBJECT.CounterInterface );