//__lib__ lib_common
'use strict';
COMPONENT.InterfaceLabel           = function () {
    this.__class_name__ = 'COMPONENT.Label';
    this.init();
};
COMPONENT.InterfaceLabel.prototype = {
    init: function () {
    },
    setLabel: function (to_set) {
        this.label = to_set;
    },
    getValue: function () {
        return "";
    }
    
};


SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, COMPONENT.Interface );


COMPONENT.Label           = function ( dom_element ) {
    // dom_element
    // label
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init       : function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    },
    updateLabel: function ( to_set ) {
        this.label                 = to_set;
        this.dom_element.innerHTML = this.label;
    }
};

COMPONENT.LabelFromData           = function () {
    this.__class_name__ = 'COMPONENT.LabelFromData';
    this.init();
};
COMPONENT.LabelFromData.prototype = {
    init: function () {
        this.current_value = "";
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element       = DOM.Service.createElement( "div", {
                class: "shinken-label-container"
            }
        );
        this.dom_element_label = DOM.Service.createElement( "span", {
            class: "shinken-label"
        } );
        this.dom_element_label.innerHTML = this.label;
        DOM.Service.addElementTo( this.dom_element_label, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData, COMPONENT.InterfaceLabel );

