'use strict';

COMPONENT.RadioListGeneric           = function ( dom_element, parent ) {
    this.init( dom_element, parent );
};
COMPONENT.RadioListGeneric.prototype = {
    init: function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initContents();
        this.initCounters( parent );
        this.initListContent( dom_element );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "value_changed":
                this.clickOnRadioBtn( param );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValueFromUser: function ( to_set ) {
        this.clickOnRadioBtn( to_set );
    },
    
    initListContent: function ( dom_element ) {
        var _list_dom = dom_element.querySelectorAll( '.shinken-radio-element' );
        var _current;
        
        for ( var i = 0, _size = _list_dom.length; i < _size; i++ ) {
            _current = new COMPONENT.Generic( _list_dom[ i ] );
            _current.initCounters( this );
            _current.computeCounters();
            this.add( _current );
            if ( _current.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current;
            }
        }
        
    },
    clickOnRadioBtn: function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getContentByUUID( value );
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    getValue       : function () {
        return this.active_button.getValue();
    },
    isDefaultOn    : function () {
        var _element = this.getContentByUUID( COMPONENT.CONST.BTN_NAME.DEFAULT );
        if ( _element ) {
            return _element.isOn();
        }
        return false;
    },
    setDefault     : function ( to_set ) {
        var _element = this.getContentByUUID( COMPONENT.CONST.BTN_NAME.DEFAULT );
        if ( _element ) {
            _element.setState( to_set );
        }
    },
    setDefaultValue: function ( to_set ) {
        this.dom_element.setAttribute( "data-default-value", to_set );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric, COMPONENT.Interface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric, SHINKEN.OBJECT.ShinkenObjectContainer );


COMPONENT.RadioListButtons           = function ( dom_element, parent ) {
    this.initSpecific( dom_element, parent );
};
COMPONENT.RadioListButtons.prototype = {
    initSpecific: function ( dom_element, parent ) {
        this.init();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    //********************************************  TO SORT  *****************************************************//
    initListContent: function ( dom_element ) {
        var _list_dom = dom_element.querySelectorAll( '.shinken-radio-btn' );
        var _current;
        
        for ( var i = 0, _size = _list_dom.length; i < _size; i++ ) {
            _current = new COMPONENT.Button( _list_dom[ i ] );
            _current.initCounters( this );
            _current.computeCounters();
            this.radio_buttons.push( _current );
            this.mapping_radio_button[ _current.getValue() ] = i;
            if ( _current.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current;
            }
        }
        
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListButtons, COMPONENT.RadioListGeneric );


