//__lib__ lib_common
'use strict';

SHINKEN_LIST.SetFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromData.prototype = {
    init: function () {
    },
    //********************************************  HTML  *****************************************************//
    computeHtml        : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml  : function () {
        this.headers.computeHtml();
        this.filters.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container" } ) );
        var _table = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead = DOM.Service.createElement( "thead" );
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead );
        DOM.Service.addElementTo( this.filters.getDomElement(), _thead );
        DOM.Service.addElementTo( _thead, _table );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table );
        this.addDomElement( _table );
        this.computeHtmlExtra();
    },
    computeLinesHtml   : function () {
        this.lines.computeHtml();
    },
    computeSpecificHtml: function () {
    
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromData, SHINKEN_LIST.Set );

SHINKEN_LIST.SetFromDataWithFixHeaderFilter           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromDataWithFixHeaderFilter.prototype = {
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.headers.computeHtml();
        this.filters.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container" } ) );
        
        //*******  First Table Header And Filter  *******//
        var _container_header_filter   = DOM.Service.createElement( "div", {
            class: "shinken-list-container-fix-header-filter"
        } );
        var _table_header_filter       = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead_table_header_filter = DOM.Service.createElement( "thead" );
        
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead_table_header_filter );
        DOM.Service.addElementTo( this.filters.getDomElement(), _thead_table_header_filter );
        DOM.Service.addElementTo( _thead_table_header_filter, _table_header_filter );
        DOM.Service.addElementTo( _table_header_filter, _container_header_filter );
        this.addDomElement( _container_header_filter );
        
        //*******  Second Table Header (Height 0px) And List  *******//
        var _container_header_list = DOM.Service.createElement( "div", {
            class: "shinken-list-container-with-scroll"
        } );
        var _table_list            = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead_table_list      = DOM.Service.createElement( "thead" );
        
        
        DOM.Service.addElementTo( _thead_table_list, _table_list );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table_list );
        DOM.Service.addElementTo( _table_list, _container_header_list );
        this.addDomElement( _container_header_list );
        
        this.computeHtmlExtra();
        this.computeSpecificHtml();
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithFixHeaderFilter, SHINKEN_LIST.SetFromData );
