//__lib__ lib_common
'use strict';
SHINKEN_LIST.LinesFromDataWithPagination           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.LinesFromDataWithPagination.prototype = {
    init: function () {
        this.initContents();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  COLLAPSE  *****************************************************//
    
    //********************************************  FILTERS  *****************************************************//
    
    //********************************************  SAVE  *****************************************************//

    //********************************************  HTML  *****************************************************//
    computeHtml: function ( pagination ) {
        if ( this.getDomElement() ) {
            DOM.Service.empty( this.getDomElement() );
        }
        else {
            this.setDomElement( DOM.Service.createElement( "tbody", { class: "shinken-list-tbody" } ) );
        }
        var _first_element_to_display = pagination.getDisplayStartingIndex();
        var _size_end_display         = Math.min( pagination.getDisplayEndingIndex(), this.getSize() );
        
        var _current;
        var _running_index = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.is_filtered ) {
                continue;
            }
            if ( _running_index >= _first_element_to_display && _running_index < _size_end_display ) {
                _current.computeHtml();
                this.addDomElement( _current.getDomElement() );
            }
            _running_index++;
        }
        if ( _running_index === 0 ) {
            this.computeMessageNoContentHml();
        }
    },
    computeMessageNoContentHml: function ( pagination ) {
    
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromDataWithPagination, SHINKEN_LIST.LinesFromData );