//__lib__ lib_common
MANAGER.ResizeManager = (function ( self ) {
    "use strict";
    self.dom_element_resize      = null;
    self._bounding_origin        = null;
    self._mouse_x_origin         = null;
    self._mouse_y_origin         = null;
    self._width_origin           = null;
    self._height_origin          = null;
    self._name_origin_controller = null;
    
    
    self.simulateResize            = function ( dom_element ) {
        var _event = {
            "clientX"      : 0,
            "clientY"      : 0,
            stopPropagation: function () {
            }
        };
        setTimeout( function () {
            self.resizeStart( _event, dom_element );
            self.doResize( _event );
            self.resizeEnd();
        }, 0 );
    };
    self.resizeStart               = function ( event, dom_element_target ) {
        var _dom_target         = dom_element_target || event.target;
        self.dom_element_resize = DOM.Service.findParentElementWithClass( _dom_target, "shinken-resizable", 50 );
        self._bounding_origin   = DOM.Service.getBoundingClientRect( self.dom_element_resize );
        self._min_width         = parseInt( _dom_target.dataset[ 'resizeMinWidth' ] );
        self._max_width         = parseInt( _dom_target.dataset[ 'resizeMaxWidth' ] );
        self._min_height        = parseInt( _dom_target.dataset[ 'resizeMinHeight' ] );
        self._max_height        = parseInt( _dom_target.dataset[ 'resizeMaxHeight' ] );
        self._mouse_x_origin    = parseInt( event.clientX );
        self._mouse_y_origin    = parseInt( event.clientY );
        self._width_origin      = self._bounding_origin.width;
        self._height_origin     = self._bounding_origin.height;
        self._type              = self.dom_element_resize.dataset.resizeType;
        self.dom_element_resize.classList.add( "shinken-resize-active" );
        
        var _body = document.querySelector( 'body' );
        _body.classList.add( "shinken-has-resize-in-progress" );
        _body.addEventListener( 'mouseleave', self.resizeEnd, false );
        
        document.documentElement.addEventListener( 'mousemove', self.doResize, false );
        document.documentElement.addEventListener( 'mouseup', self.resizeEnd, false );
        self._callbackResizeStart( event );
        event.stopPropagation();
    };
    self.doResize                  = function ( event ) {
        var _width  = self._width_origin;
        var _height = self._height_origin;
        switch ( self._type ) {
            case MANAGER.CONST.RESIZE.TYPE.LEFT:
                _width = (self._width_origin - event.clientX + self._mouse_x_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.RIGHT:
                _width  = (self._width_origin + event.clientX - self._mouse_x_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.TOP:
                _height = (self._height_origin - event.clientY + self._mouse_y_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM:
                _height  = (self._height_origin + event.clientY - self._mouse_y_origin);
                break;
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM_RIGHT:
                _width  = (self._width_origin + event.clientX - self._mouse_x_origin);
                _height = (self._height_origin + event.clientY - self._mouse_y_origin);
                break;
        }
        
        if ( self._min_width && self._min_width > _width ) {
            _width = self._min_width;
        }
        if ( self._min_height && self._min_height > _height ) {
            _height = self._min_height;
        }
        if ( self._max_width && self._max_width < _width ) {
            _width = self._max_width;
        }
        if ( self._max_height && self._max_height < _height ) {
            _height = self._max_height;
        }
        
        switch ( self._type ) {
            case MANAGER.CONST.RESIZE.TYPE.LEFT:
            case MANAGER.CONST.RESIZE.TYPE.RIGHT:
                DOM.Service.setStyles( self.dom_element_resize, { width: _width + 'px' } );
                break;
            case MANAGER.CONST.RESIZE.TYPE.TOP:
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM:
                DOM.Service.setStyles( self.dom_element_resize, { height: _height + 'px' } );
                
                break;
            case MANAGER.CONST.RESIZE.TYPE.BOTTOM_RIGHT:
                DOM.Service.setStyles( self.dom_element_resize, { width: _width + 'px', height: _height + 'px' } );
                break;
        }
        
        self._callbackResizeMove(_width, _height);
    };
    self.resizeEnd                 = function () {
        document.documentElement.removeEventListener( 'mousemove', self.doResize, false );
        document.documentElement.removeEventListener( 'mouseup', self.resizeEnd, false );
        var _body = document.querySelector( 'body' );
        _body.removeEventListener( 'mouseleave', self.resizeEnd, false );
        document.querySelector( 'body' ).classList.remove( "shinken-has-resize-in-progress" );
        self.dom_element_resize.classList.remove( "shinken-resize-active" );
        self._callbackResizeEnd();
        self.dom_element_resize = null;
        self._min_width         = null;
        self._min_height        = null;
        self._type              = null;
    };
    self._getResizeNameForCallback = function () {
        var _name = self.dom_element_resize.dataset[ 'dragResizeElementName' ];
        if ( _name ) {
            return _name;
        }
        console.error( "MANAGER.DragNDropManager : The dataset callbackResizeElementName was not found " );
    };
    self._callbackResizeStart      = function ( event ) {
        if ( MANAGER && MANAGER.DistributorControllerManager ) {
            self._name_origin_controller = MANAGER.DistributorControllerManager.findControllerName( event );
        }
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeStart( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    self._callbackResizeMove       = function (width, height) {
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeMove( self._name_origin_controller, self._getResizeNameForCallback(), width, height );
        }
    };
    self._callbackResizeEnd        = function () {
        if ( self._name_origin_controller && MANAGER && MANAGER.EventManager ) {
            MANAGER.EventManager.onResizeStop( self._name_origin_controller, self._getResizeNameForCallback() );
        }
    };
    return self;
})
( MANAGER.ResizeManager || {} );