//priority 3
//__lib__ lib_common

'use strict';

var OBJECT = OBJECT || {};

OBJECT.CONST = OBJECT.CONST || {
    TEMPLATE             : {
        FIELD : {
            UUID             : 'uuid',
            _ID              : '_id',
            _SYNC_KEYS       : '_SYNC_KEYS',
            NAME             : 'name',
            IS_TEMPLATE      : 'is_template',
            IS_TOP_LEVEL     : 'is_top_level',
            ITEM_TYPE        : 'item_type',
            LAST_MODIFICATION: 'last_modification',
            REGISTER         : 'register',
            SOURCES          : 'sources',
            USE              : 'use',
            ENABLED          : 'enabled',
            UNCONFIGURED     : 'unconfigured',
            STATUS           : 'template-status',
            IS_NEW           : 'is_new',
            LOOP             : 'loop',
            WORK_AREA_INFO   : 'work_area_info',
            METADATA         : '@metadata'
        },
        STATUS: {
            USEFUL  : 'useful-template',
            USELESS : 'useless-template',
            BADLOOP : 'badloop-template',
            NEW     : 'new-template',
            UNKNOWN : 'unknown-template',
            DISABLED: 'disabled-template'
        }
    },
    ELEMENT_LIST         : {
        TYPE: {
            USER       : 'user',
            INHERITANCE: 'inheritance',
            SEARCHING  : 'searching'
        },
        FILTER_OPTION: {
            IGNORED  : 'ignored_during_filter'
        }
    },
    MACRO                : {
        TYPE: {
            HOST_LOCAL        : '_HOST',
            SERVICE_LOCAL     : '_SERVICE',
            HOST_PROPERTY     : 'macros_host_properties',
            SERVICE_PROPERTY  : 'macros_service_properties',
            GLOBAL            : 'macros_global',
            GLOBAL_INTERPRETED: 'macros_global_interpreted',
            UNKNOWN           : 'unknown',
            VALUE_DFE         : 'VALUE_DFE',
            DFE_KEY           : '$KEY$'
        }
    },
    CHECK_IN_HOST        : {
        STATUS: {
            NONE                           : "",
            DFE_STRUCTURE                  : 'dfe-structure',
            ALREADY_EXISTING_NAME          : "already_existing_name",
            ALREADY_EXISTING_NAME_IN_SAME  : "already_existing_name_in_same_host",
            ALREADY_EXISTING_NAME_DUPLICATE: "already_existing_name_duplicate"
        }
    },
    ELEMENT              : {
        PHASE           : {
            INIT         : 0,
            VIEWING      : 1,
            EDITING      : 2,
            ON_SAVING    : 3,
            SAVING_FAILED: 4,
            RELOADING    : 5
        },
        FIELD           : {
            ID                    : '_id',
            UUID                  : 'uuid',
            SOURCES               : 'sources',
            IMPORT_DATE           : 'import_date',
            SERVICE_OVERRIDES     : 'service_overrides',
            SERVICE_EXCLUDES_BY_ID: 'service_excludes_by_id',
            WORK_AREA_INFO        : 'work_area_info',
            SYNC_KEYS             : '_SYNC_KEYS ',
            LAST_MODIFICATION     : 'last_modification',
            ENABLED               : 'enabled',
            STATUS                : 'status',
            ITEM_TYPE             : 'item_type'
        },
        FIELD_UI        : {
            UUID                                        : 'uuid',
            ITEM_NAME                                   : 'item_name',
            ITEM_UUID                                   : 'item_uuid',
            STATUS                                      : 'status',
            CONTEXT                                     : 'context',
            CONTEXT_OR_STATUS                           : 'context_or_status',
            SLA                                         : {
                __KEY__           : "sla",
                VALUE             : 'value',
                QUALITY           : 'quality',
                TENDENCY          : 'tendency',
                WARNING_THRESHOLD : 'warning_threshold',
                CRITICAL_THRESHOLD: 'critical_threshold'
            },
            ITEM_TYPE                                   : 'item_type',
            IS_EXISTING                                 : 'exists',
            IS_NOT_AUTHORIZED_FOR_USER                  : 'is_not_authorized_for_user',
            ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW: 'element_visibility_on_not_authenticated_view',
            NAME                                        : 'name',
            VISUALISATION_NAME                          : 'visualisation_name'
        },
        MODULATION      : {
            TYPE: {
                NONE_FORCED: -1,
                NONE       : 0,
                PLUS       : 1,
                EXISTING   : 2,
                ERROR      : 3
            }
        },
        TYPE            : {
            CLUSTERS                  : 'clusters',
            CLUSTER_TPLS              : 'clustertpls',
            DISCOVERY                 : 'discovery',
            HOSTS                     : 'hosts',
            HOST_GROUPS               : 'hostgroups',
            HOST_TPLS                 : 'hosttpls',
            CHECK_ON_HOST             : 'serviceshosts',
            CHECK_ON_TPL_HOST         : 'serviceshosttpls',
            CHECK_ON_CLUSTER          : 'servicesclusters',
            CHECK_ON_TPL_CLUSTER      : 'servicesclustertpls',
            CHECK_TPLS                : 'servicetpls',
            COMMANDS                  : 'commands',
            CONTACT_GROUPS            : 'contactgroups',
            CONTACT_TPLS              : 'contacttpls',
            CONTACTS                  : 'contacts',
            ESCALATIONS               : 'escalations',
            MODULATION_BUSINESS_IMPACT: 'businessimpactmodulations',
            MODULATION_DATA           : 'macromodulations',
            MODULATION_RESULT         : 'resultmodulations',
            NOTIFICATION_WAYS         : 'notificationways',
            TIME_PERIODS              : 'timeperiods',
            SYNCHRONIZER_LINKER       : 'sync'
        },
        WORK_AREA_STATUS: {
            PROPOSED : 'PROPOSED',
            WORKING  : 'WORKING',
            REJECTED : 'REJECTED',
            VALIDATED: 'VALIDATED'
            
        },
        STATUS          : {
            NEW: 'new'
        },
        SLA             : {
            TENDENCY: {
                STAGNANT  : 'stagnant',
                DECRASING : 'decreasing',
                INCREASING: 'increasing'
            },
            STATUS  : {
                OK      : 0,
                WARNING : 1,
                CRITICAL: 2,
                UNKNOWN : 3
            }
        },
        SAVE            : {
            TYPE: {
                LINK: "LINK"
            }
        }
    },
    OVERRIDE_STATUS      : {
        OFF     : "0",
        ON      : "1",
        DISABLED: "2"
    },
    MODE_OVERRIDE_EXCLUDE: {
        NORMAL  : "0",
        OVERRIDE: "1",
        EXCLUDE : "2"
    },
    EXCLUDE_STATUS       : {
        OFF    : "0",
        BY_ID  : "1",
        BY_NAME: "2"
    }
};


var SHINKEN                     = SHINKEN || {};
SHINKEN.OBJECT                  = SHINKEN.OBJECT || {};
SHINKEN.OBJECT.CONST            = SHINKEN.OBJECT.CONST || {};
SHINKEN.OBJECT.CONST.VALIDATION = SHINKEN.OBJECT.CONST.VALIDATION || {
    FIELD: {
        MESSAGES                : 'validation_messages',
        ERRORS                  : 'errors',
        CRITICAL                : 'critical',
        WARNINGS                : 'warnings',
        _KEY_MESSAGE            : 'message',
        PATH_VALIDATION_FOR_JSON: 'path_validation_for_json'
    }
};