//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.BlinkNotificationOfChange = function ( data ) {
    this.init( data );
};

SHINKEN.OBJECT.BlinkNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "init_phase":
                this.doActionAfter( "reset_object" );
                this.initPhase();
                break;
            case "init_with_dom_element":
                if ( this.getDomElement() ) {
                    return;
                }
                if ( !param ) {
                    return;
                }
                this.setDomElement( param.querySelector( ".shinken-blink-notification-container" ) );
                this.setPhaseDomElement( param, "blinkNotification" );
                break;
            case "change_value_notification_of_change_visual_blink":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED, param );
                break;
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "shinken_view_has_disabled_blink_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "play_blink_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
            case "user_has_disabled_blink_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER );
                break;
            case "set_phase_blink_depending_number_of_change":
                this.setPhase( param ? SHINKEN.OBJECT.CONST.PHASE.READY : SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
            case "ask_play_notification_visual_blink":
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.READY );
                break;
            case "reset_object":
                this.setDomElement();
                break;
            case "click_done":
                break;
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getValue: function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED:
                if ( typeof value === "object" ) {
                    this[ key ] = value.value;
                }
                else {
                    this[ key ] = value;
                }
                break;
        }
    },
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] = this.getValue();
        return _to_return;
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        this.setTooltipHtml( "" );
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.READY, 3000 );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER:
                this.setTooltipHtml( _( "notification.blink_user_warning", [DICTIONARY_COMMON_UI] ) );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING:
                this.setTooltipHtml( _( "notification.no_change", [DICTIONARY_COMMON_UI] ) );
                break;
            default:
                break;
        }
    },
    //**************************************    HTML         **************************************************//
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #visual-blink-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.BlinkNotificationOfChange, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.BlinkNotificationOfChange, SHINKEN.OBJECT.ShinkenObjectHtml );