//priority 20
//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.CONST.PHASE                  = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : "READY",
    WAITING_FOR_READY       : 10,
    STOPPING                : "STOPPING",
    STARTING                : 12,
    STUCK                   : 13,
    HIDDEN                  : 14,
    ASKING_ENTER_PREVIEWING : 15,
    PREVIEWING              : 16,
    ASKING_ENTER_EDITING    : 17,
    ASKING_SHOW_FORM        : 171,
    ASK_FOR_REFRESH         : 18,
    RUNNING_OK              : 19,
    RUNNING_OK_WITH_WARNING : 191,
    RUNNING_NOK             : 20,
    SAVING_AFTER_PREVIEWING : 21,
    TO_BE_DELETED           : 22,
    ASK_FOR_SAVING          : 23,
    ASK_FOR_CANCEL          : 24,
    CANCEL                  : 25,
    SAVE_DONE               : 26,
    RUNNING_WITH_WARNING    : 27,
    ASK_FOR_CLOSE           : 28,
    DISCREET_USER           : "DISCREET_USER",
    DISCREET_VIEW           : "DISCREET_VIEW",
    DISCREET_NAVIGATOR      : "DISCREET_NAVIGATOR"
};
SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT = 0;

SHINKEN.OBJECT.Phase           = function ( parent_object ) {
    this.previous_phase             = null;
    this.current_phase              = SHINKEN.OBJECT.CONST.PHASE.INIT;
    this.next_phase                 = null;
    this.parent_object              = parent_object;
    this.timeout_set_phase_callback = null;
    this.timeout_phase              = null;
    this.synchrnonized_phase_object = [];
};
SHINKEN.OBJECT.Phase.prototype = {
    setPhase            : function ( to_set ) {
        if ( this.timeout_phase ) {
            clearTimeout( this.timeout_phase );
        }
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        if ( this.dom_element ) {
            if ( this.dom_element_data_name ) {
                DOM.Service.setDataSet( this.dom_element, this.dom_element_data_name + 'CurrentPhase', this.current_phase );
                DOM.Service.setDataSet( this.dom_element, this.dom_element_data_name + 'PreviousPhase', this.previous_phase );
            }
            else {
                DOM.Service.setDataSet( this.dom_element, 'currentPhase', this.current_phase );
                DOM.Service.setDataSet( this.dom_element, 'previousPhase', this.previous_phase );
            }
        }
        this.next_phase = null;
        if ( this.parent_object ) {
            
            var _self = this;
            if ( _self.timeout_set_phase_callback ) {
                clearTimeout( _self.timeout_set_phase_callback );
            }
            _self.timeout_set_phase_callback = setTimeout( function () {
                _self.parent_object.callbackForPhase();
                _self.timeout_set_phase_callback = null;
            }, SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT );
        }
        if ( this.synchrnonized_phase_object.length ) {
            for ( var i = 0, _size_i = this.synchrnonized_phase_object.length; i < _size_i; i++ ) {
                this.synchrnonized_phase_object[ i ].setPhase( to_set );
            }
        }
    },
    setPhaseIfNotPhase  : function ( to_set, if_not ) {
        if ( this.isPhase( if_not ) ) {
            return;
        }
        this.setPhase( to_set );
    },
    setPhaseIfPhase  : function ( to_set, if_is ) {
        if ( !this.isPhase( if_is ) ) {
            return;
        }
        this.setPhase( to_set );
    },
    setPhaseWithTimeOut : function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self           = this;
        this.timeout_phase = setTimeout( function () {
            self.setPhase( to_set );
        }, timeout );
    },
    isPhase             : function ( to_test ) {
        return this.current_phase === to_test;
    },
    togglePhase         : function ( phase_1, phase_2 ) {
        if ( this.isPhase( phase_1 ) ) {
            this.setPhase( phase_2 );
        }
        else {
            this.setPhase( phase_1 );
        }
    },
    isPreviousPhase     : function ( to_test ) {
        if ( !this.previous_phase ) {
            return false;
        }
        return this.previous_phase === to_test;
    },
    setParent           : function ( parent_object ) {
        this.parent_object = parent_object;
    },
    addSynchronizedPhase: function ( to_add ) {
        this.synchrnonized_phase_object.push( to_add );
    },
    setDomElement       : function ( to_set, data_name ) {
        this.dom_element           = to_set;
        this.dom_element_data_name = data_name;
    }
};

SHINKEN.OBJECT.PhaseInterface           = function () {
};
SHINKEN.OBJECT.PhaseInterface.prototype = {
    initPhase           : function ( dom_element ) {
        this.phase = new SHINKEN.OBJECT.Phase( this );
        if ( dom_element ) {
            this.phase.setDomElement( dom_element );
        }
    },
    addSynchronizedPhase: function ( to_add ) {
        this.phase.addSynchronizedPhase( to_add );
    },
    isPhase             : function ( to_test ) {
        return this.phase.isPhase( to_test );
    },
    isInPhase           : function ( array_to_test ) {
        for ( var i = 0, _size_i = array_to_test.length; i < _size_i; i++ ) {
            if ( this.phase.isPhase( array_to_test[ i ] ) ) {
                return true;
            }
        }
        return false;
    },
    setPhase            : function ( to_set ) {
        this.phase.setPhase( to_set );
    },
    togglePhase         : function ( phase_1, phase_2 ) {
        this.phase.togglePhase( phase_1, phase_2 );
    },
    setPhaseParent      : function ( to_set ) {
        this.phase.setParent( to_set );
    },
    setPhaseDomElement  : function ( to_set, data_name ) {
        this.phase.setDomElement( to_set, data_name );
    },
    setPhaseIfNotPhase  : function ( to_set, if_not ) {
        this.phase.setPhaseIfNotPhase( to_set, if_not );
    },
    setPhaseIfPhase  : function ( to_set, if_is ) {
        this.phase.setPhaseIfPhase( to_set, if_is );
    },
    setPhaseWithTimeOut : function ( to_set, timeout ) {
        this.phase.setPhaseWithTimeOut( to_set, timeout );
    },
    getCurrentPhase     : function () {
        return this.phase.current_phase;
    },
    getPreviousPhase    : function () {
        return this.phase.previous_phase;
    },
    setPreviousPhaseForced    : function ( to_set ) {
        this.phase.previous_phase = to_set;
    },
    isPreviousPhase     : function ( to_test ) {
        return this.phase.isPreviousPhase( to_test );
    },
    callbackForPhase    : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );